package com.hubspot.slack.client.models.blocks.objects;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link OptionIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code Option.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code Option.of()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "OptionIF"})
@Immutable
public final class Option implements OptionIF {
  private final Text text;
  private final String value;
  private final @Nullable String url;

  private Option(Text text, String value) {
    this.text = Objects.requireNonNull(text, "text");
    this.value = Objects.requireNonNull(value, "value");
    this.url = null;
  }

  private Option(Text text, String value, @Nullable String url) {
    this.text = text;
    this.value = value;
    this.url = url;
  }

  /**
   * @return The value of the {@code text} attribute
   */
  @JsonProperty
  @Override
  public Text getText() {
    return text;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @JsonProperty
  @Override
  public String getValue() {
    return value;
  }

  /**
   * @return The value of the {@code url} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getUrl() {
    return Optional.ofNullable(url);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OptionIF#getText() text} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param text A new value for text
   * @return A modified copy of the {@code this} object
   */
  public final Option withText(Text text) {
    if (this.text == text) return this;
    Text newValue = Objects.requireNonNull(text, "text");
    return new Option(newValue, this.value, this.url);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link OptionIF#getValue() value} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final Option withValue(String value) {
    if (this.value.equals(value)) return this;
    String newValue = Objects.requireNonNull(value, "value");
    return new Option(this.text, newValue, this.url);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link OptionIF#getUrl() url} attribute.
   * @param value The value for url, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final Option withUrl(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.url, newValue)) return this;
    return new Option(this.text, this.value, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link OptionIF#getUrl() url} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for url
   * @return A modified copy of {@code this} object
   */
  public final Option withUrl(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.url, value)) return this;
    return new Option(this.text, this.value, value);
  }

  /**
   * This instance is equal to all instances of {@code Option} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof Option
        && equalTo((Option) another);
  }

  private boolean equalTo(Option another) {
    return text.equals(another.text)
        && value.equals(another.value)
        && Objects.equals(url, another.url);
  }

  /**
   * Computes a hash code from attributes: {@code text}, {@code value}, {@code url}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + text.hashCode();
    h = h * 17 + value.hashCode();
    h = h * 17 + Objects.hashCode(url);
    return h;
  }

  /**
   * Prints the immutable value {@code Option} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("Option{");
    builder.append("text=").append(text);
    builder.append(", ");
    builder.append("value=").append(value);
    if (url != null) {
      builder.append(", ");
      builder.append("url=").append(url);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements OptionIF {
    @Nullable Text text;
    @Nullable String value;
    Optional<String> url = Optional.empty();
    @JsonProperty
    public void setText(Text text) {
      this.text = text;
    }
    @JsonProperty
    public void setValue(String value) {
      this.value = value;
    }
    @JsonProperty
    public void setUrl(Optional<String> url) {
      this.url = url;
    }
    @Override
    public Text getText() { throw new UnsupportedOperationException(); }
    @Override
    public String getValue() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getUrl() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static Option fromJson(Json json) {
    Option.Builder builder = Option.builder();
    if (json.text != null) {
      builder.setText(json.text);
    }
    if (json.value != null) {
      builder.setValue(json.value);
    }
    if (json.url != null) {
      builder.setUrl(json.url);
    }
    return builder.build();
  }

  /**
   * Construct a new immutable {@code Option} instance.
   * @param text The value for the {@code text} attribute
   * @param value The value for the {@code value} attribute
   * @return An immutable Option instance
   */
  public static Option of(Text text, String value) {
    return new Option(text, value);
  }

  /**
   * Creates an immutable copy of a {@link OptionIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Option instance
   */
  public static Option copyOf(OptionIF instance) {
    if (instance instanceof Option) {
      return (Option) instance;
    }
    return Option.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link Option Option}.
   * @return A new Option builder
   */
  public static Option.Builder builder() {
    return new Option.Builder();
  }

  /**
   * Builds instances of type {@link Option Option}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TEXT = 0x1L;
    private static final long INIT_BIT_VALUE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable Text text;
    private @Nullable String value;
    private @Nullable String url;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code OptionIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(OptionIF instance) {
      Objects.requireNonNull(instance, "instance");
      setText(instance.getText());
      setValue(instance.getValue());
      Optional<String> urlOptional = instance.getUrl();
      if (urlOptional.isPresent()) {
        setUrl(urlOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link OptionIF#getText() text} attribute.
     * @param text The value for text 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setText(Text text) {
      this.text = Objects.requireNonNull(text, "text");
      initBits &= ~INIT_BIT_TEXT;
      return this;
    }

    /**
     * Initializes the value for the {@link OptionIF#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setValue(String value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Initializes the optional value {@link OptionIF#getUrl() url} to url.
     * @param url The value for url, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setUrl(@Nullable String url) {
      this.url = url;
      return this;
    }

    /**
     * Initializes the optional value {@link OptionIF#getUrl() url} to url.
     * @param url The value for url
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUrl(Optional<String> url) {
      this.url = url.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link Option Option}.
     * @return An immutable instance of Option
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public Option build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new Option(text, value, url);
    }

    private boolean textIsSet() {
      return (initBits & INIT_BIT_TEXT) == 0;
    }

    private boolean valueIsSet() {
      return (initBits & INIT_BIT_VALUE) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!textIsSet()) attributes.add("text");
      if (!valueIsSet()) attributes.add("value");
      return "Cannot build Option, some of required attributes are not set " + attributes;
    }
  }
}
