package com.hubspot.slack.client.models.blocks.objects;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link TextIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code Text.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code Text.of()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "TextIF"})
@Immutable
public final class Text implements TextIF {
  private final TextType type;
  private final String text;
  private final @Nullable Boolean emoji;
  private final @Nullable Boolean verbatim;

  private Text(TextType type, String text) {
    this.type = Objects.requireNonNull(type, "type");
    this.text = Objects.requireNonNull(text, "text");
    this.emoji = null;
    this.verbatim = null;
  }

  private Text(
      TextType type,
      String text,
      @Nullable Boolean emoji,
      @Nullable Boolean verbatim) {
    this.type = type;
    this.text = text;
    this.emoji = emoji;
    this.verbatim = verbatim;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public TextType getType() {
    return type;
  }

  /**
   * @return The value of the {@code text} attribute
   */
  @JsonProperty
  @Override
  public String getText() {
    return text;
  }

  /**
   * @return The value of the {@code emoji} attribute
   */
  @JsonProperty("emoji")
  @Override
  public Optional<Boolean> isEmoji() {
    return Optional.ofNullable(emoji);
  }

  /**
   * @return The value of the {@code verbatim} attribute
   */
  @JsonProperty("verbatim")
  @Override
  public Optional<Boolean> isVerbatim() {
    return Optional.ofNullable(verbatim);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TextIF#getType() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param type A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final Text withType(TextType type) {
    if (this.type == type) return this;
    TextType newValue = Objects.requireNonNull(type, "type");
    return new Text(newValue, this.text, this.emoji, this.verbatim);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TextIF#getText() text} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param text A new value for text
   * @return A modified copy of the {@code this} object
   */
  public final Text withText(String text) {
    if (this.text.equals(text)) return this;
    String newValue = Objects.requireNonNull(text, "text");
    return new Text(this.type, newValue, this.emoji, this.verbatim);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link TextIF#isEmoji() emoji} attribute.
   * @param value The value for emoji, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final Text withEmoji(@Nullable Boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.emoji, newValue)) return this;
    return new Text(this.type, this.text, newValue, this.verbatim);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link TextIF#isEmoji() emoji} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for emoji
   * @return A modified copy of {@code this} object
   */
  public final Text withEmoji(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.emoji, value)) return this;
    return new Text(this.type, this.text, value, this.verbatim);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link TextIF#isVerbatim() verbatim} attribute.
   * @param value The value for verbatim, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final Text withVerbatim(@Nullable Boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.verbatim, newValue)) return this;
    return new Text(this.type, this.text, this.emoji, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link TextIF#isVerbatim() verbatim} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for verbatim
   * @return A modified copy of {@code this} object
   */
  public final Text withVerbatim(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.verbatim, value)) return this;
    return new Text(this.type, this.text, this.emoji, value);
  }

  /**
   * This instance is equal to all instances of {@code Text} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof Text
        && equalTo((Text) another);
  }

  private boolean equalTo(Text another) {
    return type.equals(another.type)
        && text.equals(another.text)
        && Objects.equals(emoji, another.emoji)
        && Objects.equals(verbatim, another.verbatim);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code text}, {@code emoji}, {@code verbatim}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + type.hashCode();
    h = h * 17 + text.hashCode();
    h = h * 17 + Objects.hashCode(emoji);
    h = h * 17 + Objects.hashCode(verbatim);
    return h;
  }

  /**
   * Prints the immutable value {@code Text} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("Text{");
    builder.append("type=").append(type);
    builder.append(", ");
    builder.append("text=").append(text);
    if (emoji != null) {
      builder.append(", ");
      builder.append("emoji=").append(emoji);
    }
    if (verbatim != null) {
      builder.append(", ");
      builder.append("verbatim=").append(verbatim);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements TextIF {
    @Nullable TextType type;
    @Nullable String text;
    Optional<Boolean> emoji = Optional.empty();
    Optional<Boolean> verbatim = Optional.empty();
    @JsonProperty
    public void setType(TextType type) {
      this.type = type;
    }
    @JsonProperty
    public void setText(String text) {
      this.text = text;
    }
    @JsonProperty("emoji")
    public void setEmoji(Optional<Boolean> emoji) {
      this.emoji = emoji;
    }
    @JsonProperty("verbatim")
    public void setVerbatim(Optional<Boolean> verbatim) {
      this.verbatim = verbatim;
    }
    @Override
    public TextType getType() { throw new UnsupportedOperationException(); }
    @Override
    public String getText() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> isEmoji() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> isVerbatim() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static Text fromJson(Json json) {
    Text.Builder builder = Text.builder();
    if (json.type != null) {
      builder.setType(json.type);
    }
    if (json.text != null) {
      builder.setText(json.text);
    }
    if (json.emoji != null) {
      builder.setEmoji(json.emoji);
    }
    if (json.verbatim != null) {
      builder.setVerbatim(json.verbatim);
    }
    return builder.build();
  }

  /**
   * Construct a new immutable {@code Text} instance.
   * @param type The value for the {@code type} attribute
   * @param text The value for the {@code text} attribute
   * @return An immutable Text instance
   */
  public static Text of(TextType type, String text) {
    return new Text(type, text);
  }

  /**
   * Creates an immutable copy of a {@link TextIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Text instance
   */
  public static Text copyOf(TextIF instance) {
    if (instance instanceof Text) {
      return (Text) instance;
    }
    return Text.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link Text Text}.
   * @return A new Text builder
   */
  public static Text.Builder builder() {
    return new Text.Builder();
  }

  /**
   * Builds instances of type {@link Text Text}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TYPE = 0x1L;
    private static final long INIT_BIT_TEXT = 0x2L;
    private long initBits = 0x3L;

    private @Nullable TextType type;
    private @Nullable String text;
    private @Nullable Boolean emoji;
    private @Nullable Boolean verbatim;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code TextIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(TextIF instance) {
      Objects.requireNonNull(instance, "instance");
      setType(instance.getType());
      setText(instance.getText());
      Optional<Boolean> emojiOptional = instance.isEmoji();
      if (emojiOptional.isPresent()) {
        setEmoji(emojiOptional);
      }
      Optional<Boolean> verbatimOptional = instance.isVerbatim();
      if (verbatimOptional.isPresent()) {
        setVerbatim(verbatimOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link TextIF#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setType(TextType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link TextIF#getText() text} attribute.
     * @param text The value for text 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setText(String text) {
      this.text = Objects.requireNonNull(text, "text");
      initBits &= ~INIT_BIT_TEXT;
      return this;
    }

    /**
     * Initializes the optional value {@link TextIF#isEmoji() emoji} to emoji.
     * @param emoji The value for emoji, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setEmoji(@Nullable Boolean emoji) {
      this.emoji = emoji;
      return this;
    }

    /**
     * Initializes the optional value {@link TextIF#isEmoji() emoji} to emoji.
     * @param emoji The value for emoji
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setEmoji(Optional<Boolean> emoji) {
      this.emoji = emoji.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link TextIF#isVerbatim() verbatim} to verbatim.
     * @param verbatim The value for verbatim, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setVerbatim(@Nullable Boolean verbatim) {
      this.verbatim = verbatim;
      return this;
    }

    /**
     * Initializes the optional value {@link TextIF#isVerbatim() verbatim} to verbatim.
     * @param verbatim The value for verbatim
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setVerbatim(Optional<Boolean> verbatim) {
      this.verbatim = verbatim.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link Text Text}.
     * @return An immutable instance of Text
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public Text build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new Text(type, text, emoji, verbatim);
    }

    private boolean typeIsSet() {
      return (initBits & INIT_BIT_TYPE) == 0;
    }

    private boolean textIsSet() {
      return (initBits & INIT_BIT_TEXT) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!typeIsSet()) attributes.add("type");
      if (!textIsSet()) attributes.add("text");
      return "Cannot build Text, some of required attributes are not set " + attributes;
    }
  }
}
