package com.hubspot.slack.client.models.dialog;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.dialog.form.elements.SlackDialogFormElement;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link SlackDialogIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code SlackDialog.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "SlackDialogIF"})
@Immutable
public final class SlackDialog implements SlackDialogIF {
  private final String title;
  private final String callbackId;
  private final List<SlackDialogFormElement> elements;
  private final @Nullable String state;
  private final @Nullable String submitLabel;
  private final @Nullable Boolean notifyOnCancel;

  private SlackDialog(
      String title,
      String callbackId,
      List<SlackDialogFormElement> elements,
      @Nullable String state,
      @Nullable String submitLabel,
      @Nullable Boolean notifyOnCancel) {
    this.title = title;
    this.callbackId = callbackId;
    this.elements = elements;
    this.state = state;
    this.submitLabel = submitLabel;
    this.notifyOnCancel = notifyOnCancel;
  }

  /**
   * @return The value of the {@code title} attribute
   */
  @JsonProperty
  @Override
  public String getTitle() {
    return title;
  }

  /**
   * @return The value of the {@code callbackId} attribute
   */
  @JsonProperty
  @Override
  public String getCallbackId() {
    return callbackId;
  }

  /**
   * @return The value of the {@code elements} attribute
   */
  @JsonProperty
  @Override
  public List<SlackDialogFormElement> getElements() {
    return elements;
  }

  /**
   * @return The value of the {@code state} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getState() {
    return Optional.ofNullable(state);
  }

  /**
   * @return The value of the {@code submitLabel} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getSubmitLabel() {
    return Optional.ofNullable(submitLabel);
  }

  /**
   * @return The value of the {@code notifyOnCancel} attribute
   */
  @JsonProperty
  @Override
  public Optional<Boolean> getNotifyOnCancel() {
    return Optional.ofNullable(notifyOnCancel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackDialogIF#getTitle() title} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param title A new value for title
   * @return A modified copy of the {@code this} object
   */
  public final SlackDialog withTitle(String title) {
    if (this.title.equals(title)) return this;
    String newValue = Objects.requireNonNull(title, "title");
    return validate(new SlackDialog(newValue, this.callbackId, this.elements, this.state, this.submitLabel, this.notifyOnCancel));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackDialogIF#getCallbackId() callbackId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param callbackId A new value for callbackId
   * @return A modified copy of the {@code this} object
   */
  public final SlackDialog withCallbackId(String callbackId) {
    if (this.callbackId.equals(callbackId)) return this;
    String newValue = Objects.requireNonNull(callbackId, "callbackId");
    return validate(new SlackDialog(this.title, newValue, this.elements, this.state, this.submitLabel, this.notifyOnCancel));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SlackDialogIF#getElements() elements}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final SlackDialog withElements(SlackDialogFormElement... elements) {
    List<SlackDialogFormElement> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new SlackDialog(this.title, this.callbackId, newValue, this.state, this.submitLabel, this.notifyOnCancel));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SlackDialogIF#getElements() elements}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of elements elements to set
   * @return A modified copy of {@code this} object
   */
  public final SlackDialog withElements(Iterable<? extends SlackDialogFormElement> elements) {
    if (this.elements == elements) return this;
    List<SlackDialogFormElement> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new SlackDialog(this.title, this.callbackId, newValue, this.state, this.submitLabel, this.notifyOnCancel));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackDialogIF#getState() state} attribute.
   * @param value The value for state, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackDialog withState(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.state, newValue)) return this;
    return validate(new SlackDialog(this.title, this.callbackId, this.elements, newValue, this.submitLabel, this.notifyOnCancel));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackDialogIF#getState() state} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for state
   * @return A modified copy of {@code this} object
   */
  public final SlackDialog withState(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.state, value)) return this;
    return validate(new SlackDialog(this.title, this.callbackId, this.elements, value, this.submitLabel, this.notifyOnCancel));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackDialogIF#getSubmitLabel() submitLabel} attribute.
   * @param value The value for submitLabel, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackDialog withSubmitLabel(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.submitLabel, newValue)) return this;
    return validate(new SlackDialog(this.title, this.callbackId, this.elements, this.state, newValue, this.notifyOnCancel));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackDialogIF#getSubmitLabel() submitLabel} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for submitLabel
   * @return A modified copy of {@code this} object
   */
  public final SlackDialog withSubmitLabel(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.submitLabel, value)) return this;
    return validate(new SlackDialog(this.title, this.callbackId, this.elements, this.state, value, this.notifyOnCancel));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackDialogIF#getNotifyOnCancel() notifyOnCancel} attribute.
   * @param value The value for notifyOnCancel, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackDialog withNotifyOnCancel(@Nullable Boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.notifyOnCancel, newValue)) return this;
    return validate(new SlackDialog(this.title, this.callbackId, this.elements, this.state, this.submitLabel, newValue));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackDialogIF#getNotifyOnCancel() notifyOnCancel} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for notifyOnCancel
   * @return A modified copy of {@code this} object
   */
  public final SlackDialog withNotifyOnCancel(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.notifyOnCancel, value)) return this;
    return validate(new SlackDialog(this.title, this.callbackId, this.elements, this.state, this.submitLabel, value));
  }

  /**
   * This instance is equal to all instances of {@code SlackDialog} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof SlackDialog
        && equalTo((SlackDialog) another);
  }

  private boolean equalTo(SlackDialog another) {
    return title.equals(another.title)
        && callbackId.equals(another.callbackId)
        && elements.equals(another.elements)
        && Objects.equals(state, another.state)
        && Objects.equals(submitLabel, another.submitLabel)
        && Objects.equals(notifyOnCancel, another.notifyOnCancel);
  }

  /**
   * Computes a hash code from attributes: {@code title}, {@code callbackId}, {@code elements}, {@code state}, {@code submitLabel}, {@code notifyOnCancel}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + title.hashCode();
    h = h * 17 + callbackId.hashCode();
    h = h * 17 + elements.hashCode();
    h = h * 17 + Objects.hashCode(state);
    h = h * 17 + Objects.hashCode(submitLabel);
    h = h * 17 + Objects.hashCode(notifyOnCancel);
    return h;
  }

  /**
   * Prints the immutable value {@code SlackDialog} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("SlackDialog{");
    builder.append("title=").append(title);
    builder.append(", ");
    builder.append("callbackId=").append(callbackId);
    builder.append(", ");
    builder.append("elements=").append(elements);
    if (state != null) {
      builder.append(", ");
      builder.append("state=").append(state);
    }
    if (submitLabel != null) {
      builder.append(", ");
      builder.append("submitLabel=").append(submitLabel);
    }
    if (notifyOnCancel != null) {
      builder.append(", ");
      builder.append("notifyOnCancel=").append(notifyOnCancel);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements SlackDialogIF {
    @Nullable String title;
    @Nullable String callbackId;
    List<SlackDialogFormElement> elements = Collections.emptyList();
    Optional<String> state = Optional.empty();
    Optional<String> submitLabel = Optional.empty();
    Optional<Boolean> notifyOnCancel = Optional.empty();
    @JsonProperty
    public void setTitle(String title) {
      this.title = title;
    }
    @JsonProperty
    public void setCallbackId(String callbackId) {
      this.callbackId = callbackId;
    }
    @JsonProperty
    public void setElements(List<SlackDialogFormElement> elements) {
      this.elements = elements;
    }
    @JsonProperty
    public void setState(Optional<String> state) {
      this.state = state;
    }
    @JsonProperty
    public void setSubmitLabel(Optional<String> submitLabel) {
      this.submitLabel = submitLabel;
    }
    @JsonProperty
    public void setNotifyOnCancel(Optional<Boolean> notifyOnCancel) {
      this.notifyOnCancel = notifyOnCancel;
    }
    @Override
    public String getTitle() { throw new UnsupportedOperationException(); }
    @Override
    public String getCallbackId() { throw new UnsupportedOperationException(); }
    @Override
    public List<SlackDialogFormElement> getElements() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getState() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getSubmitLabel() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> getNotifyOnCancel() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static SlackDialog fromJson(Json json) {
    SlackDialog.Builder builder = SlackDialog.builder();
    if (json.title != null) {
      builder.setTitle(json.title);
    }
    if (json.callbackId != null) {
      builder.setCallbackId(json.callbackId);
    }
    if (json.elements != null) {
      builder.addAllElements(json.elements);
    }
    if (json.state != null) {
      builder.setState(json.state);
    }
    if (json.submitLabel != null) {
      builder.setSubmitLabel(json.submitLabel);
    }
    if (json.notifyOnCancel != null) {
      builder.setNotifyOnCancel(json.notifyOnCancel);
    }
    return builder.build();
  }

  private static SlackDialog validate(SlackDialog instance) {
    instance.validate();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link SlackDialogIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SlackDialog instance
   */
  public static SlackDialog copyOf(SlackDialogIF instance) {
    if (instance instanceof SlackDialog) {
      return (SlackDialog) instance;
    }
    return SlackDialog.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link SlackDialog SlackDialog}.
   * @return A new SlackDialog builder
   */
  public static SlackDialog.Builder builder() {
    return new SlackDialog.Builder();
  }

  /**
   * Builds instances of type {@link SlackDialog SlackDialog}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TITLE = 0x1L;
    private static final long INIT_BIT_CALLBACK_ID = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String title;
    private @Nullable String callbackId;
    private List<SlackDialogFormElement> elements = new ArrayList<SlackDialogFormElement>();
    private @Nullable String state;
    private @Nullable String submitLabel;
    private @Nullable Boolean notifyOnCancel;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SlackDialogIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackDialogIF instance) {
      Objects.requireNonNull(instance, "instance");
      setTitle(instance.getTitle());
      setCallbackId(instance.getCallbackId());
      addAllElements(instance.getElements());
      Optional<String> stateOptional = instance.getState();
      if (stateOptional.isPresent()) {
        setState(stateOptional);
      }
      Optional<String> submitLabelOptional = instance.getSubmitLabel();
      if (submitLabelOptional.isPresent()) {
        setSubmitLabel(submitLabelOptional);
      }
      Optional<Boolean> notifyOnCancelOptional = instance.getNotifyOnCancel();
      if (notifyOnCancelOptional.isPresent()) {
        setNotifyOnCancel(notifyOnCancelOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link SlackDialogIF#getTitle() title} attribute.
     * @param title The value for title 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTitle(String title) {
      this.title = Objects.requireNonNull(title, "title");
      initBits &= ~INIT_BIT_TITLE;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackDialogIF#getCallbackId() callbackId} attribute.
     * @param callbackId The value for callbackId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setCallbackId(String callbackId) {
      this.callbackId = Objects.requireNonNull(callbackId, "callbackId");
      initBits &= ~INIT_BIT_CALLBACK_ID;
      return this;
    }

    /**
     * Adds one element to {@link SlackDialogIF#getElements() elements} list.
     * @param element A elements element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addElements(SlackDialogFormElement element) {
      this.elements.add(Objects.requireNonNull(element, "elements element"));
      return this;
    }

    /**
     * Adds elements to {@link SlackDialogIF#getElements() elements} list.
     * @param elements An array of elements elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addElements(SlackDialogFormElement... elements) {
      for (SlackDialogFormElement element : elements) {
        this.elements.add(Objects.requireNonNull(element, "elements element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link SlackDialogIF#getElements() elements} list.
     * @param elements An iterable of elements elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setElements(Iterable<? extends SlackDialogFormElement> elements) {
      this.elements.clear();
      return addAllElements(elements);
    }

    /**
     * Adds elements to {@link SlackDialogIF#getElements() elements} list.
     * @param elements An iterable of elements elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllElements(Iterable<? extends SlackDialogFormElement> elements) {
      for (SlackDialogFormElement element : elements) {
        this.elements.add(Objects.requireNonNull(element, "elements element"));
      }
      return this;
    }

    /**
     * Initializes the optional value {@link SlackDialogIF#getState() state} to state.
     * @param state The value for state, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setState(@Nullable String state) {
      this.state = state;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackDialogIF#getState() state} to state.
     * @param state The value for state
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setState(Optional<String> state) {
      this.state = state.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link SlackDialogIF#getSubmitLabel() submitLabel} to submitLabel.
     * @param submitLabel The value for submitLabel, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setSubmitLabel(@Nullable String submitLabel) {
      this.submitLabel = submitLabel;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackDialogIF#getSubmitLabel() submitLabel} to submitLabel.
     * @param submitLabel The value for submitLabel
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setSubmitLabel(Optional<String> submitLabel) {
      this.submitLabel = submitLabel.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link SlackDialogIF#getNotifyOnCancel() notifyOnCancel} to notifyOnCancel.
     * @param notifyOnCancel The value for notifyOnCancel, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setNotifyOnCancel(@Nullable Boolean notifyOnCancel) {
      this.notifyOnCancel = notifyOnCancel;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackDialogIF#getNotifyOnCancel() notifyOnCancel} to notifyOnCancel.
     * @param notifyOnCancel The value for notifyOnCancel
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setNotifyOnCancel(Optional<Boolean> notifyOnCancel) {
      this.notifyOnCancel = notifyOnCancel.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link SlackDialog SlackDialog}.
     * @return An immutable instance of SlackDialog
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public SlackDialog build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return SlackDialog.validate(new SlackDialog(title, callbackId, createUnmodifiableList(true, elements), state, submitLabel, notifyOnCancel));
    }

    private boolean titleIsSet() {
      return (initBits & INIT_BIT_TITLE) == 0;
    }

    private boolean callbackIdIsSet() {
      return (initBits & INIT_BIT_CALLBACK_ID) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!titleIsSet()) attributes.add("title");
      if (!callbackIdIsSet()) attributes.add("callbackId");
      return "Cannot build SlackDialog, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
