package com.hubspot.slack.client.models.dialog.form.elements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link SlackFormOptionIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code SlackFormOption.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "SlackFormOptionIF"})
@Immutable
public final class SlackFormOption
    implements SlackFormOptionIF {
  private final String label;
  private final String value;

  private SlackFormOption(String label, String value) {
    this.label = label;
    this.value = value;
  }

  /**
   * @return The value of the {@code label} attribute
   */
  @JsonProperty
  @Override
  public String getLabel() {
    return label;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @JsonProperty
  @Override
  public String getValue() {
    return value;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackFormOptionIF#getLabel() label} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param label A new value for label
   * @return A modified copy of the {@code this} object
   */
  public final SlackFormOption withLabel(String label) {
    if (this.label.equals(label)) return this;
    String newValue = Objects.requireNonNull(label, "label");
    return validate(new SlackFormOption(newValue, this.value));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackFormOptionIF#getValue() value} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final SlackFormOption withValue(String value) {
    if (this.value.equals(value)) return this;
    String newValue = Objects.requireNonNull(value, "value");
    return validate(new SlackFormOption(this.label, newValue));
  }

  /**
   * This instance is equal to all instances of {@code SlackFormOption} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof SlackFormOption
        && equalTo((SlackFormOption) another);
  }

  private boolean equalTo(SlackFormOption another) {
    return label.equals(another.label)
        && value.equals(another.value);
  }

  /**
   * Computes a hash code from attributes: {@code label}, {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + label.hashCode();
    h = h * 17 + value.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SlackFormOption} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SlackFormOption{"
        + "label=" + label
        + ", value=" + value
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements SlackFormOptionIF {
    @Nullable String label;
    @Nullable String value;
    @JsonProperty
    public void setLabel(String label) {
      this.label = label;
    }
    @JsonProperty
    public void setValue(String value) {
      this.value = value;
    }
    @Override
    public String getLabel() { throw new UnsupportedOperationException(); }
    @Override
    public String getValue() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static SlackFormOption fromJson(Json json) {
    SlackFormOption.Builder builder = SlackFormOption.builder();
    if (json.label != null) {
      builder.setLabel(json.label);
    }
    if (json.value != null) {
      builder.setValue(json.value);
    }
    return builder.build();
  }

  private static SlackFormOption validate(SlackFormOption instance) {
    instance.validate();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link SlackFormOptionIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SlackFormOption instance
   */
  public static SlackFormOption copyOf(SlackFormOptionIF instance) {
    if (instance instanceof SlackFormOption) {
      return (SlackFormOption) instance;
    }
    return SlackFormOption.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link SlackFormOption SlackFormOption}.
   * @return A new SlackFormOption builder
   */
  public static SlackFormOption.Builder builder() {
    return new SlackFormOption.Builder();
  }

  /**
   * Builds instances of type {@link SlackFormOption SlackFormOption}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_LABEL = 0x1L;
    private static final long INIT_BIT_VALUE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String label;
    private @Nullable String value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SlackFormOptionIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackFormOptionIF instance) {
      Objects.requireNonNull(instance, "instance");
      setLabel(instance.getLabel());
      setValue(instance.getValue());
      return this;
    }

    /**
     * Initializes the value for the {@link SlackFormOptionIF#getLabel() label} attribute.
     * @param label The value for label 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setLabel(String label) {
      this.label = Objects.requireNonNull(label, "label");
      initBits &= ~INIT_BIT_LABEL;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackFormOptionIF#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setValue(String value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Builds a new {@link SlackFormOption SlackFormOption}.
     * @return An immutable instance of SlackFormOption
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public SlackFormOption build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return SlackFormOption.validate(new SlackFormOption(label, value));
    }

    private boolean labelIsSet() {
      return (initBits & INIT_BIT_LABEL) == 0;
    }

    private boolean valueIsSet() {
      return (initBits & INIT_BIT_VALUE) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!labelIsSet()) attributes.add("label");
      if (!valueIsSet()) attributes.add("value");
      return "Cannot build SlackFormOption, some of required attributes are not set " + attributes;
    }
  }
}
