package com.hubspot.slack.client.models.dialog.form.elements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.actions.SlackDataSource;
import com.hubspot.slack.client.models.dialog.form.SlackFormElementTypes;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link AbstractSlackFormSelectElement}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code SlackFormSelectElement.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "AbstractSlackFormSelectElement"})
@Immutable
public final class SlackFormSelectElement
    extends AbstractSlackFormSelectElement {
  private final SlackFormElementTypes type;
  private final SlackDataSource dataSource;
  private final List<SlackFormOption> options;
  private final List<SlackFormOptionGroup> optionGroups;
  private final @Nullable String value;
  private final List<SlackFormOption> selectedOptions;
  private final @Nullable Integer minQueryLength;
  private final String name;
  private final String label;
  private final @Nullable String placeholder;
  private final @Nullable Boolean optional;

  private SlackFormSelectElement(SlackFormSelectElement.Builder builder) {
    this.options = createUnmodifiableList(true, builder.options);
    this.optionGroups = createUnmodifiableList(true, builder.optionGroups);
    this.value = builder.value;
    this.selectedOptions = createUnmodifiableList(true, builder.selectedOptions);
    this.minQueryLength = builder.minQueryLength;
    this.name = builder.name;
    this.label = builder.label;
    this.placeholder = builder.placeholder;
    this.optional = builder.optional;
    if (builder.type != null) {
      initShim.setType(builder.type);
    }
    if (builder.dataSource != null) {
      initShim.setDataSource(builder.dataSource);
    }
    this.type = initShim.getType();
    this.dataSource = initShim.getDataSource();
    this.initShim = null;
  }

  private SlackFormSelectElement(
      SlackFormElementTypes type,
      SlackDataSource dataSource,
      List<SlackFormOption> options,
      List<SlackFormOptionGroup> optionGroups,
      @Nullable String value,
      List<SlackFormOption> selectedOptions,
      @Nullable Integer minQueryLength,
      String name,
      String label,
      @Nullable String placeholder,
      @Nullable Boolean optional) {
    this.type = type;
    this.dataSource = dataSource;
    this.options = options;
    this.optionGroups = optionGroups;
    this.value = value;
    this.selectedOptions = selectedOptions;
    this.minQueryLength = minQueryLength;
    this.name = name;
    this.label = label;
    this.placeholder = placeholder;
    this.optional = optional;
    this.initShim = null;
  }

  private static final int STAGE_INITIALIZING = -1;
  private static final int STAGE_UNINITIALIZED = 0;
  private static final int STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private SlackFormElementTypes type;
    private int typeStage;

    SlackFormElementTypes getType() {
      if (typeStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (typeStage == STAGE_UNINITIALIZED) {
        typeStage = STAGE_INITIALIZING;
        this.type = Objects.requireNonNull(SlackFormSelectElement.super.getType(), "type");
        typeStage = STAGE_INITIALIZED;
      }
      return this.type;
    }

    void setType(SlackFormElementTypes type) {
      this.type = type;
      typeStage = STAGE_INITIALIZED;
    }
    private SlackDataSource dataSource;
    private int dataSourceStage;

    SlackDataSource getDataSource() {
      if (dataSourceStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (dataSourceStage == STAGE_UNINITIALIZED) {
        dataSourceStage = STAGE_INITIALIZING;
        this.dataSource = Objects.requireNonNull(SlackFormSelectElement.super.getDataSource(), "dataSource");
        dataSourceStage = STAGE_INITIALIZED;
      }
      return this.dataSource;
    }

    void setDataSource(SlackDataSource dataSource) {
      this.dataSource = dataSource;
      dataSourceStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      ArrayList<String> attributes = new ArrayList<String>();
      if (typeStage == STAGE_INITIALIZING) attributes.add("type");
      if (dataSourceStage == STAGE_INITIALIZING) attributes.add("dataSource");
      return "Cannot build SlackFormSelectElement, attribute initializers form cycle" + attributes;
    }
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public SlackFormElementTypes getType() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getType()
        : this.type;
  }

  /**
   * @return The value of the {@code dataSource} attribute
   */
  @JsonProperty
  @Override
  public SlackDataSource getDataSource() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDataSource()
        : this.dataSource;
  }

  /**
   * @return The value of the {@code options} attribute
   */
  @JsonProperty
  @Override
  public List<SlackFormOption> getOptions() {
    return options;
  }

  /**
   * @return The value of the {@code optionGroups} attribute
   */
  @JsonProperty
  @Override
  public List<SlackFormOptionGroup> getOptionGroups() {
    return optionGroups;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getValue() {
    return Optional.ofNullable(value);
  }

  /**
   * @return The value of the {@code selectedOptions} attribute
   */
  @JsonProperty
  @Override
  public List<SlackFormOption> getSelectedOptions() {
    return selectedOptions;
  }

  /**
   * @return The value of the {@code minQueryLength} attribute
   */
  @JsonProperty
  @Override
  public Optional<Integer> getMinQueryLength() {
    return Optional.ofNullable(minQueryLength);
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code label} attribute
   */
  @JsonProperty
  @Override
  public String getLabel() {
    return label;
  }

  /**
   * @return The value of the {@code placeholder} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getPlaceholder() {
    return Optional.ofNullable(placeholder);
  }

  /**
   * @return The value of the {@code optional} attribute
   */
  @JsonProperty("optional")
  @Override
  public Optional<Boolean> isOptional() {
    return Optional.ofNullable(optional);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractSlackFormSelectElement#getType() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param type A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final SlackFormSelectElement withType(SlackFormElementTypes type) {
    if (this.type == type) return this;
    SlackFormElementTypes newValue = Objects.requireNonNull(type, "type");
    return validate(new SlackFormSelectElement(
        newValue,
        this.dataSource,
        this.options,
        this.optionGroups,
        this.value,
        this.selectedOptions,
        this.minQueryLength,
        this.name,
        this.label,
        this.placeholder,
        this.optional));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractSlackFormSelectElement#getDataSource() dataSource} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param dataSource A new value for dataSource
   * @return A modified copy of the {@code this} object
   */
  public final SlackFormSelectElement withDataSource(SlackDataSource dataSource) {
    if (this.dataSource == dataSource) return this;
    SlackDataSource newValue = Objects.requireNonNull(dataSource, "dataSource");
    return validate(new SlackFormSelectElement(
        this.type,
        newValue,
        this.options,
        this.optionGroups,
        this.value,
        this.selectedOptions,
        this.minQueryLength,
        this.name,
        this.label,
        this.placeholder,
        this.optional));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractSlackFormSelectElement#getOptions() options}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final SlackFormSelectElement withOptions(SlackFormOption... elements) {
    List<SlackFormOption> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new SlackFormSelectElement(
        this.type,
        this.dataSource,
        newValue,
        this.optionGroups,
        this.value,
        this.selectedOptions,
        this.minQueryLength,
        this.name,
        this.label,
        this.placeholder,
        this.optional));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractSlackFormSelectElement#getOptions() options}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of options elements to set
   * @return A modified copy of {@code this} object
   */
  public final SlackFormSelectElement withOptions(Iterable<? extends SlackFormOption> elements) {
    if (this.options == elements) return this;
    List<SlackFormOption> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new SlackFormSelectElement(
        this.type,
        this.dataSource,
        newValue,
        this.optionGroups,
        this.value,
        this.selectedOptions,
        this.minQueryLength,
        this.name,
        this.label,
        this.placeholder,
        this.optional));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractSlackFormSelectElement#getOptionGroups() optionGroups}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final SlackFormSelectElement withOptionGroups(SlackFormOptionGroup... elements) {
    List<SlackFormOptionGroup> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new SlackFormSelectElement(
        this.type,
        this.dataSource,
        this.options,
        newValue,
        this.value,
        this.selectedOptions,
        this.minQueryLength,
        this.name,
        this.label,
        this.placeholder,
        this.optional));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractSlackFormSelectElement#getOptionGroups() optionGroups}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of optionGroups elements to set
   * @return A modified copy of {@code this} object
   */
  public final SlackFormSelectElement withOptionGroups(Iterable<? extends SlackFormOptionGroup> elements) {
    if (this.optionGroups == elements) return this;
    List<SlackFormOptionGroup> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new SlackFormSelectElement(
        this.type,
        this.dataSource,
        this.options,
        newValue,
        this.value,
        this.selectedOptions,
        this.minQueryLength,
        this.name,
        this.label,
        this.placeholder,
        this.optional));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AbstractSlackFormSelectElement#getValue() value} attribute.
   * @param value The value for value, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackFormSelectElement withValue(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.value, newValue)) return this;
    return validate(new SlackFormSelectElement(
        this.type,
        this.dataSource,
        this.options,
        this.optionGroups,
        newValue,
        this.selectedOptions,
        this.minQueryLength,
        this.name,
        this.label,
        this.placeholder,
        this.optional));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AbstractSlackFormSelectElement#getValue() value} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for value
   * @return A modified copy of {@code this} object
   */
  public final SlackFormSelectElement withValue(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.value, value)) return this;
    return validate(new SlackFormSelectElement(
        this.type,
        this.dataSource,
        this.options,
        this.optionGroups,
        value,
        this.selectedOptions,
        this.minQueryLength,
        this.name,
        this.label,
        this.placeholder,
        this.optional));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractSlackFormSelectElement#getSelectedOptions() selectedOptions}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final SlackFormSelectElement withSelectedOptions(SlackFormOption... elements) {
    List<SlackFormOption> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new SlackFormSelectElement(
        this.type,
        this.dataSource,
        this.options,
        this.optionGroups,
        this.value,
        newValue,
        this.minQueryLength,
        this.name,
        this.label,
        this.placeholder,
        this.optional));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractSlackFormSelectElement#getSelectedOptions() selectedOptions}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of selectedOptions elements to set
   * @return A modified copy of {@code this} object
   */
  public final SlackFormSelectElement withSelectedOptions(Iterable<? extends SlackFormOption> elements) {
    if (this.selectedOptions == elements) return this;
    List<SlackFormOption> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new SlackFormSelectElement(
        this.type,
        this.dataSource,
        this.options,
        this.optionGroups,
        this.value,
        newValue,
        this.minQueryLength,
        this.name,
        this.label,
        this.placeholder,
        this.optional));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AbstractSlackFormSelectElement#getMinQueryLength() minQueryLength} attribute.
   * @param value The value for minQueryLength, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackFormSelectElement withMinQueryLength(@Nullable Integer value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.minQueryLength, newValue)) return this;
    return validate(new SlackFormSelectElement(
        this.type,
        this.dataSource,
        this.options,
        this.optionGroups,
        this.value,
        this.selectedOptions,
        newValue,
        this.name,
        this.label,
        this.placeholder,
        this.optional));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AbstractSlackFormSelectElement#getMinQueryLength() minQueryLength} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for minQueryLength
   * @return A modified copy of {@code this} object
   */
  public final SlackFormSelectElement withMinQueryLength(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.minQueryLength, value)) return this;
    return validate(new SlackFormSelectElement(
        this.type,
        this.dataSource,
        this.options,
        this.optionGroups,
        this.value,
        this.selectedOptions,
        value,
        this.name,
        this.label,
        this.placeholder,
        this.optional));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractSlackFormSelectElement#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param name A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final SlackFormSelectElement withName(String name) {
    if (this.name.equals(name)) return this;
    String newValue = Objects.requireNonNull(name, "name");
    return validate(new SlackFormSelectElement(
        this.type,
        this.dataSource,
        this.options,
        this.optionGroups,
        this.value,
        this.selectedOptions,
        this.minQueryLength,
        newValue,
        this.label,
        this.placeholder,
        this.optional));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractSlackFormSelectElement#getLabel() label} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param label A new value for label
   * @return A modified copy of the {@code this} object
   */
  public final SlackFormSelectElement withLabel(String label) {
    if (this.label.equals(label)) return this;
    String newValue = Objects.requireNonNull(label, "label");
    return validate(new SlackFormSelectElement(
        this.type,
        this.dataSource,
        this.options,
        this.optionGroups,
        this.value,
        this.selectedOptions,
        this.minQueryLength,
        this.name,
        newValue,
        this.placeholder,
        this.optional));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AbstractSlackFormSelectElement#getPlaceholder() placeholder} attribute.
   * @param value The value for placeholder, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackFormSelectElement withPlaceholder(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.placeholder, newValue)) return this;
    return validate(new SlackFormSelectElement(
        this.type,
        this.dataSource,
        this.options,
        this.optionGroups,
        this.value,
        this.selectedOptions,
        this.minQueryLength,
        this.name,
        this.label,
        newValue,
        this.optional));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AbstractSlackFormSelectElement#getPlaceholder() placeholder} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for placeholder
   * @return A modified copy of {@code this} object
   */
  public final SlackFormSelectElement withPlaceholder(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.placeholder, value)) return this;
    return validate(new SlackFormSelectElement(
        this.type,
        this.dataSource,
        this.options,
        this.optionGroups,
        this.value,
        this.selectedOptions,
        this.minQueryLength,
        this.name,
        this.label,
        value,
        this.optional));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AbstractSlackFormSelectElement#isOptional() optional} attribute.
   * @param value The value for optional, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackFormSelectElement withOptional(@Nullable Boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.optional, newValue)) return this;
    return validate(new SlackFormSelectElement(
        this.type,
        this.dataSource,
        this.options,
        this.optionGroups,
        this.value,
        this.selectedOptions,
        this.minQueryLength,
        this.name,
        this.label,
        this.placeholder,
        newValue));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AbstractSlackFormSelectElement#isOptional() optional} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for optional
   * @return A modified copy of {@code this} object
   */
  public final SlackFormSelectElement withOptional(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.optional, value)) return this;
    return validate(new SlackFormSelectElement(
        this.type,
        this.dataSource,
        this.options,
        this.optionGroups,
        this.value,
        this.selectedOptions,
        this.minQueryLength,
        this.name,
        this.label,
        this.placeholder,
        value));
  }

  /**
   * This instance is equal to all instances of {@code SlackFormSelectElement} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof SlackFormSelectElement
        && equalTo((SlackFormSelectElement) another);
  }

  private boolean equalTo(SlackFormSelectElement another) {
    return type.equals(another.type)
        && dataSource.equals(another.dataSource)
        && options.equals(another.options)
        && optionGroups.equals(another.optionGroups)
        && Objects.equals(value, another.value)
        && selectedOptions.equals(another.selectedOptions)
        && Objects.equals(minQueryLength, another.minQueryLength)
        && name.equals(another.name)
        && label.equals(another.label)
        && Objects.equals(placeholder, another.placeholder)
        && Objects.equals(optional, another.optional);
  }

  /**
   * Computes a hash code from attributes: {@code type}, {@code dataSource}, {@code options}, {@code optionGroups}, {@code value}, {@code selectedOptions}, {@code minQueryLength}, {@code name}, {@code label}, {@code placeholder}, {@code optional}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + type.hashCode();
    h = h * 17 + dataSource.hashCode();
    h = h * 17 + options.hashCode();
    h = h * 17 + optionGroups.hashCode();
    h = h * 17 + Objects.hashCode(value);
    h = h * 17 + selectedOptions.hashCode();
    h = h * 17 + Objects.hashCode(minQueryLength);
    h = h * 17 + name.hashCode();
    h = h * 17 + label.hashCode();
    h = h * 17 + Objects.hashCode(placeholder);
    h = h * 17 + Objects.hashCode(optional);
    return h;
  }

  /**
   * Prints the immutable value {@code SlackFormSelectElement} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("SlackFormSelectElement{");
    builder.append("type=").append(type);
    builder.append(", ");
    builder.append("dataSource=").append(dataSource);
    builder.append(", ");
    builder.append("options=").append(options);
    builder.append(", ");
    builder.append("optionGroups=").append(optionGroups);
    if (value != null) {
      builder.append(", ");
      builder.append("value=").append(value);
    }
    builder.append(", ");
    builder.append("selectedOptions=").append(selectedOptions);
    if (minQueryLength != null) {
      builder.append(", ");
      builder.append("minQueryLength=").append(minQueryLength);
    }
    builder.append(", ");
    builder.append("name=").append(name);
    builder.append(", ");
    builder.append("label=").append(label);
    if (placeholder != null) {
      builder.append(", ");
      builder.append("placeholder=").append(placeholder);
    }
    if (optional != null) {
      builder.append(", ");
      builder.append("optional=").append(optional);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      extends AbstractSlackFormSelectElement {
    @Nullable SlackFormElementTypes type;
    @Nullable SlackDataSource dataSource;
    List<SlackFormOption> options = Collections.emptyList();
    List<SlackFormOptionGroup> optionGroups = Collections.emptyList();
    Optional<String> value = Optional.empty();
    List<SlackFormOption> selectedOptions = Collections.emptyList();
    Optional<Integer> minQueryLength = Optional.empty();
    @Nullable String name;
    @Nullable String label;
    Optional<String> placeholder = Optional.empty();
    Optional<Boolean> optional = Optional.empty();
    @JsonProperty
    public void setType(SlackFormElementTypes type) {
      this.type = type;
    }
    @JsonProperty
    public void setDataSource(SlackDataSource dataSource) {
      this.dataSource = dataSource;
    }
    @JsonProperty
    public void setOptions(List<SlackFormOption> options) {
      this.options = options;
    }
    @JsonProperty
    public void setOptionGroups(List<SlackFormOptionGroup> optionGroups) {
      this.optionGroups = optionGroups;
    }
    @JsonProperty
    public void setValue(Optional<String> value) {
      this.value = value;
    }
    @JsonProperty
    public void setSelectedOptions(List<SlackFormOption> selectedOptions) {
      this.selectedOptions = selectedOptions;
    }
    @JsonProperty
    public void setMinQueryLength(Optional<Integer> minQueryLength) {
      this.minQueryLength = minQueryLength;
    }
    @JsonProperty
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty
    public void setLabel(String label) {
      this.label = label;
    }
    @JsonProperty
    public void setPlaceholder(Optional<String> placeholder) {
      this.placeholder = placeholder;
    }
    @JsonProperty("optional")
    public void setOptional(Optional<Boolean> optional) {
      this.optional = optional;
    }
    @Override
    public SlackFormElementTypes getType() { throw new UnsupportedOperationException(); }
    @Override
    public SlackDataSource getDataSource() { throw new UnsupportedOperationException(); }
    @Override
    public List<SlackFormOption> getOptions() { throw new UnsupportedOperationException(); }
    @Override
    public List<SlackFormOptionGroup> getOptionGroups() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getValue() { throw new UnsupportedOperationException(); }
    @Override
    public List<SlackFormOption> getSelectedOptions() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Integer> getMinQueryLength() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getLabel() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getPlaceholder() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> isOptional() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static SlackFormSelectElement fromJson(Json json) {
    SlackFormSelectElement.Builder builder = SlackFormSelectElement.builder();
    if (json.type != null) {
      builder.setType(json.type);
    }
    if (json.dataSource != null) {
      builder.setDataSource(json.dataSource);
    }
    if (json.options != null) {
      builder.addAllOptions(json.options);
    }
    if (json.optionGroups != null) {
      builder.addAllOptionGroups(json.optionGroups);
    }
    if (json.value != null) {
      builder.setValue(json.value);
    }
    if (json.selectedOptions != null) {
      builder.addAllSelectedOptions(json.selectedOptions);
    }
    if (json.minQueryLength != null) {
      builder.setMinQueryLength(json.minQueryLength);
    }
    if (json.name != null) {
      builder.setName(json.name);
    }
    if (json.label != null) {
      builder.setLabel(json.label);
    }
    if (json.placeholder != null) {
      builder.setPlaceholder(json.placeholder);
    }
    if (json.optional != null) {
      builder.setOptional(json.optional);
    }
    return builder.build();
  }

  private static SlackFormSelectElement validate(SlackFormSelectElement instance) {
    instance.validate();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link AbstractSlackFormSelectElement} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SlackFormSelectElement instance
   */
  public static SlackFormSelectElement copyOf(AbstractSlackFormSelectElement instance) {
    if (instance instanceof SlackFormSelectElement) {
      return (SlackFormSelectElement) instance;
    }
    return SlackFormSelectElement.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link SlackFormSelectElement SlackFormSelectElement}.
   * @return A new SlackFormSelectElement builder
   */
  public static SlackFormSelectElement.Builder builder() {
    return new SlackFormSelectElement.Builder();
  }

  /**
   * Builds instances of type {@link SlackFormSelectElement SlackFormSelectElement}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private static final long INIT_BIT_LABEL = 0x2L;
    private long initBits = 0x3L;

    private @Nullable SlackFormElementTypes type;
    private @Nullable SlackDataSource dataSource;
    private List<SlackFormOption> options = new ArrayList<SlackFormOption>();
    private List<SlackFormOptionGroup> optionGroups = new ArrayList<SlackFormOptionGroup>();
    private @Nullable String value;
    private List<SlackFormOption> selectedOptions = new ArrayList<SlackFormOption>();
    private @Nullable Integer minQueryLength;
    private @Nullable String name;
    private @Nullable String label;
    private @Nullable String placeholder;
    private @Nullable Boolean optional;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.dialog.form.elements.SlackDialogFormElement} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackDialogFormElement instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.dialog.form.elements.AbstractSlackFormSelectElement} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractSlackFormSelectElement instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof SlackDialogFormElement) {
        SlackDialogFormElement instance = (SlackDialogFormElement) object;
        setName(instance.getName());
        Optional<Boolean> optionalOptional = instance.isOptional();
        if (optionalOptional.isPresent()) {
          setOptional(optionalOptional);
        }
        setLabel(instance.getLabel());
        Optional<String> placeholderOptional = instance.getPlaceholder();
        if (placeholderOptional.isPresent()) {
          setPlaceholder(placeholderOptional);
        }
        if ((bits & 0x1L) == 0) {
          setType(instance.getType());
          bits |= 0x1L;
        }
      }
      if (object instanceof AbstractSlackFormSelectElement) {
        AbstractSlackFormSelectElement instance = (AbstractSlackFormSelectElement) object;
        Optional<Integer> minQueryLengthOptional = instance.getMinQueryLength();
        if (minQueryLengthOptional.isPresent()) {
          setMinQueryLength(minQueryLengthOptional);
        }
        addAllOptions(instance.getOptions());
        addAllSelectedOptions(instance.getSelectedOptions());
        addAllOptionGroups(instance.getOptionGroups());
        if ((bits & 0x1L) == 0) {
          setType(instance.getType());
          bits |= 0x1L;
        }
        setDataSource(instance.getDataSource());
        Optional<String> valueOptional = instance.getValue();
        if (valueOptional.isPresent()) {
          setValue(valueOptional);
        }
      }
    }

    /**
     * Initializes the value for the {@link AbstractSlackFormSelectElement#getType() type} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link AbstractSlackFormSelectElement#getType() type}.</em>
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setType(SlackFormElementTypes type) {
      this.type = Objects.requireNonNull(type, "type");
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractSlackFormSelectElement#getDataSource() dataSource} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link AbstractSlackFormSelectElement#getDataSource() dataSource}.</em>
     * @param dataSource The value for dataSource 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setDataSource(SlackDataSource dataSource) {
      this.dataSource = Objects.requireNonNull(dataSource, "dataSource");
      return this;
    }

    /**
     * Adds one element to {@link AbstractSlackFormSelectElement#getOptions() options} list.
     * @param element A options element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addOptions(SlackFormOption element) {
      this.options.add(Objects.requireNonNull(element, "options element"));
      return this;
    }

    /**
     * Adds elements to {@link AbstractSlackFormSelectElement#getOptions() options} list.
     * @param elements An array of options elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addOptions(SlackFormOption... elements) {
      for (SlackFormOption element : elements) {
        this.options.add(Objects.requireNonNull(element, "options element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link AbstractSlackFormSelectElement#getOptions() options} list.
     * @param elements An iterable of options elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setOptions(Iterable<? extends SlackFormOption> elements) {
      this.options.clear();
      return addAllOptions(elements);
    }

    /**
     * Adds elements to {@link AbstractSlackFormSelectElement#getOptions() options} list.
     * @param elements An iterable of options elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllOptions(Iterable<? extends SlackFormOption> elements) {
      for (SlackFormOption element : elements) {
        this.options.add(Objects.requireNonNull(element, "options element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link AbstractSlackFormSelectElement#getOptionGroups() optionGroups} list.
     * @param element A optionGroups element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addOptionGroups(SlackFormOptionGroup element) {
      this.optionGroups.add(Objects.requireNonNull(element, "optionGroups element"));
      return this;
    }

    /**
     * Adds elements to {@link AbstractSlackFormSelectElement#getOptionGroups() optionGroups} list.
     * @param elements An array of optionGroups elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addOptionGroups(SlackFormOptionGroup... elements) {
      for (SlackFormOptionGroup element : elements) {
        this.optionGroups.add(Objects.requireNonNull(element, "optionGroups element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link AbstractSlackFormSelectElement#getOptionGroups() optionGroups} list.
     * @param elements An iterable of optionGroups elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setOptionGroups(Iterable<? extends SlackFormOptionGroup> elements) {
      this.optionGroups.clear();
      return addAllOptionGroups(elements);
    }

    /**
     * Adds elements to {@link AbstractSlackFormSelectElement#getOptionGroups() optionGroups} list.
     * @param elements An iterable of optionGroups elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllOptionGroups(Iterable<? extends SlackFormOptionGroup> elements) {
      for (SlackFormOptionGroup element : elements) {
        this.optionGroups.add(Objects.requireNonNull(element, "optionGroups element"));
      }
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlackFormSelectElement#getValue() value} to value.
     * @param value The value for value, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setValue(@Nullable String value) {
      this.value = value;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlackFormSelectElement#getValue() value} to value.
     * @param value The value for value
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setValue(Optional<String> value) {
      this.value = value.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link AbstractSlackFormSelectElement#getSelectedOptions() selectedOptions} list.
     * @param element A selectedOptions element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSelectedOptions(SlackFormOption element) {
      this.selectedOptions.add(Objects.requireNonNull(element, "selectedOptions element"));
      return this;
    }

    /**
     * Adds elements to {@link AbstractSlackFormSelectElement#getSelectedOptions() selectedOptions} list.
     * @param elements An array of selectedOptions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addSelectedOptions(SlackFormOption... elements) {
      for (SlackFormOption element : elements) {
        this.selectedOptions.add(Objects.requireNonNull(element, "selectedOptions element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link AbstractSlackFormSelectElement#getSelectedOptions() selectedOptions} list.
     * @param elements An iterable of selectedOptions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setSelectedOptions(Iterable<? extends SlackFormOption> elements) {
      this.selectedOptions.clear();
      return addAllSelectedOptions(elements);
    }

    /**
     * Adds elements to {@link AbstractSlackFormSelectElement#getSelectedOptions() selectedOptions} list.
     * @param elements An iterable of selectedOptions elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllSelectedOptions(Iterable<? extends SlackFormOption> elements) {
      for (SlackFormOption element : elements) {
        this.selectedOptions.add(Objects.requireNonNull(element, "selectedOptions element"));
      }
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlackFormSelectElement#getMinQueryLength() minQueryLength} to minQueryLength.
     * @param minQueryLength The value for minQueryLength, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setMinQueryLength(@Nullable Integer minQueryLength) {
      this.minQueryLength = minQueryLength;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlackFormSelectElement#getMinQueryLength() minQueryLength} to minQueryLength.
     * @param minQueryLength The value for minQueryLength
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setMinQueryLength(Optional<Integer> minQueryLength) {
      this.minQueryLength = minQueryLength.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractSlackFormSelectElement#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setName(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractSlackFormSelectElement#getLabel() label} attribute.
     * @param label The value for label 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setLabel(String label) {
      this.label = Objects.requireNonNull(label, "label");
      initBits &= ~INIT_BIT_LABEL;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlackFormSelectElement#getPlaceholder() placeholder} to placeholder.
     * @param placeholder The value for placeholder, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setPlaceholder(@Nullable String placeholder) {
      this.placeholder = placeholder;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlackFormSelectElement#getPlaceholder() placeholder} to placeholder.
     * @param placeholder The value for placeholder
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setPlaceholder(Optional<String> placeholder) {
      this.placeholder = placeholder.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlackFormSelectElement#isOptional() optional} to optional.
     * @param optional The value for optional, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setOptional(@Nullable Boolean optional) {
      this.optional = optional;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlackFormSelectElement#isOptional() optional} to optional.
     * @param optional The value for optional
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setOptional(Optional<Boolean> optional) {
      this.optional = optional.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link SlackFormSelectElement SlackFormSelectElement}.
     * @return An immutable instance of SlackFormSelectElement
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public SlackFormSelectElement build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return SlackFormSelectElement.validate(new SlackFormSelectElement(this));
    }

    private boolean nameIsSet() {
      return (initBits & INIT_BIT_NAME) == 0;
    }

    private boolean labelIsSet() {
      return (initBits & INIT_BIT_LABEL) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!nameIsSet()) attributes.add("name");
      if (!labelIsSet()) attributes.add("label");
      return "Cannot build SlackFormSelectElement, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
