package com.hubspot.slack.client.models.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ChallengeEventIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ChallengeEvent.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ChallengeEventIF"})
@Immutable
public final class ChallengeEvent implements ChallengeEventIF {
  private final String token;
  private final String challenge;
  private final String type;

  private ChallengeEvent(String token, String challenge, String type) {
    this.token = token;
    this.challenge = challenge;
    this.type = type;
  }

  /**
   * @return The value of the {@code token} attribute
   */
  @JsonProperty
  @Override
  public String getToken() {
    return token;
  }

  /**
   * @return The value of the {@code challenge} attribute
   */
  @JsonProperty
  @Override
  public String getChallenge() {
    return challenge;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public String getType() {
    return type;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ChallengeEventIF#getToken() token} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param token A new value for token
   * @return A modified copy of the {@code this} object
   */
  public final ChallengeEvent withToken(String token) {
    if (this.token.equals(token)) return this;
    String newValue = Objects.requireNonNull(token, "token");
    return new ChallengeEvent(newValue, this.challenge, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ChallengeEventIF#getChallenge() challenge} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param challenge A new value for challenge
   * @return A modified copy of the {@code this} object
   */
  public final ChallengeEvent withChallenge(String challenge) {
    if (this.challenge.equals(challenge)) return this;
    String newValue = Objects.requireNonNull(challenge, "challenge");
    return new ChallengeEvent(this.token, newValue, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ChallengeEventIF#getType() type} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param type A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ChallengeEvent withType(String type) {
    if (this.type.equals(type)) return this;
    String newValue = Objects.requireNonNull(type, "type");
    return new ChallengeEvent(this.token, this.challenge, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ChallengeEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ChallengeEvent
        && equalTo((ChallengeEvent) another);
  }

  private boolean equalTo(ChallengeEvent another) {
    return token.equals(another.token)
        && challenge.equals(another.challenge)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code token}, {@code challenge}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + token.hashCode();
    h = h * 17 + challenge.hashCode();
    h = h * 17 + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ChallengeEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ChallengeEvent{"
        + "token=" + token
        + ", challenge=" + challenge
        + ", type=" + type
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ChallengeEventIF {
    @Nullable String token;
    @Nullable String challenge;
    @Nullable String type;
    @JsonProperty
    public void setToken(String token) {
      this.token = token;
    }
    @JsonProperty
    public void setChallenge(String challenge) {
      this.challenge = challenge;
    }
    @JsonProperty
    public void setType(String type) {
      this.type = type;
    }
    @Override
    public String getToken() { throw new UnsupportedOperationException(); }
    @Override
    public String getChallenge() { throw new UnsupportedOperationException(); }
    @Override
    public String getType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ChallengeEvent fromJson(Json json) {
    ChallengeEvent.Builder builder = ChallengeEvent.builder();
    if (json.token != null) {
      builder.setToken(json.token);
    }
    if (json.challenge != null) {
      builder.setChallenge(json.challenge);
    }
    if (json.type != null) {
      builder.setType(json.type);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ChallengeEventIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ChallengeEvent instance
   */
  public static ChallengeEvent copyOf(ChallengeEventIF instance) {
    if (instance instanceof ChallengeEvent) {
      return (ChallengeEvent) instance;
    }
    return ChallengeEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ChallengeEvent ChallengeEvent}.
   * @return A new ChallengeEvent builder
   */
  public static ChallengeEvent.Builder builder() {
    return new ChallengeEvent.Builder();
  }

  /**
   * Builds instances of type {@link ChallengeEvent ChallengeEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TOKEN = 0x1L;
    private static final long INIT_BIT_CHALLENGE = 0x2L;
    private static final long INIT_BIT_TYPE = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String token;
    private @Nullable String challenge;
    private @Nullable String type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ChallengeEventIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ChallengeEventIF instance) {
      Objects.requireNonNull(instance, "instance");
      setToken(instance.getToken());
      setChallenge(instance.getChallenge());
      setType(instance.getType());
      return this;
    }

    /**
     * Initializes the value for the {@link ChallengeEventIF#getToken() token} attribute.
     * @param token The value for token 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setToken(String token) {
      this.token = Objects.requireNonNull(token, "token");
      initBits &= ~INIT_BIT_TOKEN;
      return this;
    }

    /**
     * Initializes the value for the {@link ChallengeEventIF#getChallenge() challenge} attribute.
     * @param challenge The value for challenge 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChallenge(String challenge) {
      this.challenge = Objects.requireNonNull(challenge, "challenge");
      initBits &= ~INIT_BIT_CHALLENGE;
      return this;
    }

    /**
     * Initializes the value for the {@link ChallengeEventIF#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setType(String type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link ChallengeEvent ChallengeEvent}.
     * @return An immutable instance of ChallengeEvent
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ChallengeEvent build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new ChallengeEvent(token, challenge, type);
    }

    private boolean tokenIsSet() {
      return (initBits & INIT_BIT_TOKEN) == 0;
    }

    private boolean challengeIsSet() {
      return (initBits & INIT_BIT_CHALLENGE) == 0;
    }

    private boolean typeIsSet() {
      return (initBits & INIT_BIT_TYPE) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!tokenIsSet()) attributes.add("token");
      if (!challengeIsSet()) attributes.add("challenge");
      if (!typeIsSet()) attributes.add("type");
      return "Cannot build ChallengeEvent, some of required attributes are not set " + attributes;
    }
  }
}
