package com.hubspot.slack.client.models.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ChallengeResponseIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ChallengeResponse.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ChallengeResponseIF"})
@Immutable
public final class ChallengeResponse implements ChallengeResponseIF {
  private final String challenge;

  private ChallengeResponse(String challenge) {
    this.challenge = challenge;
  }

  /**
   * @return The value of the {@code challenge} attribute
   */
  @JsonProperty
  @Override
  public String getChallenge() {
    return challenge;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ChallengeResponseIF#getChallenge() challenge} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param challenge A new value for challenge
   * @return A modified copy of the {@code this} object
   */
  public final ChallengeResponse withChallenge(String challenge) {
    if (this.challenge.equals(challenge)) return this;
    String newValue = Objects.requireNonNull(challenge, "challenge");
    return new ChallengeResponse(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ChallengeResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ChallengeResponse
        && equalTo((ChallengeResponse) another);
  }

  private boolean equalTo(ChallengeResponse another) {
    return challenge.equals(another.challenge);
  }

  /**
   * Computes a hash code from attributes: {@code challenge}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + challenge.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ChallengeResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ChallengeResponse{"
        + "challenge=" + challenge
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ChallengeResponseIF {
    @Nullable String challenge;
    @JsonProperty
    public void setChallenge(String challenge) {
      this.challenge = challenge;
    }
    @Override
    public String getChallenge() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ChallengeResponse fromJson(Json json) {
    ChallengeResponse.Builder builder = ChallengeResponse.builder();
    if (json.challenge != null) {
      builder.setChallenge(json.challenge);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ChallengeResponseIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ChallengeResponse instance
   */
  public static ChallengeResponse copyOf(ChallengeResponseIF instance) {
    if (instance instanceof ChallengeResponse) {
      return (ChallengeResponse) instance;
    }
    return ChallengeResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ChallengeResponse ChallengeResponse}.
   * @return A new ChallengeResponse builder
   */
  public static ChallengeResponse.Builder builder() {
    return new ChallengeResponse.Builder();
  }

  /**
   * Builds instances of type {@link ChallengeResponse ChallengeResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CHALLENGE = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String challenge;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ChallengeResponseIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ChallengeResponseIF instance) {
      Objects.requireNonNull(instance, "instance");
      setChallenge(instance.getChallenge());
      return this;
    }

    /**
     * Initializes the value for the {@link ChallengeResponseIF#getChallenge() challenge} attribute.
     * @param challenge The value for challenge 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChallenge(String challenge) {
      this.challenge = Objects.requireNonNull(challenge, "challenge");
      initBits &= ~INIT_BIT_CHALLENGE;
      return this;
    }

    /**
     * Builds a new {@link ChallengeResponse ChallengeResponse}.
     * @return An immutable instance of ChallengeResponse
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ChallengeResponse build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new ChallengeResponse(challenge);
    }

    private boolean challengeIsSet() {
      return (initBits & INIT_BIT_CHALLENGE) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!challengeIsSet()) attributes.add("challenge");
      return "Cannot build ChallengeResponse, some of required attributes are not set " + attributes;
    }
  }
}
