package com.hubspot.slack.client.models.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import com.hubspot.slack.client.models.Attachment;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link AbstractSlackEventBotMessage}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code SlackEventBotMessage.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "AbstractSlackEventBotMessage"})
@Immutable
public final class SlackEventBotMessage
    extends AbstractSlackEventBotMessage {
  private final String channelId;
  private final @Nullable String text;
  private final List<Attachment> attachments;
  private final String botId;
  private final @Nullable SlackMessageSubtype subtype;
  private final SlackEventType type;
  private final String ts;

  private SlackEventBotMessage(
      String channelId,
      @Nullable String text,
      List<Attachment> attachments,
      String botId,
      @Nullable SlackMessageSubtype subtype,
      SlackEventType type,
      String ts) {
    this.channelId = channelId;
    this.text = text;
    this.attachments = attachments;
    this.botId = botId;
    this.subtype = subtype;
    this.type = type;
    this.ts = ts;
  }

  /**
   * @return The value of the {@code channelId} attribute
   */
  @JsonProperty("channel")
  @Override
  public String getChannelId() {
    return channelId;
  }

  /**
   * @return The value of the {@code text} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getText() {
    return Optional.ofNullable(text);
  }

  /**
   * @return The value of the {@code attachments} attribute
   */
  @JsonProperty
  @Override
  public List<Attachment> getAttachments() {
    return attachments;
  }

  /**
   * @return The value of the {@code botId} attribute
   */
  @JsonProperty
  @Override
  public String getBotId() {
    return botId;
  }

  /**
   * @return The value of the {@code subtype} attribute
   */
  @JsonProperty
  @Override
  public Optional<SlackMessageSubtype> getSubtype() {
    return Optional.ofNullable(subtype);
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public SlackEventType getType() {
    return type;
  }

  /**
   * @return The value of the {@code ts} attribute
   */
  @JsonProperty
  @Override
  public String getTs() {
    return ts;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractSlackEventBotMessage#getChannelId() channelId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param channelId A new value for channelId
   * @return A modified copy of the {@code this} object
   */
  public final SlackEventBotMessage withChannelId(String channelId) {
    if (this.channelId.equals(channelId)) return this;
    String newValue = Objects.requireNonNull(channelId, "channelId");
    return new SlackEventBotMessage(newValue, this.text, this.attachments, this.botId, this.subtype, this.type, this.ts);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AbstractSlackEventBotMessage#getText() text} attribute.
   * @param value The value for text, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackEventBotMessage withText(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.text, newValue)) return this;
    return new SlackEventBotMessage(this.channelId, newValue, this.attachments, this.botId, this.subtype, this.type, this.ts);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AbstractSlackEventBotMessage#getText() text} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for text
   * @return A modified copy of {@code this} object
   */
  public final SlackEventBotMessage withText(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.text, value)) return this;
    return new SlackEventBotMessage(this.channelId, value, this.attachments, this.botId, this.subtype, this.type, this.ts);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractSlackEventBotMessage#getAttachments() attachments}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final SlackEventBotMessage withAttachments(Attachment... elements) {
    List<Attachment> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new SlackEventBotMessage(this.channelId, this.text, newValue, this.botId, this.subtype, this.type, this.ts);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractSlackEventBotMessage#getAttachments() attachments}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of attachments elements to set
   * @return A modified copy of {@code this} object
   */
  public final SlackEventBotMessage withAttachments(Iterable<? extends Attachment> elements) {
    if (this.attachments == elements) return this;
    List<Attachment> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new SlackEventBotMessage(this.channelId, this.text, newValue, this.botId, this.subtype, this.type, this.ts);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractSlackEventBotMessage#getBotId() botId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param botId A new value for botId
   * @return A modified copy of the {@code this} object
   */
  public final SlackEventBotMessage withBotId(String botId) {
    if (this.botId.equals(botId)) return this;
    String newValue = Objects.requireNonNull(botId, "botId");
    return new SlackEventBotMessage(this.channelId, this.text, this.attachments, newValue, this.subtype, this.type, this.ts);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AbstractSlackEventBotMessage#getSubtype() subtype} attribute.
   * @param value The value for subtype, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackEventBotMessage withSubtype(@Nullable SlackMessageSubtype value) {
    @Nullable SlackMessageSubtype newValue = value;
    if (Objects.equals(this.subtype, newValue)) return this;
    return new SlackEventBotMessage(this.channelId, this.text, this.attachments, this.botId, newValue, this.type, this.ts);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AbstractSlackEventBotMessage#getSubtype() subtype} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for subtype
   * @return A modified copy of {@code this} object
   */
  public final SlackEventBotMessage withSubtype(Optional<SlackMessageSubtype> optional) {
    @Nullable SlackMessageSubtype value = optional.orElse(null);
    if (Objects.equals(this.subtype, value)) return this;
    return new SlackEventBotMessage(this.channelId, this.text, this.attachments, this.botId, value, this.type, this.ts);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractSlackEventBotMessage#getType() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param type A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final SlackEventBotMessage withType(SlackEventType type) {
    if (this.type == type) return this;
    SlackEventType newValue = Objects.requireNonNull(type, "type");
    return new SlackEventBotMessage(this.channelId, this.text, this.attachments, this.botId, this.subtype, newValue, this.ts);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractSlackEventBotMessage#getTs() ts} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param ts A new value for ts
   * @return A modified copy of the {@code this} object
   */
  public final SlackEventBotMessage withTs(String ts) {
    if (this.ts.equals(ts)) return this;
    String newValue = Objects.requireNonNull(ts, "ts");
    return new SlackEventBotMessage(this.channelId, this.text, this.attachments, this.botId, this.subtype, this.type, newValue);
  }

  /**
   * This instance is equal to all instances of {@code SlackEventBotMessage} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof SlackEventBotMessage
        && equalTo((SlackEventBotMessage) another);
  }

  private boolean equalTo(SlackEventBotMessage another) {
    return channelId.equals(another.channelId)
        && Objects.equals(text, another.text)
        && attachments.equals(another.attachments)
        && botId.equals(another.botId)
        && Objects.equals(subtype, another.subtype)
        && type.equals(another.type)
        && ts.equals(another.ts);
  }

  /**
   * Computes a hash code from attributes: {@code channelId}, {@code text}, {@code attachments}, {@code botId}, {@code subtype}, {@code type}, {@code ts}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + channelId.hashCode();
    h = h * 17 + Objects.hashCode(text);
    h = h * 17 + attachments.hashCode();
    h = h * 17 + botId.hashCode();
    h = h * 17 + Objects.hashCode(subtype);
    h = h * 17 + type.hashCode();
    h = h * 17 + ts.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SlackEventBotMessage} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("SlackEventBotMessage{");
    builder.append("channelId=").append(channelId);
    if (text != null) {
      builder.append(", ");
      builder.append("text=").append(text);
    }
    builder.append(", ");
    builder.append("attachments=").append(attachments);
    builder.append(", ");
    builder.append("botId=").append(botId);
    if (subtype != null) {
      builder.append(", ");
      builder.append("subtype=").append(subtype);
    }
    builder.append(", ");
    builder.append("type=").append(type);
    builder.append(", ");
    builder.append("ts=").append(ts);
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends AbstractSlackEventBotMessage {
    @Nullable String channelId;
    Optional<String> text = Optional.empty();
    List<Attachment> attachments = Collections.emptyList();
    @Nullable String botId;
    Optional<SlackMessageSubtype> subtype = Optional.empty();
    @Nullable SlackEventType type;
    @Nullable String ts;
    @JsonProperty("channel")
    public void setChannelId(String channelId) {
      this.channelId = channelId;
    }
    @JsonProperty
    public void setText(Optional<String> text) {
      this.text = text;
    }
    @JsonProperty
    public void setAttachments(List<Attachment> attachments) {
      this.attachments = attachments;
    }
    @JsonProperty
    public void setBotId(String botId) {
      this.botId = botId;
    }
    @JsonProperty
    public void setSubtype(Optional<SlackMessageSubtype> subtype) {
      this.subtype = subtype;
    }
    @JsonProperty
    public void setType(SlackEventType type) {
      this.type = type;
    }
    @JsonProperty
    public void setTs(String ts) {
      this.ts = ts;
    }
    @Override
    public String getChannelId() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getText() { throw new UnsupportedOperationException(); }
    @Override
    public List<Attachment> getAttachments() { throw new UnsupportedOperationException(); }
    @Override
    public String getBotId() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<SlackMessageSubtype> getSubtype() { throw new UnsupportedOperationException(); }
    @Override
    public SlackEventType getType() { throw new UnsupportedOperationException(); }
    @Override
    public String getTs() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static SlackEventBotMessage fromJson(Json json) {
    SlackEventBotMessage.Builder builder = SlackEventBotMessage.builder();
    if (json.channelId != null) {
      builder.setChannelId(json.channelId);
    }
    if (json.text != null) {
      builder.setText(json.text);
    }
    if (json.attachments != null) {
      builder.addAllAttachments(json.attachments);
    }
    if (json.botId != null) {
      builder.setBotId(json.botId);
    }
    if (json.subtype != null) {
      builder.setSubtype(json.subtype);
    }
    if (json.type != null) {
      builder.setType(json.type);
    }
    if (json.ts != null) {
      builder.setTs(json.ts);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link AbstractSlackEventBotMessage} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SlackEventBotMessage instance
   */
  public static SlackEventBotMessage copyOf(AbstractSlackEventBotMessage instance) {
    if (instance instanceof SlackEventBotMessage) {
      return (SlackEventBotMessage) instance;
    }
    return SlackEventBotMessage.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link SlackEventBotMessage SlackEventBotMessage}.
   * @return A new SlackEventBotMessage builder
   */
  public static SlackEventBotMessage.Builder builder() {
    return new SlackEventBotMessage.Builder();
  }

  /**
   * Builds instances of type {@link SlackEventBotMessage SlackEventBotMessage}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CHANNEL_ID = 0x1L;
    private static final long INIT_BIT_BOT_ID = 0x2L;
    private static final long INIT_BIT_TYPE = 0x4L;
    private static final long INIT_BIT_TS = 0x8L;
    private long initBits = 0xfL;

    private @Nullable String channelId;
    private @Nullable String text;
    private List<Attachment> attachments = new ArrayList<Attachment>();
    private @Nullable String botId;
    private @Nullable SlackMessageSubtype subtype;
    private @Nullable SlackEventType type;
    private @Nullable String ts;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.interceptor.HasChannel} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(HasChannel instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.events.SlackEventMessageBase} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackEventMessageBase instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.events.SlackEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.events.AbstractSlackEventBotMessage} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractSlackEventBotMessage instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof HasChannel) {
        HasChannel instance = (HasChannel) object;
        if ((bits & 0x1L) == 0) {
          setChannelId(instance.getChannelId());
          bits |= 0x1L;
        }
      }
      if (object instanceof SlackEventMessageBase) {
        SlackEventMessageBase instance = (SlackEventMessageBase) object;
        Optional<SlackMessageSubtype> subtypeOptional = instance.getSubtype();
        if (subtypeOptional.isPresent()) {
          setSubtype(subtypeOptional);
        }
      }
      if (object instanceof SlackEvent) {
        SlackEvent instance = (SlackEvent) object;
        setType(instance.getType());
        setTs(instance.getTs());
      }
      if (object instanceof AbstractSlackEventBotMessage) {
        AbstractSlackEventBotMessage instance = (AbstractSlackEventBotMessage) object;
        addAllAttachments(instance.getAttachments());
        Optional<String> textOptional = instance.getText();
        if (textOptional.isPresent()) {
          setText(textOptional);
        }
        setBotId(instance.getBotId());
        if ((bits & 0x1L) == 0) {
          setChannelId(instance.getChannelId());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link AbstractSlackEventBotMessage#getChannelId() channelId} attribute.
     * @param channelId The value for channelId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannelId(String channelId) {
      this.channelId = Objects.requireNonNull(channelId, "channelId");
      initBits &= ~INIT_BIT_CHANNEL_ID;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlackEventBotMessage#getText() text} to text.
     * @param text The value for text, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setText(@Nullable String text) {
      this.text = text;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlackEventBotMessage#getText() text} to text.
     * @param text The value for text
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setText(Optional<String> text) {
      this.text = text.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link AbstractSlackEventBotMessage#getAttachments() attachments} list.
     * @param element A attachments element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAttachments(Attachment element) {
      this.attachments.add(Objects.requireNonNull(element, "attachments element"));
      return this;
    }

    /**
     * Adds elements to {@link AbstractSlackEventBotMessage#getAttachments() attachments} list.
     * @param elements An array of attachments elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAttachments(Attachment... elements) {
      for (Attachment element : elements) {
        this.attachments.add(Objects.requireNonNull(element, "attachments element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link AbstractSlackEventBotMessage#getAttachments() attachments} list.
     * @param elements An iterable of attachments elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setAttachments(Iterable<? extends Attachment> elements) {
      this.attachments.clear();
      return addAllAttachments(elements);
    }

    /**
     * Adds elements to {@link AbstractSlackEventBotMessage#getAttachments() attachments} list.
     * @param elements An iterable of attachments elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllAttachments(Iterable<? extends Attachment> elements) {
      for (Attachment element : elements) {
        this.attachments.add(Objects.requireNonNull(element, "attachments element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractSlackEventBotMessage#getBotId() botId} attribute.
     * @param botId The value for botId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setBotId(String botId) {
      this.botId = Objects.requireNonNull(botId, "botId");
      initBits &= ~INIT_BIT_BOT_ID;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlackEventBotMessage#getSubtype() subtype} to subtype.
     * @param subtype The value for subtype, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setSubtype(@Nullable SlackMessageSubtype subtype) {
      this.subtype = subtype;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlackEventBotMessage#getSubtype() subtype} to subtype.
     * @param subtype The value for subtype
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setSubtype(Optional<SlackMessageSubtype> subtype) {
      this.subtype = subtype.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractSlackEventBotMessage#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setType(SlackEventType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractSlackEventBotMessage#getTs() ts} attribute.
     * @param ts The value for ts 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTs(String ts) {
      this.ts = Objects.requireNonNull(ts, "ts");
      initBits &= ~INIT_BIT_TS;
      return this;
    }

    /**
     * Builds a new {@link SlackEventBotMessage SlackEventBotMessage}.
     * @return An immutable instance of SlackEventBotMessage
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public SlackEventBotMessage build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new SlackEventBotMessage(channelId, text, createUnmodifiableList(true, attachments), botId, subtype, type, ts);
    }

    private boolean channelIdIsSet() {
      return (initBits & INIT_BIT_CHANNEL_ID) == 0;
    }

    private boolean botIdIsSet() {
      return (initBits & INIT_BIT_BOT_ID) == 0;
    }

    private boolean typeIsSet() {
      return (initBits & INIT_BIT_TYPE) == 0;
    }

    private boolean tsIsSet() {
      return (initBits & INIT_BIT_TS) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!channelIdIsSet()) attributes.add("channelId");
      if (!botIdIsSet()) attributes.add("botId");
      if (!typeIsSet()) attributes.add("type");
      if (!tsIsSet()) attributes.add("ts");
      return "Cannot build SlackEventBotMessage, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
