package com.hubspot.slack.client.models.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import com.hubspot.slack.client.methods.interceptor.HasUser;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link AbstractSlackEventMessageIm}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code SlackEventMessageIm.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "AbstractSlackEventMessageIm"})
@Immutable
public final class SlackEventMessageIm
    extends AbstractSlackEventMessageIm {
  private final String channelId;
  private final @Nullable String threadTs;
  private final String text;
  private final String userId;
  private final @Nullable SlackMessageSubtype subtype;
  private final SlackEventType type;
  private final String ts;

  private SlackEventMessageIm(
      String channelId,
      @Nullable String threadTs,
      String text,
      String userId,
      @Nullable SlackMessageSubtype subtype,
      SlackEventType type,
      String ts) {
    this.channelId = channelId;
    this.threadTs = threadTs;
    this.text = text;
    this.userId = userId;
    this.subtype = subtype;
    this.type = type;
    this.ts = ts;
  }

  /**
   * @return The value of the {@code channelId} attribute
   */
  @JsonProperty("channel")
  @Override
  public String getChannelId() {
    return channelId;
  }

  /**
   * @return The value of the {@code threadTs} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getThreadTs() {
    return Optional.ofNullable(threadTs);
  }

  /**
   * @return The value of the {@code text} attribute
   */
  @JsonProperty
  @Override
  public String getText() {
    return text;
  }

  /**
   * @return The value of the {@code userId} attribute
   */
  @JsonProperty("user")
  @Override
  public String getUserId() {
    return userId;
  }

  /**
   * @return The value of the {@code subtype} attribute
   */
  @JsonProperty
  @Override
  public Optional<SlackMessageSubtype> getSubtype() {
    return Optional.ofNullable(subtype);
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public SlackEventType getType() {
    return type;
  }

  /**
   * @return The value of the {@code ts} attribute
   */
  @JsonProperty
  @Override
  public String getTs() {
    return ts;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractSlackEventMessageIm#getChannelId() channelId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param channelId A new value for channelId
   * @return A modified copy of the {@code this} object
   */
  public final SlackEventMessageIm withChannelId(String channelId) {
    if (this.channelId.equals(channelId)) return this;
    String newValue = Objects.requireNonNull(channelId, "channelId");
    return new SlackEventMessageIm(newValue, this.threadTs, this.text, this.userId, this.subtype, this.type, this.ts);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AbstractSlackEventMessageIm#getThreadTs() threadTs} attribute.
   * @param value The value for threadTs, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackEventMessageIm withThreadTs(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.threadTs, newValue)) return this;
    return new SlackEventMessageIm(this.channelId, newValue, this.text, this.userId, this.subtype, this.type, this.ts);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AbstractSlackEventMessageIm#getThreadTs() threadTs} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for threadTs
   * @return A modified copy of {@code this} object
   */
  public final SlackEventMessageIm withThreadTs(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.threadTs, value)) return this;
    return new SlackEventMessageIm(this.channelId, value, this.text, this.userId, this.subtype, this.type, this.ts);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractSlackEventMessageIm#getText() text} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param text A new value for text
   * @return A modified copy of the {@code this} object
   */
  public final SlackEventMessageIm withText(String text) {
    if (this.text.equals(text)) return this;
    String newValue = Objects.requireNonNull(text, "text");
    return new SlackEventMessageIm(this.channelId, this.threadTs, newValue, this.userId, this.subtype, this.type, this.ts);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractSlackEventMessageIm#getUserId() userId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param userId A new value for userId
   * @return A modified copy of the {@code this} object
   */
  public final SlackEventMessageIm withUserId(String userId) {
    if (this.userId.equals(userId)) return this;
    String newValue = Objects.requireNonNull(userId, "userId");
    return new SlackEventMessageIm(this.channelId, this.threadTs, this.text, newValue, this.subtype, this.type, this.ts);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AbstractSlackEventMessageIm#getSubtype() subtype} attribute.
   * @param value The value for subtype, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackEventMessageIm withSubtype(@Nullable SlackMessageSubtype value) {
    @Nullable SlackMessageSubtype newValue = value;
    if (Objects.equals(this.subtype, newValue)) return this;
    return new SlackEventMessageIm(this.channelId, this.threadTs, this.text, this.userId, newValue, this.type, this.ts);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AbstractSlackEventMessageIm#getSubtype() subtype} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for subtype
   * @return A modified copy of {@code this} object
   */
  public final SlackEventMessageIm withSubtype(Optional<SlackMessageSubtype> optional) {
    @Nullable SlackMessageSubtype value = optional.orElse(null);
    if (Objects.equals(this.subtype, value)) return this;
    return new SlackEventMessageIm(this.channelId, this.threadTs, this.text, this.userId, value, this.type, this.ts);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractSlackEventMessageIm#getType() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param type A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final SlackEventMessageIm withType(SlackEventType type) {
    if (this.type == type) return this;
    SlackEventType newValue = Objects.requireNonNull(type, "type");
    return new SlackEventMessageIm(this.channelId, this.threadTs, this.text, this.userId, this.subtype, newValue, this.ts);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractSlackEventMessageIm#getTs() ts} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param ts A new value for ts
   * @return A modified copy of the {@code this} object
   */
  public final SlackEventMessageIm withTs(String ts) {
    if (this.ts.equals(ts)) return this;
    String newValue = Objects.requireNonNull(ts, "ts");
    return new SlackEventMessageIm(this.channelId, this.threadTs, this.text, this.userId, this.subtype, this.type, newValue);
  }

  /**
   * This instance is equal to all instances of {@code SlackEventMessageIm} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof SlackEventMessageIm
        && equalTo((SlackEventMessageIm) another);
  }

  private boolean equalTo(SlackEventMessageIm another) {
    return channelId.equals(another.channelId)
        && Objects.equals(threadTs, another.threadTs)
        && text.equals(another.text)
        && userId.equals(another.userId)
        && Objects.equals(subtype, another.subtype)
        && type.equals(another.type)
        && ts.equals(another.ts);
  }

  /**
   * Computes a hash code from attributes: {@code channelId}, {@code threadTs}, {@code text}, {@code userId}, {@code subtype}, {@code type}, {@code ts}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + channelId.hashCode();
    h = h * 17 + Objects.hashCode(threadTs);
    h = h * 17 + text.hashCode();
    h = h * 17 + userId.hashCode();
    h = h * 17 + Objects.hashCode(subtype);
    h = h * 17 + type.hashCode();
    h = h * 17 + ts.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SlackEventMessageIm} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("SlackEventMessageIm{");
    builder.append("channelId=").append(channelId);
    if (threadTs != null) {
      builder.append(", ");
      builder.append("threadTs=").append(threadTs);
    }
    builder.append(", ");
    builder.append("text=").append(text);
    builder.append(", ");
    builder.append("userId=").append(userId);
    if (subtype != null) {
      builder.append(", ");
      builder.append("subtype=").append(subtype);
    }
    builder.append(", ");
    builder.append("type=").append(type);
    builder.append(", ");
    builder.append("ts=").append(ts);
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends AbstractSlackEventMessageIm {
    @Nullable String channelId;
    Optional<String> threadTs = Optional.empty();
    @Nullable String text;
    @Nullable String userId;
    Optional<SlackMessageSubtype> subtype = Optional.empty();
    @Nullable SlackEventType type;
    @Nullable String ts;
    @JsonProperty("channel")
    public void setChannelId(String channelId) {
      this.channelId = channelId;
    }
    @JsonProperty
    public void setThreadTs(Optional<String> threadTs) {
      this.threadTs = threadTs;
    }
    @JsonProperty
    public void setText(String text) {
      this.text = text;
    }
    @JsonProperty("user")
    public void setUserId(String userId) {
      this.userId = userId;
    }
    @JsonProperty
    public void setSubtype(Optional<SlackMessageSubtype> subtype) {
      this.subtype = subtype;
    }
    @JsonProperty
    public void setType(SlackEventType type) {
      this.type = type;
    }
    @JsonProperty
    public void setTs(String ts) {
      this.ts = ts;
    }
    @Override
    public String getChannelId() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getThreadTs() { throw new UnsupportedOperationException(); }
    @Override
    public String getText() { throw new UnsupportedOperationException(); }
    @Override
    public String getUserId() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<SlackMessageSubtype> getSubtype() { throw new UnsupportedOperationException(); }
    @Override
    public SlackEventType getType() { throw new UnsupportedOperationException(); }
    @Override
    public String getTs() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static SlackEventMessageIm fromJson(Json json) {
    SlackEventMessageIm.Builder builder = SlackEventMessageIm.builder();
    if (json.channelId != null) {
      builder.setChannelId(json.channelId);
    }
    if (json.threadTs != null) {
      builder.setThreadTs(json.threadTs);
    }
    if (json.text != null) {
      builder.setText(json.text);
    }
    if (json.userId != null) {
      builder.setUserId(json.userId);
    }
    if (json.subtype != null) {
      builder.setSubtype(json.subtype);
    }
    if (json.type != null) {
      builder.setType(json.type);
    }
    if (json.ts != null) {
      builder.setTs(json.ts);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link AbstractSlackEventMessageIm} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SlackEventMessageIm instance
   */
  public static SlackEventMessageIm copyOf(AbstractSlackEventMessageIm instance) {
    if (instance instanceof SlackEventMessageIm) {
      return (SlackEventMessageIm) instance;
    }
    return SlackEventMessageIm.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link SlackEventMessageIm SlackEventMessageIm}.
   * @return A new SlackEventMessageIm builder
   */
  public static SlackEventMessageIm.Builder builder() {
    return new SlackEventMessageIm.Builder();
  }

  /**
   * Builds instances of type {@link SlackEventMessageIm SlackEventMessageIm}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CHANNEL_ID = 0x1L;
    private static final long INIT_BIT_TEXT = 0x2L;
    private static final long INIT_BIT_USER_ID = 0x4L;
    private static final long INIT_BIT_TYPE = 0x8L;
    private static final long INIT_BIT_TS = 0x10L;
    private long initBits = 0x1fL;

    private @Nullable String channelId;
    private @Nullable String threadTs;
    private @Nullable String text;
    private @Nullable String userId;
    private @Nullable SlackMessageSubtype subtype;
    private @Nullable SlackEventType type;
    private @Nullable String ts;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.interceptor.HasChannel} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(HasChannel instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.events.SlackEventMessageBase} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackEventMessageBase instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.events.SlackEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.interceptor.HasUser} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(HasUser instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.events.AbstractSlackEventMessageIm} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractSlackEventMessageIm instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof HasChannel) {
        HasChannel instance = (HasChannel) object;
        if ((bits & 0x2L) == 0) {
          setChannelId(instance.getChannelId());
          bits |= 0x2L;
        }
      }
      if (object instanceof SlackEventMessageBase) {
        SlackEventMessageBase instance = (SlackEventMessageBase) object;
        Optional<SlackMessageSubtype> subtypeOptional = instance.getSubtype();
        if (subtypeOptional.isPresent()) {
          setSubtype(subtypeOptional);
        }
      }
      if (object instanceof SlackEvent) {
        SlackEvent instance = (SlackEvent) object;
        setType(instance.getType());
        setTs(instance.getTs());
      }
      if (object instanceof HasUser) {
        HasUser instance = (HasUser) object;
        if ((bits & 0x1L) == 0) {
          setUserId(instance.getUserId());
          bits |= 0x1L;
        }
      }
      if (object instanceof AbstractSlackEventMessageIm) {
        AbstractSlackEventMessageIm instance = (AbstractSlackEventMessageIm) object;
        setText(instance.getText());
        Optional<String> threadTsOptional = instance.getThreadTs();
        if (threadTsOptional.isPresent()) {
          setThreadTs(threadTsOptional);
        }
        if ((bits & 0x1L) == 0) {
          setUserId(instance.getUserId());
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          setChannelId(instance.getChannelId());
          bits |= 0x2L;
        }
      }
    }

    /**
     * Initializes the value for the {@link AbstractSlackEventMessageIm#getChannelId() channelId} attribute.
     * @param channelId The value for channelId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannelId(String channelId) {
      this.channelId = Objects.requireNonNull(channelId, "channelId");
      initBits &= ~INIT_BIT_CHANNEL_ID;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlackEventMessageIm#getThreadTs() threadTs} to threadTs.
     * @param threadTs The value for threadTs, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setThreadTs(@Nullable String threadTs) {
      this.threadTs = threadTs;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlackEventMessageIm#getThreadTs() threadTs} to threadTs.
     * @param threadTs The value for threadTs
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setThreadTs(Optional<String> threadTs) {
      this.threadTs = threadTs.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractSlackEventMessageIm#getText() text} attribute.
     * @param text The value for text 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setText(String text) {
      this.text = Objects.requireNonNull(text, "text");
      initBits &= ~INIT_BIT_TEXT;
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractSlackEventMessageIm#getUserId() userId} attribute.
     * @param userId The value for userId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUserId(String userId) {
      this.userId = Objects.requireNonNull(userId, "userId");
      initBits &= ~INIT_BIT_USER_ID;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlackEventMessageIm#getSubtype() subtype} to subtype.
     * @param subtype The value for subtype, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setSubtype(@Nullable SlackMessageSubtype subtype) {
      this.subtype = subtype;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlackEventMessageIm#getSubtype() subtype} to subtype.
     * @param subtype The value for subtype
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setSubtype(Optional<SlackMessageSubtype> subtype) {
      this.subtype = subtype.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractSlackEventMessageIm#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setType(SlackEventType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractSlackEventMessageIm#getTs() ts} attribute.
     * @param ts The value for ts 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTs(String ts) {
      this.ts = Objects.requireNonNull(ts, "ts");
      initBits &= ~INIT_BIT_TS;
      return this;
    }

    /**
     * Builds a new {@link SlackEventMessageIm SlackEventMessageIm}.
     * @return An immutable instance of SlackEventMessageIm
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public SlackEventMessageIm build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new SlackEventMessageIm(channelId, threadTs, text, userId, subtype, type, ts);
    }

    private boolean channelIdIsSet() {
      return (initBits & INIT_BIT_CHANNEL_ID) == 0;
    }

    private boolean textIsSet() {
      return (initBits & INIT_BIT_TEXT) == 0;
    }

    private boolean userIdIsSet() {
      return (initBits & INIT_BIT_USER_ID) == 0;
    }

    private boolean typeIsSet() {
      return (initBits & INIT_BIT_TYPE) == 0;
    }

    private boolean tsIsSet() {
      return (initBits & INIT_BIT_TS) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!channelIdIsSet()) attributes.add("channelId");
      if (!textIsSet()) attributes.add("text");
      if (!userIdIsSet()) attributes.add("userId");
      if (!typeIsSet()) attributes.add("type");
      if (!tsIsSet()) attributes.add("ts");
      return "Cannot build SlackEventMessageIm, some of required attributes are not set " + attributes;
    }
  }
}
