package com.hubspot.slack.client.models.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import com.hubspot.slack.client.models.events.util.SlackReplyMessage;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link AbstractSlackEventMessageReplied}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code SlackEventMessageReplied.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "AbstractSlackEventMessageReplied"})
@Immutable
public final class SlackEventMessageReplied
    extends AbstractSlackEventMessageReplied {
  private final String channelId;
  private final SlackReplyMessage message;
  private final @Nullable SlackMessageSubtype subtype;
  private final SlackEventType type;
  private final String ts;

  private SlackEventMessageReplied(
      String channelId,
      SlackReplyMessage message,
      @Nullable SlackMessageSubtype subtype,
      SlackEventType type,
      String ts) {
    this.channelId = channelId;
    this.message = message;
    this.subtype = subtype;
    this.type = type;
    this.ts = ts;
  }

  /**
   * @return The value of the {@code channelId} attribute
   */
  @JsonProperty("channel")
  @Override
  public String getChannelId() {
    return channelId;
  }

  /**
   * @return The value of the {@code message} attribute
   */
  @JsonProperty
  @Override
  public SlackReplyMessage getMessage() {
    return message;
  }

  /**
   * @return The value of the {@code subtype} attribute
   */
  @JsonProperty
  @Override
  public Optional<SlackMessageSubtype> getSubtype() {
    return Optional.ofNullable(subtype);
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public SlackEventType getType() {
    return type;
  }

  /**
   * @return The value of the {@code ts} attribute
   */
  @JsonProperty
  @Override
  public String getTs() {
    return ts;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractSlackEventMessageReplied#getChannelId() channelId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param channelId A new value for channelId
   * @return A modified copy of the {@code this} object
   */
  public final SlackEventMessageReplied withChannelId(String channelId) {
    if (this.channelId.equals(channelId)) return this;
    String newValue = Objects.requireNonNull(channelId, "channelId");
    return new SlackEventMessageReplied(newValue, this.message, this.subtype, this.type, this.ts);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractSlackEventMessageReplied#getMessage() message} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param message A new value for message
   * @return A modified copy of the {@code this} object
   */
  public final SlackEventMessageReplied withMessage(SlackReplyMessage message) {
    if (this.message == message) return this;
    SlackReplyMessage newValue = Objects.requireNonNull(message, "message");
    return new SlackEventMessageReplied(this.channelId, newValue, this.subtype, this.type, this.ts);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AbstractSlackEventMessageReplied#getSubtype() subtype} attribute.
   * @param value The value for subtype, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackEventMessageReplied withSubtype(@Nullable SlackMessageSubtype value) {
    @Nullable SlackMessageSubtype newValue = value;
    if (Objects.equals(this.subtype, newValue)) return this;
    return new SlackEventMessageReplied(this.channelId, this.message, newValue, this.type, this.ts);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AbstractSlackEventMessageReplied#getSubtype() subtype} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for subtype
   * @return A modified copy of {@code this} object
   */
  public final SlackEventMessageReplied withSubtype(Optional<SlackMessageSubtype> optional) {
    @Nullable SlackMessageSubtype value = optional.orElse(null);
    if (Objects.equals(this.subtype, value)) return this;
    return new SlackEventMessageReplied(this.channelId, this.message, value, this.type, this.ts);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractSlackEventMessageReplied#getType() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param type A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final SlackEventMessageReplied withType(SlackEventType type) {
    if (this.type == type) return this;
    SlackEventType newValue = Objects.requireNonNull(type, "type");
    return new SlackEventMessageReplied(this.channelId, this.message, this.subtype, newValue, this.ts);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractSlackEventMessageReplied#getTs() ts} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param ts A new value for ts
   * @return A modified copy of the {@code this} object
   */
  public final SlackEventMessageReplied withTs(String ts) {
    if (this.ts.equals(ts)) return this;
    String newValue = Objects.requireNonNull(ts, "ts");
    return new SlackEventMessageReplied(this.channelId, this.message, this.subtype, this.type, newValue);
  }

  /**
   * This instance is equal to all instances of {@code SlackEventMessageReplied} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof SlackEventMessageReplied
        && equalTo((SlackEventMessageReplied) another);
  }

  private boolean equalTo(SlackEventMessageReplied another) {
    return channelId.equals(another.channelId)
        && message.equals(another.message)
        && Objects.equals(subtype, another.subtype)
        && type.equals(another.type)
        && ts.equals(another.ts);
  }

  /**
   * Computes a hash code from attributes: {@code channelId}, {@code message}, {@code subtype}, {@code type}, {@code ts}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + channelId.hashCode();
    h = h * 17 + message.hashCode();
    h = h * 17 + Objects.hashCode(subtype);
    h = h * 17 + type.hashCode();
    h = h * 17 + ts.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SlackEventMessageReplied} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("SlackEventMessageReplied{");
    builder.append("channelId=").append(channelId);
    builder.append(", ");
    builder.append("message=").append(message);
    if (subtype != null) {
      builder.append(", ");
      builder.append("subtype=").append(subtype);
    }
    builder.append(", ");
    builder.append("type=").append(type);
    builder.append(", ");
    builder.append("ts=").append(ts);
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends AbstractSlackEventMessageReplied {
    @Nullable String channelId;
    @Nullable SlackReplyMessage message;
    Optional<SlackMessageSubtype> subtype = Optional.empty();
    @Nullable SlackEventType type;
    @Nullable String ts;
    @JsonProperty("channel")
    public void setChannelId(String channelId) {
      this.channelId = channelId;
    }
    @JsonProperty
    public void setMessage(SlackReplyMessage message) {
      this.message = message;
    }
    @JsonProperty
    public void setSubtype(Optional<SlackMessageSubtype> subtype) {
      this.subtype = subtype;
    }
    @JsonProperty
    public void setType(SlackEventType type) {
      this.type = type;
    }
    @JsonProperty
    public void setTs(String ts) {
      this.ts = ts;
    }
    @Override
    public String getChannelId() { throw new UnsupportedOperationException(); }
    @Override
    public SlackReplyMessage getMessage() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<SlackMessageSubtype> getSubtype() { throw new UnsupportedOperationException(); }
    @Override
    public SlackEventType getType() { throw new UnsupportedOperationException(); }
    @Override
    public String getTs() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static SlackEventMessageReplied fromJson(Json json) {
    SlackEventMessageReplied.Builder builder = SlackEventMessageReplied.builder();
    if (json.channelId != null) {
      builder.setChannelId(json.channelId);
    }
    if (json.message != null) {
      builder.setMessage(json.message);
    }
    if (json.subtype != null) {
      builder.setSubtype(json.subtype);
    }
    if (json.type != null) {
      builder.setType(json.type);
    }
    if (json.ts != null) {
      builder.setTs(json.ts);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link AbstractSlackEventMessageReplied} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SlackEventMessageReplied instance
   */
  public static SlackEventMessageReplied copyOf(AbstractSlackEventMessageReplied instance) {
    if (instance instanceof SlackEventMessageReplied) {
      return (SlackEventMessageReplied) instance;
    }
    return SlackEventMessageReplied.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link SlackEventMessageReplied SlackEventMessageReplied}.
   * @return A new SlackEventMessageReplied builder
   */
  public static SlackEventMessageReplied.Builder builder() {
    return new SlackEventMessageReplied.Builder();
  }

  /**
   * Builds instances of type {@link SlackEventMessageReplied SlackEventMessageReplied}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CHANNEL_ID = 0x1L;
    private static final long INIT_BIT_MESSAGE = 0x2L;
    private static final long INIT_BIT_TYPE = 0x4L;
    private static final long INIT_BIT_TS = 0x8L;
    private long initBits = 0xfL;

    private @Nullable String channelId;
    private @Nullable SlackReplyMessage message;
    private @Nullable SlackMessageSubtype subtype;
    private @Nullable SlackEventType type;
    private @Nullable String ts;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.events.AbstractSlackEventMessageReplied} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractSlackEventMessageReplied instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.interceptor.HasChannel} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(HasChannel instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.events.SlackEventMessageBase} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackEventMessageBase instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.events.SlackEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof AbstractSlackEventMessageReplied) {
        AbstractSlackEventMessageReplied instance = (AbstractSlackEventMessageReplied) object;
        setMessage(instance.getMessage());
        if ((bits & 0x1L) == 0) {
          setChannelId(instance.getChannelId());
          bits |= 0x1L;
        }
      }
      if (object instanceof HasChannel) {
        HasChannel instance = (HasChannel) object;
        if ((bits & 0x1L) == 0) {
          setChannelId(instance.getChannelId());
          bits |= 0x1L;
        }
      }
      if (object instanceof SlackEventMessageBase) {
        SlackEventMessageBase instance = (SlackEventMessageBase) object;
        Optional<SlackMessageSubtype> subtypeOptional = instance.getSubtype();
        if (subtypeOptional.isPresent()) {
          setSubtype(subtypeOptional);
        }
      }
      if (object instanceof SlackEvent) {
        SlackEvent instance = (SlackEvent) object;
        setType(instance.getType());
        setTs(instance.getTs());
      }
    }

    /**
     * Initializes the value for the {@link AbstractSlackEventMessageReplied#getChannelId() channelId} attribute.
     * @param channelId The value for channelId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannelId(String channelId) {
      this.channelId = Objects.requireNonNull(channelId, "channelId");
      initBits &= ~INIT_BIT_CHANNEL_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractSlackEventMessageReplied#getMessage() message} attribute.
     * @param message The value for message 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setMessage(SlackReplyMessage message) {
      this.message = Objects.requireNonNull(message, "message");
      initBits &= ~INIT_BIT_MESSAGE;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlackEventMessageReplied#getSubtype() subtype} to subtype.
     * @param subtype The value for subtype, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setSubtype(@Nullable SlackMessageSubtype subtype) {
      this.subtype = subtype;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlackEventMessageReplied#getSubtype() subtype} to subtype.
     * @param subtype The value for subtype
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setSubtype(Optional<SlackMessageSubtype> subtype) {
      this.subtype = subtype.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractSlackEventMessageReplied#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setType(SlackEventType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractSlackEventMessageReplied#getTs() ts} attribute.
     * @param ts The value for ts 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTs(String ts) {
      this.ts = Objects.requireNonNull(ts, "ts");
      initBits &= ~INIT_BIT_TS;
      return this;
    }

    /**
     * Builds a new {@link SlackEventMessageReplied SlackEventMessageReplied}.
     * @return An immutable instance of SlackEventMessageReplied
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public SlackEventMessageReplied build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new SlackEventMessageReplied(channelId, message, subtype, type, ts);
    }

    private boolean channelIdIsSet() {
      return (initBits & INIT_BIT_CHANNEL_ID) == 0;
    }

    private boolean messageIsSet() {
      return (initBits & INIT_BIT_MESSAGE) == 0;
    }

    private boolean typeIsSet() {
      return (initBits & INIT_BIT_TYPE) == 0;
    }

    private boolean tsIsSet() {
      return (initBits & INIT_BIT_TS) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!channelIdIsSet()) attributes.add("channelId");
      if (!messageIsSet()) attributes.add("message");
      if (!typeIsSet()) attributes.add("type");
      if (!tsIsSet()) attributes.add("ts");
      return "Cannot build SlackEventMessageReplied, some of required attributes are not set " + attributes;
    }
  }
}
