package com.hubspot.slack.client.models.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link SlackEventSkeletonIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code SlackEventSkeleton.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "SlackEventSkeletonIF"})
@Immutable
public final class SlackEventSkeleton implements SlackEventSkeletonIF {
  private final @Nullable String channelMaybe;
  private final SlackEventType type;
  private final String ts;

  private SlackEventSkeleton(
      @Nullable String channelMaybe,
      SlackEventType type,
      String ts) {
    this.channelMaybe = channelMaybe;
    this.type = type;
    this.ts = ts;
  }

  /**
   * @return The value of the {@code channelMaybe} attribute
   */
  @JsonProperty("channel")
  @Override
  public Optional<String> getChannelMaybe() {
    return Optional.ofNullable(channelMaybe);
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public SlackEventType getType() {
    return type;
  }

  /**
   * @return The value of the {@code ts} attribute
   */
  @JsonProperty
  @Override
  public String getTs() {
    return ts;
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackEventSkeletonIF#getChannelMaybe() channelMaybe} attribute.
   * @param value The value for channelMaybe, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackEventSkeleton withChannelMaybe(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.channelMaybe, newValue)) return this;
    return new SlackEventSkeleton(newValue, this.type, this.ts);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackEventSkeletonIF#getChannelMaybe() channelMaybe} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for channelMaybe
   * @return A modified copy of {@code this} object
   */
  public final SlackEventSkeleton withChannelMaybe(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.channelMaybe, value)) return this;
    return new SlackEventSkeleton(value, this.type, this.ts);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackEventSkeletonIF#getType() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param type A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final SlackEventSkeleton withType(SlackEventType type) {
    if (this.type == type) return this;
    SlackEventType newValue = Objects.requireNonNull(type, "type");
    return new SlackEventSkeleton(this.channelMaybe, newValue, this.ts);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackEventSkeletonIF#getTs() ts} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param ts A new value for ts
   * @return A modified copy of the {@code this} object
   */
  public final SlackEventSkeleton withTs(String ts) {
    if (this.ts.equals(ts)) return this;
    String newValue = Objects.requireNonNull(ts, "ts");
    return new SlackEventSkeleton(this.channelMaybe, this.type, newValue);
  }

  /**
   * This instance is equal to all instances of {@code SlackEventSkeleton} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof SlackEventSkeleton
        && equalTo((SlackEventSkeleton) another);
  }

  private boolean equalTo(SlackEventSkeleton another) {
    return Objects.equals(channelMaybe, another.channelMaybe)
        && type.equals(another.type)
        && ts.equals(another.ts);
  }

  /**
   * Computes a hash code from attributes: {@code channelMaybe}, {@code type}, {@code ts}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(channelMaybe);
    h = h * 17 + type.hashCode();
    h = h * 17 + ts.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SlackEventSkeleton} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("SlackEventSkeleton{");
    if (channelMaybe != null) {
      builder.append("channelMaybe=").append(channelMaybe);
    }
    if (builder.length() > 19) builder.append(", ");
    builder.append("type=").append(type);
    builder.append(", ");
    builder.append("ts=").append(ts);
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements SlackEventSkeletonIF {
    Optional<String> channelMaybe = Optional.empty();
    @Nullable SlackEventType type;
    @Nullable String ts;
    @JsonProperty("channel")
    public void setChannelMaybe(Optional<String> channelMaybe) {
      this.channelMaybe = channelMaybe;
    }
    @JsonProperty
    public void setType(SlackEventType type) {
      this.type = type;
    }
    @JsonProperty
    public void setTs(String ts) {
      this.ts = ts;
    }
    @Override
    public Optional<String> getChannelMaybe() { throw new UnsupportedOperationException(); }
    @Override
    public SlackEventType getType() { throw new UnsupportedOperationException(); }
    @Override
    public String getTs() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static SlackEventSkeleton fromJson(Json json) {
    SlackEventSkeleton.Builder builder = SlackEventSkeleton.builder();
    if (json.channelMaybe != null) {
      builder.setChannelMaybe(json.channelMaybe);
    }
    if (json.type != null) {
      builder.setType(json.type);
    }
    if (json.ts != null) {
      builder.setTs(json.ts);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link SlackEventSkeletonIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SlackEventSkeleton instance
   */
  public static SlackEventSkeleton copyOf(SlackEventSkeletonIF instance) {
    if (instance instanceof SlackEventSkeleton) {
      return (SlackEventSkeleton) instance;
    }
    return SlackEventSkeleton.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link SlackEventSkeleton SlackEventSkeleton}.
   * @return A new SlackEventSkeleton builder
   */
  public static SlackEventSkeleton.Builder builder() {
    return new SlackEventSkeleton.Builder();
  }

  /**
   * Builds instances of type {@link SlackEventSkeleton SlackEventSkeleton}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TYPE = 0x1L;
    private static final long INIT_BIT_TS = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String channelMaybe;
    private @Nullable SlackEventType type;
    private @Nullable String ts;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.events.SlackEventSkeletonIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackEventSkeletonIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.events.SlackEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof SlackEventSkeletonIF) {
        SlackEventSkeletonIF instance = (SlackEventSkeletonIF) object;
        Optional<String> channelMaybeOptional = instance.getChannelMaybe();
        if (channelMaybeOptional.isPresent()) {
          setChannelMaybe(channelMaybeOptional);
        }
      }
      if (object instanceof SlackEvent) {
        SlackEvent instance = (SlackEvent) object;
        setType(instance.getType());
        setTs(instance.getTs());
      }
    }

    /**
     * Initializes the optional value {@link SlackEventSkeletonIF#getChannelMaybe() channelMaybe} to channelMaybe.
     * @param channelMaybe The value for channelMaybe, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setChannelMaybe(@Nullable String channelMaybe) {
      this.channelMaybe = channelMaybe;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackEventSkeletonIF#getChannelMaybe() channelMaybe} to channelMaybe.
     * @param channelMaybe The value for channelMaybe
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannelMaybe(Optional<String> channelMaybe) {
      this.channelMaybe = channelMaybe.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link SlackEventSkeletonIF#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setType(SlackEventType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackEventSkeletonIF#getTs() ts} attribute.
     * @param ts The value for ts 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTs(String ts) {
      this.ts = Objects.requireNonNull(ts, "ts");
      initBits &= ~INIT_BIT_TS;
      return this;
    }

    /**
     * Builds a new {@link SlackEventSkeleton SlackEventSkeleton}.
     * @return An immutable instance of SlackEventSkeleton
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public SlackEventSkeleton build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new SlackEventSkeleton(channelMaybe, type, ts);
    }

    private boolean typeIsSet() {
      return (initBits & INIT_BIT_TYPE) == 0;
    }

    private boolean tsIsSet() {
      return (initBits & INIT_BIT_TS) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!typeIsSet()) attributes.add("type");
      if (!tsIsSet()) attributes.add("ts");
      return "Cannot build SlackEventSkeleton, some of required attributes are not set " + attributes;
    }
  }
}
