package com.hubspot.slack.client.models.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link SlackEventWrapperIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code SlackEventWrapper.<T>builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "SlackEventWrapperIF<T>"})
@Immutable
public final class SlackEventWrapper<T extends SlackEvent>
    implements SlackEventWrapperIF<T> {
  private final String token;
  private final String teamId;
  private final SlackEventType type;
  private final List<String> authedUsers;
  private final String eventId;
  private final String eventTime;
  private final T event;

  private SlackEventWrapper(
      String token,
      String teamId,
      SlackEventType type,
      List<String> authedUsers,
      String eventId,
      String eventTime,
      T event) {
    this.token = token;
    this.teamId = teamId;
    this.type = type;
    this.authedUsers = authedUsers;
    this.eventId = eventId;
    this.eventTime = eventTime;
    this.event = event;
  }

  /**
   * @return The value of the {@code token} attribute
   */
  @JsonProperty
  @Override
  public String getToken() {
    return token;
  }

  /**
   * @return The value of the {@code teamId} attribute
   */
  @JsonProperty
  @Override
  public String getTeamId() {
    return teamId;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public SlackEventType getType() {
    return type;
  }

  /**
   * @return The value of the {@code authedUsers} attribute
   */
  @JsonProperty
  @Override
  public List<String> getAuthedUsers() {
    return authedUsers;
  }

  /**
   * @return The value of the {@code eventId} attribute
   */
  @JsonProperty
  @Override
  public String getEventId() {
    return eventId;
  }

  /**
   * @return The value of the {@code eventTime} attribute
   */
  @JsonProperty
  @Override
  public String getEventTime() {
    return eventTime;
  }

  /**
   * @return The value of the {@code event} attribute
   */
  @JsonProperty
  @Override
  public T getEvent() {
    return event;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackEventWrapperIF#getToken() token} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param token A new value for token
   * @return A modified copy of the {@code this} object
   */
  public final SlackEventWrapper<T> withToken(String token) {
    if (this.token.equals(token)) return this;
    String newValue = Objects.requireNonNull(token, "token");
    return new SlackEventWrapper<T>(newValue, this.teamId, this.type, this.authedUsers, this.eventId, this.eventTime, this.event);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackEventWrapperIF#getTeamId() teamId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param teamId A new value for teamId
   * @return A modified copy of the {@code this} object
   */
  public final SlackEventWrapper<T> withTeamId(String teamId) {
    if (this.teamId.equals(teamId)) return this;
    String newValue = Objects.requireNonNull(teamId, "teamId");
    return new SlackEventWrapper<T>(this.token, newValue, this.type, this.authedUsers, this.eventId, this.eventTime, this.event);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackEventWrapperIF#getType() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param type A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final SlackEventWrapper<T> withType(SlackEventType type) {
    if (this.type == type) return this;
    SlackEventType newValue = Objects.requireNonNull(type, "type");
    return new SlackEventWrapper<T>(this.token, this.teamId, newValue, this.authedUsers, this.eventId, this.eventTime, this.event);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SlackEventWrapperIF#getAuthedUsers() authedUsers}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final SlackEventWrapper<T> withAuthedUsers(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new SlackEventWrapper<T>(this.token, this.teamId, this.type, newValue, this.eventId, this.eventTime, this.event);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SlackEventWrapperIF#getAuthedUsers() authedUsers}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of authedUsers elements to set
   * @return A modified copy of {@code this} object
   */
  public final SlackEventWrapper<T> withAuthedUsers(Iterable<String> elements) {
    if (this.authedUsers == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new SlackEventWrapper<T>(this.token, this.teamId, this.type, newValue, this.eventId, this.eventTime, this.event);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackEventWrapperIF#getEventId() eventId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param eventId A new value for eventId
   * @return A modified copy of the {@code this} object
   */
  public final SlackEventWrapper<T> withEventId(String eventId) {
    if (this.eventId.equals(eventId)) return this;
    String newValue = Objects.requireNonNull(eventId, "eventId");
    return new SlackEventWrapper<T>(this.token, this.teamId, this.type, this.authedUsers, newValue, this.eventTime, this.event);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackEventWrapperIF#getEventTime() eventTime} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param eventTime A new value for eventTime
   * @return A modified copy of the {@code this} object
   */
  public final SlackEventWrapper<T> withEventTime(String eventTime) {
    if (this.eventTime.equals(eventTime)) return this;
    String newValue = Objects.requireNonNull(eventTime, "eventTime");
    return new SlackEventWrapper<T>(this.token, this.teamId, this.type, this.authedUsers, this.eventId, newValue, this.event);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackEventWrapperIF#getEvent() event} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param event A new value for event
   * @return A modified copy of the {@code this} object
   */
  public final SlackEventWrapper<T> withEvent(T event) {
    if (this.event == event) return this;
    T newValue = Objects.requireNonNull(event, "event");
    return new SlackEventWrapper<T>(this.token, this.teamId, this.type, this.authedUsers, this.eventId, this.eventTime, newValue);
  }

  /**
   * This instance is equal to all instances of {@code SlackEventWrapper} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof SlackEventWrapper<?>
        && equalTo((SlackEventWrapper<?>) another);
  }

  private boolean equalTo(SlackEventWrapper<?> another) {
    return token.equals(another.token)
        && teamId.equals(another.teamId)
        && type.equals(another.type)
        && authedUsers.equals(another.authedUsers)
        && eventId.equals(another.eventId)
        && eventTime.equals(another.eventTime)
        && event.equals(another.event);
  }

  /**
   * Computes a hash code from attributes: {@code token}, {@code teamId}, {@code type}, {@code authedUsers}, {@code eventId}, {@code eventTime}, {@code event}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + token.hashCode();
    h = h * 17 + teamId.hashCode();
    h = h * 17 + type.hashCode();
    h = h * 17 + authedUsers.hashCode();
    h = h * 17 + eventId.hashCode();
    h = h * 17 + eventTime.hashCode();
    h = h * 17 + event.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SlackEventWrapper} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SlackEventWrapper{"
        + "token=" + token
        + ", teamId=" + teamId
        + ", type=" + type
        + ", authedUsers=" + authedUsers
        + ", eventId=" + eventId
        + ", eventTime=" + eventTime
        + ", event=" + event
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json<T extends SlackEvent>
      implements SlackEventWrapperIF<T> {
    @Nullable String token;
    @Nullable String teamId;
    @Nullable SlackEventType type;
    List<String> authedUsers = Collections.emptyList();
    @Nullable String eventId;
    @Nullable String eventTime;
    @Nullable T event;
    @JsonProperty
    public void setToken(String token) {
      this.token = token;
    }
    @JsonProperty
    public void setTeamId(String teamId) {
      this.teamId = teamId;
    }
    @JsonProperty
    public void setType(SlackEventType type) {
      this.type = type;
    }
    @JsonProperty
    public void setAuthedUsers(List<String> authedUsers) {
      this.authedUsers = authedUsers;
    }
    @JsonProperty
    public void setEventId(String eventId) {
      this.eventId = eventId;
    }
    @JsonProperty
    public void setEventTime(String eventTime) {
      this.eventTime = eventTime;
    }
    @JsonProperty
    public void setEvent(T event) {
      this.event = event;
    }
    @Override
    public String getToken() { throw new UnsupportedOperationException(); }
    @Override
    public String getTeamId() { throw new UnsupportedOperationException(); }
    @Override
    public SlackEventType getType() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getAuthedUsers() { throw new UnsupportedOperationException(); }
    @Override
    public String getEventId() { throw new UnsupportedOperationException(); }
    @Override
    public String getEventTime() { throw new UnsupportedOperationException(); }
    @Override
    public T getEvent() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param <T> generic parameter T
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static <T extends SlackEvent> SlackEventWrapper<T> fromJson(Json<T> json) {
    SlackEventWrapper.Builder<T> builder = SlackEventWrapper.<T>builder();
    if (json.token != null) {
      builder.setToken(json.token);
    }
    if (json.teamId != null) {
      builder.setTeamId(json.teamId);
    }
    if (json.type != null) {
      builder.setType(json.type);
    }
    if (json.authedUsers != null) {
      builder.addAllAuthedUsers(json.authedUsers);
    }
    if (json.eventId != null) {
      builder.setEventId(json.eventId);
    }
    if (json.eventTime != null) {
      builder.setEventTime(json.eventTime);
    }
    if (json.event != null) {
      builder.setEvent(json.event);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link SlackEventWrapperIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param <T> generic parameter T
   * @param instance The instance to copy
   * @return A copied immutable SlackEventWrapper instance
   */
  public static <T extends SlackEvent> SlackEventWrapper<T> copyOf(SlackEventWrapperIF<T> instance) {
    if (instance instanceof SlackEventWrapper<?>) {
      return (SlackEventWrapper<T>) instance;
    }
    return SlackEventWrapper.<T>builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link SlackEventWrapper SlackEventWrapper}.
   * @param <T> generic parameter T
   * @return A new SlackEventWrapper builder
   */
  public static <T extends SlackEvent> SlackEventWrapper.Builder<T> builder() {
    return new SlackEventWrapper.Builder<T>();
  }

  /**
   * Builds instances of type {@link SlackEventWrapper SlackEventWrapper}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder<T extends SlackEvent> {
    private static final long INIT_BIT_TOKEN = 0x1L;
    private static final long INIT_BIT_TEAM_ID = 0x2L;
    private static final long INIT_BIT_TYPE = 0x4L;
    private static final long INIT_BIT_EVENT_ID = 0x8L;
    private static final long INIT_BIT_EVENT_TIME = 0x10L;
    private static final long INIT_BIT_EVENT = 0x20L;
    private long initBits = 0x3fL;

    private @Nullable String token;
    private @Nullable String teamId;
    private @Nullable SlackEventType type;
    private List<String> authedUsers = new ArrayList<String>();
    private @Nullable String eventId;
    private @Nullable String eventTime;
    private @Nullable T event;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SlackEventWrapperIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> from(SlackEventWrapperIF<T> instance) {
      Objects.requireNonNull(instance, "instance");
      setToken(instance.getToken());
      setTeamId(instance.getTeamId());
      setType(instance.getType());
      addAllAuthedUsers(instance.getAuthedUsers());
      setEventId(instance.getEventId());
      setEventTime(instance.getEventTime());
      setEvent(instance.getEvent());
      return this;
    }

    /**
     * Initializes the value for the {@link SlackEventWrapperIF#getToken() token} attribute.
     * @param token The value for token 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> setToken(String token) {
      this.token = Objects.requireNonNull(token, "token");
      initBits &= ~INIT_BIT_TOKEN;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackEventWrapperIF#getTeamId() teamId} attribute.
     * @param teamId The value for teamId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> setTeamId(String teamId) {
      this.teamId = Objects.requireNonNull(teamId, "teamId");
      initBits &= ~INIT_BIT_TEAM_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackEventWrapperIF#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> setType(SlackEventType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Adds one element to {@link SlackEventWrapperIF#getAuthedUsers() authedUsers} list.
     * @param element A authedUsers element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> addAuthedUsers(String element) {
      this.authedUsers.add(Objects.requireNonNull(element, "authedUsers element"));
      return this;
    }

    /**
     * Adds elements to {@link SlackEventWrapperIF#getAuthedUsers() authedUsers} list.
     * @param elements An array of authedUsers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> addAuthedUsers(String... elements) {
      for (String element : elements) {
        this.authedUsers.add(Objects.requireNonNull(element, "authedUsers element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link SlackEventWrapperIF#getAuthedUsers() authedUsers} list.
     * @param elements An iterable of authedUsers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> setAuthedUsers(Iterable<String> elements) {
      this.authedUsers.clear();
      return addAllAuthedUsers(elements);
    }

    /**
     * Adds elements to {@link SlackEventWrapperIF#getAuthedUsers() authedUsers} list.
     * @param elements An iterable of authedUsers elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> addAllAuthedUsers(Iterable<String> elements) {
      for (String element : elements) {
        this.authedUsers.add(Objects.requireNonNull(element, "authedUsers element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link SlackEventWrapperIF#getEventId() eventId} attribute.
     * @param eventId The value for eventId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> setEventId(String eventId) {
      this.eventId = Objects.requireNonNull(eventId, "eventId");
      initBits &= ~INIT_BIT_EVENT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackEventWrapperIF#getEventTime() eventTime} attribute.
     * @param eventTime The value for eventTime 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> setEventTime(String eventTime) {
      this.eventTime = Objects.requireNonNull(eventTime, "eventTime");
      initBits &= ~INIT_BIT_EVENT_TIME;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackEventWrapperIF#getEvent() event} attribute.
     * @param event The value for event 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder<T> setEvent(T event) {
      this.event = Objects.requireNonNull(event, "event");
      initBits &= ~INIT_BIT_EVENT;
      return this;
    }

    /**
     * Builds a new {@link SlackEventWrapper SlackEventWrapper}.
     * @return An immutable instance of SlackEventWrapper
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public SlackEventWrapper<T> build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new SlackEventWrapper<T>(token, teamId, type, createUnmodifiableList(true, authedUsers), eventId, eventTime, event);
    }

    private boolean tokenIsSet() {
      return (initBits & INIT_BIT_TOKEN) == 0;
    }

    private boolean teamIdIsSet() {
      return (initBits & INIT_BIT_TEAM_ID) == 0;
    }

    private boolean typeIsSet() {
      return (initBits & INIT_BIT_TYPE) == 0;
    }

    private boolean eventIdIsSet() {
      return (initBits & INIT_BIT_EVENT_ID) == 0;
    }

    private boolean eventTimeIsSet() {
      return (initBits & INIT_BIT_EVENT_TIME) == 0;
    }

    private boolean eventIsSet() {
      return (initBits & INIT_BIT_EVENT) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!tokenIsSet()) attributes.add("token");
      if (!teamIdIsSet()) attributes.add("teamId");
      if (!typeIsSet()) attributes.add("type");
      if (!eventIdIsSet()) attributes.add("eventId");
      if (!eventTimeIsSet()) attributes.add("eventTime");
      if (!eventIsSet()) attributes.add("event");
      return "Cannot build SlackEventWrapper, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
