package com.hubspot.slack.client.models.events.channel;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.events.SlackEvent;
import com.hubspot.slack.client.models.events.SlackEventType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link SlackChannelArchiveEventIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code SlackChannelArchiveEvent.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "SlackChannelArchiveEventIF"})
@Immutable
public final class SlackChannelArchiveEvent
    implements SlackChannelArchiveEventIF {
  private final String channelId;
  private final String userId;
  private final SlackEventType type;

  private SlackChannelArchiveEvent(
      String channelId,
      String userId,
      SlackEventType type) {
    this.channelId = channelId;
    this.userId = userId;
    this.type = type;
  }

  /**
   * @return The value of the {@code channelId} attribute
   */
  @JsonProperty("channel")
  @Override
  public String getChannelId() {
    return channelId;
  }

  /**
   * @return The value of the {@code userId} attribute
   */
  @JsonProperty("user")
  @Override
  public String getUserId() {
    return userId;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public SlackEventType getType() {
    return type;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackChannelArchiveEventIF#getChannelId() channelId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param channelId A new value for channelId
   * @return A modified copy of the {@code this} object
   */
  public final SlackChannelArchiveEvent withChannelId(String channelId) {
    if (this.channelId.equals(channelId)) return this;
    String newValue = Objects.requireNonNull(channelId, "channelId");
    return new SlackChannelArchiveEvent(newValue, this.userId, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackChannelArchiveEventIF#getUserId() userId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param userId A new value for userId
   * @return A modified copy of the {@code this} object
   */
  public final SlackChannelArchiveEvent withUserId(String userId) {
    if (this.userId.equals(userId)) return this;
    String newValue = Objects.requireNonNull(userId, "userId");
    return new SlackChannelArchiveEvent(this.channelId, newValue, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackChannelArchiveEventIF#getType() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param type A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final SlackChannelArchiveEvent withType(SlackEventType type) {
    if (this.type == type) return this;
    SlackEventType newValue = Objects.requireNonNull(type, "type");
    return new SlackChannelArchiveEvent(this.channelId, this.userId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code SlackChannelArchiveEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof SlackChannelArchiveEvent
        && equalTo((SlackChannelArchiveEvent) another);
  }

  private boolean equalTo(SlackChannelArchiveEvent another) {
    return channelId.equals(another.channelId)
        && userId.equals(another.userId)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code channelId}, {@code userId}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + channelId.hashCode();
    h = h * 17 + userId.hashCode();
    h = h * 17 + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SlackChannelArchiveEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SlackChannelArchiveEvent{"
        + "channelId=" + channelId
        + ", userId=" + userId
        + ", type=" + type
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements SlackChannelArchiveEventIF {
    @Nullable String channelId;
    @Nullable String userId;
    @Nullable SlackEventType type;
    @JsonProperty("channel")
    public void setChannelId(String channelId) {
      this.channelId = channelId;
    }
    @JsonProperty("user")
    public void setUserId(String userId) {
      this.userId = userId;
    }
    @JsonProperty
    public void setType(SlackEventType type) {
      this.type = type;
    }
    @Override
    public String getChannelId() { throw new UnsupportedOperationException(); }
    @Override
    public String getUserId() { throw new UnsupportedOperationException(); }
    @Override
    public SlackEventType getType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static SlackChannelArchiveEvent fromJson(Json json) {
    SlackChannelArchiveEvent.Builder builder = SlackChannelArchiveEvent.builder();
    if (json.channelId != null) {
      builder.setChannelId(json.channelId);
    }
    if (json.userId != null) {
      builder.setUserId(json.userId);
    }
    if (json.type != null) {
      builder.setType(json.type);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link SlackChannelArchiveEventIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SlackChannelArchiveEvent instance
   */
  public static SlackChannelArchiveEvent copyOf(SlackChannelArchiveEventIF instance) {
    if (instance instanceof SlackChannelArchiveEvent) {
      return (SlackChannelArchiveEvent) instance;
    }
    return SlackChannelArchiveEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link SlackChannelArchiveEvent SlackChannelArchiveEvent}.
   * @return A new SlackChannelArchiveEvent builder
   */
  public static SlackChannelArchiveEvent.Builder builder() {
    return new SlackChannelArchiveEvent.Builder();
  }

  /**
   * Builds instances of type {@link SlackChannelArchiveEvent SlackChannelArchiveEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CHANNEL_ID = 0x1L;
    private static final long INIT_BIT_USER_ID = 0x2L;
    private static final long INIT_BIT_TYPE = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String channelId;
    private @Nullable String userId;
    private @Nullable SlackEventType type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.events.SlackEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.events.channel.SlackChannelArchiveEventIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackChannelArchiveEventIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof SlackEvent) {
        SlackEvent instance = (SlackEvent) object;
        setType(instance.getType());
      }
      if (object instanceof SlackChannelArchiveEventIF) {
        SlackChannelArchiveEventIF instance = (SlackChannelArchiveEventIF) object;
        setUserId(instance.getUserId());
        setChannelId(instance.getChannelId());
      }
    }

    /**
     * Initializes the value for the {@link SlackChannelArchiveEventIF#getChannelId() channelId} attribute.
     * @param channelId The value for channelId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannelId(String channelId) {
      this.channelId = Objects.requireNonNull(channelId, "channelId");
      initBits &= ~INIT_BIT_CHANNEL_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackChannelArchiveEventIF#getUserId() userId} attribute.
     * @param userId The value for userId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUserId(String userId) {
      this.userId = Objects.requireNonNull(userId, "userId");
      initBits &= ~INIT_BIT_USER_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackChannelArchiveEventIF#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setType(SlackEventType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link SlackChannelArchiveEvent SlackChannelArchiveEvent}.
     * @return An immutable instance of SlackChannelArchiveEvent
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public SlackChannelArchiveEvent build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new SlackChannelArchiveEvent(channelId, userId, type);
    }

    private boolean channelIdIsSet() {
      return (initBits & INIT_BIT_CHANNEL_ID) == 0;
    }

    private boolean userIdIsSet() {
      return (initBits & INIT_BIT_USER_ID) == 0;
    }

    private boolean typeIsSet() {
      return (initBits & INIT_BIT_TYPE) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!channelIdIsSet()) attributes.add("channelId");
      if (!userIdIsSet()) attributes.add("userId");
      if (!typeIsSet()) attributes.add("type");
      return "Cannot build SlackChannelArchiveEvent, some of required attributes are not set " + attributes;
    }
  }
}
