package com.hubspot.slack.client.models.events.channel;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.SlackChannel;
import com.hubspot.slack.client.models.events.SlackEvent;
import com.hubspot.slack.client.models.events.SlackEventType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link SlackChannelCreatedEventIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code SlackChannelCreatedEvent.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "SlackChannelCreatedEventIF"})
@Immutable
public final class SlackChannelCreatedEvent
    implements SlackChannelCreatedEventIF {
  private final SlackChannel channel;
  private final SlackEventType type;

  private SlackChannelCreatedEvent(
      SlackChannel channel,
      SlackEventType type) {
    this.channel = channel;
    this.type = type;
  }

  /**
   * @return The value of the {@code channel} attribute
   */
  @JsonProperty
  @Override
  public SlackChannel getChannel() {
    return channel;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public SlackEventType getType() {
    return type;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackChannelCreatedEventIF#getChannel() channel} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param channel A new value for channel
   * @return A modified copy of the {@code this} object
   */
  public final SlackChannelCreatedEvent withChannel(SlackChannel channel) {
    if (this.channel == channel) return this;
    SlackChannel newValue = Objects.requireNonNull(channel, "channel");
    return new SlackChannelCreatedEvent(newValue, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackChannelCreatedEventIF#getType() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param type A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final SlackChannelCreatedEvent withType(SlackEventType type) {
    if (this.type == type) return this;
    SlackEventType newValue = Objects.requireNonNull(type, "type");
    return new SlackChannelCreatedEvent(this.channel, newValue);
  }

  /**
   * This instance is equal to all instances of {@code SlackChannelCreatedEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof SlackChannelCreatedEvent
        && equalTo((SlackChannelCreatedEvent) another);
  }

  private boolean equalTo(SlackChannelCreatedEvent another) {
    return channel.equals(another.channel)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code channel}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + channel.hashCode();
    h = h * 17 + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SlackChannelCreatedEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SlackChannelCreatedEvent{"
        + "channel=" + channel
        + ", type=" + type
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements SlackChannelCreatedEventIF {
    @Nullable SlackChannel channel;
    @Nullable SlackEventType type;
    @JsonProperty
    public void setChannel(SlackChannel channel) {
      this.channel = channel;
    }
    @JsonProperty
    public void setType(SlackEventType type) {
      this.type = type;
    }
    @Override
    public SlackChannel getChannel() { throw new UnsupportedOperationException(); }
    @Override
    public SlackEventType getType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static SlackChannelCreatedEvent fromJson(Json json) {
    SlackChannelCreatedEvent.Builder builder = SlackChannelCreatedEvent.builder();
    if (json.channel != null) {
      builder.setChannel(json.channel);
    }
    if (json.type != null) {
      builder.setType(json.type);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link SlackChannelCreatedEventIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SlackChannelCreatedEvent instance
   */
  public static SlackChannelCreatedEvent copyOf(SlackChannelCreatedEventIF instance) {
    if (instance instanceof SlackChannelCreatedEvent) {
      return (SlackChannelCreatedEvent) instance;
    }
    return SlackChannelCreatedEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link SlackChannelCreatedEvent SlackChannelCreatedEvent}.
   * @return A new SlackChannelCreatedEvent builder
   */
  public static SlackChannelCreatedEvent.Builder builder() {
    return new SlackChannelCreatedEvent.Builder();
  }

  /**
   * Builds instances of type {@link SlackChannelCreatedEvent SlackChannelCreatedEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CHANNEL = 0x1L;
    private static final long INIT_BIT_TYPE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable SlackChannel channel;
    private @Nullable SlackEventType type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.events.channel.SlackChannelCreatedEventIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackChannelCreatedEventIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.events.SlackEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof SlackChannelCreatedEventIF) {
        SlackChannelCreatedEventIF instance = (SlackChannelCreatedEventIF) object;
        setChannel(instance.getChannel());
      }
      if (object instanceof SlackEvent) {
        SlackEvent instance = (SlackEvent) object;
        setType(instance.getType());
      }
    }

    /**
     * Initializes the value for the {@link SlackChannelCreatedEventIF#getChannel() channel} attribute.
     * @param channel The value for channel 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannel(SlackChannel channel) {
      this.channel = Objects.requireNonNull(channel, "channel");
      initBits &= ~INIT_BIT_CHANNEL;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackChannelCreatedEventIF#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setType(SlackEventType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link SlackChannelCreatedEvent SlackChannelCreatedEvent}.
     * @return An immutable instance of SlackChannelCreatedEvent
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public SlackChannelCreatedEvent build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new SlackChannelCreatedEvent(channel, type);
    }

    private boolean channelIsSet() {
      return (initBits & INIT_BIT_CHANNEL) == 0;
    }

    private boolean typeIsSet() {
      return (initBits & INIT_BIT_TYPE) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!channelIsSet()) attributes.add("channel");
      if (!typeIsSet()) attributes.add("type");
      return "Cannot build SlackChannelCreatedEvent, some of required attributes are not set " + attributes;
    }
  }
}
