package com.hubspot.slack.client.models.events.channel;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.events.SlackEvent;
import com.hubspot.slack.client.models.events.SlackEventType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link SlackChannelUnarchiveEventIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code SlackChannelUnarchiveEvent.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "SlackChannelUnarchiveEventIF"})
@Immutable
public final class SlackChannelUnarchiveEvent
    implements SlackChannelUnarchiveEventIF {
  private final String channelId;
  private final String unarchivedByUserId;
  private final SlackEventType type;

  private SlackChannelUnarchiveEvent(
      String channelId,
      String unarchivedByUserId,
      SlackEventType type) {
    this.channelId = channelId;
    this.unarchivedByUserId = unarchivedByUserId;
    this.type = type;
  }

  /**
   * @return The value of the {@code channelId} attribute
   */
  @JsonProperty("channel")
  @Override
  public String getChannelId() {
    return channelId;
  }

  /**
   * @return The value of the {@code unarchivedByUserId} attribute
   */
  @JsonProperty("user")
  @Override
  public String getUnarchivedByUserId() {
    return unarchivedByUserId;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public SlackEventType getType() {
    return type;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackChannelUnarchiveEventIF#getChannelId() channelId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param channelId A new value for channelId
   * @return A modified copy of the {@code this} object
   */
  public final SlackChannelUnarchiveEvent withChannelId(String channelId) {
    if (this.channelId.equals(channelId)) return this;
    String newValue = Objects.requireNonNull(channelId, "channelId");
    return new SlackChannelUnarchiveEvent(newValue, this.unarchivedByUserId, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackChannelUnarchiveEventIF#getUnarchivedByUserId() unarchivedByUserId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param unarchivedByUserId A new value for unarchivedByUserId
   * @return A modified copy of the {@code this} object
   */
  public final SlackChannelUnarchiveEvent withUnarchivedByUserId(String unarchivedByUserId) {
    if (this.unarchivedByUserId.equals(unarchivedByUserId)) return this;
    String newValue = Objects.requireNonNull(unarchivedByUserId, "unarchivedByUserId");
    return new SlackChannelUnarchiveEvent(this.channelId, newValue, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackChannelUnarchiveEventIF#getType() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param type A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final SlackChannelUnarchiveEvent withType(SlackEventType type) {
    if (this.type == type) return this;
    SlackEventType newValue = Objects.requireNonNull(type, "type");
    return new SlackChannelUnarchiveEvent(this.channelId, this.unarchivedByUserId, newValue);
  }

  /**
   * This instance is equal to all instances of {@code SlackChannelUnarchiveEvent} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof SlackChannelUnarchiveEvent
        && equalTo((SlackChannelUnarchiveEvent) another);
  }

  private boolean equalTo(SlackChannelUnarchiveEvent another) {
    return channelId.equals(another.channelId)
        && unarchivedByUserId.equals(another.unarchivedByUserId)
        && type.equals(another.type);
  }

  /**
   * Computes a hash code from attributes: {@code channelId}, {@code unarchivedByUserId}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + channelId.hashCode();
    h = h * 17 + unarchivedByUserId.hashCode();
    h = h * 17 + type.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SlackChannelUnarchiveEvent} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "SlackChannelUnarchiveEvent{"
        + "channelId=" + channelId
        + ", unarchivedByUserId=" + unarchivedByUserId
        + ", type=" + type
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements SlackChannelUnarchiveEventIF {
    @Nullable String channelId;
    @Nullable String unarchivedByUserId;
    @Nullable SlackEventType type;
    @JsonProperty("channel")
    public void setChannelId(String channelId) {
      this.channelId = channelId;
    }
    @JsonProperty("user")
    public void setUnarchivedByUserId(String unarchivedByUserId) {
      this.unarchivedByUserId = unarchivedByUserId;
    }
    @JsonProperty
    public void setType(SlackEventType type) {
      this.type = type;
    }
    @Override
    public String getChannelId() { throw new UnsupportedOperationException(); }
    @Override
    public String getUnarchivedByUserId() { throw new UnsupportedOperationException(); }
    @Override
    public SlackEventType getType() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static SlackChannelUnarchiveEvent fromJson(Json json) {
    SlackChannelUnarchiveEvent.Builder builder = SlackChannelUnarchiveEvent.builder();
    if (json.channelId != null) {
      builder.setChannelId(json.channelId);
    }
    if (json.unarchivedByUserId != null) {
      builder.setUnarchivedByUserId(json.unarchivedByUserId);
    }
    if (json.type != null) {
      builder.setType(json.type);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link SlackChannelUnarchiveEventIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SlackChannelUnarchiveEvent instance
   */
  public static SlackChannelUnarchiveEvent copyOf(SlackChannelUnarchiveEventIF instance) {
    if (instance instanceof SlackChannelUnarchiveEvent) {
      return (SlackChannelUnarchiveEvent) instance;
    }
    return SlackChannelUnarchiveEvent.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link SlackChannelUnarchiveEvent SlackChannelUnarchiveEvent}.
   * @return A new SlackChannelUnarchiveEvent builder
   */
  public static SlackChannelUnarchiveEvent.Builder builder() {
    return new SlackChannelUnarchiveEvent.Builder();
  }

  /**
   * Builds instances of type {@link SlackChannelUnarchiveEvent SlackChannelUnarchiveEvent}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CHANNEL_ID = 0x1L;
    private static final long INIT_BIT_UNARCHIVED_BY_USER_ID = 0x2L;
    private static final long INIT_BIT_TYPE = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String channelId;
    private @Nullable String unarchivedByUserId;
    private @Nullable SlackEventType type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.events.channel.SlackChannelUnarchiveEventIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackChannelUnarchiveEventIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.events.SlackEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof SlackChannelUnarchiveEventIF) {
        SlackChannelUnarchiveEventIF instance = (SlackChannelUnarchiveEventIF) object;
        setChannelId(instance.getChannelId());
        setUnarchivedByUserId(instance.getUnarchivedByUserId());
      }
      if (object instanceof SlackEvent) {
        SlackEvent instance = (SlackEvent) object;
        setType(instance.getType());
      }
    }

    /**
     * Initializes the value for the {@link SlackChannelUnarchiveEventIF#getChannelId() channelId} attribute.
     * @param channelId The value for channelId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannelId(String channelId) {
      this.channelId = Objects.requireNonNull(channelId, "channelId");
      initBits &= ~INIT_BIT_CHANNEL_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackChannelUnarchiveEventIF#getUnarchivedByUserId() unarchivedByUserId} attribute.
     * @param unarchivedByUserId The value for unarchivedByUserId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUnarchivedByUserId(String unarchivedByUserId) {
      this.unarchivedByUserId = Objects.requireNonNull(unarchivedByUserId, "unarchivedByUserId");
      initBits &= ~INIT_BIT_UNARCHIVED_BY_USER_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackChannelUnarchiveEventIF#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setType(SlackEventType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link SlackChannelUnarchiveEvent SlackChannelUnarchiveEvent}.
     * @return An immutable instance of SlackChannelUnarchiveEvent
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public SlackChannelUnarchiveEvent build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new SlackChannelUnarchiveEvent(channelId, unarchivedByUserId, type);
    }

    private boolean channelIdIsSet() {
      return (initBits & INIT_BIT_CHANNEL_ID) == 0;
    }

    private boolean unarchivedByUserIdIsSet() {
      return (initBits & INIT_BIT_UNARCHIVED_BY_USER_ID) == 0;
    }

    private boolean typeIsSet() {
      return (initBits & INIT_BIT_TYPE) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!channelIdIsSet()) attributes.add("channelId");
      if (!unarchivedByUserIdIsSet()) attributes.add("unarchivedByUserId");
      if (!typeIsSet()) attributes.add("type");
      return "Cannot build SlackChannelUnarchiveEvent, some of required attributes are not set " + attributes;
    }
  }
}
