package com.hubspot.slack.client.models.events.util;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import com.hubspot.slack.client.methods.interceptor.HasUser;
import com.hubspot.slack.client.models.events.SlackEvent;
import com.hubspot.slack.client.models.events.SlackEventMessageBase;
import com.hubspot.slack.client.models.events.SlackEventType;
import com.hubspot.slack.client.models.events.SlackMessageSubtype;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link AbstractSlackReplyMessage}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code SlackReplyMessage.builder()}.
 */
@SuppressWarnings({"all", "deprecation"})
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "AbstractSlackReplyMessage"})
@Immutable
public final class SlackReplyMessage
    extends AbstractSlackReplyMessage {
  private final String threadTs;
  private final String userId;
  private final String channelId;
  private final int replyCount;
  private final @Nullable List<String> replyUserIds;
  private final @Nullable Integer replyUsersCount;
  private final @Nullable String latestReplyTimestamp;
  private final List<Reply> replies;
  private final @Nullable SlackMessageSubtype subtype;
  private final SlackEventType type;
  private final String ts;

  private SlackReplyMessage(SlackReplyMessage.Builder builder) {
    this.threadTs = builder.threadTs;
    this.userId = builder.userId;
    this.channelId = builder.channelId;
    this.replyUserIds = builder.replyUserIds;
    this.replyUsersCount = builder.replyUsersCount;
    this.latestReplyTimestamp = builder.latestReplyTimestamp;
    this.subtype = builder.subtype;
    this.type = builder.type;
    this.ts = builder.ts;
    if (builder.replyCountIsSet()) {
      initShim.setReplyCount(builder.replyCount);
    }
    if (builder.repliesIsSet()) {
      initShim.setReplies(createUnmodifiableList(true, builder.replies));
    }
    this.replyCount = initShim.getReplyCount();
    this.replies = initShim.getReplies();
    this.initShim = null;
  }

  private SlackReplyMessage(
      String threadTs,
      String userId,
      String channelId,
      int replyCount,
      @Nullable List<String> replyUserIds,
      @Nullable Integer replyUsersCount,
      @Nullable String latestReplyTimestamp,
      List<Reply> replies,
      @Nullable SlackMessageSubtype subtype,
      SlackEventType type,
      String ts) {
    this.threadTs = threadTs;
    this.userId = userId;
    this.channelId = channelId;
    this.replyCount = replyCount;
    this.replyUserIds = replyUserIds;
    this.replyUsersCount = replyUsersCount;
    this.latestReplyTimestamp = latestReplyTimestamp;
    this.replies = replies;
    this.subtype = subtype;
    this.type = type;
    this.ts = ts;
    this.initShim = null;
  }

  private static final int STAGE_INITIALIZING = -1;
  private static final int STAGE_UNINITIALIZED = 0;
  private static final int STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private int replyCount;
    private int replyCountStage;

    int getReplyCount() {
      if (replyCountStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (replyCountStage == STAGE_UNINITIALIZED) {
        replyCountStage = STAGE_INITIALIZING;
        this.replyCount = SlackReplyMessage.super.getReplyCount();
        replyCountStage = STAGE_INITIALIZED;
      }
      return this.replyCount;
    }

    void setReplyCount(int replyCount) {
      this.replyCount = replyCount;
      replyCountStage = STAGE_INITIALIZED;
    }
    private List<Reply> replies;
    private int repliesStage;

    List<Reply> getReplies() {
      if (repliesStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (repliesStage == STAGE_UNINITIALIZED) {
        repliesStage = STAGE_INITIALIZING;
        this.replies = createUnmodifiableList(false, createSafeList(SlackReplyMessage.super.getReplies(), true, false));
        repliesStage = STAGE_INITIALIZED;
      }
      return this.replies;
    }

    void setReplies(List<Reply> replies) {
      this.replies = replies;
      repliesStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      ArrayList<String> attributes = new ArrayList<String>();
      if (replyCountStage == STAGE_INITIALIZING) attributes.add("replyCount");
      if (repliesStage == STAGE_INITIALIZING) attributes.add("replies");
      return "Cannot build SlackReplyMessage, attribute initializers form cycle" + attributes;
    }
  }

  /**
   * @return The value of the {@code threadTs} attribute
   */
  @JsonProperty
  @Override
  public String getThreadTs() {
    return threadTs;
  }

  /**
   * @return The value of the {@code userId} attribute
   */
  @JsonProperty("user")
  @Override
  public String getUserId() {
    return userId;
  }

  /**
   * @return The value of the {@code channelId} attribute
   */
  @JsonProperty("channel")
  @Override
  public String getChannelId() {
    return channelId;
  }

  /**
   * @return The value of the {@code replyCount} attribute
   */
  @JsonProperty
  @Override
  public int getReplyCount() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getReplyCount()
        : this.replyCount;
  }

  /**
   * @return The value of the {@code replyUserIds} attribute
   */
  @JsonProperty("reply_users")
  @Override
  public Optional<List<String>> getReplyUserIds() {
    return Optional.ofNullable(replyUserIds);
  }

  /**
   * @return The value of the {@code replyUsersCount} attribute
   */
  @JsonProperty
  @Override
  public Optional<Integer> getReplyUsersCount() {
    return Optional.ofNullable(replyUsersCount);
  }

  /**
   * @return The value of the {@code latestReplyTimestamp} attribute
   */
  @JsonProperty("latest_reply")
  @Override
  public Optional<String> getLatestReplyTimestamp() {
    return Optional.ofNullable(latestReplyTimestamp);
  }

  /**
   * @deprecated use {@link #getReplyUserIds()} or {@link #getLatestReplyTimestamp()}
   * These can be used to find the user ids and the last reply timestamp.
   * Used to return a list of `Reply`
   */
  @JsonProperty
  @Deprecated
  @Override
  public List<Reply> getReplies() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getReplies()
        : this.replies;
  }

  /**
   * @return The value of the {@code subtype} attribute
   */
  @JsonProperty
  @Override
  public Optional<SlackMessageSubtype> getSubtype() {
    return Optional.ofNullable(subtype);
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public SlackEventType getType() {
    return type;
  }

  /**
   * @return The value of the {@code ts} attribute
   */
  @JsonProperty
  @Override
  public String getTs() {
    return ts;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractSlackReplyMessage#getThreadTs() threadTs} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param threadTs A new value for threadTs
   * @return A modified copy of the {@code this} object
   */
  public final SlackReplyMessage withThreadTs(String threadTs) {
    if (this.threadTs.equals(threadTs)) return this;
    String newValue = Objects.requireNonNull(threadTs, "threadTs");
    return new SlackReplyMessage(
        newValue,
        this.userId,
        this.channelId,
        this.replyCount,
        this.replyUserIds,
        this.replyUsersCount,
        this.latestReplyTimestamp,
        this.replies,
        this.subtype,
        this.type,
        this.ts);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractSlackReplyMessage#getUserId() userId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param userId A new value for userId
   * @return A modified copy of the {@code this} object
   */
  public final SlackReplyMessage withUserId(String userId) {
    if (this.userId.equals(userId)) return this;
    String newValue = Objects.requireNonNull(userId, "userId");
    return new SlackReplyMessage(
        this.threadTs,
        newValue,
        this.channelId,
        this.replyCount,
        this.replyUserIds,
        this.replyUsersCount,
        this.latestReplyTimestamp,
        this.replies,
        this.subtype,
        this.type,
        this.ts);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractSlackReplyMessage#getChannelId() channelId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param channelId A new value for channelId
   * @return A modified copy of the {@code this} object
   */
  public final SlackReplyMessage withChannelId(String channelId) {
    if (this.channelId.equals(channelId)) return this;
    String newValue = Objects.requireNonNull(channelId, "channelId");
    return new SlackReplyMessage(
        this.threadTs,
        this.userId,
        newValue,
        this.replyCount,
        this.replyUserIds,
        this.replyUsersCount,
        this.latestReplyTimestamp,
        this.replies,
        this.subtype,
        this.type,
        this.ts);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractSlackReplyMessage#getReplyCount() replyCount} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param replyCount A new value for replyCount
   * @return A modified copy of the {@code this} object
   */
  public final SlackReplyMessage withReplyCount(int replyCount) {
    if (this.replyCount == replyCount) return this;
    return new SlackReplyMessage(
        this.threadTs,
        this.userId,
        this.channelId,
        replyCount,
        this.replyUserIds,
        this.replyUsersCount,
        this.latestReplyTimestamp,
        this.replies,
        this.subtype,
        this.type,
        this.ts);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AbstractSlackReplyMessage#getReplyUserIds() replyUserIds} attribute.
   * @param value The value for replyUserIds, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackReplyMessage withReplyUserIds(@Nullable List<String> value) {
    @Nullable List<String> newValue = value;
    if (this.replyUserIds == newValue) return this;
    return new SlackReplyMessage(
        this.threadTs,
        this.userId,
        this.channelId,
        this.replyCount,
        newValue,
        this.replyUsersCount,
        this.latestReplyTimestamp,
        this.replies,
        this.subtype,
        this.type,
        this.ts);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AbstractSlackReplyMessage#getReplyUserIds() replyUserIds} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for replyUserIds
   * @return A modified copy of {@code this} object
   */
  public final SlackReplyMessage withReplyUserIds(Optional<List<String>> optional) {
    @Nullable List<String> value = optional.orElse(null);
    if (this.replyUserIds == value) return this;
    return new SlackReplyMessage(
        this.threadTs,
        this.userId,
        this.channelId,
        this.replyCount,
        value,
        this.replyUsersCount,
        this.latestReplyTimestamp,
        this.replies,
        this.subtype,
        this.type,
        this.ts);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AbstractSlackReplyMessage#getReplyUsersCount() replyUsersCount} attribute.
   * @param value The value for replyUsersCount, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackReplyMessage withReplyUsersCount(@Nullable Integer value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.replyUsersCount, newValue)) return this;
    return new SlackReplyMessage(
        this.threadTs,
        this.userId,
        this.channelId,
        this.replyCount,
        this.replyUserIds,
        newValue,
        this.latestReplyTimestamp,
        this.replies,
        this.subtype,
        this.type,
        this.ts);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AbstractSlackReplyMessage#getReplyUsersCount() replyUsersCount} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for replyUsersCount
   * @return A modified copy of {@code this} object
   */
  public final SlackReplyMessage withReplyUsersCount(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.replyUsersCount, value)) return this;
    return new SlackReplyMessage(
        this.threadTs,
        this.userId,
        this.channelId,
        this.replyCount,
        this.replyUserIds,
        value,
        this.latestReplyTimestamp,
        this.replies,
        this.subtype,
        this.type,
        this.ts);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AbstractSlackReplyMessage#getLatestReplyTimestamp() latestReplyTimestamp} attribute.
   * @param value The value for latestReplyTimestamp, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackReplyMessage withLatestReplyTimestamp(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.latestReplyTimestamp, newValue)) return this;
    return new SlackReplyMessage(
        this.threadTs,
        this.userId,
        this.channelId,
        this.replyCount,
        this.replyUserIds,
        this.replyUsersCount,
        newValue,
        this.replies,
        this.subtype,
        this.type,
        this.ts);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AbstractSlackReplyMessage#getLatestReplyTimestamp() latestReplyTimestamp} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for latestReplyTimestamp
   * @return A modified copy of {@code this} object
   */
  public final SlackReplyMessage withLatestReplyTimestamp(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.latestReplyTimestamp, value)) return this;
    return new SlackReplyMessage(
        this.threadTs,
        this.userId,
        this.channelId,
        this.replyCount,
        this.replyUserIds,
        this.replyUsersCount,
        value,
        this.replies,
        this.subtype,
        this.type,
        this.ts);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractSlackReplyMessage#getReplies() replies}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  @Deprecated
  public final SlackReplyMessage withReplies(Reply... elements) {
    List<Reply> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new SlackReplyMessage(
        this.threadTs,
        this.userId,
        this.channelId,
        this.replyCount,
        this.replyUserIds,
        this.replyUsersCount,
        this.latestReplyTimestamp,
        newValue,
        this.subtype,
        this.type,
        this.ts);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link AbstractSlackReplyMessage#getReplies() replies}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of replies elements to set
   * @return A modified copy of {@code this} object
   */
  @Deprecated
  public final SlackReplyMessage withReplies(Iterable<? extends Reply> elements) {
    if (this.replies == elements) return this;
    List<Reply> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new SlackReplyMessage(
        this.threadTs,
        this.userId,
        this.channelId,
        this.replyCount,
        this.replyUserIds,
        this.replyUsersCount,
        this.latestReplyTimestamp,
        newValue,
        this.subtype,
        this.type,
        this.ts);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AbstractSlackReplyMessage#getSubtype() subtype} attribute.
   * @param value The value for subtype, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackReplyMessage withSubtype(@Nullable SlackMessageSubtype value) {
    @Nullable SlackMessageSubtype newValue = value;
    if (Objects.equals(this.subtype, newValue)) return this;
    return new SlackReplyMessage(
        this.threadTs,
        this.userId,
        this.channelId,
        this.replyCount,
        this.replyUserIds,
        this.replyUsersCount,
        this.latestReplyTimestamp,
        this.replies,
        newValue,
        this.type,
        this.ts);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AbstractSlackReplyMessage#getSubtype() subtype} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for subtype
   * @return A modified copy of {@code this} object
   */
  public final SlackReplyMessage withSubtype(Optional<SlackMessageSubtype> optional) {
    @Nullable SlackMessageSubtype value = optional.orElse(null);
    if (Objects.equals(this.subtype, value)) return this;
    return new SlackReplyMessage(
        this.threadTs,
        this.userId,
        this.channelId,
        this.replyCount,
        this.replyUserIds,
        this.replyUsersCount,
        this.latestReplyTimestamp,
        this.replies,
        value,
        this.type,
        this.ts);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractSlackReplyMessage#getType() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param type A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final SlackReplyMessage withType(SlackEventType type) {
    if (this.type == type) return this;
    SlackEventType newValue = Objects.requireNonNull(type, "type");
    return new SlackReplyMessage(
        this.threadTs,
        this.userId,
        this.channelId,
        this.replyCount,
        this.replyUserIds,
        this.replyUsersCount,
        this.latestReplyTimestamp,
        this.replies,
        this.subtype,
        newValue,
        this.ts);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AbstractSlackReplyMessage#getTs() ts} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param ts A new value for ts
   * @return A modified copy of the {@code this} object
   */
  public final SlackReplyMessage withTs(String ts) {
    if (this.ts.equals(ts)) return this;
    String newValue = Objects.requireNonNull(ts, "ts");
    return new SlackReplyMessage(
        this.threadTs,
        this.userId,
        this.channelId,
        this.replyCount,
        this.replyUserIds,
        this.replyUsersCount,
        this.latestReplyTimestamp,
        this.replies,
        this.subtype,
        this.type,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code SlackReplyMessage} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof SlackReplyMessage
        && equalTo((SlackReplyMessage) another);
  }

  private boolean equalTo(SlackReplyMessage another) {
    return threadTs.equals(another.threadTs)
        && userId.equals(another.userId)
        && channelId.equals(another.channelId)
        && replyCount == another.replyCount
        && Objects.equals(replyUserIds, another.replyUserIds)
        && Objects.equals(replyUsersCount, another.replyUsersCount)
        && Objects.equals(latestReplyTimestamp, another.latestReplyTimestamp)
        && replies.equals(another.replies)
        && Objects.equals(subtype, another.subtype)
        && type.equals(another.type)
        && ts.equals(another.ts);
  }

  /**
   * Computes a hash code from attributes: {@code threadTs}, {@code userId}, {@code channelId}, {@code replyCount}, {@code replyUserIds}, {@code replyUsersCount}, {@code latestReplyTimestamp}, {@code replies}, {@code subtype}, {@code type}, {@code ts}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + threadTs.hashCode();
    h = h * 17 + userId.hashCode();
    h = h * 17 + channelId.hashCode();
    h = h * 17 + replyCount;
    h = h * 17 + Objects.hashCode(replyUserIds);
    h = h * 17 + Objects.hashCode(replyUsersCount);
    h = h * 17 + Objects.hashCode(latestReplyTimestamp);
    h = h * 17 + replies.hashCode();
    h = h * 17 + Objects.hashCode(subtype);
    h = h * 17 + type.hashCode();
    h = h * 17 + ts.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SlackReplyMessage} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("SlackReplyMessage{");
    builder.append("threadTs=").append(threadTs);
    builder.append(", ");
    builder.append("userId=").append(userId);
    builder.append(", ");
    builder.append("channelId=").append(channelId);
    builder.append(", ");
    builder.append("replyCount=").append(replyCount);
    if (replyUserIds != null) {
      builder.append(", ");
      builder.append("replyUserIds=").append(replyUserIds);
    }
    if (replyUsersCount != null) {
      builder.append(", ");
      builder.append("replyUsersCount=").append(replyUsersCount);
    }
    if (latestReplyTimestamp != null) {
      builder.append(", ");
      builder.append("latestReplyTimestamp=").append(latestReplyTimestamp);
    }
    builder.append(", ");
    builder.append("replies=").append(replies);
    if (subtype != null) {
      builder.append(", ");
      builder.append("subtype=").append(subtype);
    }
    builder.append(", ");
    builder.append("type=").append(type);
    builder.append(", ");
    builder.append("ts=").append(ts);
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends AbstractSlackReplyMessage {
    @Nullable String threadTs;
    @Nullable String userId;
    @Nullable String channelId;
    int replyCount;
    boolean replyCountIsSet;
    Optional<List<String>> replyUserIds = Optional.empty();
    Optional<Integer> replyUsersCount = Optional.empty();
    Optional<String> latestReplyTimestamp = Optional.empty();
    List<Reply> replies = Collections.emptyList();
    boolean repliesIsSet;
    Optional<SlackMessageSubtype> subtype = Optional.empty();
    @Nullable SlackEventType type;
    @Nullable String ts;
    @JsonProperty
    public void setThreadTs(String threadTs) {
      this.threadTs = threadTs;
    }
    @JsonProperty("user")
    public void setUserId(String userId) {
      this.userId = userId;
    }
    @JsonProperty("channel")
    public void setChannelId(String channelId) {
      this.channelId = channelId;
    }
    @JsonProperty
    public void setReplyCount(int replyCount) {
      this.replyCount = replyCount;
      this.replyCountIsSet = true;
    }
    @JsonProperty("reply_users")
    public void setReplyUserIds(Optional<List<String>> replyUserIds) {
      this.replyUserIds = replyUserIds;
    }
    @JsonProperty
    public void setReplyUsersCount(Optional<Integer> replyUsersCount) {
      this.replyUsersCount = replyUsersCount;
    }
    @JsonProperty("latest_reply")
    public void setLatestReplyTimestamp(Optional<String> latestReplyTimestamp) {
      this.latestReplyTimestamp = latestReplyTimestamp;
    }
    @JsonProperty
    public void setReplies(List<Reply> replies) {
      this.replies = replies;
      this.repliesIsSet = true;
    }
    @JsonProperty
    public void setSubtype(Optional<SlackMessageSubtype> subtype) {
      this.subtype = subtype;
    }
    @JsonProperty
    public void setType(SlackEventType type) {
      this.type = type;
    }
    @JsonProperty
    public void setTs(String ts) {
      this.ts = ts;
    }
    @Override
    public String getThreadTs() { throw new UnsupportedOperationException(); }
    @Override
    public String getUserId() { throw new UnsupportedOperationException(); }
    @Override
    public String getChannelId() { throw new UnsupportedOperationException(); }
    @Override
    public int getReplyCount() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<List<String>> getReplyUserIds() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Integer> getReplyUsersCount() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getLatestReplyTimestamp() { throw new UnsupportedOperationException(); }
    @Override
    public List<Reply> getReplies() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<SlackMessageSubtype> getSubtype() { throw new UnsupportedOperationException(); }
    @Override
    public SlackEventType getType() { throw new UnsupportedOperationException(); }
    @Override
    public String getTs() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static SlackReplyMessage fromJson(Json json) {
    SlackReplyMessage.Builder builder = SlackReplyMessage.builder();
    if (json.threadTs != null) {
      builder.setThreadTs(json.threadTs);
    }
    if (json.userId != null) {
      builder.setUserId(json.userId);
    }
    if (json.channelId != null) {
      builder.setChannelId(json.channelId);
    }
    if (json.replyCountIsSet) {
      builder.setReplyCount(json.replyCount);
    }
    if (json.replyUserIds != null) {
      builder.setReplyUserIds(json.replyUserIds);
    }
    if (json.replyUsersCount != null) {
      builder.setReplyUsersCount(json.replyUsersCount);
    }
    if (json.latestReplyTimestamp != null) {
      builder.setLatestReplyTimestamp(json.latestReplyTimestamp);
    }
    if (json.repliesIsSet) {
      builder.setReplies(json.replies);
    }
    if (json.subtype != null) {
      builder.setSubtype(json.subtype);
    }
    if (json.type != null) {
      builder.setType(json.type);
    }
    if (json.ts != null) {
      builder.setTs(json.ts);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link AbstractSlackReplyMessage} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SlackReplyMessage instance
   */
  public static SlackReplyMessage copyOf(AbstractSlackReplyMessage instance) {
    if (instance instanceof SlackReplyMessage) {
      return (SlackReplyMessage) instance;
    }
    return SlackReplyMessage.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link SlackReplyMessage SlackReplyMessage}.
   * @return A new SlackReplyMessage builder
   */
  public static SlackReplyMessage.Builder builder() {
    return new SlackReplyMessage.Builder();
  }

  /**
   * Builds instances of type {@link SlackReplyMessage SlackReplyMessage}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_THREAD_TS = 0x1L;
    private static final long INIT_BIT_USER_ID = 0x2L;
    private static final long INIT_BIT_CHANNEL_ID = 0x4L;
    private static final long INIT_BIT_TYPE = 0x8L;
    private static final long INIT_BIT_TS = 0x10L;
    private static final long OPT_BIT_REPLY_COUNT = 0x1L;
    private static final long OPT_BIT_REPLIES = 0x2L;
    private long initBits = 0x1fL;
    private long optBits;

    private @Nullable String threadTs;
    private @Nullable String userId;
    private @Nullable String channelId;
    private int replyCount;
    private @Nullable List<String> replyUserIds;
    private @Nullable Integer replyUsersCount;
    private @Nullable String latestReplyTimestamp;
    private List<Reply> replies = new ArrayList<Reply>();
    private @Nullable SlackMessageSubtype subtype;
    private @Nullable SlackEventType type;
    private @Nullable String ts;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.interceptor.HasChannel} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(HasChannel instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.events.SlackEventMessageBase} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackEventMessageBase instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.events.SlackEvent} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackEvent instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.methods.interceptor.HasUser} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(HasUser instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.events.util.AbstractSlackReplyMessage} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AbstractSlackReplyMessage instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof HasChannel) {
        HasChannel instance = (HasChannel) object;
        if ((bits & 0x2L) == 0) {
          setChannelId(instance.getChannelId());
          bits |= 0x2L;
        }
      }
      if (object instanceof SlackEventMessageBase) {
        SlackEventMessageBase instance = (SlackEventMessageBase) object;
        Optional<SlackMessageSubtype> subtypeOptional = instance.getSubtype();
        if (subtypeOptional.isPresent()) {
          setSubtype(subtypeOptional);
        }
      }
      if (object instanceof SlackEvent) {
        SlackEvent instance = (SlackEvent) object;
        setType(instance.getType());
        setTs(instance.getTs());
      }
      if (object instanceof HasUser) {
        HasUser instance = (HasUser) object;
        if ((bits & 0x1L) == 0) {
          setUserId(instance.getUserId());
          bits |= 0x1L;
        }
      }
      if (object instanceof AbstractSlackReplyMessage) {
        AbstractSlackReplyMessage instance = (AbstractSlackReplyMessage) object;
        setReplyCount(instance.getReplyCount());
        Optional<Integer> replyUsersCountOptional = instance.getReplyUsersCount();
        if (replyUsersCountOptional.isPresent()) {
          setReplyUsersCount(replyUsersCountOptional);
        }
        Optional<List<String>> replyUserIdsOptional = instance.getReplyUserIds();
        if (replyUserIdsOptional.isPresent()) {
          setReplyUserIds(replyUserIdsOptional);
        }
        addAllReplies(instance.getReplies());
        Optional<String> latestReplyTimestampOptional = instance.getLatestReplyTimestamp();
        if (latestReplyTimestampOptional.isPresent()) {
          setLatestReplyTimestamp(latestReplyTimestampOptional);
        }
        setThreadTs(instance.getThreadTs());
        if ((bits & 0x1L) == 0) {
          setUserId(instance.getUserId());
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          setChannelId(instance.getChannelId());
          bits |= 0x2L;
        }
      }
    }

    /**
     * Initializes the value for the {@link AbstractSlackReplyMessage#getThreadTs() threadTs} attribute.
     * @param threadTs The value for threadTs 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setThreadTs(String threadTs) {
      this.threadTs = Objects.requireNonNull(threadTs, "threadTs");
      initBits &= ~INIT_BIT_THREAD_TS;
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractSlackReplyMessage#getUserId() userId} attribute.
     * @param userId The value for userId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUserId(String userId) {
      this.userId = Objects.requireNonNull(userId, "userId");
      initBits &= ~INIT_BIT_USER_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractSlackReplyMessage#getChannelId() channelId} attribute.
     * @param channelId The value for channelId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannelId(String channelId) {
      this.channelId = Objects.requireNonNull(channelId, "channelId");
      initBits &= ~INIT_BIT_CHANNEL_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractSlackReplyMessage#getReplyCount() replyCount} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link AbstractSlackReplyMessage#getReplyCount() replyCount}.</em>
     * @param replyCount The value for replyCount 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setReplyCount(int replyCount) {
      this.replyCount = replyCount;
      optBits |= OPT_BIT_REPLY_COUNT;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlackReplyMessage#getReplyUserIds() replyUserIds} to replyUserIds.
     * @param replyUserIds The value for replyUserIds, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setReplyUserIds(@Nullable List<String> replyUserIds) {
      this.replyUserIds = replyUserIds;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlackReplyMessage#getReplyUserIds() replyUserIds} to replyUserIds.
     * @param replyUserIds The value for replyUserIds
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setReplyUserIds(Optional<List<String>> replyUserIds) {
      this.replyUserIds = replyUserIds.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlackReplyMessage#getReplyUsersCount() replyUsersCount} to replyUsersCount.
     * @param replyUsersCount The value for replyUsersCount, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setReplyUsersCount(@Nullable Integer replyUsersCount) {
      this.replyUsersCount = replyUsersCount;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlackReplyMessage#getReplyUsersCount() replyUsersCount} to replyUsersCount.
     * @param replyUsersCount The value for replyUsersCount
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setReplyUsersCount(Optional<Integer> replyUsersCount) {
      this.replyUsersCount = replyUsersCount.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlackReplyMessage#getLatestReplyTimestamp() latestReplyTimestamp} to latestReplyTimestamp.
     * @param latestReplyTimestamp The value for latestReplyTimestamp, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setLatestReplyTimestamp(@Nullable String latestReplyTimestamp) {
      this.latestReplyTimestamp = latestReplyTimestamp;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlackReplyMessage#getLatestReplyTimestamp() latestReplyTimestamp} to latestReplyTimestamp.
     * @param latestReplyTimestamp The value for latestReplyTimestamp
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setLatestReplyTimestamp(Optional<String> latestReplyTimestamp) {
      this.latestReplyTimestamp = latestReplyTimestamp.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link AbstractSlackReplyMessage#getReplies() replies} list.
     * @param element A replies element
     * @return {@code this} builder for use in a chained invocation
     */
    @Deprecated
    public final Builder addReplies(Reply element) {
      this.replies.add(Objects.requireNonNull(element, "replies element"));
      optBits |= OPT_BIT_REPLIES;
      return this;
    }

    /**
     * Adds elements to {@link AbstractSlackReplyMessage#getReplies() replies} list.
     * @param elements An array of replies elements
     * @return {@code this} builder for use in a chained invocation
     */
    @Deprecated
    public final Builder addReplies(Reply... elements) {
      for (Reply element : elements) {
        this.replies.add(Objects.requireNonNull(element, "replies element"));
      }
      optBits |= OPT_BIT_REPLIES;
      return this;
    }

    /**
     * Sets or replaces all elements for {@link AbstractSlackReplyMessage#getReplies() replies} list.
     * @param elements An iterable of replies elements
     * @return {@code this} builder for use in a chained invocation
     */
    @Deprecated
    public final Builder setReplies(Iterable<? extends Reply> elements) {
      this.replies.clear();
      return addAllReplies(elements);
    }

    /**
     * Adds elements to {@link AbstractSlackReplyMessage#getReplies() replies} list.
     * @param elements An iterable of replies elements
     * @return {@code this} builder for use in a chained invocation
     */
    @Deprecated
    public final Builder addAllReplies(Iterable<? extends Reply> elements) {
      for (Reply element : elements) {
        this.replies.add(Objects.requireNonNull(element, "replies element"));
      }
      optBits |= OPT_BIT_REPLIES;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlackReplyMessage#getSubtype() subtype} to subtype.
     * @param subtype The value for subtype, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setSubtype(@Nullable SlackMessageSubtype subtype) {
      this.subtype = subtype;
      return this;
    }

    /**
     * Initializes the optional value {@link AbstractSlackReplyMessage#getSubtype() subtype} to subtype.
     * @param subtype The value for subtype
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setSubtype(Optional<SlackMessageSubtype> subtype) {
      this.subtype = subtype.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractSlackReplyMessage#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setType(SlackEventType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link AbstractSlackReplyMessage#getTs() ts} attribute.
     * @param ts The value for ts 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTs(String ts) {
      this.ts = Objects.requireNonNull(ts, "ts");
      initBits &= ~INIT_BIT_TS;
      return this;
    }

    /**
     * Builds a new {@link SlackReplyMessage SlackReplyMessage}.
     * @return An immutable instance of SlackReplyMessage
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public SlackReplyMessage build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new SlackReplyMessage(this);
    }

    private boolean replyCountIsSet() {
      return (optBits & OPT_BIT_REPLY_COUNT) != 0;
    }

    private boolean repliesIsSet() {
      return (optBits & OPT_BIT_REPLIES) != 0;
    }

    private boolean threadTsIsSet() {
      return (initBits & INIT_BIT_THREAD_TS) == 0;
    }

    private boolean userIdIsSet() {
      return (initBits & INIT_BIT_USER_ID) == 0;
    }

    private boolean channelIdIsSet() {
      return (initBits & INIT_BIT_CHANNEL_ID) == 0;
    }

    private boolean typeIsSet() {
      return (initBits & INIT_BIT_TYPE) == 0;
    }

    private boolean tsIsSet() {
      return (initBits & INIT_BIT_TS) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!threadTsIsSet()) attributes.add("threadTs");
      if (!userIdIsSet()) attributes.add("userId");
      if (!channelIdIsSet()) attributes.add("channelId");
      if (!typeIsSet()) attributes.add("type");
      if (!tsIsSet()) attributes.add("ts");
      return "Cannot build SlackReplyMessage, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
