package com.hubspot.slack.client.models.files;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link SlackCsvFileIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code SlackCsvFile.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "SlackCsvFileIF"})
@Immutable
public final class SlackCsvFile implements SlackCsvFileIF {
  private final SlackFileType filetype;
  private final String editLink;
  private final String preview;
  private final String previewHighlight;
  private final String lines;
  private final String linesMore;
  private final boolean previewTruncated;
  private final String id;
  private final long createdEpochSeconds;
  private final long timestampEpochSeconds;
  private final String name;
  private final String title;
  private final String mimetype;
  private final String prettyType;
  private final String userId;
  private final boolean editable;
  private final long size;
  private final String mode;
  private final boolean external;
  private final boolean isPublic;
  private final boolean publicUrlShared;
  private final boolean displayAsBot;
  private final String username;
  private final String urlPrivate;
  private final @Nullable String urlPrivateDownload;
  private final String permalink;
  private final @Nullable String permalinkPublic;
  private final int commentsCount;
  private final @Nullable Boolean starred;
  private final List<String> channelIds;
  private final List<String> groupIds;
  private final List<String> imIds;

  private SlackCsvFile(SlackCsvFile.Builder builder) {
    this.editLink = builder.editLink;
    this.preview = builder.preview;
    this.previewHighlight = builder.previewHighlight;
    this.lines = builder.lines;
    this.linesMore = builder.linesMore;
    this.previewTruncated = builder.previewTruncated;
    this.id = builder.id;
    this.createdEpochSeconds = builder.createdEpochSeconds;
    this.timestampEpochSeconds = builder.timestampEpochSeconds;
    this.name = builder.name;
    this.title = builder.title;
    this.mimetype = builder.mimetype;
    this.prettyType = builder.prettyType;
    this.userId = builder.userId;
    this.editable = builder.editable;
    this.size = builder.size;
    this.mode = builder.mode;
    this.external = builder.external;
    this.isPublic = builder.isPublic;
    this.publicUrlShared = builder.publicUrlShared;
    this.displayAsBot = builder.displayAsBot;
    this.username = builder.username;
    this.urlPrivate = builder.urlPrivate;
    this.urlPrivateDownload = builder.urlPrivateDownload;
    this.permalink = builder.permalink;
    this.permalinkPublic = builder.permalinkPublic;
    this.starred = builder.starred;
    this.channelIds = createUnmodifiableList(true, builder.channelIds);
    this.groupIds = createUnmodifiableList(true, builder.groupIds);
    this.imIds = createUnmodifiableList(true, builder.imIds);
    if (builder.filetype != null) {
      initShim.setFiletype(builder.filetype);
    }
    if (builder.commentsCountIsSet()) {
      initShim.setCommentsCount(builder.commentsCount);
    }
    this.filetype = initShim.getFiletype();
    this.commentsCount = initShim.getCommentsCount();
    this.initShim = null;
  }

  private SlackCsvFile(
      SlackFileType filetype,
      String editLink,
      String preview,
      String previewHighlight,
      String lines,
      String linesMore,
      boolean previewTruncated,
      String id,
      long createdEpochSeconds,
      long timestampEpochSeconds,
      String name,
      String title,
      String mimetype,
      String prettyType,
      String userId,
      boolean editable,
      long size,
      String mode,
      boolean external,
      boolean isPublic,
      boolean publicUrlShared,
      boolean displayAsBot,
      String username,
      String urlPrivate,
      @Nullable String urlPrivateDownload,
      String permalink,
      @Nullable String permalinkPublic,
      int commentsCount,
      @Nullable Boolean starred,
      List<String> channelIds,
      List<String> groupIds,
      List<String> imIds) {
    this.filetype = filetype;
    this.editLink = editLink;
    this.preview = preview;
    this.previewHighlight = previewHighlight;
    this.lines = lines;
    this.linesMore = linesMore;
    this.previewTruncated = previewTruncated;
    this.id = id;
    this.createdEpochSeconds = createdEpochSeconds;
    this.timestampEpochSeconds = timestampEpochSeconds;
    this.name = name;
    this.title = title;
    this.mimetype = mimetype;
    this.prettyType = prettyType;
    this.userId = userId;
    this.editable = editable;
    this.size = size;
    this.mode = mode;
    this.external = external;
    this.isPublic = isPublic;
    this.publicUrlShared = publicUrlShared;
    this.displayAsBot = displayAsBot;
    this.username = username;
    this.urlPrivate = urlPrivate;
    this.urlPrivateDownload = urlPrivateDownload;
    this.permalink = permalink;
    this.permalinkPublic = permalinkPublic;
    this.commentsCount = commentsCount;
    this.starred = starred;
    this.channelIds = channelIds;
    this.groupIds = groupIds;
    this.imIds = imIds;
    this.initShim = null;
  }

  private static final int STAGE_INITIALIZING = -1;
  private static final int STAGE_UNINITIALIZED = 0;
  private static final int STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private SlackFileType filetype;
    private int filetypeStage;

    SlackFileType getFiletype() {
      if (filetypeStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (filetypeStage == STAGE_UNINITIALIZED) {
        filetypeStage = STAGE_INITIALIZING;
        this.filetype = Objects.requireNonNull(getFiletypeInitialize(), "filetype");
        filetypeStage = STAGE_INITIALIZED;
      }
      return this.filetype;
    }

    void setFiletype(SlackFileType filetype) {
      this.filetype = filetype;
      filetypeStage = STAGE_INITIALIZED;
    }
    private int commentsCount;
    private int commentsCountStage;

    int getCommentsCount() {
      if (commentsCountStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (commentsCountStage == STAGE_UNINITIALIZED) {
        commentsCountStage = STAGE_INITIALIZING;
        this.commentsCount = getCommentsCountInitialize();
        commentsCountStage = STAGE_INITIALIZED;
      }
      return this.commentsCount;
    }

    void setCommentsCount(int commentsCount) {
      this.commentsCount = commentsCount;
      commentsCountStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      ArrayList<String> attributes = new ArrayList<String>();
      if (filetypeStage == STAGE_INITIALIZING) attributes.add("filetype");
      if (commentsCountStage == STAGE_INITIALIZING) attributes.add("commentsCount");
      return "Cannot build SlackCsvFile, attribute initializers form cycle" + attributes;
    }
  }

  private SlackFileType getFiletypeInitialize() {
    return SlackCsvFileIF.super.getFiletype();
  }

  private int getCommentsCountInitialize() {
    return SlackCsvFileIF.super.getCommentsCount();
  }

  /**
   * @return The value of the {@code filetype} attribute
   */
  @JsonProperty
  @Override
  public SlackFileType getFiletype() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getFiletype()
        : this.filetype;
  }

  /**
   * @return The value of the {@code editLink} attribute
   */
  @JsonProperty
  @Override
  public String getEditLink() {
    return editLink;
  }

  /**
   * @return The value of the {@code preview} attribute
   */
  @JsonProperty
  @Override
  public String getPreview() {
    return preview;
  }

  /**
   * @return The value of the {@code previewHighlight} attribute
   */
  @JsonProperty
  @Override
  public String getPreviewHighlight() {
    return previewHighlight;
  }

  /**
   * @return The value of the {@code lines} attribute
   */
  @JsonProperty
  @Override
  public String getLines() {
    return lines;
  }

  /**
   * @return The value of the {@code linesMore} attribute
   */
  @JsonProperty
  @Override
  public String getLinesMore() {
    return linesMore;
  }

  /**
   * @return The value of the {@code previewTruncated} attribute
   */
  @JsonProperty("preview_is_truncated")
  @Override
  public boolean isPreviewTruncated() {
    return previewTruncated;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code createdEpochSeconds} attribute
   */
  @JsonProperty("created")
  @Override
  public long getCreatedEpochSeconds() {
    return createdEpochSeconds;
  }

  /**
   * @return The value of the {@code timestampEpochSeconds} attribute
   */
  @JsonProperty("timestamp")
  @Override
  public long getTimestampEpochSeconds() {
    return timestampEpochSeconds;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code title} attribute
   */
  @JsonProperty
  @Override
  public String getTitle() {
    return title;
  }

  /**
   * @return The value of the {@code mimetype} attribute
   */
  @JsonProperty
  @Override
  public String getMimetype() {
    return mimetype;
  }

  /**
   * @return The value of the {@code prettyType} attribute
   */
  @JsonProperty
  @Override
  public String getPrettyType() {
    return prettyType;
  }

  /**
   * @return The value of the {@code userId} attribute
   */
  @JsonProperty("user")
  @Override
  public String getUserId() {
    return userId;
  }

  /**
   * @return The value of the {@code editable} attribute
   */
  @JsonProperty
  @Override
  public boolean isEditable() {
    return editable;
  }

  /**
   * @return The value of the {@code size} attribute
   */
  @JsonProperty
  @Override
  public long getSize() {
    return size;
  }

  /**
   * @return The value of the {@code mode} attribute
   */
  @JsonProperty
  @Override
  public String getMode() {
    return mode;
  }

  /**
   * @return The value of the {@code external} attribute
   */
  @JsonProperty("is_external")
  @Override
  public boolean isExternal() {
    return external;
  }

  /**
   * @return The value of the {@code isPublic} attribute
   */
  @JsonProperty("is_public")
  @Override
  public boolean isPublic() {
    return isPublic;
  }

  /**
   * @return The value of the {@code publicUrlShared} attribute
   */
  @JsonProperty
  @Override
  public boolean isPublicUrlShared() {
    return publicUrlShared;
  }

  /**
   * @return The value of the {@code displayAsBot} attribute
   */
  @JsonProperty
  @Override
  public boolean getDisplayAsBot() {
    return displayAsBot;
  }

  /**
   * @return The value of the {@code username} attribute
   */
  @JsonProperty
  @Override
  public String getUsername() {
    return username;
  }

  /**
   * @return The value of the {@code urlPrivate} attribute
   */
  @JsonProperty
  @Override
  public String getUrlPrivate() {
    return urlPrivate;
  }

  /**
   * @return The value of the {@code urlPrivateDownload} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getUrlPrivateDownload() {
    return Optional.ofNullable(urlPrivateDownload);
  }

  /**
   * @return The value of the {@code permalink} attribute
   */
  @JsonProperty
  @Override
  public String getPermalink() {
    return permalink;
  }

  /**
   * @return The value of the {@code permalinkPublic} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getPermalinkPublic() {
    return Optional.ofNullable(permalinkPublic);
  }

  /**
   * @return The value of the {@code commentsCount} attribute
   */
  @JsonProperty
  @Override
  public int getCommentsCount() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getCommentsCount()
        : this.commentsCount;
  }

  /**
   * @return The value of the {@code starred} attribute
   */
  @JsonProperty("is_starred")
  @Override
  public Optional<Boolean> isStarred() {
    return Optional.ofNullable(starred);
  }

  /**
   * @return The value of the {@code channelIds} attribute
   */
  @JsonProperty("channels")
  @Override
  public List<String> getChannelIds() {
    return channelIds;
  }

  /**
   * @return The value of the {@code groupIds} attribute
   */
  @JsonProperty("groups")
  @Override
  public List<String> getGroupIds() {
    return groupIds;
  }

  /**
   * @return The value of the {@code imIds} attribute
   */
  @JsonProperty("ims")
  @Override
  public List<String> getImIds() {
    return imIds;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackCsvFileIF#getFiletype() filetype} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param filetype A new value for filetype
   * @return A modified copy of the {@code this} object
   */
  public final SlackCsvFile withFiletype(SlackFileType filetype) {
    if (this.filetype == filetype) return this;
    SlackFileType newValue = Objects.requireNonNull(filetype, "filetype");
    return new SlackCsvFile(
        newValue,
        this.editLink,
        this.preview,
        this.previewHighlight,
        this.lines,
        this.linesMore,
        this.previewTruncated,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackCsvFileIF#getEditLink() editLink} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param editLink A new value for editLink
   * @return A modified copy of the {@code this} object
   */
  public final SlackCsvFile withEditLink(String editLink) {
    if (this.editLink.equals(editLink)) return this;
    String newValue = Objects.requireNonNull(editLink, "editLink");
    return new SlackCsvFile(
        this.filetype,
        newValue,
        this.preview,
        this.previewHighlight,
        this.lines,
        this.linesMore,
        this.previewTruncated,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackCsvFileIF#getPreview() preview} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param preview A new value for preview
   * @return A modified copy of the {@code this} object
   */
  public final SlackCsvFile withPreview(String preview) {
    if (this.preview.equals(preview)) return this;
    String newValue = Objects.requireNonNull(preview, "preview");
    return new SlackCsvFile(
        this.filetype,
        this.editLink,
        newValue,
        this.previewHighlight,
        this.lines,
        this.linesMore,
        this.previewTruncated,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackCsvFileIF#getPreviewHighlight() previewHighlight} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param previewHighlight A new value for previewHighlight
   * @return A modified copy of the {@code this} object
   */
  public final SlackCsvFile withPreviewHighlight(String previewHighlight) {
    if (this.previewHighlight.equals(previewHighlight)) return this;
    String newValue = Objects.requireNonNull(previewHighlight, "previewHighlight");
    return new SlackCsvFile(
        this.filetype,
        this.editLink,
        this.preview,
        newValue,
        this.lines,
        this.linesMore,
        this.previewTruncated,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackCsvFileIF#getLines() lines} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param lines A new value for lines
   * @return A modified copy of the {@code this} object
   */
  public final SlackCsvFile withLines(String lines) {
    if (this.lines.equals(lines)) return this;
    String newValue = Objects.requireNonNull(lines, "lines");
    return new SlackCsvFile(
        this.filetype,
        this.editLink,
        this.preview,
        this.previewHighlight,
        newValue,
        this.linesMore,
        this.previewTruncated,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackCsvFileIF#getLinesMore() linesMore} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param linesMore A new value for linesMore
   * @return A modified copy of the {@code this} object
   */
  public final SlackCsvFile withLinesMore(String linesMore) {
    if (this.linesMore.equals(linesMore)) return this;
    String newValue = Objects.requireNonNull(linesMore, "linesMore");
    return new SlackCsvFile(
        this.filetype,
        this.editLink,
        this.preview,
        this.previewHighlight,
        this.lines,
        newValue,
        this.previewTruncated,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackCsvFileIF#isPreviewTruncated() previewTruncated} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param previewTruncated A new value for previewTruncated
   * @return A modified copy of the {@code this} object
   */
  public final SlackCsvFile withPreviewTruncated(boolean previewTruncated) {
    if (this.previewTruncated == previewTruncated) return this;
    return new SlackCsvFile(
        this.filetype,
        this.editLink,
        this.preview,
        this.previewHighlight,
        this.lines,
        this.linesMore,
        previewTruncated,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackCsvFileIF#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param id A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final SlackCsvFile withId(String id) {
    if (this.id.equals(id)) return this;
    String newValue = Objects.requireNonNull(id, "id");
    return new SlackCsvFile(
        this.filetype,
        this.editLink,
        this.preview,
        this.previewHighlight,
        this.lines,
        this.linesMore,
        this.previewTruncated,
        newValue,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackCsvFileIF#getCreatedEpochSeconds() createdEpochSeconds} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param createdEpochSeconds A new value for createdEpochSeconds
   * @return A modified copy of the {@code this} object
   */
  public final SlackCsvFile withCreatedEpochSeconds(long createdEpochSeconds) {
    if (this.createdEpochSeconds == createdEpochSeconds) return this;
    return new SlackCsvFile(
        this.filetype,
        this.editLink,
        this.preview,
        this.previewHighlight,
        this.lines,
        this.linesMore,
        this.previewTruncated,
        this.id,
        createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackCsvFileIF#getTimestampEpochSeconds() timestampEpochSeconds} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param timestampEpochSeconds A new value for timestampEpochSeconds
   * @return A modified copy of the {@code this} object
   */
  public final SlackCsvFile withTimestampEpochSeconds(long timestampEpochSeconds) {
    if (this.timestampEpochSeconds == timestampEpochSeconds) return this;
    return new SlackCsvFile(
        this.filetype,
        this.editLink,
        this.preview,
        this.previewHighlight,
        this.lines,
        this.linesMore,
        this.previewTruncated,
        this.id,
        this.createdEpochSeconds,
        timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackCsvFileIF#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param name A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final SlackCsvFile withName(String name) {
    if (this.name.equals(name)) return this;
    String newValue = Objects.requireNonNull(name, "name");
    return new SlackCsvFile(
        this.filetype,
        this.editLink,
        this.preview,
        this.previewHighlight,
        this.lines,
        this.linesMore,
        this.previewTruncated,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        newValue,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackCsvFileIF#getTitle() title} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param title A new value for title
   * @return A modified copy of the {@code this} object
   */
  public final SlackCsvFile withTitle(String title) {
    if (this.title.equals(title)) return this;
    String newValue = Objects.requireNonNull(title, "title");
    return new SlackCsvFile(
        this.filetype,
        this.editLink,
        this.preview,
        this.previewHighlight,
        this.lines,
        this.linesMore,
        this.previewTruncated,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        newValue,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackCsvFileIF#getMimetype() mimetype} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param mimetype A new value for mimetype
   * @return A modified copy of the {@code this} object
   */
  public final SlackCsvFile withMimetype(String mimetype) {
    if (this.mimetype.equals(mimetype)) return this;
    String newValue = Objects.requireNonNull(mimetype, "mimetype");
    return new SlackCsvFile(
        this.filetype,
        this.editLink,
        this.preview,
        this.previewHighlight,
        this.lines,
        this.linesMore,
        this.previewTruncated,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        newValue,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackCsvFileIF#getPrettyType() prettyType} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param prettyType A new value for prettyType
   * @return A modified copy of the {@code this} object
   */
  public final SlackCsvFile withPrettyType(String prettyType) {
    if (this.prettyType.equals(prettyType)) return this;
    String newValue = Objects.requireNonNull(prettyType, "prettyType");
    return new SlackCsvFile(
        this.filetype,
        this.editLink,
        this.preview,
        this.previewHighlight,
        this.lines,
        this.linesMore,
        this.previewTruncated,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        newValue,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackCsvFileIF#getUserId() userId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param userId A new value for userId
   * @return A modified copy of the {@code this} object
   */
  public final SlackCsvFile withUserId(String userId) {
    if (this.userId.equals(userId)) return this;
    String newValue = Objects.requireNonNull(userId, "userId");
    return new SlackCsvFile(
        this.filetype,
        this.editLink,
        this.preview,
        this.previewHighlight,
        this.lines,
        this.linesMore,
        this.previewTruncated,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        newValue,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackCsvFileIF#isEditable() editable} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param editable A new value for editable
   * @return A modified copy of the {@code this} object
   */
  public final SlackCsvFile withEditable(boolean editable) {
    if (this.editable == editable) return this;
    return new SlackCsvFile(
        this.filetype,
        this.editLink,
        this.preview,
        this.previewHighlight,
        this.lines,
        this.linesMore,
        this.previewTruncated,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackCsvFileIF#getSize() size} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param size A new value for size
   * @return A modified copy of the {@code this} object
   */
  public final SlackCsvFile withSize(long size) {
    if (this.size == size) return this;
    return new SlackCsvFile(
        this.filetype,
        this.editLink,
        this.preview,
        this.previewHighlight,
        this.lines,
        this.linesMore,
        this.previewTruncated,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackCsvFileIF#getMode() mode} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param mode A new value for mode
   * @return A modified copy of the {@code this} object
   */
  public final SlackCsvFile withMode(String mode) {
    if (this.mode.equals(mode)) return this;
    String newValue = Objects.requireNonNull(mode, "mode");
    return new SlackCsvFile(
        this.filetype,
        this.editLink,
        this.preview,
        this.previewHighlight,
        this.lines,
        this.linesMore,
        this.previewTruncated,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        newValue,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackCsvFileIF#isExternal() external} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param external A new value for external
   * @return A modified copy of the {@code this} object
   */
  public final SlackCsvFile withExternal(boolean external) {
    if (this.external == external) return this;
    return new SlackCsvFile(
        this.filetype,
        this.editLink,
        this.preview,
        this.previewHighlight,
        this.lines,
        this.linesMore,
        this.previewTruncated,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackCsvFileIF#isPublic() isPublic} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param isPublic A new value for isPublic
   * @return A modified copy of the {@code this} object
   */
  public final SlackCsvFile withIsPublic(boolean isPublic) {
    if (this.isPublic == isPublic) return this;
    return new SlackCsvFile(
        this.filetype,
        this.editLink,
        this.preview,
        this.previewHighlight,
        this.lines,
        this.linesMore,
        this.previewTruncated,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackCsvFileIF#isPublicUrlShared() publicUrlShared} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param publicUrlShared A new value for publicUrlShared
   * @return A modified copy of the {@code this} object
   */
  public final SlackCsvFile withPublicUrlShared(boolean publicUrlShared) {
    if (this.publicUrlShared == publicUrlShared) return this;
    return new SlackCsvFile(
        this.filetype,
        this.editLink,
        this.preview,
        this.previewHighlight,
        this.lines,
        this.linesMore,
        this.previewTruncated,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackCsvFileIF#getDisplayAsBot() displayAsBot} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param displayAsBot A new value for displayAsBot
   * @return A modified copy of the {@code this} object
   */
  public final SlackCsvFile withDisplayAsBot(boolean displayAsBot) {
    if (this.displayAsBot == displayAsBot) return this;
    return new SlackCsvFile(
        this.filetype,
        this.editLink,
        this.preview,
        this.previewHighlight,
        this.lines,
        this.linesMore,
        this.previewTruncated,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackCsvFileIF#getUsername() username} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param username A new value for username
   * @return A modified copy of the {@code this} object
   */
  public final SlackCsvFile withUsername(String username) {
    if (this.username.equals(username)) return this;
    String newValue = Objects.requireNonNull(username, "username");
    return new SlackCsvFile(
        this.filetype,
        this.editLink,
        this.preview,
        this.previewHighlight,
        this.lines,
        this.linesMore,
        this.previewTruncated,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        newValue,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackCsvFileIF#getUrlPrivate() urlPrivate} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param urlPrivate A new value for urlPrivate
   * @return A modified copy of the {@code this} object
   */
  public final SlackCsvFile withUrlPrivate(String urlPrivate) {
    if (this.urlPrivate.equals(urlPrivate)) return this;
    String newValue = Objects.requireNonNull(urlPrivate, "urlPrivate");
    return new SlackCsvFile(
        this.filetype,
        this.editLink,
        this.preview,
        this.previewHighlight,
        this.lines,
        this.linesMore,
        this.previewTruncated,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        newValue,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackCsvFileIF#getUrlPrivateDownload() urlPrivateDownload} attribute.
   * @param value The value for urlPrivateDownload, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackCsvFile withUrlPrivateDownload(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.urlPrivateDownload, newValue)) return this;
    return new SlackCsvFile(
        this.filetype,
        this.editLink,
        this.preview,
        this.previewHighlight,
        this.lines,
        this.linesMore,
        this.previewTruncated,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        newValue,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackCsvFileIF#getUrlPrivateDownload() urlPrivateDownload} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for urlPrivateDownload
   * @return A modified copy of {@code this} object
   */
  public final SlackCsvFile withUrlPrivateDownload(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.urlPrivateDownload, value)) return this;
    return new SlackCsvFile(
        this.filetype,
        this.editLink,
        this.preview,
        this.previewHighlight,
        this.lines,
        this.linesMore,
        this.previewTruncated,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        value,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackCsvFileIF#getPermalink() permalink} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param permalink A new value for permalink
   * @return A modified copy of the {@code this} object
   */
  public final SlackCsvFile withPermalink(String permalink) {
    if (this.permalink.equals(permalink)) return this;
    String newValue = Objects.requireNonNull(permalink, "permalink");
    return new SlackCsvFile(
        this.filetype,
        this.editLink,
        this.preview,
        this.previewHighlight,
        this.lines,
        this.linesMore,
        this.previewTruncated,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        newValue,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackCsvFileIF#getPermalinkPublic() permalinkPublic} attribute.
   * @param value The value for permalinkPublic, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackCsvFile withPermalinkPublic(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.permalinkPublic, newValue)) return this;
    return new SlackCsvFile(
        this.filetype,
        this.editLink,
        this.preview,
        this.previewHighlight,
        this.lines,
        this.linesMore,
        this.previewTruncated,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        newValue,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackCsvFileIF#getPermalinkPublic() permalinkPublic} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for permalinkPublic
   * @return A modified copy of {@code this} object
   */
  public final SlackCsvFile withPermalinkPublic(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.permalinkPublic, value)) return this;
    return new SlackCsvFile(
        this.filetype,
        this.editLink,
        this.preview,
        this.previewHighlight,
        this.lines,
        this.linesMore,
        this.previewTruncated,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        value,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackCsvFileIF#getCommentsCount() commentsCount} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param commentsCount A new value for commentsCount
   * @return A modified copy of the {@code this} object
   */
  public final SlackCsvFile withCommentsCount(int commentsCount) {
    if (this.commentsCount == commentsCount) return this;
    return new SlackCsvFile(
        this.filetype,
        this.editLink,
        this.preview,
        this.previewHighlight,
        this.lines,
        this.linesMore,
        this.previewTruncated,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackCsvFileIF#isStarred() starred} attribute.
   * @param value The value for starred, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackCsvFile withStarred(@Nullable Boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.starred, newValue)) return this;
    return new SlackCsvFile(
        this.filetype,
        this.editLink,
        this.preview,
        this.previewHighlight,
        this.lines,
        this.linesMore,
        this.previewTruncated,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        newValue,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackCsvFileIF#isStarred() starred} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for starred
   * @return A modified copy of {@code this} object
   */
  public final SlackCsvFile withStarred(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.starred, value)) return this;
    return new SlackCsvFile(
        this.filetype,
        this.editLink,
        this.preview,
        this.previewHighlight,
        this.lines,
        this.linesMore,
        this.previewTruncated,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        value,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SlackCsvFileIF#getChannelIds() channelIds}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final SlackCsvFile withChannelIds(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new SlackCsvFile(
        this.filetype,
        this.editLink,
        this.preview,
        this.previewHighlight,
        this.lines,
        this.linesMore,
        this.previewTruncated,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        newValue,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SlackCsvFileIF#getChannelIds() channelIds}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of channelIds elements to set
   * @return A modified copy of {@code this} object
   */
  public final SlackCsvFile withChannelIds(Iterable<String> elements) {
    if (this.channelIds == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new SlackCsvFile(
        this.filetype,
        this.editLink,
        this.preview,
        this.previewHighlight,
        this.lines,
        this.linesMore,
        this.previewTruncated,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        newValue,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SlackCsvFileIF#getGroupIds() groupIds}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final SlackCsvFile withGroupIds(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new SlackCsvFile(
        this.filetype,
        this.editLink,
        this.preview,
        this.previewHighlight,
        this.lines,
        this.linesMore,
        this.previewTruncated,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        newValue,
        this.imIds);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SlackCsvFileIF#getGroupIds() groupIds}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of groupIds elements to set
   * @return A modified copy of {@code this} object
   */
  public final SlackCsvFile withGroupIds(Iterable<String> elements) {
    if (this.groupIds == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new SlackCsvFile(
        this.filetype,
        this.editLink,
        this.preview,
        this.previewHighlight,
        this.lines,
        this.linesMore,
        this.previewTruncated,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        newValue,
        this.imIds);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SlackCsvFileIF#getImIds() imIds}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final SlackCsvFile withImIds(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new SlackCsvFile(
        this.filetype,
        this.editLink,
        this.preview,
        this.previewHighlight,
        this.lines,
        this.linesMore,
        this.previewTruncated,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SlackCsvFileIF#getImIds() imIds}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of imIds elements to set
   * @return A modified copy of {@code this} object
   */
  public final SlackCsvFile withImIds(Iterable<String> elements) {
    if (this.imIds == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new SlackCsvFile(
        this.filetype,
        this.editLink,
        this.preview,
        this.previewHighlight,
        this.lines,
        this.linesMore,
        this.previewTruncated,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code SlackCsvFile} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof SlackCsvFile
        && equalTo((SlackCsvFile) another);
  }

  private boolean equalTo(SlackCsvFile another) {
    return filetype.equals(another.filetype)
        && editLink.equals(another.editLink)
        && preview.equals(another.preview)
        && previewHighlight.equals(another.previewHighlight)
        && lines.equals(another.lines)
        && linesMore.equals(another.linesMore)
        && previewTruncated == another.previewTruncated
        && id.equals(another.id)
        && createdEpochSeconds == another.createdEpochSeconds
        && timestampEpochSeconds == another.timestampEpochSeconds
        && name.equals(another.name)
        && title.equals(another.title)
        && mimetype.equals(another.mimetype)
        && prettyType.equals(another.prettyType)
        && userId.equals(another.userId)
        && editable == another.editable
        && size == another.size
        && mode.equals(another.mode)
        && external == another.external
        && isPublic == another.isPublic
        && publicUrlShared == another.publicUrlShared
        && displayAsBot == another.displayAsBot
        && username.equals(another.username)
        && urlPrivate.equals(another.urlPrivate)
        && Objects.equals(urlPrivateDownload, another.urlPrivateDownload)
        && permalink.equals(another.permalink)
        && Objects.equals(permalinkPublic, another.permalinkPublic)
        && commentsCount == another.commentsCount
        && Objects.equals(starred, another.starred)
        && channelIds.equals(another.channelIds)
        && groupIds.equals(another.groupIds)
        && imIds.equals(another.imIds);
  }

  /**
   * Computes a hash code from attributes: {@code filetype}, {@code editLink}, {@code preview}, {@code previewHighlight}, {@code lines}, {@code linesMore}, {@code previewTruncated}, {@code id}, {@code createdEpochSeconds}, {@code timestampEpochSeconds}, {@code name}, {@code title}, {@code mimetype}, {@code prettyType}, {@code userId}, {@code editable}, {@code size}, {@code mode}, {@code external}, {@code isPublic}, {@code publicUrlShared}, {@code displayAsBot}, {@code username}, {@code urlPrivate}, {@code urlPrivateDownload}, {@code permalink}, {@code permalinkPublic}, {@code commentsCount}, {@code starred}, {@code channelIds}, {@code groupIds}, {@code imIds}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + filetype.hashCode();
    h = h * 17 + editLink.hashCode();
    h = h * 17 + preview.hashCode();
    h = h * 17 + previewHighlight.hashCode();
    h = h * 17 + lines.hashCode();
    h = h * 17 + linesMore.hashCode();
    h = h * 17 + Boolean.hashCode(previewTruncated);
    h = h * 17 + id.hashCode();
    h = h * 17 + Long.hashCode(createdEpochSeconds);
    h = h * 17 + Long.hashCode(timestampEpochSeconds);
    h = h * 17 + name.hashCode();
    h = h * 17 + title.hashCode();
    h = h * 17 + mimetype.hashCode();
    h = h * 17 + prettyType.hashCode();
    h = h * 17 + userId.hashCode();
    h = h * 17 + Boolean.hashCode(editable);
    h = h * 17 + Long.hashCode(size);
    h = h * 17 + mode.hashCode();
    h = h * 17 + Boolean.hashCode(external);
    h = h * 17 + Boolean.hashCode(isPublic);
    h = h * 17 + Boolean.hashCode(publicUrlShared);
    h = h * 17 + Boolean.hashCode(displayAsBot);
    h = h * 17 + username.hashCode();
    h = h * 17 + urlPrivate.hashCode();
    h = h * 17 + Objects.hashCode(urlPrivateDownload);
    h = h * 17 + permalink.hashCode();
    h = h * 17 + Objects.hashCode(permalinkPublic);
    h = h * 17 + commentsCount;
    h = h * 17 + Objects.hashCode(starred);
    h = h * 17 + channelIds.hashCode();
    h = h * 17 + groupIds.hashCode();
    h = h * 17 + imIds.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SlackCsvFile} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("SlackCsvFile{");
    builder.append("filetype=").append(filetype);
    builder.append(", ");
    builder.append("editLink=").append(editLink);
    builder.append(", ");
    builder.append("preview=").append(preview);
    builder.append(", ");
    builder.append("previewHighlight=").append(previewHighlight);
    builder.append(", ");
    builder.append("lines=").append(lines);
    builder.append(", ");
    builder.append("linesMore=").append(linesMore);
    builder.append(", ");
    builder.append("previewTruncated=").append(previewTruncated);
    builder.append(", ");
    builder.append("id=").append(id);
    builder.append(", ");
    builder.append("createdEpochSeconds=").append(createdEpochSeconds);
    builder.append(", ");
    builder.append("timestampEpochSeconds=").append(timestampEpochSeconds);
    builder.append(", ");
    builder.append("name=").append(name);
    builder.append(", ");
    builder.append("title=").append(title);
    builder.append(", ");
    builder.append("mimetype=").append(mimetype);
    builder.append(", ");
    builder.append("prettyType=").append(prettyType);
    builder.append(", ");
    builder.append("userId=").append(userId);
    builder.append(", ");
    builder.append("editable=").append(editable);
    builder.append(", ");
    builder.append("size=").append(size);
    builder.append(", ");
    builder.append("mode=").append(mode);
    builder.append(", ");
    builder.append("external=").append(external);
    builder.append(", ");
    builder.append("isPublic=").append(isPublic);
    builder.append(", ");
    builder.append("publicUrlShared=").append(publicUrlShared);
    builder.append(", ");
    builder.append("displayAsBot=").append(displayAsBot);
    builder.append(", ");
    builder.append("username=").append(username);
    builder.append(", ");
    builder.append("urlPrivate=").append(urlPrivate);
    if (urlPrivateDownload != null) {
      builder.append(", ");
      builder.append("urlPrivateDownload=").append(urlPrivateDownload);
    }
    builder.append(", ");
    builder.append("permalink=").append(permalink);
    if (permalinkPublic != null) {
      builder.append(", ");
      builder.append("permalinkPublic=").append(permalinkPublic);
    }
    builder.append(", ");
    builder.append("commentsCount=").append(commentsCount);
    if (starred != null) {
      builder.append(", ");
      builder.append("starred=").append(starred);
    }
    builder.append(", ");
    builder.append("channelIds=").append(channelIds);
    builder.append(", ");
    builder.append("groupIds=").append(groupIds);
    builder.append(", ");
    builder.append("imIds=").append(imIds);
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements SlackCsvFileIF {
    @Nullable SlackFileType filetype;
    @Nullable String editLink;
    @Nullable String preview;
    @Nullable String previewHighlight;
    @Nullable String lines;
    @Nullable String linesMore;
    boolean previewTruncated;
    boolean previewTruncatedIsSet;
    @Nullable String id;
    long createdEpochSeconds;
    boolean createdEpochSecondsIsSet;
    long timestampEpochSeconds;
    boolean timestampEpochSecondsIsSet;
    @Nullable String name;
    @Nullable String title;
    @Nullable String mimetype;
    @Nullable String prettyType;
    @Nullable String userId;
    boolean editable;
    boolean editableIsSet;
    long size;
    boolean sizeIsSet;
    @Nullable String mode;
    boolean external;
    boolean externalIsSet;
    boolean isPublic;
    boolean isPublicIsSet;
    boolean publicUrlShared;
    boolean publicUrlSharedIsSet;
    boolean displayAsBot;
    boolean displayAsBotIsSet;
    @Nullable String username;
    @Nullable String urlPrivate;
    Optional<String> urlPrivateDownload = Optional.empty();
    @Nullable String permalink;
    Optional<String> permalinkPublic = Optional.empty();
    int commentsCount;
    boolean commentsCountIsSet;
    Optional<Boolean> starred = Optional.empty();
    List<String> channelIds = Collections.emptyList();
    List<String> groupIds = Collections.emptyList();
    List<String> imIds = Collections.emptyList();
    @JsonProperty
    public void setFiletype(SlackFileType filetype) {
      this.filetype = filetype;
    }
    @JsonProperty
    public void setEditLink(String editLink) {
      this.editLink = editLink;
    }
    @JsonProperty
    public void setPreview(String preview) {
      this.preview = preview;
    }
    @JsonProperty
    public void setPreviewHighlight(String previewHighlight) {
      this.previewHighlight = previewHighlight;
    }
    @JsonProperty
    public void setLines(String lines) {
      this.lines = lines;
    }
    @JsonProperty
    public void setLinesMore(String linesMore) {
      this.linesMore = linesMore;
    }
    @JsonProperty("preview_is_truncated")
    public void setPreviewTruncated(boolean previewTruncated) {
      this.previewTruncated = previewTruncated;
      this.previewTruncatedIsSet = true;
    }
    @JsonProperty
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("created")
    public void setCreatedEpochSeconds(long createdEpochSeconds) {
      this.createdEpochSeconds = createdEpochSeconds;
      this.createdEpochSecondsIsSet = true;
    }
    @JsonProperty("timestamp")
    public void setTimestampEpochSeconds(long timestampEpochSeconds) {
      this.timestampEpochSeconds = timestampEpochSeconds;
      this.timestampEpochSecondsIsSet = true;
    }
    @JsonProperty
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty
    public void setTitle(String title) {
      this.title = title;
    }
    @JsonProperty
    public void setMimetype(String mimetype) {
      this.mimetype = mimetype;
    }
    @JsonProperty
    public void setPrettyType(String prettyType) {
      this.prettyType = prettyType;
    }
    @JsonProperty("user")
    public void setUserId(String userId) {
      this.userId = userId;
    }
    @JsonProperty
    public void setEditable(boolean editable) {
      this.editable = editable;
      this.editableIsSet = true;
    }
    @JsonProperty
    public void setSize(long size) {
      this.size = size;
      this.sizeIsSet = true;
    }
    @JsonProperty
    public void setMode(String mode) {
      this.mode = mode;
    }
    @JsonProperty("is_external")
    public void setExternal(boolean external) {
      this.external = external;
      this.externalIsSet = true;
    }
    @JsonProperty("is_public")
    public void setIsPublic(boolean isPublic) {
      this.isPublic = isPublic;
      this.isPublicIsSet = true;
    }
    @JsonProperty
    public void setPublicUrlShared(boolean publicUrlShared) {
      this.publicUrlShared = publicUrlShared;
      this.publicUrlSharedIsSet = true;
    }
    @JsonProperty
    public void setDisplayAsBot(boolean displayAsBot) {
      this.displayAsBot = displayAsBot;
      this.displayAsBotIsSet = true;
    }
    @JsonProperty
    public void setUsername(String username) {
      this.username = username;
    }
    @JsonProperty
    public void setUrlPrivate(String urlPrivate) {
      this.urlPrivate = urlPrivate;
    }
    @JsonProperty
    public void setUrlPrivateDownload(Optional<String> urlPrivateDownload) {
      this.urlPrivateDownload = urlPrivateDownload;
    }
    @JsonProperty
    public void setPermalink(String permalink) {
      this.permalink = permalink;
    }
    @JsonProperty
    public void setPermalinkPublic(Optional<String> permalinkPublic) {
      this.permalinkPublic = permalinkPublic;
    }
    @JsonProperty
    public void setCommentsCount(int commentsCount) {
      this.commentsCount = commentsCount;
      this.commentsCountIsSet = true;
    }
    @JsonProperty("is_starred")
    public void setStarred(Optional<Boolean> starred) {
      this.starred = starred;
    }
    @JsonProperty("channels")
    public void setChannelIds(List<String> channelIds) {
      this.channelIds = channelIds;
    }
    @JsonProperty("groups")
    public void setGroupIds(List<String> groupIds) {
      this.groupIds = groupIds;
    }
    @JsonProperty("ims")
    public void setImIds(List<String> imIds) {
      this.imIds = imIds;
    }
    @Override
    public SlackFileType getFiletype() { throw new UnsupportedOperationException(); }
    @Override
    public String getEditLink() { throw new UnsupportedOperationException(); }
    @Override
    public String getPreview() { throw new UnsupportedOperationException(); }
    @Override
    public String getPreviewHighlight() { throw new UnsupportedOperationException(); }
    @Override
    public String getLines() { throw new UnsupportedOperationException(); }
    @Override
    public String getLinesMore() { throw new UnsupportedOperationException(); }
    @Override
    public boolean isPreviewTruncated() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public long getCreatedEpochSeconds() { throw new UnsupportedOperationException(); }
    @Override
    public long getTimestampEpochSeconds() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getTitle() { throw new UnsupportedOperationException(); }
    @Override
    public String getMimetype() { throw new UnsupportedOperationException(); }
    @Override
    public String getPrettyType() { throw new UnsupportedOperationException(); }
    @Override
    public String getUserId() { throw new UnsupportedOperationException(); }
    @Override
    public boolean isEditable() { throw new UnsupportedOperationException(); }
    @Override
    public long getSize() { throw new UnsupportedOperationException(); }
    @Override
    public String getMode() { throw new UnsupportedOperationException(); }
    @Override
    public boolean isExternal() { throw new UnsupportedOperationException(); }
    @Override
    public boolean isPublic() { throw new UnsupportedOperationException(); }
    @Override
    public boolean isPublicUrlShared() { throw new UnsupportedOperationException(); }
    @Override
    public boolean getDisplayAsBot() { throw new UnsupportedOperationException(); }
    @Override
    public String getUsername() { throw new UnsupportedOperationException(); }
    @Override
    public String getUrlPrivate() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getUrlPrivateDownload() { throw new UnsupportedOperationException(); }
    @Override
    public String getPermalink() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getPermalinkPublic() { throw new UnsupportedOperationException(); }
    @Override
    public int getCommentsCount() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> isStarred() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getChannelIds() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getGroupIds() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getImIds() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static SlackCsvFile fromJson(Json json) {
    SlackCsvFile.Builder builder = SlackCsvFile.builder();
    if (json.filetype != null) {
      builder.setFiletype(json.filetype);
    }
    if (json.editLink != null) {
      builder.setEditLink(json.editLink);
    }
    if (json.preview != null) {
      builder.setPreview(json.preview);
    }
    if (json.previewHighlight != null) {
      builder.setPreviewHighlight(json.previewHighlight);
    }
    if (json.lines != null) {
      builder.setLines(json.lines);
    }
    if (json.linesMore != null) {
      builder.setLinesMore(json.linesMore);
    }
    if (json.previewTruncatedIsSet) {
      builder.setPreviewTruncated(json.previewTruncated);
    }
    if (json.id != null) {
      builder.setId(json.id);
    }
    if (json.createdEpochSecondsIsSet) {
      builder.setCreatedEpochSeconds(json.createdEpochSeconds);
    }
    if (json.timestampEpochSecondsIsSet) {
      builder.setTimestampEpochSeconds(json.timestampEpochSeconds);
    }
    if (json.name != null) {
      builder.setName(json.name);
    }
    if (json.title != null) {
      builder.setTitle(json.title);
    }
    if (json.mimetype != null) {
      builder.setMimetype(json.mimetype);
    }
    if (json.prettyType != null) {
      builder.setPrettyType(json.prettyType);
    }
    if (json.userId != null) {
      builder.setUserId(json.userId);
    }
    if (json.editableIsSet) {
      builder.setEditable(json.editable);
    }
    if (json.sizeIsSet) {
      builder.setSize(json.size);
    }
    if (json.mode != null) {
      builder.setMode(json.mode);
    }
    if (json.externalIsSet) {
      builder.setExternal(json.external);
    }
    if (json.isPublicIsSet) {
      builder.setIsPublic(json.isPublic);
    }
    if (json.publicUrlSharedIsSet) {
      builder.setPublicUrlShared(json.publicUrlShared);
    }
    if (json.displayAsBotIsSet) {
      builder.setDisplayAsBot(json.displayAsBot);
    }
    if (json.username != null) {
      builder.setUsername(json.username);
    }
    if (json.urlPrivate != null) {
      builder.setUrlPrivate(json.urlPrivate);
    }
    if (json.urlPrivateDownload != null) {
      builder.setUrlPrivateDownload(json.urlPrivateDownload);
    }
    if (json.permalink != null) {
      builder.setPermalink(json.permalink);
    }
    if (json.permalinkPublic != null) {
      builder.setPermalinkPublic(json.permalinkPublic);
    }
    if (json.commentsCountIsSet) {
      builder.setCommentsCount(json.commentsCount);
    }
    if (json.starred != null) {
      builder.setStarred(json.starred);
    }
    if (json.channelIds != null) {
      builder.addAllChannelIds(json.channelIds);
    }
    if (json.groupIds != null) {
      builder.addAllGroupIds(json.groupIds);
    }
    if (json.imIds != null) {
      builder.addAllImIds(json.imIds);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link SlackCsvFileIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SlackCsvFile instance
   */
  public static SlackCsvFile copyOf(SlackCsvFileIF instance) {
    if (instance instanceof SlackCsvFile) {
      return (SlackCsvFile) instance;
    }
    return SlackCsvFile.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link SlackCsvFile SlackCsvFile}.
   * @return A new SlackCsvFile builder
   */
  public static SlackCsvFile.Builder builder() {
    return new SlackCsvFile.Builder();
  }

  /**
   * Builds instances of type {@link SlackCsvFile SlackCsvFile}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_EDIT_LINK = 0x1L;
    private static final long INIT_BIT_PREVIEW = 0x2L;
    private static final long INIT_BIT_PREVIEW_HIGHLIGHT = 0x4L;
    private static final long INIT_BIT_LINES = 0x8L;
    private static final long INIT_BIT_LINES_MORE = 0x10L;
    private static final long INIT_BIT_PREVIEW_TRUNCATED = 0x20L;
    private static final long INIT_BIT_ID = 0x40L;
    private static final long INIT_BIT_CREATED_EPOCH_SECONDS = 0x80L;
    private static final long INIT_BIT_TIMESTAMP_EPOCH_SECONDS = 0x100L;
    private static final long INIT_BIT_NAME = 0x200L;
    private static final long INIT_BIT_TITLE = 0x400L;
    private static final long INIT_BIT_MIMETYPE = 0x800L;
    private static final long INIT_BIT_PRETTY_TYPE = 0x1000L;
    private static final long INIT_BIT_USER_ID = 0x2000L;
    private static final long INIT_BIT_EDITABLE = 0x4000L;
    private static final long INIT_BIT_SIZE = 0x8000L;
    private static final long INIT_BIT_MODE = 0x10000L;
    private static final long INIT_BIT_EXTERNAL = 0x20000L;
    private static final long INIT_BIT_IS_PUBLIC = 0x40000L;
    private static final long INIT_BIT_PUBLIC_URL_SHARED = 0x80000L;
    private static final long INIT_BIT_DISPLAY_AS_BOT = 0x100000L;
    private static final long INIT_BIT_USERNAME = 0x200000L;
    private static final long INIT_BIT_URL_PRIVATE = 0x400000L;
    private static final long INIT_BIT_PERMALINK = 0x800000L;
    private static final long OPT_BIT_COMMENTS_COUNT = 0x1L;
    private long initBits = 0xffffffL;
    private long optBits;

    private @Nullable SlackFileType filetype;
    private @Nullable String editLink;
    private @Nullable String preview;
    private @Nullable String previewHighlight;
    private @Nullable String lines;
    private @Nullable String linesMore;
    private boolean previewTruncated;
    private @Nullable String id;
    private long createdEpochSeconds;
    private long timestampEpochSeconds;
    private @Nullable String name;
    private @Nullable String title;
    private @Nullable String mimetype;
    private @Nullable String prettyType;
    private @Nullable String userId;
    private boolean editable;
    private long size;
    private @Nullable String mode;
    private boolean external;
    private boolean isPublic;
    private boolean publicUrlShared;
    private boolean displayAsBot;
    private @Nullable String username;
    private @Nullable String urlPrivate;
    private @Nullable String urlPrivateDownload;
    private @Nullable String permalink;
    private @Nullable String permalinkPublic;
    private int commentsCount;
    private @Nullable Boolean starred;
    private List<String> channelIds = new ArrayList<String>();
    private List<String> groupIds = new ArrayList<String>();
    private List<String> imIds = new ArrayList<String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.files.SlackTextFileCore} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackTextFileCore instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.files.SlackFile} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackFile instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.files.SlackCsvFileIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackCsvFileIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof SlackTextFileCore) {
        SlackTextFileCore instance = (SlackTextFileCore) object;
        setPreview(instance.getPreview());
        setPreviewHighlight(instance.getPreviewHighlight());
        setLines(instance.getLines());
        setEditLink(instance.getEditLink());
        setLinesMore(instance.getLinesMore());
        setPreviewTruncated(instance.isPreviewTruncated());
      }
      if (object instanceof SlackFile) {
        SlackFile instance = (SlackFile) object;
        if ((bits & 0x1L) == 0) {
          setFiletype(instance.getFiletype());
          bits |= 0x1L;
        }
        setTitle(instance.getTitle());
        setDisplayAsBot(instance.getDisplayAsBot());
        addAllImIds(instance.getImIds());
        Optional<String> urlPrivateDownloadOptional = instance.getUrlPrivateDownload();
        if (urlPrivateDownloadOptional.isPresent()) {
          setUrlPrivateDownload(urlPrivateDownloadOptional);
        }
        setMode(instance.getMode());
        Optional<Boolean> starredOptional = instance.isStarred();
        if (starredOptional.isPresent()) {
          setStarred(starredOptional);
        }
        setUrlPrivate(instance.getUrlPrivate());
        setPrettyType(instance.getPrettyType());
        addAllGroupIds(instance.getGroupIds());
        setPublicUrlShared(instance.isPublicUrlShared());
        setTimestampEpochSeconds(instance.getTimestampEpochSeconds());
        setIsPublic(instance.isPublic());
        setId(instance.getId());
        addAllChannelIds(instance.getChannelIds());
        setCreatedEpochSeconds(instance.getCreatedEpochSeconds());
        setEditable(instance.isEditable());
        setUserId(instance.getUserId());
        setExternal(instance.isExternal());
        setSize(instance.getSize());
        setCommentsCount(instance.getCommentsCount());
        setName(instance.getName());
        setMimetype(instance.getMimetype());
        Optional<String> permalinkPublicOptional = instance.getPermalinkPublic();
        if (permalinkPublicOptional.isPresent()) {
          setPermalinkPublic(permalinkPublicOptional);
        }
        setPermalink(instance.getPermalink());
        setUsername(instance.getUsername());
      }
      if (object instanceof SlackCsvFileIF) {
        SlackCsvFileIF instance = (SlackCsvFileIF) object;
        if ((bits & 0x1L) == 0) {
          setFiletype(instance.getFiletype());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link SlackCsvFileIF#getFiletype() filetype} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SlackCsvFileIF#getFiletype() filetype}.</em>
     * @param filetype The value for filetype 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setFiletype(SlackFileType filetype) {
      this.filetype = Objects.requireNonNull(filetype, "filetype");
      return this;
    }

    /**
     * Initializes the value for the {@link SlackCsvFileIF#getEditLink() editLink} attribute.
     * @param editLink The value for editLink 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setEditLink(String editLink) {
      this.editLink = Objects.requireNonNull(editLink, "editLink");
      initBits &= ~INIT_BIT_EDIT_LINK;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackCsvFileIF#getPreview() preview} attribute.
     * @param preview The value for preview 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setPreview(String preview) {
      this.preview = Objects.requireNonNull(preview, "preview");
      initBits &= ~INIT_BIT_PREVIEW;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackCsvFileIF#getPreviewHighlight() previewHighlight} attribute.
     * @param previewHighlight The value for previewHighlight 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setPreviewHighlight(String previewHighlight) {
      this.previewHighlight = Objects.requireNonNull(previewHighlight, "previewHighlight");
      initBits &= ~INIT_BIT_PREVIEW_HIGHLIGHT;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackCsvFileIF#getLines() lines} attribute.
     * @param lines The value for lines 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setLines(String lines) {
      this.lines = Objects.requireNonNull(lines, "lines");
      initBits &= ~INIT_BIT_LINES;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackCsvFileIF#getLinesMore() linesMore} attribute.
     * @param linesMore The value for linesMore 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setLinesMore(String linesMore) {
      this.linesMore = Objects.requireNonNull(linesMore, "linesMore");
      initBits &= ~INIT_BIT_LINES_MORE;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackCsvFileIF#isPreviewTruncated() previewTruncated} attribute.
     * @param previewTruncated The value for previewTruncated 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setPreviewTruncated(boolean previewTruncated) {
      this.previewTruncated = previewTruncated;
      initBits &= ~INIT_BIT_PREVIEW_TRUNCATED;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackCsvFileIF#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setId(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackCsvFileIF#getCreatedEpochSeconds() createdEpochSeconds} attribute.
     * @param createdEpochSeconds The value for createdEpochSeconds 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setCreatedEpochSeconds(long createdEpochSeconds) {
      this.createdEpochSeconds = createdEpochSeconds;
      initBits &= ~INIT_BIT_CREATED_EPOCH_SECONDS;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackCsvFileIF#getTimestampEpochSeconds() timestampEpochSeconds} attribute.
     * @param timestampEpochSeconds The value for timestampEpochSeconds 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTimestampEpochSeconds(long timestampEpochSeconds) {
      this.timestampEpochSeconds = timestampEpochSeconds;
      initBits &= ~INIT_BIT_TIMESTAMP_EPOCH_SECONDS;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackCsvFileIF#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setName(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackCsvFileIF#getTitle() title} attribute.
     * @param title The value for title 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTitle(String title) {
      this.title = Objects.requireNonNull(title, "title");
      initBits &= ~INIT_BIT_TITLE;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackCsvFileIF#getMimetype() mimetype} attribute.
     * @param mimetype The value for mimetype 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setMimetype(String mimetype) {
      this.mimetype = Objects.requireNonNull(mimetype, "mimetype");
      initBits &= ~INIT_BIT_MIMETYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackCsvFileIF#getPrettyType() prettyType} attribute.
     * @param prettyType The value for prettyType 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setPrettyType(String prettyType) {
      this.prettyType = Objects.requireNonNull(prettyType, "prettyType");
      initBits &= ~INIT_BIT_PRETTY_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackCsvFileIF#getUserId() userId} attribute.
     * @param userId The value for userId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUserId(String userId) {
      this.userId = Objects.requireNonNull(userId, "userId");
      initBits &= ~INIT_BIT_USER_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackCsvFileIF#isEditable() editable} attribute.
     * @param editable The value for editable 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setEditable(boolean editable) {
      this.editable = editable;
      initBits &= ~INIT_BIT_EDITABLE;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackCsvFileIF#getSize() size} attribute.
     * @param size The value for size 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setSize(long size) {
      this.size = size;
      initBits &= ~INIT_BIT_SIZE;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackCsvFileIF#getMode() mode} attribute.
     * @param mode The value for mode 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setMode(String mode) {
      this.mode = Objects.requireNonNull(mode, "mode");
      initBits &= ~INIT_BIT_MODE;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackCsvFileIF#isExternal() external} attribute.
     * @param external The value for external 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setExternal(boolean external) {
      this.external = external;
      initBits &= ~INIT_BIT_EXTERNAL;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackCsvFileIF#isPublic() isPublic} attribute.
     * @param isPublic The value for isPublic 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setIsPublic(boolean isPublic) {
      this.isPublic = isPublic;
      initBits &= ~INIT_BIT_IS_PUBLIC;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackCsvFileIF#isPublicUrlShared() publicUrlShared} attribute.
     * @param publicUrlShared The value for publicUrlShared 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setPublicUrlShared(boolean publicUrlShared) {
      this.publicUrlShared = publicUrlShared;
      initBits &= ~INIT_BIT_PUBLIC_URL_SHARED;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackCsvFileIF#getDisplayAsBot() displayAsBot} attribute.
     * @param displayAsBot The value for displayAsBot 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setDisplayAsBot(boolean displayAsBot) {
      this.displayAsBot = displayAsBot;
      initBits &= ~INIT_BIT_DISPLAY_AS_BOT;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackCsvFileIF#getUsername() username} attribute.
     * @param username The value for username 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUsername(String username) {
      this.username = Objects.requireNonNull(username, "username");
      initBits &= ~INIT_BIT_USERNAME;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackCsvFileIF#getUrlPrivate() urlPrivate} attribute.
     * @param urlPrivate The value for urlPrivate 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUrlPrivate(String urlPrivate) {
      this.urlPrivate = Objects.requireNonNull(urlPrivate, "urlPrivate");
      initBits &= ~INIT_BIT_URL_PRIVATE;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackCsvFileIF#getUrlPrivateDownload() urlPrivateDownload} to urlPrivateDownload.
     * @param urlPrivateDownload The value for urlPrivateDownload, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setUrlPrivateDownload(@Nullable String urlPrivateDownload) {
      this.urlPrivateDownload = urlPrivateDownload;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackCsvFileIF#getUrlPrivateDownload() urlPrivateDownload} to urlPrivateDownload.
     * @param urlPrivateDownload The value for urlPrivateDownload
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUrlPrivateDownload(Optional<String> urlPrivateDownload) {
      this.urlPrivateDownload = urlPrivateDownload.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link SlackCsvFileIF#getPermalink() permalink} attribute.
     * @param permalink The value for permalink 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setPermalink(String permalink) {
      this.permalink = Objects.requireNonNull(permalink, "permalink");
      initBits &= ~INIT_BIT_PERMALINK;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackCsvFileIF#getPermalinkPublic() permalinkPublic} to permalinkPublic.
     * @param permalinkPublic The value for permalinkPublic, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setPermalinkPublic(@Nullable String permalinkPublic) {
      this.permalinkPublic = permalinkPublic;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackCsvFileIF#getPermalinkPublic() permalinkPublic} to permalinkPublic.
     * @param permalinkPublic The value for permalinkPublic
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setPermalinkPublic(Optional<String> permalinkPublic) {
      this.permalinkPublic = permalinkPublic.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link SlackCsvFileIF#getCommentsCount() commentsCount} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SlackCsvFileIF#getCommentsCount() commentsCount}.</em>
     * @param commentsCount The value for commentsCount 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setCommentsCount(int commentsCount) {
      this.commentsCount = commentsCount;
      optBits |= OPT_BIT_COMMENTS_COUNT;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackCsvFileIF#isStarred() starred} to starred.
     * @param starred The value for starred, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setStarred(@Nullable Boolean starred) {
      this.starred = starred;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackCsvFileIF#isStarred() starred} to starred.
     * @param starred The value for starred
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setStarred(Optional<Boolean> starred) {
      this.starred = starred.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link SlackCsvFileIF#getChannelIds() channelIds} list.
     * @param element A channelIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addChannelIds(String element) {
      this.channelIds.add(Objects.requireNonNull(element, "channelIds element"));
      return this;
    }

    /**
     * Adds elements to {@link SlackCsvFileIF#getChannelIds() channelIds} list.
     * @param elements An array of channelIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addChannelIds(String... elements) {
      for (String element : elements) {
        this.channelIds.add(Objects.requireNonNull(element, "channelIds element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link SlackCsvFileIF#getChannelIds() channelIds} list.
     * @param elements An iterable of channelIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannelIds(Iterable<String> elements) {
      this.channelIds.clear();
      return addAllChannelIds(elements);
    }

    /**
     * Adds elements to {@link SlackCsvFileIF#getChannelIds() channelIds} list.
     * @param elements An iterable of channelIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllChannelIds(Iterable<String> elements) {
      for (String element : elements) {
        this.channelIds.add(Objects.requireNonNull(element, "channelIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link SlackCsvFileIF#getGroupIds() groupIds} list.
     * @param element A groupIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addGroupIds(String element) {
      this.groupIds.add(Objects.requireNonNull(element, "groupIds element"));
      return this;
    }

    /**
     * Adds elements to {@link SlackCsvFileIF#getGroupIds() groupIds} list.
     * @param elements An array of groupIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addGroupIds(String... elements) {
      for (String element : elements) {
        this.groupIds.add(Objects.requireNonNull(element, "groupIds element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link SlackCsvFileIF#getGroupIds() groupIds} list.
     * @param elements An iterable of groupIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setGroupIds(Iterable<String> elements) {
      this.groupIds.clear();
      return addAllGroupIds(elements);
    }

    /**
     * Adds elements to {@link SlackCsvFileIF#getGroupIds() groupIds} list.
     * @param elements An iterable of groupIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllGroupIds(Iterable<String> elements) {
      for (String element : elements) {
        this.groupIds.add(Objects.requireNonNull(element, "groupIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link SlackCsvFileIF#getImIds() imIds} list.
     * @param element A imIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addImIds(String element) {
      this.imIds.add(Objects.requireNonNull(element, "imIds element"));
      return this;
    }

    /**
     * Adds elements to {@link SlackCsvFileIF#getImIds() imIds} list.
     * @param elements An array of imIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addImIds(String... elements) {
      for (String element : elements) {
        this.imIds.add(Objects.requireNonNull(element, "imIds element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link SlackCsvFileIF#getImIds() imIds} list.
     * @param elements An iterable of imIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setImIds(Iterable<String> elements) {
      this.imIds.clear();
      return addAllImIds(elements);
    }

    /**
     * Adds elements to {@link SlackCsvFileIF#getImIds() imIds} list.
     * @param elements An iterable of imIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllImIds(Iterable<String> elements) {
      for (String element : elements) {
        this.imIds.add(Objects.requireNonNull(element, "imIds element"));
      }
      return this;
    }

    /**
     * Builds a new {@link SlackCsvFile SlackCsvFile}.
     * @return An immutable instance of SlackCsvFile
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public SlackCsvFile build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new SlackCsvFile(this);
    }

    private boolean commentsCountIsSet() {
      return (optBits & OPT_BIT_COMMENTS_COUNT) != 0;
    }

    private boolean editLinkIsSet() {
      return (initBits & INIT_BIT_EDIT_LINK) == 0;
    }

    private boolean previewIsSet() {
      return (initBits & INIT_BIT_PREVIEW) == 0;
    }

    private boolean previewHighlightIsSet() {
      return (initBits & INIT_BIT_PREVIEW_HIGHLIGHT) == 0;
    }

    private boolean linesIsSet() {
      return (initBits & INIT_BIT_LINES) == 0;
    }

    private boolean linesMoreIsSet() {
      return (initBits & INIT_BIT_LINES_MORE) == 0;
    }

    private boolean previewTruncatedIsSet() {
      return (initBits & INIT_BIT_PREVIEW_TRUNCATED) == 0;
    }

    private boolean idIsSet() {
      return (initBits & INIT_BIT_ID) == 0;
    }

    private boolean createdEpochSecondsIsSet() {
      return (initBits & INIT_BIT_CREATED_EPOCH_SECONDS) == 0;
    }

    private boolean timestampEpochSecondsIsSet() {
      return (initBits & INIT_BIT_TIMESTAMP_EPOCH_SECONDS) == 0;
    }

    private boolean nameIsSet() {
      return (initBits & INIT_BIT_NAME) == 0;
    }

    private boolean titleIsSet() {
      return (initBits & INIT_BIT_TITLE) == 0;
    }

    private boolean mimetypeIsSet() {
      return (initBits & INIT_BIT_MIMETYPE) == 0;
    }

    private boolean prettyTypeIsSet() {
      return (initBits & INIT_BIT_PRETTY_TYPE) == 0;
    }

    private boolean userIdIsSet() {
      return (initBits & INIT_BIT_USER_ID) == 0;
    }

    private boolean editableIsSet() {
      return (initBits & INIT_BIT_EDITABLE) == 0;
    }

    private boolean sizeIsSet() {
      return (initBits & INIT_BIT_SIZE) == 0;
    }

    private boolean modeIsSet() {
      return (initBits & INIT_BIT_MODE) == 0;
    }

    private boolean externalIsSet() {
      return (initBits & INIT_BIT_EXTERNAL) == 0;
    }

    private boolean isPublicIsSet() {
      return (initBits & INIT_BIT_IS_PUBLIC) == 0;
    }

    private boolean publicUrlSharedIsSet() {
      return (initBits & INIT_BIT_PUBLIC_URL_SHARED) == 0;
    }

    private boolean displayAsBotIsSet() {
      return (initBits & INIT_BIT_DISPLAY_AS_BOT) == 0;
    }

    private boolean usernameIsSet() {
      return (initBits & INIT_BIT_USERNAME) == 0;
    }

    private boolean urlPrivateIsSet() {
      return (initBits & INIT_BIT_URL_PRIVATE) == 0;
    }

    private boolean permalinkIsSet() {
      return (initBits & INIT_BIT_PERMALINK) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!editLinkIsSet()) attributes.add("editLink");
      if (!previewIsSet()) attributes.add("preview");
      if (!previewHighlightIsSet()) attributes.add("previewHighlight");
      if (!linesIsSet()) attributes.add("lines");
      if (!linesMoreIsSet()) attributes.add("linesMore");
      if (!previewTruncatedIsSet()) attributes.add("previewTruncated");
      if (!idIsSet()) attributes.add("id");
      if (!createdEpochSecondsIsSet()) attributes.add("createdEpochSeconds");
      if (!timestampEpochSecondsIsSet()) attributes.add("timestampEpochSeconds");
      if (!nameIsSet()) attributes.add("name");
      if (!titleIsSet()) attributes.add("title");
      if (!mimetypeIsSet()) attributes.add("mimetype");
      if (!prettyTypeIsSet()) attributes.add("prettyType");
      if (!userIdIsSet()) attributes.add("userId");
      if (!editableIsSet()) attributes.add("editable");
      if (!sizeIsSet()) attributes.add("size");
      if (!modeIsSet()) attributes.add("mode");
      if (!externalIsSet()) attributes.add("external");
      if (!isPublicIsSet()) attributes.add("isPublic");
      if (!publicUrlSharedIsSet()) attributes.add("publicUrlShared");
      if (!displayAsBotIsSet()) attributes.add("displayAsBot");
      if (!usernameIsSet()) attributes.add("username");
      if (!urlPrivateIsSet()) attributes.add("urlPrivate");
      if (!permalinkIsSet()) attributes.add("permalink");
      return "Cannot build SlackCsvFile, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
