package com.hubspot.slack.client.models.files;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link SlackGifFileIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code SlackGifFile.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "SlackGifFileIF"})
@Immutable
public final class SlackGifFile implements SlackGifFileIF {
  private final SlackFileType filetype;
  private final @Nullable String thumb64Url;
  private final @Nullable String thumb80Url;
  private final @Nullable String thumb160Url;
  private final @Nullable String thumb360Url;
  private final @Nullable Integer thumb360Width;
  private final @Nullable Integer thumb360Height;
  private final @Nullable String thumb480Url;
  private final @Nullable Integer thumb480Width;
  private final @Nullable Integer thumb480Height;
  private final @Nullable Integer imageExifRotation;
  private final @Nullable Integer originalWidth;
  private final @Nullable Integer originalHeight;
  private final boolean hasRichPreview;
  private final String id;
  private final long createdEpochSeconds;
  private final long timestampEpochSeconds;
  private final String name;
  private final String title;
  private final String mimetype;
  private final String prettyType;
  private final String userId;
  private final boolean editable;
  private final long size;
  private final String mode;
  private final boolean external;
  private final boolean isPublic;
  private final boolean publicUrlShared;
  private final boolean displayAsBot;
  private final String username;
  private final String urlPrivate;
  private final @Nullable String urlPrivateDownload;
  private final String permalink;
  private final @Nullable String permalinkPublic;
  private final int commentsCount;
  private final @Nullable Boolean starred;
  private final List<String> channelIds;
  private final List<String> groupIds;
  private final List<String> imIds;

  private SlackGifFile(SlackGifFile.Builder builder) {
    this.thumb64Url = builder.thumb64Url;
    this.thumb80Url = builder.thumb80Url;
    this.thumb160Url = builder.thumb160Url;
    this.thumb360Url = builder.thumb360Url;
    this.thumb360Width = builder.thumb360Width;
    this.thumb360Height = builder.thumb360Height;
    this.thumb480Url = builder.thumb480Url;
    this.thumb480Width = builder.thumb480Width;
    this.thumb480Height = builder.thumb480Height;
    this.imageExifRotation = builder.imageExifRotation;
    this.originalWidth = builder.originalWidth;
    this.originalHeight = builder.originalHeight;
    this.hasRichPreview = builder.hasRichPreview;
    this.id = builder.id;
    this.createdEpochSeconds = builder.createdEpochSeconds;
    this.timestampEpochSeconds = builder.timestampEpochSeconds;
    this.name = builder.name;
    this.title = builder.title;
    this.mimetype = builder.mimetype;
    this.prettyType = builder.prettyType;
    this.userId = builder.userId;
    this.editable = builder.editable;
    this.size = builder.size;
    this.mode = builder.mode;
    this.external = builder.external;
    this.isPublic = builder.isPublic;
    this.publicUrlShared = builder.publicUrlShared;
    this.displayAsBot = builder.displayAsBot;
    this.username = builder.username;
    this.urlPrivate = builder.urlPrivate;
    this.urlPrivateDownload = builder.urlPrivateDownload;
    this.permalink = builder.permalink;
    this.permalinkPublic = builder.permalinkPublic;
    this.starred = builder.starred;
    this.channelIds = createUnmodifiableList(true, builder.channelIds);
    this.groupIds = createUnmodifiableList(true, builder.groupIds);
    this.imIds = createUnmodifiableList(true, builder.imIds);
    if (builder.filetype != null) {
      initShim.setFiletype(builder.filetype);
    }
    if (builder.commentsCountIsSet()) {
      initShim.setCommentsCount(builder.commentsCount);
    }
    this.filetype = initShim.getFiletype();
    this.commentsCount = initShim.getCommentsCount();
    this.initShim = null;
  }

  private SlackGifFile(
      SlackFileType filetype,
      @Nullable String thumb64Url,
      @Nullable String thumb80Url,
      @Nullable String thumb160Url,
      @Nullable String thumb360Url,
      @Nullable Integer thumb360Width,
      @Nullable Integer thumb360Height,
      @Nullable String thumb480Url,
      @Nullable Integer thumb480Width,
      @Nullable Integer thumb480Height,
      @Nullable Integer imageExifRotation,
      @Nullable Integer originalWidth,
      @Nullable Integer originalHeight,
      boolean hasRichPreview,
      String id,
      long createdEpochSeconds,
      long timestampEpochSeconds,
      String name,
      String title,
      String mimetype,
      String prettyType,
      String userId,
      boolean editable,
      long size,
      String mode,
      boolean external,
      boolean isPublic,
      boolean publicUrlShared,
      boolean displayAsBot,
      String username,
      String urlPrivate,
      @Nullable String urlPrivateDownload,
      String permalink,
      @Nullable String permalinkPublic,
      int commentsCount,
      @Nullable Boolean starred,
      List<String> channelIds,
      List<String> groupIds,
      List<String> imIds) {
    this.filetype = filetype;
    this.thumb64Url = thumb64Url;
    this.thumb80Url = thumb80Url;
    this.thumb160Url = thumb160Url;
    this.thumb360Url = thumb360Url;
    this.thumb360Width = thumb360Width;
    this.thumb360Height = thumb360Height;
    this.thumb480Url = thumb480Url;
    this.thumb480Width = thumb480Width;
    this.thumb480Height = thumb480Height;
    this.imageExifRotation = imageExifRotation;
    this.originalWidth = originalWidth;
    this.originalHeight = originalHeight;
    this.hasRichPreview = hasRichPreview;
    this.id = id;
    this.createdEpochSeconds = createdEpochSeconds;
    this.timestampEpochSeconds = timestampEpochSeconds;
    this.name = name;
    this.title = title;
    this.mimetype = mimetype;
    this.prettyType = prettyType;
    this.userId = userId;
    this.editable = editable;
    this.size = size;
    this.mode = mode;
    this.external = external;
    this.isPublic = isPublic;
    this.publicUrlShared = publicUrlShared;
    this.displayAsBot = displayAsBot;
    this.username = username;
    this.urlPrivate = urlPrivate;
    this.urlPrivateDownload = urlPrivateDownload;
    this.permalink = permalink;
    this.permalinkPublic = permalinkPublic;
    this.commentsCount = commentsCount;
    this.starred = starred;
    this.channelIds = channelIds;
    this.groupIds = groupIds;
    this.imIds = imIds;
    this.initShim = null;
  }

  private static final int STAGE_INITIALIZING = -1;
  private static final int STAGE_UNINITIALIZED = 0;
  private static final int STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private SlackFileType filetype;
    private int filetypeStage;

    SlackFileType getFiletype() {
      if (filetypeStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (filetypeStage == STAGE_UNINITIALIZED) {
        filetypeStage = STAGE_INITIALIZING;
        this.filetype = Objects.requireNonNull(getFiletypeInitialize(), "filetype");
        filetypeStage = STAGE_INITIALIZED;
      }
      return this.filetype;
    }

    void setFiletype(SlackFileType filetype) {
      this.filetype = filetype;
      filetypeStage = STAGE_INITIALIZED;
    }
    private int commentsCount;
    private int commentsCountStage;

    int getCommentsCount() {
      if (commentsCountStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (commentsCountStage == STAGE_UNINITIALIZED) {
        commentsCountStage = STAGE_INITIALIZING;
        this.commentsCount = getCommentsCountInitialize();
        commentsCountStage = STAGE_INITIALIZED;
      }
      return this.commentsCount;
    }

    void setCommentsCount(int commentsCount) {
      this.commentsCount = commentsCount;
      commentsCountStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      ArrayList<String> attributes = new ArrayList<String>();
      if (filetypeStage == STAGE_INITIALIZING) attributes.add("filetype");
      if (commentsCountStage == STAGE_INITIALIZING) attributes.add("commentsCount");
      return "Cannot build SlackGifFile, attribute initializers form cycle" + attributes;
    }
  }

  private SlackFileType getFiletypeInitialize() {
    return SlackGifFileIF.super.getFiletype();
  }

  private int getCommentsCountInitialize() {
    return SlackGifFileIF.super.getCommentsCount();
  }

  /**
   * @return The value of the {@code filetype} attribute
   */
  @JsonProperty
  @Override
  public SlackFileType getFiletype() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getFiletype()
        : this.filetype;
  }

  /**
   * @return The value of the {@code thumb64Url} attribute
   */
  @JsonProperty("thumb_64")
  @Override
  public Optional<String> getThumb64Url() {
    return Optional.ofNullable(thumb64Url);
  }

  /**
   * @return The value of the {@code thumb80Url} attribute
   */
  @JsonProperty("thumb_80")
  @Override
  public Optional<String> getThumb80Url() {
    return Optional.ofNullable(thumb80Url);
  }

  /**
   * @return The value of the {@code thumb160Url} attribute
   */
  @JsonProperty("thumb_160")
  @Override
  public Optional<String> getThumb160Url() {
    return Optional.ofNullable(thumb160Url);
  }

  /**
   * @return The value of the {@code thumb360Url} attribute
   */
  @JsonProperty("thumb_360")
  @Override
  public Optional<String> getThumb360Url() {
    return Optional.ofNullable(thumb360Url);
  }

  /**
   * @return The value of the {@code thumb360Width} attribute
   */
  @JsonProperty("thumb_360_w")
  @Override
  public Optional<Integer> getThumb360Width() {
    return Optional.ofNullable(thumb360Width);
  }

  /**
   * @return The value of the {@code thumb360Height} attribute
   */
  @JsonProperty("thumb_360_h")
  @Override
  public Optional<Integer> getThumb360Height() {
    return Optional.ofNullable(thumb360Height);
  }

  /**
   * @return The value of the {@code thumb480Url} attribute
   */
  @JsonProperty("thumb_480")
  @Override
  public Optional<String> getThumb480Url() {
    return Optional.ofNullable(thumb480Url);
  }

  /**
   * @return The value of the {@code thumb480Width} attribute
   */
  @JsonProperty("thumb_480_w")
  @Override
  public Optional<Integer> getThumb480Width() {
    return Optional.ofNullable(thumb480Width);
  }

  /**
   * @return The value of the {@code thumb480Height} attribute
   */
  @JsonProperty("thumb_480_h")
  @Override
  public Optional<Integer> getThumb480Height() {
    return Optional.ofNullable(thumb480Height);
  }

  /**
   * @return The value of the {@code imageExifRotation} attribute
   */
  @JsonProperty
  @Override
  public Optional<Integer> getImageExifRotation() {
    return Optional.ofNullable(imageExifRotation);
  }

  /**
   * @return The value of the {@code originalWidth} attribute
   */
  @JsonProperty("original_w")
  @Override
  public Optional<Integer> getOriginalWidth() {
    return Optional.ofNullable(originalWidth);
  }

  /**
   * @return The value of the {@code originalHeight} attribute
   */
  @JsonProperty("original_h")
  @Override
  public Optional<Integer> getOriginalHeight() {
    return Optional.ofNullable(originalHeight);
  }

  /**
   * @return The value of the {@code hasRichPreview} attribute
   */
  @JsonProperty("has_rich_preview")
  @Override
  public boolean hasRichPreview() {
    return hasRichPreview;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code createdEpochSeconds} attribute
   */
  @JsonProperty("created")
  @Override
  public long getCreatedEpochSeconds() {
    return createdEpochSeconds;
  }

  /**
   * @return The value of the {@code timestampEpochSeconds} attribute
   */
  @JsonProperty("timestamp")
  @Override
  public long getTimestampEpochSeconds() {
    return timestampEpochSeconds;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code title} attribute
   */
  @JsonProperty
  @Override
  public String getTitle() {
    return title;
  }

  /**
   * @return The value of the {@code mimetype} attribute
   */
  @JsonProperty
  @Override
  public String getMimetype() {
    return mimetype;
  }

  /**
   * @return The value of the {@code prettyType} attribute
   */
  @JsonProperty
  @Override
  public String getPrettyType() {
    return prettyType;
  }

  /**
   * @return The value of the {@code userId} attribute
   */
  @JsonProperty("user")
  @Override
  public String getUserId() {
    return userId;
  }

  /**
   * @return The value of the {@code editable} attribute
   */
  @JsonProperty
  @Override
  public boolean isEditable() {
    return editable;
  }

  /**
   * @return The value of the {@code size} attribute
   */
  @JsonProperty
  @Override
  public long getSize() {
    return size;
  }

  /**
   * @return The value of the {@code mode} attribute
   */
  @JsonProperty
  @Override
  public String getMode() {
    return mode;
  }

  /**
   * @return The value of the {@code external} attribute
   */
  @JsonProperty("is_external")
  @Override
  public boolean isExternal() {
    return external;
  }

  /**
   * @return The value of the {@code isPublic} attribute
   */
  @JsonProperty("is_public")
  @Override
  public boolean isPublic() {
    return isPublic;
  }

  /**
   * @return The value of the {@code publicUrlShared} attribute
   */
  @JsonProperty
  @Override
  public boolean isPublicUrlShared() {
    return publicUrlShared;
  }

  /**
   * @return The value of the {@code displayAsBot} attribute
   */
  @JsonProperty
  @Override
  public boolean getDisplayAsBot() {
    return displayAsBot;
  }

  /**
   * @return The value of the {@code username} attribute
   */
  @JsonProperty
  @Override
  public String getUsername() {
    return username;
  }

  /**
   * @return The value of the {@code urlPrivate} attribute
   */
  @JsonProperty
  @Override
  public String getUrlPrivate() {
    return urlPrivate;
  }

  /**
   * @return The value of the {@code urlPrivateDownload} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getUrlPrivateDownload() {
    return Optional.ofNullable(urlPrivateDownload);
  }

  /**
   * @return The value of the {@code permalink} attribute
   */
  @JsonProperty
  @Override
  public String getPermalink() {
    return permalink;
  }

  /**
   * @return The value of the {@code permalinkPublic} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getPermalinkPublic() {
    return Optional.ofNullable(permalinkPublic);
  }

  /**
   * @return The value of the {@code commentsCount} attribute
   */
  @JsonProperty
  @Override
  public int getCommentsCount() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getCommentsCount()
        : this.commentsCount;
  }

  /**
   * @return The value of the {@code starred} attribute
   */
  @JsonProperty("is_starred")
  @Override
  public Optional<Boolean> isStarred() {
    return Optional.ofNullable(starred);
  }

  /**
   * @return The value of the {@code channelIds} attribute
   */
  @JsonProperty("channels")
  @Override
  public List<String> getChannelIds() {
    return channelIds;
  }

  /**
   * @return The value of the {@code groupIds} attribute
   */
  @JsonProperty("groups")
  @Override
  public List<String> getGroupIds() {
    return groupIds;
  }

  /**
   * @return The value of the {@code imIds} attribute
   */
  @JsonProperty("ims")
  @Override
  public List<String> getImIds() {
    return imIds;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackGifFileIF#getFiletype() filetype} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param filetype A new value for filetype
   * @return A modified copy of the {@code this} object
   */
  public final SlackGifFile withFiletype(SlackFileType filetype) {
    if (this.filetype == filetype) return this;
    SlackFileType newValue = Objects.requireNonNull(filetype, "filetype");
    return new SlackGifFile(
        newValue,
        this.thumb64Url,
        this.thumb80Url,
        this.thumb160Url,
        this.thumb360Url,
        this.thumb360Width,
        this.thumb360Height,
        this.thumb480Url,
        this.thumb480Width,
        this.thumb480Height,
        this.imageExifRotation,
        this.originalWidth,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackGifFileIF#getThumb64Url() thumb64Url} attribute.
   * @param value The value for thumb64Url, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackGifFile withThumb64Url(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.thumb64Url, newValue)) return this;
    return new SlackGifFile(
        this.filetype,
        newValue,
        this.thumb80Url,
        this.thumb160Url,
        this.thumb360Url,
        this.thumb360Width,
        this.thumb360Height,
        this.thumb480Url,
        this.thumb480Width,
        this.thumb480Height,
        this.imageExifRotation,
        this.originalWidth,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackGifFileIF#getThumb64Url() thumb64Url} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for thumb64Url
   * @return A modified copy of {@code this} object
   */
  public final SlackGifFile withThumb64Url(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.thumb64Url, value)) return this;
    return new SlackGifFile(
        this.filetype,
        value,
        this.thumb80Url,
        this.thumb160Url,
        this.thumb360Url,
        this.thumb360Width,
        this.thumb360Height,
        this.thumb480Url,
        this.thumb480Width,
        this.thumb480Height,
        this.imageExifRotation,
        this.originalWidth,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackGifFileIF#getThumb80Url() thumb80Url} attribute.
   * @param value The value for thumb80Url, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackGifFile withThumb80Url(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.thumb80Url, newValue)) return this;
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        newValue,
        this.thumb160Url,
        this.thumb360Url,
        this.thumb360Width,
        this.thumb360Height,
        this.thumb480Url,
        this.thumb480Width,
        this.thumb480Height,
        this.imageExifRotation,
        this.originalWidth,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackGifFileIF#getThumb80Url() thumb80Url} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for thumb80Url
   * @return A modified copy of {@code this} object
   */
  public final SlackGifFile withThumb80Url(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.thumb80Url, value)) return this;
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        value,
        this.thumb160Url,
        this.thumb360Url,
        this.thumb360Width,
        this.thumb360Height,
        this.thumb480Url,
        this.thumb480Width,
        this.thumb480Height,
        this.imageExifRotation,
        this.originalWidth,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackGifFileIF#getThumb160Url() thumb160Url} attribute.
   * @param value The value for thumb160Url, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackGifFile withThumb160Url(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.thumb160Url, newValue)) return this;
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        this.thumb80Url,
        newValue,
        this.thumb360Url,
        this.thumb360Width,
        this.thumb360Height,
        this.thumb480Url,
        this.thumb480Width,
        this.thumb480Height,
        this.imageExifRotation,
        this.originalWidth,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackGifFileIF#getThumb160Url() thumb160Url} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for thumb160Url
   * @return A modified copy of {@code this} object
   */
  public final SlackGifFile withThumb160Url(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.thumb160Url, value)) return this;
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        this.thumb80Url,
        value,
        this.thumb360Url,
        this.thumb360Width,
        this.thumb360Height,
        this.thumb480Url,
        this.thumb480Width,
        this.thumb480Height,
        this.imageExifRotation,
        this.originalWidth,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackGifFileIF#getThumb360Url() thumb360Url} attribute.
   * @param value The value for thumb360Url, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackGifFile withThumb360Url(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.thumb360Url, newValue)) return this;
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        this.thumb80Url,
        this.thumb160Url,
        newValue,
        this.thumb360Width,
        this.thumb360Height,
        this.thumb480Url,
        this.thumb480Width,
        this.thumb480Height,
        this.imageExifRotation,
        this.originalWidth,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackGifFileIF#getThumb360Url() thumb360Url} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for thumb360Url
   * @return A modified copy of {@code this} object
   */
  public final SlackGifFile withThumb360Url(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.thumb360Url, value)) return this;
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        this.thumb80Url,
        this.thumb160Url,
        value,
        this.thumb360Width,
        this.thumb360Height,
        this.thumb480Url,
        this.thumb480Width,
        this.thumb480Height,
        this.imageExifRotation,
        this.originalWidth,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackGifFileIF#getThumb360Width() thumb360Width} attribute.
   * @param value The value for thumb360Width, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackGifFile withThumb360Width(@Nullable Integer value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.thumb360Width, newValue)) return this;
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        this.thumb80Url,
        this.thumb160Url,
        this.thumb360Url,
        newValue,
        this.thumb360Height,
        this.thumb480Url,
        this.thumb480Width,
        this.thumb480Height,
        this.imageExifRotation,
        this.originalWidth,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackGifFileIF#getThumb360Width() thumb360Width} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for thumb360Width
   * @return A modified copy of {@code this} object
   */
  public final SlackGifFile withThumb360Width(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.thumb360Width, value)) return this;
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        this.thumb80Url,
        this.thumb160Url,
        this.thumb360Url,
        value,
        this.thumb360Height,
        this.thumb480Url,
        this.thumb480Width,
        this.thumb480Height,
        this.imageExifRotation,
        this.originalWidth,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackGifFileIF#getThumb360Height() thumb360Height} attribute.
   * @param value The value for thumb360Height, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackGifFile withThumb360Height(@Nullable Integer value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.thumb360Height, newValue)) return this;
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        this.thumb80Url,
        this.thumb160Url,
        this.thumb360Url,
        this.thumb360Width,
        newValue,
        this.thumb480Url,
        this.thumb480Width,
        this.thumb480Height,
        this.imageExifRotation,
        this.originalWidth,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackGifFileIF#getThumb360Height() thumb360Height} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for thumb360Height
   * @return A modified copy of {@code this} object
   */
  public final SlackGifFile withThumb360Height(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.thumb360Height, value)) return this;
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        this.thumb80Url,
        this.thumb160Url,
        this.thumb360Url,
        this.thumb360Width,
        value,
        this.thumb480Url,
        this.thumb480Width,
        this.thumb480Height,
        this.imageExifRotation,
        this.originalWidth,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackGifFileIF#getThumb480Url() thumb480Url} attribute.
   * @param value The value for thumb480Url, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackGifFile withThumb480Url(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.thumb480Url, newValue)) return this;
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        this.thumb80Url,
        this.thumb160Url,
        this.thumb360Url,
        this.thumb360Width,
        this.thumb360Height,
        newValue,
        this.thumb480Width,
        this.thumb480Height,
        this.imageExifRotation,
        this.originalWidth,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackGifFileIF#getThumb480Url() thumb480Url} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for thumb480Url
   * @return A modified copy of {@code this} object
   */
  public final SlackGifFile withThumb480Url(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.thumb480Url, value)) return this;
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        this.thumb80Url,
        this.thumb160Url,
        this.thumb360Url,
        this.thumb360Width,
        this.thumb360Height,
        value,
        this.thumb480Width,
        this.thumb480Height,
        this.imageExifRotation,
        this.originalWidth,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackGifFileIF#getThumb480Width() thumb480Width} attribute.
   * @param value The value for thumb480Width, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackGifFile withThumb480Width(@Nullable Integer value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.thumb480Width, newValue)) return this;
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        this.thumb80Url,
        this.thumb160Url,
        this.thumb360Url,
        this.thumb360Width,
        this.thumb360Height,
        this.thumb480Url,
        newValue,
        this.thumb480Height,
        this.imageExifRotation,
        this.originalWidth,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackGifFileIF#getThumb480Width() thumb480Width} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for thumb480Width
   * @return A modified copy of {@code this} object
   */
  public final SlackGifFile withThumb480Width(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.thumb480Width, value)) return this;
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        this.thumb80Url,
        this.thumb160Url,
        this.thumb360Url,
        this.thumb360Width,
        this.thumb360Height,
        this.thumb480Url,
        value,
        this.thumb480Height,
        this.imageExifRotation,
        this.originalWidth,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackGifFileIF#getThumb480Height() thumb480Height} attribute.
   * @param value The value for thumb480Height, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackGifFile withThumb480Height(@Nullable Integer value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.thumb480Height, newValue)) return this;
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        this.thumb80Url,
        this.thumb160Url,
        this.thumb360Url,
        this.thumb360Width,
        this.thumb360Height,
        this.thumb480Url,
        this.thumb480Width,
        newValue,
        this.imageExifRotation,
        this.originalWidth,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackGifFileIF#getThumb480Height() thumb480Height} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for thumb480Height
   * @return A modified copy of {@code this} object
   */
  public final SlackGifFile withThumb480Height(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.thumb480Height, value)) return this;
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        this.thumb80Url,
        this.thumb160Url,
        this.thumb360Url,
        this.thumb360Width,
        this.thumb360Height,
        this.thumb480Url,
        this.thumb480Width,
        value,
        this.imageExifRotation,
        this.originalWidth,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackGifFileIF#getImageExifRotation() imageExifRotation} attribute.
   * @param value The value for imageExifRotation, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackGifFile withImageExifRotation(@Nullable Integer value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.imageExifRotation, newValue)) return this;
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        this.thumb80Url,
        this.thumb160Url,
        this.thumb360Url,
        this.thumb360Width,
        this.thumb360Height,
        this.thumb480Url,
        this.thumb480Width,
        this.thumb480Height,
        newValue,
        this.originalWidth,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackGifFileIF#getImageExifRotation() imageExifRotation} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for imageExifRotation
   * @return A modified copy of {@code this} object
   */
  public final SlackGifFile withImageExifRotation(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.imageExifRotation, value)) return this;
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        this.thumb80Url,
        this.thumb160Url,
        this.thumb360Url,
        this.thumb360Width,
        this.thumb360Height,
        this.thumb480Url,
        this.thumb480Width,
        this.thumb480Height,
        value,
        this.originalWidth,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackGifFileIF#getOriginalWidth() originalWidth} attribute.
   * @param value The value for originalWidth, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackGifFile withOriginalWidth(@Nullable Integer value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.originalWidth, newValue)) return this;
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        this.thumb80Url,
        this.thumb160Url,
        this.thumb360Url,
        this.thumb360Width,
        this.thumb360Height,
        this.thumb480Url,
        this.thumb480Width,
        this.thumb480Height,
        this.imageExifRotation,
        newValue,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackGifFileIF#getOriginalWidth() originalWidth} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for originalWidth
   * @return A modified copy of {@code this} object
   */
  public final SlackGifFile withOriginalWidth(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.originalWidth, value)) return this;
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        this.thumb80Url,
        this.thumb160Url,
        this.thumb360Url,
        this.thumb360Width,
        this.thumb360Height,
        this.thumb480Url,
        this.thumb480Width,
        this.thumb480Height,
        this.imageExifRotation,
        value,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackGifFileIF#getOriginalHeight() originalHeight} attribute.
   * @param value The value for originalHeight, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackGifFile withOriginalHeight(@Nullable Integer value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.originalHeight, newValue)) return this;
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        this.thumb80Url,
        this.thumb160Url,
        this.thumb360Url,
        this.thumb360Width,
        this.thumb360Height,
        this.thumb480Url,
        this.thumb480Width,
        this.thumb480Height,
        this.imageExifRotation,
        this.originalWidth,
        newValue,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackGifFileIF#getOriginalHeight() originalHeight} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for originalHeight
   * @return A modified copy of {@code this} object
   */
  public final SlackGifFile withOriginalHeight(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.originalHeight, value)) return this;
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        this.thumb80Url,
        this.thumb160Url,
        this.thumb360Url,
        this.thumb360Width,
        this.thumb360Height,
        this.thumb480Url,
        this.thumb480Width,
        this.thumb480Height,
        this.imageExifRotation,
        this.originalWidth,
        value,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackGifFileIF#hasRichPreview() hasRichPreview} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param hasRichPreview A new value for hasRichPreview
   * @return A modified copy of the {@code this} object
   */
  public final SlackGifFile withHasRichPreview(boolean hasRichPreview) {
    if (this.hasRichPreview == hasRichPreview) return this;
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        this.thumb80Url,
        this.thumb160Url,
        this.thumb360Url,
        this.thumb360Width,
        this.thumb360Height,
        this.thumb480Url,
        this.thumb480Width,
        this.thumb480Height,
        this.imageExifRotation,
        this.originalWidth,
        this.originalHeight,
        hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackGifFileIF#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param id A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final SlackGifFile withId(String id) {
    if (this.id.equals(id)) return this;
    String newValue = Objects.requireNonNull(id, "id");
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        this.thumb80Url,
        this.thumb160Url,
        this.thumb360Url,
        this.thumb360Width,
        this.thumb360Height,
        this.thumb480Url,
        this.thumb480Width,
        this.thumb480Height,
        this.imageExifRotation,
        this.originalWidth,
        this.originalHeight,
        this.hasRichPreview,
        newValue,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackGifFileIF#getCreatedEpochSeconds() createdEpochSeconds} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param createdEpochSeconds A new value for createdEpochSeconds
   * @return A modified copy of the {@code this} object
   */
  public final SlackGifFile withCreatedEpochSeconds(long createdEpochSeconds) {
    if (this.createdEpochSeconds == createdEpochSeconds) return this;
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        this.thumb80Url,
        this.thumb160Url,
        this.thumb360Url,
        this.thumb360Width,
        this.thumb360Height,
        this.thumb480Url,
        this.thumb480Width,
        this.thumb480Height,
        this.imageExifRotation,
        this.originalWidth,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackGifFileIF#getTimestampEpochSeconds() timestampEpochSeconds} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param timestampEpochSeconds A new value for timestampEpochSeconds
   * @return A modified copy of the {@code this} object
   */
  public final SlackGifFile withTimestampEpochSeconds(long timestampEpochSeconds) {
    if (this.timestampEpochSeconds == timestampEpochSeconds) return this;
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        this.thumb80Url,
        this.thumb160Url,
        this.thumb360Url,
        this.thumb360Width,
        this.thumb360Height,
        this.thumb480Url,
        this.thumb480Width,
        this.thumb480Height,
        this.imageExifRotation,
        this.originalWidth,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackGifFileIF#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param name A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final SlackGifFile withName(String name) {
    if (this.name.equals(name)) return this;
    String newValue = Objects.requireNonNull(name, "name");
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        this.thumb80Url,
        this.thumb160Url,
        this.thumb360Url,
        this.thumb360Width,
        this.thumb360Height,
        this.thumb480Url,
        this.thumb480Width,
        this.thumb480Height,
        this.imageExifRotation,
        this.originalWidth,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        newValue,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackGifFileIF#getTitle() title} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param title A new value for title
   * @return A modified copy of the {@code this} object
   */
  public final SlackGifFile withTitle(String title) {
    if (this.title.equals(title)) return this;
    String newValue = Objects.requireNonNull(title, "title");
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        this.thumb80Url,
        this.thumb160Url,
        this.thumb360Url,
        this.thumb360Width,
        this.thumb360Height,
        this.thumb480Url,
        this.thumb480Width,
        this.thumb480Height,
        this.imageExifRotation,
        this.originalWidth,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        newValue,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackGifFileIF#getMimetype() mimetype} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param mimetype A new value for mimetype
   * @return A modified copy of the {@code this} object
   */
  public final SlackGifFile withMimetype(String mimetype) {
    if (this.mimetype.equals(mimetype)) return this;
    String newValue = Objects.requireNonNull(mimetype, "mimetype");
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        this.thumb80Url,
        this.thumb160Url,
        this.thumb360Url,
        this.thumb360Width,
        this.thumb360Height,
        this.thumb480Url,
        this.thumb480Width,
        this.thumb480Height,
        this.imageExifRotation,
        this.originalWidth,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        newValue,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackGifFileIF#getPrettyType() prettyType} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param prettyType A new value for prettyType
   * @return A modified copy of the {@code this} object
   */
  public final SlackGifFile withPrettyType(String prettyType) {
    if (this.prettyType.equals(prettyType)) return this;
    String newValue = Objects.requireNonNull(prettyType, "prettyType");
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        this.thumb80Url,
        this.thumb160Url,
        this.thumb360Url,
        this.thumb360Width,
        this.thumb360Height,
        this.thumb480Url,
        this.thumb480Width,
        this.thumb480Height,
        this.imageExifRotation,
        this.originalWidth,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        newValue,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackGifFileIF#getUserId() userId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param userId A new value for userId
   * @return A modified copy of the {@code this} object
   */
  public final SlackGifFile withUserId(String userId) {
    if (this.userId.equals(userId)) return this;
    String newValue = Objects.requireNonNull(userId, "userId");
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        this.thumb80Url,
        this.thumb160Url,
        this.thumb360Url,
        this.thumb360Width,
        this.thumb360Height,
        this.thumb480Url,
        this.thumb480Width,
        this.thumb480Height,
        this.imageExifRotation,
        this.originalWidth,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        newValue,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackGifFileIF#isEditable() editable} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param editable A new value for editable
   * @return A modified copy of the {@code this} object
   */
  public final SlackGifFile withEditable(boolean editable) {
    if (this.editable == editable) return this;
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        this.thumb80Url,
        this.thumb160Url,
        this.thumb360Url,
        this.thumb360Width,
        this.thumb360Height,
        this.thumb480Url,
        this.thumb480Width,
        this.thumb480Height,
        this.imageExifRotation,
        this.originalWidth,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackGifFileIF#getSize() size} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param size A new value for size
   * @return A modified copy of the {@code this} object
   */
  public final SlackGifFile withSize(long size) {
    if (this.size == size) return this;
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        this.thumb80Url,
        this.thumb160Url,
        this.thumb360Url,
        this.thumb360Width,
        this.thumb360Height,
        this.thumb480Url,
        this.thumb480Width,
        this.thumb480Height,
        this.imageExifRotation,
        this.originalWidth,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackGifFileIF#getMode() mode} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param mode A new value for mode
   * @return A modified copy of the {@code this} object
   */
  public final SlackGifFile withMode(String mode) {
    if (this.mode.equals(mode)) return this;
    String newValue = Objects.requireNonNull(mode, "mode");
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        this.thumb80Url,
        this.thumb160Url,
        this.thumb360Url,
        this.thumb360Width,
        this.thumb360Height,
        this.thumb480Url,
        this.thumb480Width,
        this.thumb480Height,
        this.imageExifRotation,
        this.originalWidth,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        newValue,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackGifFileIF#isExternal() external} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param external A new value for external
   * @return A modified copy of the {@code this} object
   */
  public final SlackGifFile withExternal(boolean external) {
    if (this.external == external) return this;
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        this.thumb80Url,
        this.thumb160Url,
        this.thumb360Url,
        this.thumb360Width,
        this.thumb360Height,
        this.thumb480Url,
        this.thumb480Width,
        this.thumb480Height,
        this.imageExifRotation,
        this.originalWidth,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackGifFileIF#isPublic() isPublic} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param isPublic A new value for isPublic
   * @return A modified copy of the {@code this} object
   */
  public final SlackGifFile withIsPublic(boolean isPublic) {
    if (this.isPublic == isPublic) return this;
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        this.thumb80Url,
        this.thumb160Url,
        this.thumb360Url,
        this.thumb360Width,
        this.thumb360Height,
        this.thumb480Url,
        this.thumb480Width,
        this.thumb480Height,
        this.imageExifRotation,
        this.originalWidth,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackGifFileIF#isPublicUrlShared() publicUrlShared} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param publicUrlShared A new value for publicUrlShared
   * @return A modified copy of the {@code this} object
   */
  public final SlackGifFile withPublicUrlShared(boolean publicUrlShared) {
    if (this.publicUrlShared == publicUrlShared) return this;
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        this.thumb80Url,
        this.thumb160Url,
        this.thumb360Url,
        this.thumb360Width,
        this.thumb360Height,
        this.thumb480Url,
        this.thumb480Width,
        this.thumb480Height,
        this.imageExifRotation,
        this.originalWidth,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackGifFileIF#getDisplayAsBot() displayAsBot} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param displayAsBot A new value for displayAsBot
   * @return A modified copy of the {@code this} object
   */
  public final SlackGifFile withDisplayAsBot(boolean displayAsBot) {
    if (this.displayAsBot == displayAsBot) return this;
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        this.thumb80Url,
        this.thumb160Url,
        this.thumb360Url,
        this.thumb360Width,
        this.thumb360Height,
        this.thumb480Url,
        this.thumb480Width,
        this.thumb480Height,
        this.imageExifRotation,
        this.originalWidth,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackGifFileIF#getUsername() username} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param username A new value for username
   * @return A modified copy of the {@code this} object
   */
  public final SlackGifFile withUsername(String username) {
    if (this.username.equals(username)) return this;
    String newValue = Objects.requireNonNull(username, "username");
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        this.thumb80Url,
        this.thumb160Url,
        this.thumb360Url,
        this.thumb360Width,
        this.thumb360Height,
        this.thumb480Url,
        this.thumb480Width,
        this.thumb480Height,
        this.imageExifRotation,
        this.originalWidth,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        newValue,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackGifFileIF#getUrlPrivate() urlPrivate} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param urlPrivate A new value for urlPrivate
   * @return A modified copy of the {@code this} object
   */
  public final SlackGifFile withUrlPrivate(String urlPrivate) {
    if (this.urlPrivate.equals(urlPrivate)) return this;
    String newValue = Objects.requireNonNull(urlPrivate, "urlPrivate");
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        this.thumb80Url,
        this.thumb160Url,
        this.thumb360Url,
        this.thumb360Width,
        this.thumb360Height,
        this.thumb480Url,
        this.thumb480Width,
        this.thumb480Height,
        this.imageExifRotation,
        this.originalWidth,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        newValue,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackGifFileIF#getUrlPrivateDownload() urlPrivateDownload} attribute.
   * @param value The value for urlPrivateDownload, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackGifFile withUrlPrivateDownload(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.urlPrivateDownload, newValue)) return this;
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        this.thumb80Url,
        this.thumb160Url,
        this.thumb360Url,
        this.thumb360Width,
        this.thumb360Height,
        this.thumb480Url,
        this.thumb480Width,
        this.thumb480Height,
        this.imageExifRotation,
        this.originalWidth,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        newValue,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackGifFileIF#getUrlPrivateDownload() urlPrivateDownload} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for urlPrivateDownload
   * @return A modified copy of {@code this} object
   */
  public final SlackGifFile withUrlPrivateDownload(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.urlPrivateDownload, value)) return this;
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        this.thumb80Url,
        this.thumb160Url,
        this.thumb360Url,
        this.thumb360Width,
        this.thumb360Height,
        this.thumb480Url,
        this.thumb480Width,
        this.thumb480Height,
        this.imageExifRotation,
        this.originalWidth,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        value,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackGifFileIF#getPermalink() permalink} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param permalink A new value for permalink
   * @return A modified copy of the {@code this} object
   */
  public final SlackGifFile withPermalink(String permalink) {
    if (this.permalink.equals(permalink)) return this;
    String newValue = Objects.requireNonNull(permalink, "permalink");
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        this.thumb80Url,
        this.thumb160Url,
        this.thumb360Url,
        this.thumb360Width,
        this.thumb360Height,
        this.thumb480Url,
        this.thumb480Width,
        this.thumb480Height,
        this.imageExifRotation,
        this.originalWidth,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        newValue,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackGifFileIF#getPermalinkPublic() permalinkPublic} attribute.
   * @param value The value for permalinkPublic, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackGifFile withPermalinkPublic(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.permalinkPublic, newValue)) return this;
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        this.thumb80Url,
        this.thumb160Url,
        this.thumb360Url,
        this.thumb360Width,
        this.thumb360Height,
        this.thumb480Url,
        this.thumb480Width,
        this.thumb480Height,
        this.imageExifRotation,
        this.originalWidth,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        newValue,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackGifFileIF#getPermalinkPublic() permalinkPublic} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for permalinkPublic
   * @return A modified copy of {@code this} object
   */
  public final SlackGifFile withPermalinkPublic(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.permalinkPublic, value)) return this;
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        this.thumb80Url,
        this.thumb160Url,
        this.thumb360Url,
        this.thumb360Width,
        this.thumb360Height,
        this.thumb480Url,
        this.thumb480Width,
        this.thumb480Height,
        this.imageExifRotation,
        this.originalWidth,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        value,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackGifFileIF#getCommentsCount() commentsCount} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param commentsCount A new value for commentsCount
   * @return A modified copy of the {@code this} object
   */
  public final SlackGifFile withCommentsCount(int commentsCount) {
    if (this.commentsCount == commentsCount) return this;
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        this.thumb80Url,
        this.thumb160Url,
        this.thumb360Url,
        this.thumb360Width,
        this.thumb360Height,
        this.thumb480Url,
        this.thumb480Width,
        this.thumb480Height,
        this.imageExifRotation,
        this.originalWidth,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackGifFileIF#isStarred() starred} attribute.
   * @param value The value for starred, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackGifFile withStarred(@Nullable Boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.starred, newValue)) return this;
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        this.thumb80Url,
        this.thumb160Url,
        this.thumb360Url,
        this.thumb360Width,
        this.thumb360Height,
        this.thumb480Url,
        this.thumb480Width,
        this.thumb480Height,
        this.imageExifRotation,
        this.originalWidth,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        newValue,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackGifFileIF#isStarred() starred} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for starred
   * @return A modified copy of {@code this} object
   */
  public final SlackGifFile withStarred(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.starred, value)) return this;
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        this.thumb80Url,
        this.thumb160Url,
        this.thumb360Url,
        this.thumb360Width,
        this.thumb360Height,
        this.thumb480Url,
        this.thumb480Width,
        this.thumb480Height,
        this.imageExifRotation,
        this.originalWidth,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        value,
        this.channelIds,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SlackGifFileIF#getChannelIds() channelIds}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final SlackGifFile withChannelIds(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        this.thumb80Url,
        this.thumb160Url,
        this.thumb360Url,
        this.thumb360Width,
        this.thumb360Height,
        this.thumb480Url,
        this.thumb480Width,
        this.thumb480Height,
        this.imageExifRotation,
        this.originalWidth,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        newValue,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SlackGifFileIF#getChannelIds() channelIds}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of channelIds elements to set
   * @return A modified copy of {@code this} object
   */
  public final SlackGifFile withChannelIds(Iterable<String> elements) {
    if (this.channelIds == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        this.thumb80Url,
        this.thumb160Url,
        this.thumb360Url,
        this.thumb360Width,
        this.thumb360Height,
        this.thumb480Url,
        this.thumb480Width,
        this.thumb480Height,
        this.imageExifRotation,
        this.originalWidth,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        newValue,
        this.groupIds,
        this.imIds);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SlackGifFileIF#getGroupIds() groupIds}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final SlackGifFile withGroupIds(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        this.thumb80Url,
        this.thumb160Url,
        this.thumb360Url,
        this.thumb360Width,
        this.thumb360Height,
        this.thumb480Url,
        this.thumb480Width,
        this.thumb480Height,
        this.imageExifRotation,
        this.originalWidth,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        newValue,
        this.imIds);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SlackGifFileIF#getGroupIds() groupIds}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of groupIds elements to set
   * @return A modified copy of {@code this} object
   */
  public final SlackGifFile withGroupIds(Iterable<String> elements) {
    if (this.groupIds == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        this.thumb80Url,
        this.thumb160Url,
        this.thumb360Url,
        this.thumb360Width,
        this.thumb360Height,
        this.thumb480Url,
        this.thumb480Width,
        this.thumb480Height,
        this.imageExifRotation,
        this.originalWidth,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        newValue,
        this.imIds);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SlackGifFileIF#getImIds() imIds}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final SlackGifFile withImIds(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        this.thumb80Url,
        this.thumb160Url,
        this.thumb360Url,
        this.thumb360Width,
        this.thumb360Height,
        this.thumb480Url,
        this.thumb480Width,
        this.thumb480Height,
        this.imageExifRotation,
        this.originalWidth,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SlackGifFileIF#getImIds() imIds}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of imIds elements to set
   * @return A modified copy of {@code this} object
   */
  public final SlackGifFile withImIds(Iterable<String> elements) {
    if (this.imIds == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new SlackGifFile(
        this.filetype,
        this.thumb64Url,
        this.thumb80Url,
        this.thumb160Url,
        this.thumb360Url,
        this.thumb360Width,
        this.thumb360Height,
        this.thumb480Url,
        this.thumb480Width,
        this.thumb480Height,
        this.imageExifRotation,
        this.originalWidth,
        this.originalHeight,
        this.hasRichPreview,
        this.id,
        this.createdEpochSeconds,
        this.timestampEpochSeconds,
        this.name,
        this.title,
        this.mimetype,
        this.prettyType,
        this.userId,
        this.editable,
        this.size,
        this.mode,
        this.external,
        this.isPublic,
        this.publicUrlShared,
        this.displayAsBot,
        this.username,
        this.urlPrivate,
        this.urlPrivateDownload,
        this.permalink,
        this.permalinkPublic,
        this.commentsCount,
        this.starred,
        this.channelIds,
        this.groupIds,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code SlackGifFile} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof SlackGifFile
        && equalTo((SlackGifFile) another);
  }

  private boolean equalTo(SlackGifFile another) {
    return filetype.equals(another.filetype)
        && Objects.equals(thumb64Url, another.thumb64Url)
        && Objects.equals(thumb80Url, another.thumb80Url)
        && Objects.equals(thumb160Url, another.thumb160Url)
        && Objects.equals(thumb360Url, another.thumb360Url)
        && Objects.equals(thumb360Width, another.thumb360Width)
        && Objects.equals(thumb360Height, another.thumb360Height)
        && Objects.equals(thumb480Url, another.thumb480Url)
        && Objects.equals(thumb480Width, another.thumb480Width)
        && Objects.equals(thumb480Height, another.thumb480Height)
        && Objects.equals(imageExifRotation, another.imageExifRotation)
        && Objects.equals(originalWidth, another.originalWidth)
        && Objects.equals(originalHeight, another.originalHeight)
        && hasRichPreview == another.hasRichPreview
        && id.equals(another.id)
        && createdEpochSeconds == another.createdEpochSeconds
        && timestampEpochSeconds == another.timestampEpochSeconds
        && name.equals(another.name)
        && title.equals(another.title)
        && mimetype.equals(another.mimetype)
        && prettyType.equals(another.prettyType)
        && userId.equals(another.userId)
        && editable == another.editable
        && size == another.size
        && mode.equals(another.mode)
        && external == another.external
        && isPublic == another.isPublic
        && publicUrlShared == another.publicUrlShared
        && displayAsBot == another.displayAsBot
        && username.equals(another.username)
        && urlPrivate.equals(another.urlPrivate)
        && Objects.equals(urlPrivateDownload, another.urlPrivateDownload)
        && permalink.equals(another.permalink)
        && Objects.equals(permalinkPublic, another.permalinkPublic)
        && commentsCount == another.commentsCount
        && Objects.equals(starred, another.starred)
        && channelIds.equals(another.channelIds)
        && groupIds.equals(another.groupIds)
        && imIds.equals(another.imIds);
  }

  /**
   * Computes a hash code from attributes: {@code filetype}, {@code thumb64Url}, {@code thumb80Url}, {@code thumb160Url}, {@code thumb360Url}, {@code thumb360Width}, {@code thumb360Height}, {@code thumb480Url}, {@code thumb480Width}, {@code thumb480Height}, {@code imageExifRotation}, {@code originalWidth}, {@code originalHeight}, {@code hasRichPreview}, {@code id}, {@code createdEpochSeconds}, {@code timestampEpochSeconds}, {@code name}, {@code title}, {@code mimetype}, {@code prettyType}, {@code userId}, {@code editable}, {@code size}, {@code mode}, {@code external}, {@code isPublic}, {@code publicUrlShared}, {@code displayAsBot}, {@code username}, {@code urlPrivate}, {@code urlPrivateDownload}, {@code permalink}, {@code permalinkPublic}, {@code commentsCount}, {@code starred}, {@code channelIds}, {@code groupIds}, {@code imIds}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + filetype.hashCode();
    h = h * 17 + Objects.hashCode(thumb64Url);
    h = h * 17 + Objects.hashCode(thumb80Url);
    h = h * 17 + Objects.hashCode(thumb160Url);
    h = h * 17 + Objects.hashCode(thumb360Url);
    h = h * 17 + Objects.hashCode(thumb360Width);
    h = h * 17 + Objects.hashCode(thumb360Height);
    h = h * 17 + Objects.hashCode(thumb480Url);
    h = h * 17 + Objects.hashCode(thumb480Width);
    h = h * 17 + Objects.hashCode(thumb480Height);
    h = h * 17 + Objects.hashCode(imageExifRotation);
    h = h * 17 + Objects.hashCode(originalWidth);
    h = h * 17 + Objects.hashCode(originalHeight);
    h = h * 17 + Boolean.hashCode(hasRichPreview);
    h = h * 17 + id.hashCode();
    h = h * 17 + Long.hashCode(createdEpochSeconds);
    h = h * 17 + Long.hashCode(timestampEpochSeconds);
    h = h * 17 + name.hashCode();
    h = h * 17 + title.hashCode();
    h = h * 17 + mimetype.hashCode();
    h = h * 17 + prettyType.hashCode();
    h = h * 17 + userId.hashCode();
    h = h * 17 + Boolean.hashCode(editable);
    h = h * 17 + Long.hashCode(size);
    h = h * 17 + mode.hashCode();
    h = h * 17 + Boolean.hashCode(external);
    h = h * 17 + Boolean.hashCode(isPublic);
    h = h * 17 + Boolean.hashCode(publicUrlShared);
    h = h * 17 + Boolean.hashCode(displayAsBot);
    h = h * 17 + username.hashCode();
    h = h * 17 + urlPrivate.hashCode();
    h = h * 17 + Objects.hashCode(urlPrivateDownload);
    h = h * 17 + permalink.hashCode();
    h = h * 17 + Objects.hashCode(permalinkPublic);
    h = h * 17 + commentsCount;
    h = h * 17 + Objects.hashCode(starred);
    h = h * 17 + channelIds.hashCode();
    h = h * 17 + groupIds.hashCode();
    h = h * 17 + imIds.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code SlackGifFile} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("SlackGifFile{");
    builder.append("filetype=").append(filetype);
    if (thumb64Url != null) {
      builder.append(", ");
      builder.append("thumb64Url=").append(thumb64Url);
    }
    if (thumb80Url != null) {
      builder.append(", ");
      builder.append("thumb80Url=").append(thumb80Url);
    }
    if (thumb160Url != null) {
      builder.append(", ");
      builder.append("thumb160Url=").append(thumb160Url);
    }
    if (thumb360Url != null) {
      builder.append(", ");
      builder.append("thumb360Url=").append(thumb360Url);
    }
    if (thumb360Width != null) {
      builder.append(", ");
      builder.append("thumb360Width=").append(thumb360Width);
    }
    if (thumb360Height != null) {
      builder.append(", ");
      builder.append("thumb360Height=").append(thumb360Height);
    }
    if (thumb480Url != null) {
      builder.append(", ");
      builder.append("thumb480Url=").append(thumb480Url);
    }
    if (thumb480Width != null) {
      builder.append(", ");
      builder.append("thumb480Width=").append(thumb480Width);
    }
    if (thumb480Height != null) {
      builder.append(", ");
      builder.append("thumb480Height=").append(thumb480Height);
    }
    if (imageExifRotation != null) {
      builder.append(", ");
      builder.append("imageExifRotation=").append(imageExifRotation);
    }
    if (originalWidth != null) {
      builder.append(", ");
      builder.append("originalWidth=").append(originalWidth);
    }
    if (originalHeight != null) {
      builder.append(", ");
      builder.append("originalHeight=").append(originalHeight);
    }
    builder.append(", ");
    builder.append("hasRichPreview=").append(hasRichPreview);
    builder.append(", ");
    builder.append("id=").append(id);
    builder.append(", ");
    builder.append("createdEpochSeconds=").append(createdEpochSeconds);
    builder.append(", ");
    builder.append("timestampEpochSeconds=").append(timestampEpochSeconds);
    builder.append(", ");
    builder.append("name=").append(name);
    builder.append(", ");
    builder.append("title=").append(title);
    builder.append(", ");
    builder.append("mimetype=").append(mimetype);
    builder.append(", ");
    builder.append("prettyType=").append(prettyType);
    builder.append(", ");
    builder.append("userId=").append(userId);
    builder.append(", ");
    builder.append("editable=").append(editable);
    builder.append(", ");
    builder.append("size=").append(size);
    builder.append(", ");
    builder.append("mode=").append(mode);
    builder.append(", ");
    builder.append("external=").append(external);
    builder.append(", ");
    builder.append("isPublic=").append(isPublic);
    builder.append(", ");
    builder.append("publicUrlShared=").append(publicUrlShared);
    builder.append(", ");
    builder.append("displayAsBot=").append(displayAsBot);
    builder.append(", ");
    builder.append("username=").append(username);
    builder.append(", ");
    builder.append("urlPrivate=").append(urlPrivate);
    if (urlPrivateDownload != null) {
      builder.append(", ");
      builder.append("urlPrivateDownload=").append(urlPrivateDownload);
    }
    builder.append(", ");
    builder.append("permalink=").append(permalink);
    if (permalinkPublic != null) {
      builder.append(", ");
      builder.append("permalinkPublic=").append(permalinkPublic);
    }
    builder.append(", ");
    builder.append("commentsCount=").append(commentsCount);
    if (starred != null) {
      builder.append(", ");
      builder.append("starred=").append(starred);
    }
    builder.append(", ");
    builder.append("channelIds=").append(channelIds);
    builder.append(", ");
    builder.append("groupIds=").append(groupIds);
    builder.append(", ");
    builder.append("imIds=").append(imIds);
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements SlackGifFileIF {
    @Nullable SlackFileType filetype;
    Optional<String> thumb64Url = Optional.empty();
    Optional<String> thumb80Url = Optional.empty();
    Optional<String> thumb160Url = Optional.empty();
    Optional<String> thumb360Url = Optional.empty();
    Optional<Integer> thumb360Width = Optional.empty();
    Optional<Integer> thumb360Height = Optional.empty();
    Optional<String> thumb480Url = Optional.empty();
    Optional<Integer> thumb480Width = Optional.empty();
    Optional<Integer> thumb480Height = Optional.empty();
    Optional<Integer> imageExifRotation = Optional.empty();
    Optional<Integer> originalWidth = Optional.empty();
    Optional<Integer> originalHeight = Optional.empty();
    boolean hasRichPreview;
    boolean hasRichPreviewIsSet;
    @Nullable String id;
    long createdEpochSeconds;
    boolean createdEpochSecondsIsSet;
    long timestampEpochSeconds;
    boolean timestampEpochSecondsIsSet;
    @Nullable String name;
    @Nullable String title;
    @Nullable String mimetype;
    @Nullable String prettyType;
    @Nullable String userId;
    boolean editable;
    boolean editableIsSet;
    long size;
    boolean sizeIsSet;
    @Nullable String mode;
    boolean external;
    boolean externalIsSet;
    boolean isPublic;
    boolean isPublicIsSet;
    boolean publicUrlShared;
    boolean publicUrlSharedIsSet;
    boolean displayAsBot;
    boolean displayAsBotIsSet;
    @Nullable String username;
    @Nullable String urlPrivate;
    Optional<String> urlPrivateDownload = Optional.empty();
    @Nullable String permalink;
    Optional<String> permalinkPublic = Optional.empty();
    int commentsCount;
    boolean commentsCountIsSet;
    Optional<Boolean> starred = Optional.empty();
    List<String> channelIds = Collections.emptyList();
    List<String> groupIds = Collections.emptyList();
    List<String> imIds = Collections.emptyList();
    @JsonProperty
    public void setFiletype(SlackFileType filetype) {
      this.filetype = filetype;
    }
    @JsonProperty("thumb_64")
    public void setThumb64Url(Optional<String> thumb64Url) {
      this.thumb64Url = thumb64Url;
    }
    @JsonProperty("thumb_80")
    public void setThumb80Url(Optional<String> thumb80Url) {
      this.thumb80Url = thumb80Url;
    }
    @JsonProperty("thumb_160")
    public void setThumb160Url(Optional<String> thumb160Url) {
      this.thumb160Url = thumb160Url;
    }
    @JsonProperty("thumb_360")
    public void setThumb360Url(Optional<String> thumb360Url) {
      this.thumb360Url = thumb360Url;
    }
    @JsonProperty("thumb_360_w")
    public void setThumb360Width(Optional<Integer> thumb360Width) {
      this.thumb360Width = thumb360Width;
    }
    @JsonProperty("thumb_360_h")
    public void setThumb360Height(Optional<Integer> thumb360Height) {
      this.thumb360Height = thumb360Height;
    }
    @JsonProperty("thumb_480")
    public void setThumb480Url(Optional<String> thumb480Url) {
      this.thumb480Url = thumb480Url;
    }
    @JsonProperty("thumb_480_w")
    public void setThumb480Width(Optional<Integer> thumb480Width) {
      this.thumb480Width = thumb480Width;
    }
    @JsonProperty("thumb_480_h")
    public void setThumb480Height(Optional<Integer> thumb480Height) {
      this.thumb480Height = thumb480Height;
    }
    @JsonProperty
    public void setImageExifRotation(Optional<Integer> imageExifRotation) {
      this.imageExifRotation = imageExifRotation;
    }
    @JsonProperty("original_w")
    public void setOriginalWidth(Optional<Integer> originalWidth) {
      this.originalWidth = originalWidth;
    }
    @JsonProperty("original_h")
    public void setOriginalHeight(Optional<Integer> originalHeight) {
      this.originalHeight = originalHeight;
    }
    @JsonProperty("has_rich_preview")
    public void setHasRichPreview(boolean hasRichPreview) {
      this.hasRichPreview = hasRichPreview;
      this.hasRichPreviewIsSet = true;
    }
    @JsonProperty
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("created")
    public void setCreatedEpochSeconds(long createdEpochSeconds) {
      this.createdEpochSeconds = createdEpochSeconds;
      this.createdEpochSecondsIsSet = true;
    }
    @JsonProperty("timestamp")
    public void setTimestampEpochSeconds(long timestampEpochSeconds) {
      this.timestampEpochSeconds = timestampEpochSeconds;
      this.timestampEpochSecondsIsSet = true;
    }
    @JsonProperty
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty
    public void setTitle(String title) {
      this.title = title;
    }
    @JsonProperty
    public void setMimetype(String mimetype) {
      this.mimetype = mimetype;
    }
    @JsonProperty
    public void setPrettyType(String prettyType) {
      this.prettyType = prettyType;
    }
    @JsonProperty("user")
    public void setUserId(String userId) {
      this.userId = userId;
    }
    @JsonProperty
    public void setEditable(boolean editable) {
      this.editable = editable;
      this.editableIsSet = true;
    }
    @JsonProperty
    public void setSize(long size) {
      this.size = size;
      this.sizeIsSet = true;
    }
    @JsonProperty
    public void setMode(String mode) {
      this.mode = mode;
    }
    @JsonProperty("is_external")
    public void setExternal(boolean external) {
      this.external = external;
      this.externalIsSet = true;
    }
    @JsonProperty("is_public")
    public void setIsPublic(boolean isPublic) {
      this.isPublic = isPublic;
      this.isPublicIsSet = true;
    }
    @JsonProperty
    public void setPublicUrlShared(boolean publicUrlShared) {
      this.publicUrlShared = publicUrlShared;
      this.publicUrlSharedIsSet = true;
    }
    @JsonProperty
    public void setDisplayAsBot(boolean displayAsBot) {
      this.displayAsBot = displayAsBot;
      this.displayAsBotIsSet = true;
    }
    @JsonProperty
    public void setUsername(String username) {
      this.username = username;
    }
    @JsonProperty
    public void setUrlPrivate(String urlPrivate) {
      this.urlPrivate = urlPrivate;
    }
    @JsonProperty
    public void setUrlPrivateDownload(Optional<String> urlPrivateDownload) {
      this.urlPrivateDownload = urlPrivateDownload;
    }
    @JsonProperty
    public void setPermalink(String permalink) {
      this.permalink = permalink;
    }
    @JsonProperty
    public void setPermalinkPublic(Optional<String> permalinkPublic) {
      this.permalinkPublic = permalinkPublic;
    }
    @JsonProperty
    public void setCommentsCount(int commentsCount) {
      this.commentsCount = commentsCount;
      this.commentsCountIsSet = true;
    }
    @JsonProperty("is_starred")
    public void setStarred(Optional<Boolean> starred) {
      this.starred = starred;
    }
    @JsonProperty("channels")
    public void setChannelIds(List<String> channelIds) {
      this.channelIds = channelIds;
    }
    @JsonProperty("groups")
    public void setGroupIds(List<String> groupIds) {
      this.groupIds = groupIds;
    }
    @JsonProperty("ims")
    public void setImIds(List<String> imIds) {
      this.imIds = imIds;
    }
    @Override
    public SlackFileType getFiletype() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getThumb64Url() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getThumb80Url() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getThumb160Url() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getThumb360Url() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Integer> getThumb360Width() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Integer> getThumb360Height() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getThumb480Url() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Integer> getThumb480Width() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Integer> getThumb480Height() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Integer> getImageExifRotation() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Integer> getOriginalWidth() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Integer> getOriginalHeight() { throw new UnsupportedOperationException(); }
    @Override
    public boolean hasRichPreview() { throw new UnsupportedOperationException(); }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public long getCreatedEpochSeconds() { throw new UnsupportedOperationException(); }
    @Override
    public long getTimestampEpochSeconds() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public String getTitle() { throw new UnsupportedOperationException(); }
    @Override
    public String getMimetype() { throw new UnsupportedOperationException(); }
    @Override
    public String getPrettyType() { throw new UnsupportedOperationException(); }
    @Override
    public String getUserId() { throw new UnsupportedOperationException(); }
    @Override
    public boolean isEditable() { throw new UnsupportedOperationException(); }
    @Override
    public long getSize() { throw new UnsupportedOperationException(); }
    @Override
    public String getMode() { throw new UnsupportedOperationException(); }
    @Override
    public boolean isExternal() { throw new UnsupportedOperationException(); }
    @Override
    public boolean isPublic() { throw new UnsupportedOperationException(); }
    @Override
    public boolean isPublicUrlShared() { throw new UnsupportedOperationException(); }
    @Override
    public boolean getDisplayAsBot() { throw new UnsupportedOperationException(); }
    @Override
    public String getUsername() { throw new UnsupportedOperationException(); }
    @Override
    public String getUrlPrivate() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getUrlPrivateDownload() { throw new UnsupportedOperationException(); }
    @Override
    public String getPermalink() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getPermalinkPublic() { throw new UnsupportedOperationException(); }
    @Override
    public int getCommentsCount() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Boolean> isStarred() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getChannelIds() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getGroupIds() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getImIds() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static SlackGifFile fromJson(Json json) {
    SlackGifFile.Builder builder = SlackGifFile.builder();
    if (json.filetype != null) {
      builder.setFiletype(json.filetype);
    }
    if (json.thumb64Url != null) {
      builder.setThumb64Url(json.thumb64Url);
    }
    if (json.thumb80Url != null) {
      builder.setThumb80Url(json.thumb80Url);
    }
    if (json.thumb160Url != null) {
      builder.setThumb160Url(json.thumb160Url);
    }
    if (json.thumb360Url != null) {
      builder.setThumb360Url(json.thumb360Url);
    }
    if (json.thumb360Width != null) {
      builder.setThumb360Width(json.thumb360Width);
    }
    if (json.thumb360Height != null) {
      builder.setThumb360Height(json.thumb360Height);
    }
    if (json.thumb480Url != null) {
      builder.setThumb480Url(json.thumb480Url);
    }
    if (json.thumb480Width != null) {
      builder.setThumb480Width(json.thumb480Width);
    }
    if (json.thumb480Height != null) {
      builder.setThumb480Height(json.thumb480Height);
    }
    if (json.imageExifRotation != null) {
      builder.setImageExifRotation(json.imageExifRotation);
    }
    if (json.originalWidth != null) {
      builder.setOriginalWidth(json.originalWidth);
    }
    if (json.originalHeight != null) {
      builder.setOriginalHeight(json.originalHeight);
    }
    if (json.hasRichPreviewIsSet) {
      builder.setHasRichPreview(json.hasRichPreview);
    }
    if (json.id != null) {
      builder.setId(json.id);
    }
    if (json.createdEpochSecondsIsSet) {
      builder.setCreatedEpochSeconds(json.createdEpochSeconds);
    }
    if (json.timestampEpochSecondsIsSet) {
      builder.setTimestampEpochSeconds(json.timestampEpochSeconds);
    }
    if (json.name != null) {
      builder.setName(json.name);
    }
    if (json.title != null) {
      builder.setTitle(json.title);
    }
    if (json.mimetype != null) {
      builder.setMimetype(json.mimetype);
    }
    if (json.prettyType != null) {
      builder.setPrettyType(json.prettyType);
    }
    if (json.userId != null) {
      builder.setUserId(json.userId);
    }
    if (json.editableIsSet) {
      builder.setEditable(json.editable);
    }
    if (json.sizeIsSet) {
      builder.setSize(json.size);
    }
    if (json.mode != null) {
      builder.setMode(json.mode);
    }
    if (json.externalIsSet) {
      builder.setExternal(json.external);
    }
    if (json.isPublicIsSet) {
      builder.setIsPublic(json.isPublic);
    }
    if (json.publicUrlSharedIsSet) {
      builder.setPublicUrlShared(json.publicUrlShared);
    }
    if (json.displayAsBotIsSet) {
      builder.setDisplayAsBot(json.displayAsBot);
    }
    if (json.username != null) {
      builder.setUsername(json.username);
    }
    if (json.urlPrivate != null) {
      builder.setUrlPrivate(json.urlPrivate);
    }
    if (json.urlPrivateDownload != null) {
      builder.setUrlPrivateDownload(json.urlPrivateDownload);
    }
    if (json.permalink != null) {
      builder.setPermalink(json.permalink);
    }
    if (json.permalinkPublic != null) {
      builder.setPermalinkPublic(json.permalinkPublic);
    }
    if (json.commentsCountIsSet) {
      builder.setCommentsCount(json.commentsCount);
    }
    if (json.starred != null) {
      builder.setStarred(json.starred);
    }
    if (json.channelIds != null) {
      builder.addAllChannelIds(json.channelIds);
    }
    if (json.groupIds != null) {
      builder.addAllGroupIds(json.groupIds);
    }
    if (json.imIds != null) {
      builder.addAllImIds(json.imIds);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link SlackGifFileIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SlackGifFile instance
   */
  public static SlackGifFile copyOf(SlackGifFileIF instance) {
    if (instance instanceof SlackGifFile) {
      return (SlackGifFile) instance;
    }
    return SlackGifFile.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link SlackGifFile SlackGifFile}.
   * @return A new SlackGifFile builder
   */
  public static SlackGifFile.Builder builder() {
    return new SlackGifFile.Builder();
  }

  /**
   * Builds instances of type {@link SlackGifFile SlackGifFile}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_HAS_RICH_PREVIEW = 0x1L;
    private static final long INIT_BIT_ID = 0x2L;
    private static final long INIT_BIT_CREATED_EPOCH_SECONDS = 0x4L;
    private static final long INIT_BIT_TIMESTAMP_EPOCH_SECONDS = 0x8L;
    private static final long INIT_BIT_NAME = 0x10L;
    private static final long INIT_BIT_TITLE = 0x20L;
    private static final long INIT_BIT_MIMETYPE = 0x40L;
    private static final long INIT_BIT_PRETTY_TYPE = 0x80L;
    private static final long INIT_BIT_USER_ID = 0x100L;
    private static final long INIT_BIT_EDITABLE = 0x200L;
    private static final long INIT_BIT_SIZE = 0x400L;
    private static final long INIT_BIT_MODE = 0x800L;
    private static final long INIT_BIT_EXTERNAL = 0x1000L;
    private static final long INIT_BIT_IS_PUBLIC = 0x2000L;
    private static final long INIT_BIT_PUBLIC_URL_SHARED = 0x4000L;
    private static final long INIT_BIT_DISPLAY_AS_BOT = 0x8000L;
    private static final long INIT_BIT_USERNAME = 0x10000L;
    private static final long INIT_BIT_URL_PRIVATE = 0x20000L;
    private static final long INIT_BIT_PERMALINK = 0x40000L;
    private static final long OPT_BIT_COMMENTS_COUNT = 0x1L;
    private long initBits = 0x7ffffL;
    private long optBits;

    private @Nullable SlackFileType filetype;
    private @Nullable String thumb64Url;
    private @Nullable String thumb80Url;
    private @Nullable String thumb160Url;
    private @Nullable String thumb360Url;
    private @Nullable Integer thumb360Width;
    private @Nullable Integer thumb360Height;
    private @Nullable String thumb480Url;
    private @Nullable Integer thumb480Width;
    private @Nullable Integer thumb480Height;
    private @Nullable Integer imageExifRotation;
    private @Nullable Integer originalWidth;
    private @Nullable Integer originalHeight;
    private boolean hasRichPreview;
    private @Nullable String id;
    private long createdEpochSeconds;
    private long timestampEpochSeconds;
    private @Nullable String name;
    private @Nullable String title;
    private @Nullable String mimetype;
    private @Nullable String prettyType;
    private @Nullable String userId;
    private boolean editable;
    private long size;
    private @Nullable String mode;
    private boolean external;
    private boolean isPublic;
    private boolean publicUrlShared;
    private boolean displayAsBot;
    private @Nullable String username;
    private @Nullable String urlPrivate;
    private @Nullable String urlPrivateDownload;
    private @Nullable String permalink;
    private @Nullable String permalinkPublic;
    private int commentsCount;
    private @Nullable Boolean starred;
    private List<String> channelIds = new ArrayList<String>();
    private List<String> groupIds = new ArrayList<String>();
    private List<String> imIds = new ArrayList<String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.files.SlackGifFileIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackGifFileIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.files.SlackFile} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackFile instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.files.SlackImageFile} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackImageFile instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      long bits = 0;
      if (object instanceof SlackGifFileIF) {
        SlackGifFileIF instance = (SlackGifFileIF) object;
        if ((bits & 0x1L) == 0) {
          setFiletype(instance.getFiletype());
          bits |= 0x1L;
        }
      }
      if (object instanceof SlackFile) {
        SlackFile instance = (SlackFile) object;
        if ((bits & 0x1L) == 0) {
          setFiletype(instance.getFiletype());
          bits |= 0x1L;
        }
        setTitle(instance.getTitle());
        setDisplayAsBot(instance.getDisplayAsBot());
        addAllImIds(instance.getImIds());
        Optional<String> urlPrivateDownloadOptional = instance.getUrlPrivateDownload();
        if (urlPrivateDownloadOptional.isPresent()) {
          setUrlPrivateDownload(urlPrivateDownloadOptional);
        }
        setMode(instance.getMode());
        Optional<Boolean> starredOptional = instance.isStarred();
        if (starredOptional.isPresent()) {
          setStarred(starredOptional);
        }
        setUrlPrivate(instance.getUrlPrivate());
        setPrettyType(instance.getPrettyType());
        addAllGroupIds(instance.getGroupIds());
        setPublicUrlShared(instance.isPublicUrlShared());
        setTimestampEpochSeconds(instance.getTimestampEpochSeconds());
        setIsPublic(instance.isPublic());
        setId(instance.getId());
        addAllChannelIds(instance.getChannelIds());
        setCreatedEpochSeconds(instance.getCreatedEpochSeconds());
        setEditable(instance.isEditable());
        setUserId(instance.getUserId());
        setExternal(instance.isExternal());
        setSize(instance.getSize());
        setCommentsCount(instance.getCommentsCount());
        setName(instance.getName());
        setMimetype(instance.getMimetype());
        Optional<String> permalinkPublicOptional = instance.getPermalinkPublic();
        if (permalinkPublicOptional.isPresent()) {
          setPermalinkPublic(permalinkPublicOptional);
        }
        setPermalink(instance.getPermalink());
        setUsername(instance.getUsername());
      }
      if (object instanceof SlackImageFile) {
        SlackImageFile instance = (SlackImageFile) object;
        Optional<Integer> originalHeightOptional = instance.getOriginalHeight();
        if (originalHeightOptional.isPresent()) {
          setOriginalHeight(originalHeightOptional);
        }
        Optional<Integer> thumb480HeightOptional = instance.getThumb480Height();
        if (thumb480HeightOptional.isPresent()) {
          setThumb480Height(thumb480HeightOptional);
        }
        Optional<String> thumb64UrlOptional = instance.getThumb64Url();
        if (thumb64UrlOptional.isPresent()) {
          setThumb64Url(thumb64UrlOptional);
        }
        Optional<Integer> thumb360HeightOptional = instance.getThumb360Height();
        if (thumb360HeightOptional.isPresent()) {
          setThumb360Height(thumb360HeightOptional);
        }
        setHasRichPreview(instance.hasRichPreview());
        Optional<String> thumb80UrlOptional = instance.getThumb80Url();
        if (thumb80UrlOptional.isPresent()) {
          setThumb80Url(thumb80UrlOptional);
        }
        Optional<Integer> imageExifRotationOptional = instance.getImageExifRotation();
        if (imageExifRotationOptional.isPresent()) {
          setImageExifRotation(imageExifRotationOptional);
        }
        Optional<Integer> originalWidthOptional = instance.getOriginalWidth();
        if (originalWidthOptional.isPresent()) {
          setOriginalWidth(originalWidthOptional);
        }
        Optional<String> thumb360UrlOptional = instance.getThumb360Url();
        if (thumb360UrlOptional.isPresent()) {
          setThumb360Url(thumb360UrlOptional);
        }
        Optional<String> thumb480UrlOptional = instance.getThumb480Url();
        if (thumb480UrlOptional.isPresent()) {
          setThumb480Url(thumb480UrlOptional);
        }
        Optional<String> thumb160UrlOptional = instance.getThumb160Url();
        if (thumb160UrlOptional.isPresent()) {
          setThumb160Url(thumb160UrlOptional);
        }
        Optional<Integer> thumb480WidthOptional = instance.getThumb480Width();
        if (thumb480WidthOptional.isPresent()) {
          setThumb480Width(thumb480WidthOptional);
        }
        Optional<Integer> thumb360WidthOptional = instance.getThumb360Width();
        if (thumb360WidthOptional.isPresent()) {
          setThumb360Width(thumb360WidthOptional);
        }
      }
    }

    /**
     * Initializes the value for the {@link SlackGifFileIF#getFiletype() filetype} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SlackGifFileIF#getFiletype() filetype}.</em>
     * @param filetype The value for filetype 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setFiletype(SlackFileType filetype) {
      this.filetype = Objects.requireNonNull(filetype, "filetype");
      return this;
    }

    /**
     * Initializes the optional value {@link SlackGifFileIF#getThumb64Url() thumb64Url} to thumb64Url.
     * @param thumb64Url The value for thumb64Url, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setThumb64Url(@Nullable String thumb64Url) {
      this.thumb64Url = thumb64Url;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackGifFileIF#getThumb64Url() thumb64Url} to thumb64Url.
     * @param thumb64Url The value for thumb64Url
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setThumb64Url(Optional<String> thumb64Url) {
      this.thumb64Url = thumb64Url.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link SlackGifFileIF#getThumb80Url() thumb80Url} to thumb80Url.
     * @param thumb80Url The value for thumb80Url, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setThumb80Url(@Nullable String thumb80Url) {
      this.thumb80Url = thumb80Url;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackGifFileIF#getThumb80Url() thumb80Url} to thumb80Url.
     * @param thumb80Url The value for thumb80Url
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setThumb80Url(Optional<String> thumb80Url) {
      this.thumb80Url = thumb80Url.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link SlackGifFileIF#getThumb160Url() thumb160Url} to thumb160Url.
     * @param thumb160Url The value for thumb160Url, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setThumb160Url(@Nullable String thumb160Url) {
      this.thumb160Url = thumb160Url;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackGifFileIF#getThumb160Url() thumb160Url} to thumb160Url.
     * @param thumb160Url The value for thumb160Url
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setThumb160Url(Optional<String> thumb160Url) {
      this.thumb160Url = thumb160Url.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link SlackGifFileIF#getThumb360Url() thumb360Url} to thumb360Url.
     * @param thumb360Url The value for thumb360Url, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setThumb360Url(@Nullable String thumb360Url) {
      this.thumb360Url = thumb360Url;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackGifFileIF#getThumb360Url() thumb360Url} to thumb360Url.
     * @param thumb360Url The value for thumb360Url
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setThumb360Url(Optional<String> thumb360Url) {
      this.thumb360Url = thumb360Url.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link SlackGifFileIF#getThumb360Width() thumb360Width} to thumb360Width.
     * @param thumb360Width The value for thumb360Width, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setThumb360Width(@Nullable Integer thumb360Width) {
      this.thumb360Width = thumb360Width;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackGifFileIF#getThumb360Width() thumb360Width} to thumb360Width.
     * @param thumb360Width The value for thumb360Width
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setThumb360Width(Optional<Integer> thumb360Width) {
      this.thumb360Width = thumb360Width.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link SlackGifFileIF#getThumb360Height() thumb360Height} to thumb360Height.
     * @param thumb360Height The value for thumb360Height, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setThumb360Height(@Nullable Integer thumb360Height) {
      this.thumb360Height = thumb360Height;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackGifFileIF#getThumb360Height() thumb360Height} to thumb360Height.
     * @param thumb360Height The value for thumb360Height
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setThumb360Height(Optional<Integer> thumb360Height) {
      this.thumb360Height = thumb360Height.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link SlackGifFileIF#getThumb480Url() thumb480Url} to thumb480Url.
     * @param thumb480Url The value for thumb480Url, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setThumb480Url(@Nullable String thumb480Url) {
      this.thumb480Url = thumb480Url;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackGifFileIF#getThumb480Url() thumb480Url} to thumb480Url.
     * @param thumb480Url The value for thumb480Url
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setThumb480Url(Optional<String> thumb480Url) {
      this.thumb480Url = thumb480Url.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link SlackGifFileIF#getThumb480Width() thumb480Width} to thumb480Width.
     * @param thumb480Width The value for thumb480Width, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setThumb480Width(@Nullable Integer thumb480Width) {
      this.thumb480Width = thumb480Width;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackGifFileIF#getThumb480Width() thumb480Width} to thumb480Width.
     * @param thumb480Width The value for thumb480Width
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setThumb480Width(Optional<Integer> thumb480Width) {
      this.thumb480Width = thumb480Width.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link SlackGifFileIF#getThumb480Height() thumb480Height} to thumb480Height.
     * @param thumb480Height The value for thumb480Height, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setThumb480Height(@Nullable Integer thumb480Height) {
      this.thumb480Height = thumb480Height;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackGifFileIF#getThumb480Height() thumb480Height} to thumb480Height.
     * @param thumb480Height The value for thumb480Height
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setThumb480Height(Optional<Integer> thumb480Height) {
      this.thumb480Height = thumb480Height.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link SlackGifFileIF#getImageExifRotation() imageExifRotation} to imageExifRotation.
     * @param imageExifRotation The value for imageExifRotation, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setImageExifRotation(@Nullable Integer imageExifRotation) {
      this.imageExifRotation = imageExifRotation;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackGifFileIF#getImageExifRotation() imageExifRotation} to imageExifRotation.
     * @param imageExifRotation The value for imageExifRotation
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setImageExifRotation(Optional<Integer> imageExifRotation) {
      this.imageExifRotation = imageExifRotation.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link SlackGifFileIF#getOriginalWidth() originalWidth} to originalWidth.
     * @param originalWidth The value for originalWidth, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setOriginalWidth(@Nullable Integer originalWidth) {
      this.originalWidth = originalWidth;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackGifFileIF#getOriginalWidth() originalWidth} to originalWidth.
     * @param originalWidth The value for originalWidth
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setOriginalWidth(Optional<Integer> originalWidth) {
      this.originalWidth = originalWidth.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link SlackGifFileIF#getOriginalHeight() originalHeight} to originalHeight.
     * @param originalHeight The value for originalHeight, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setOriginalHeight(@Nullable Integer originalHeight) {
      this.originalHeight = originalHeight;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackGifFileIF#getOriginalHeight() originalHeight} to originalHeight.
     * @param originalHeight The value for originalHeight
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setOriginalHeight(Optional<Integer> originalHeight) {
      this.originalHeight = originalHeight.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link SlackGifFileIF#hasRichPreview() hasRichPreview} attribute.
     * @param hasRichPreview The value for hasRichPreview 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setHasRichPreview(boolean hasRichPreview) {
      this.hasRichPreview = hasRichPreview;
      initBits &= ~INIT_BIT_HAS_RICH_PREVIEW;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackGifFileIF#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setId(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackGifFileIF#getCreatedEpochSeconds() createdEpochSeconds} attribute.
     * @param createdEpochSeconds The value for createdEpochSeconds 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setCreatedEpochSeconds(long createdEpochSeconds) {
      this.createdEpochSeconds = createdEpochSeconds;
      initBits &= ~INIT_BIT_CREATED_EPOCH_SECONDS;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackGifFileIF#getTimestampEpochSeconds() timestampEpochSeconds} attribute.
     * @param timestampEpochSeconds The value for timestampEpochSeconds 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTimestampEpochSeconds(long timestampEpochSeconds) {
      this.timestampEpochSeconds = timestampEpochSeconds;
      initBits &= ~INIT_BIT_TIMESTAMP_EPOCH_SECONDS;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackGifFileIF#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setName(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackGifFileIF#getTitle() title} attribute.
     * @param title The value for title 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTitle(String title) {
      this.title = Objects.requireNonNull(title, "title");
      initBits &= ~INIT_BIT_TITLE;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackGifFileIF#getMimetype() mimetype} attribute.
     * @param mimetype The value for mimetype 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setMimetype(String mimetype) {
      this.mimetype = Objects.requireNonNull(mimetype, "mimetype");
      initBits &= ~INIT_BIT_MIMETYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackGifFileIF#getPrettyType() prettyType} attribute.
     * @param prettyType The value for prettyType 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setPrettyType(String prettyType) {
      this.prettyType = Objects.requireNonNull(prettyType, "prettyType");
      initBits &= ~INIT_BIT_PRETTY_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackGifFileIF#getUserId() userId} attribute.
     * @param userId The value for userId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUserId(String userId) {
      this.userId = Objects.requireNonNull(userId, "userId");
      initBits &= ~INIT_BIT_USER_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackGifFileIF#isEditable() editable} attribute.
     * @param editable The value for editable 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setEditable(boolean editable) {
      this.editable = editable;
      initBits &= ~INIT_BIT_EDITABLE;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackGifFileIF#getSize() size} attribute.
     * @param size The value for size 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setSize(long size) {
      this.size = size;
      initBits &= ~INIT_BIT_SIZE;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackGifFileIF#getMode() mode} attribute.
     * @param mode The value for mode 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setMode(String mode) {
      this.mode = Objects.requireNonNull(mode, "mode");
      initBits &= ~INIT_BIT_MODE;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackGifFileIF#isExternal() external} attribute.
     * @param external The value for external 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setExternal(boolean external) {
      this.external = external;
      initBits &= ~INIT_BIT_EXTERNAL;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackGifFileIF#isPublic() isPublic} attribute.
     * @param isPublic The value for isPublic 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setIsPublic(boolean isPublic) {
      this.isPublic = isPublic;
      initBits &= ~INIT_BIT_IS_PUBLIC;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackGifFileIF#isPublicUrlShared() publicUrlShared} attribute.
     * @param publicUrlShared The value for publicUrlShared 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setPublicUrlShared(boolean publicUrlShared) {
      this.publicUrlShared = publicUrlShared;
      initBits &= ~INIT_BIT_PUBLIC_URL_SHARED;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackGifFileIF#getDisplayAsBot() displayAsBot} attribute.
     * @param displayAsBot The value for displayAsBot 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setDisplayAsBot(boolean displayAsBot) {
      this.displayAsBot = displayAsBot;
      initBits &= ~INIT_BIT_DISPLAY_AS_BOT;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackGifFileIF#getUsername() username} attribute.
     * @param username The value for username 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUsername(String username) {
      this.username = Objects.requireNonNull(username, "username");
      initBits &= ~INIT_BIT_USERNAME;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackGifFileIF#getUrlPrivate() urlPrivate} attribute.
     * @param urlPrivate The value for urlPrivate 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUrlPrivate(String urlPrivate) {
      this.urlPrivate = Objects.requireNonNull(urlPrivate, "urlPrivate");
      initBits &= ~INIT_BIT_URL_PRIVATE;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackGifFileIF#getUrlPrivateDownload() urlPrivateDownload} to urlPrivateDownload.
     * @param urlPrivateDownload The value for urlPrivateDownload, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setUrlPrivateDownload(@Nullable String urlPrivateDownload) {
      this.urlPrivateDownload = urlPrivateDownload;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackGifFileIF#getUrlPrivateDownload() urlPrivateDownload} to urlPrivateDownload.
     * @param urlPrivateDownload The value for urlPrivateDownload
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUrlPrivateDownload(Optional<String> urlPrivateDownload) {
      this.urlPrivateDownload = urlPrivateDownload.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link SlackGifFileIF#getPermalink() permalink} attribute.
     * @param permalink The value for permalink 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setPermalink(String permalink) {
      this.permalink = Objects.requireNonNull(permalink, "permalink");
      initBits &= ~INIT_BIT_PERMALINK;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackGifFileIF#getPermalinkPublic() permalinkPublic} to permalinkPublic.
     * @param permalinkPublic The value for permalinkPublic, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setPermalinkPublic(@Nullable String permalinkPublic) {
      this.permalinkPublic = permalinkPublic;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackGifFileIF#getPermalinkPublic() permalinkPublic} to permalinkPublic.
     * @param permalinkPublic The value for permalinkPublic
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setPermalinkPublic(Optional<String> permalinkPublic) {
      this.permalinkPublic = permalinkPublic.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link SlackGifFileIF#getCommentsCount() commentsCount} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SlackGifFileIF#getCommentsCount() commentsCount}.</em>
     * @param commentsCount The value for commentsCount 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setCommentsCount(int commentsCount) {
      this.commentsCount = commentsCount;
      optBits |= OPT_BIT_COMMENTS_COUNT;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackGifFileIF#isStarred() starred} to starred.
     * @param starred The value for starred, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setStarred(@Nullable Boolean starred) {
      this.starred = starred;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackGifFileIF#isStarred() starred} to starred.
     * @param starred The value for starred
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setStarred(Optional<Boolean> starred) {
      this.starred = starred.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link SlackGifFileIF#getChannelIds() channelIds} list.
     * @param element A channelIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addChannelIds(String element) {
      this.channelIds.add(Objects.requireNonNull(element, "channelIds element"));
      return this;
    }

    /**
     * Adds elements to {@link SlackGifFileIF#getChannelIds() channelIds} list.
     * @param elements An array of channelIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addChannelIds(String... elements) {
      for (String element : elements) {
        this.channelIds.add(Objects.requireNonNull(element, "channelIds element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link SlackGifFileIF#getChannelIds() channelIds} list.
     * @param elements An iterable of channelIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannelIds(Iterable<String> elements) {
      this.channelIds.clear();
      return addAllChannelIds(elements);
    }

    /**
     * Adds elements to {@link SlackGifFileIF#getChannelIds() channelIds} list.
     * @param elements An iterable of channelIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllChannelIds(Iterable<String> elements) {
      for (String element : elements) {
        this.channelIds.add(Objects.requireNonNull(element, "channelIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link SlackGifFileIF#getGroupIds() groupIds} list.
     * @param element A groupIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addGroupIds(String element) {
      this.groupIds.add(Objects.requireNonNull(element, "groupIds element"));
      return this;
    }

    /**
     * Adds elements to {@link SlackGifFileIF#getGroupIds() groupIds} list.
     * @param elements An array of groupIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addGroupIds(String... elements) {
      for (String element : elements) {
        this.groupIds.add(Objects.requireNonNull(element, "groupIds element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link SlackGifFileIF#getGroupIds() groupIds} list.
     * @param elements An iterable of groupIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setGroupIds(Iterable<String> elements) {
      this.groupIds.clear();
      return addAllGroupIds(elements);
    }

    /**
     * Adds elements to {@link SlackGifFileIF#getGroupIds() groupIds} list.
     * @param elements An iterable of groupIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllGroupIds(Iterable<String> elements) {
      for (String element : elements) {
        this.groupIds.add(Objects.requireNonNull(element, "groupIds element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link SlackGifFileIF#getImIds() imIds} list.
     * @param element A imIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addImIds(String element) {
      this.imIds.add(Objects.requireNonNull(element, "imIds element"));
      return this;
    }

    /**
     * Adds elements to {@link SlackGifFileIF#getImIds() imIds} list.
     * @param elements An array of imIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addImIds(String... elements) {
      for (String element : elements) {
        this.imIds.add(Objects.requireNonNull(element, "imIds element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link SlackGifFileIF#getImIds() imIds} list.
     * @param elements An iterable of imIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setImIds(Iterable<String> elements) {
      this.imIds.clear();
      return addAllImIds(elements);
    }

    /**
     * Adds elements to {@link SlackGifFileIF#getImIds() imIds} list.
     * @param elements An iterable of imIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllImIds(Iterable<String> elements) {
      for (String element : elements) {
        this.imIds.add(Objects.requireNonNull(element, "imIds element"));
      }
      return this;
    }

    /**
     * Builds a new {@link SlackGifFile SlackGifFile}.
     * @return An immutable instance of SlackGifFile
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public SlackGifFile build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new SlackGifFile(this);
    }

    private boolean commentsCountIsSet() {
      return (optBits & OPT_BIT_COMMENTS_COUNT) != 0;
    }

    private boolean hasRichPreviewIsSet() {
      return (initBits & INIT_BIT_HAS_RICH_PREVIEW) == 0;
    }

    private boolean idIsSet() {
      return (initBits & INIT_BIT_ID) == 0;
    }

    private boolean createdEpochSecondsIsSet() {
      return (initBits & INIT_BIT_CREATED_EPOCH_SECONDS) == 0;
    }

    private boolean timestampEpochSecondsIsSet() {
      return (initBits & INIT_BIT_TIMESTAMP_EPOCH_SECONDS) == 0;
    }

    private boolean nameIsSet() {
      return (initBits & INIT_BIT_NAME) == 0;
    }

    private boolean titleIsSet() {
      return (initBits & INIT_BIT_TITLE) == 0;
    }

    private boolean mimetypeIsSet() {
      return (initBits & INIT_BIT_MIMETYPE) == 0;
    }

    private boolean prettyTypeIsSet() {
      return (initBits & INIT_BIT_PRETTY_TYPE) == 0;
    }

    private boolean userIdIsSet() {
      return (initBits & INIT_BIT_USER_ID) == 0;
    }

    private boolean editableIsSet() {
      return (initBits & INIT_BIT_EDITABLE) == 0;
    }

    private boolean sizeIsSet() {
      return (initBits & INIT_BIT_SIZE) == 0;
    }

    private boolean modeIsSet() {
      return (initBits & INIT_BIT_MODE) == 0;
    }

    private boolean externalIsSet() {
      return (initBits & INIT_BIT_EXTERNAL) == 0;
    }

    private boolean isPublicIsSet() {
      return (initBits & INIT_BIT_IS_PUBLIC) == 0;
    }

    private boolean publicUrlSharedIsSet() {
      return (initBits & INIT_BIT_PUBLIC_URL_SHARED) == 0;
    }

    private boolean displayAsBotIsSet() {
      return (initBits & INIT_BIT_DISPLAY_AS_BOT) == 0;
    }

    private boolean usernameIsSet() {
      return (initBits & INIT_BIT_USERNAME) == 0;
    }

    private boolean urlPrivateIsSet() {
      return (initBits & INIT_BIT_URL_PRIVATE) == 0;
    }

    private boolean permalinkIsSet() {
      return (initBits & INIT_BIT_PERMALINK) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!hasRichPreviewIsSet()) attributes.add("hasRichPreview");
      if (!idIsSet()) attributes.add("id");
      if (!createdEpochSecondsIsSet()) attributes.add("createdEpochSeconds");
      if (!timestampEpochSecondsIsSet()) attributes.add("timestampEpochSeconds");
      if (!nameIsSet()) attributes.add("name");
      if (!titleIsSet()) attributes.add("title");
      if (!mimetypeIsSet()) attributes.add("mimetype");
      if (!prettyTypeIsSet()) attributes.add("prettyType");
      if (!userIdIsSet()) attributes.add("userId");
      if (!editableIsSet()) attributes.add("editable");
      if (!sizeIsSet()) attributes.add("size");
      if (!modeIsSet()) attributes.add("mode");
      if (!externalIsSet()) attributes.add("external");
      if (!isPublicIsSet()) attributes.add("isPublic");
      if (!publicUrlSharedIsSet()) attributes.add("publicUrlShared");
      if (!displayAsBotIsSet()) attributes.add("displayAsBot");
      if (!usernameIsSet()) attributes.add("username");
      if (!urlPrivateIsSet()) attributes.add("urlPrivate");
      if (!permalinkIsSet()) attributes.add("permalink");
      return "Cannot build SlackGifFile, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
