package com.hubspot.slack.client.models.group;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.ChannelMetadata;
import com.hubspot.slack.client.models.Message;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link SlackGroupIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code SlackGroup.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "SlackGroupIF"})
@Immutable
public final class SlackGroup implements SlackGroupIF {
  private final String id;
  private final String name;
  private final long createdEpochSeconds;
  private final String creatorId;
  private final boolean archived;
  private final boolean mpim;
  private final List<String> memberIds;
  private final ChannelMetadata topic;
  private final ChannelMetadata purpose;
  private final @Nullable Message latest;

  private SlackGroup(
      String id,
      String name,
      long createdEpochSeconds,
      String creatorId,
      boolean archived,
      boolean mpim,
      List<String> memberIds,
      ChannelMetadata topic,
      ChannelMetadata purpose,
      @Nullable Message latest) {
    this.id = id;
    this.name = name;
    this.createdEpochSeconds = createdEpochSeconds;
    this.creatorId = creatorId;
    this.archived = archived;
    this.mpim = mpim;
    this.memberIds = memberIds;
    this.topic = topic;
    this.purpose = purpose;
    this.latest = latest;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @JsonProperty
  @Override
  public String getName() {
    return name;
  }

  /**
   * @return The value of the {@code createdEpochSeconds} attribute
   */
  @JsonProperty("created")
  @Override
  public long getCreatedEpochSeconds() {
    return createdEpochSeconds;
  }

  /**
   * @return The value of the {@code creatorId} attribute
   */
  @JsonProperty("creator")
  @Override
  public String getCreatorId() {
    return creatorId;
  }

  /**
   * @return The value of the {@code archived} attribute
   */
  @JsonProperty("is_archived")
  @Override
  public boolean isArchived() {
    return archived;
  }

  /**
   * @return The value of the {@code mpim} attribute
   */
  @JsonProperty("is_mpim")
  @Override
  public boolean isMpim() {
    return mpim;
  }

  /**
   * @return The value of the {@code memberIds} attribute
   */
  @JsonProperty("members")
  @Override
  public List<String> getMemberIds() {
    return memberIds;
  }

  /**
   * @return The value of the {@code topic} attribute
   */
  @JsonProperty
  @Override
  public ChannelMetadata getTopic() {
    return topic;
  }

  /**
   * @return The value of the {@code purpose} attribute
   */
  @JsonProperty
  @Override
  public ChannelMetadata getPurpose() {
    return purpose;
  }

  /**
   * @return The value of the {@code latest} attribute
   */
  @JsonProperty
  @Override
  public Optional<Message> getLatest() {
    return Optional.ofNullable(latest);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackGroupIF#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param id A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final SlackGroup withId(String id) {
    if (this.id.equals(id)) return this;
    String newValue = Objects.requireNonNull(id, "id");
    return new SlackGroup(
        newValue,
        this.name,
        this.createdEpochSeconds,
        this.creatorId,
        this.archived,
        this.mpim,
        this.memberIds,
        this.topic,
        this.purpose,
        this.latest);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackGroupIF#getName() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param name A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final SlackGroup withName(String name) {
    if (this.name.equals(name)) return this;
    String newValue = Objects.requireNonNull(name, "name");
    return new SlackGroup(
        this.id,
        newValue,
        this.createdEpochSeconds,
        this.creatorId,
        this.archived,
        this.mpim,
        this.memberIds,
        this.topic,
        this.purpose,
        this.latest);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackGroupIF#getCreatedEpochSeconds() createdEpochSeconds} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param createdEpochSeconds A new value for createdEpochSeconds
   * @return A modified copy of the {@code this} object
   */
  public final SlackGroup withCreatedEpochSeconds(long createdEpochSeconds) {
    if (this.createdEpochSeconds == createdEpochSeconds) return this;
    return new SlackGroup(
        this.id,
        this.name,
        createdEpochSeconds,
        this.creatorId,
        this.archived,
        this.mpim,
        this.memberIds,
        this.topic,
        this.purpose,
        this.latest);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackGroupIF#getCreatorId() creatorId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param creatorId A new value for creatorId
   * @return A modified copy of the {@code this} object
   */
  public final SlackGroup withCreatorId(String creatorId) {
    if (this.creatorId.equals(creatorId)) return this;
    String newValue = Objects.requireNonNull(creatorId, "creatorId");
    return new SlackGroup(
        this.id,
        this.name,
        this.createdEpochSeconds,
        newValue,
        this.archived,
        this.mpim,
        this.memberIds,
        this.topic,
        this.purpose,
        this.latest);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackGroupIF#isArchived() archived} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param archived A new value for archived
   * @return A modified copy of the {@code this} object
   */
  public final SlackGroup withArchived(boolean archived) {
    if (this.archived == archived) return this;
    return new SlackGroup(
        this.id,
        this.name,
        this.createdEpochSeconds,
        this.creatorId,
        archived,
        this.mpim,
        this.memberIds,
        this.topic,
        this.purpose,
        this.latest);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackGroupIF#isMpim() mpim} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param mpim A new value for mpim
   * @return A modified copy of the {@code this} object
   */
  public final SlackGroup withMpim(boolean mpim) {
    if (this.mpim == mpim) return this;
    return new SlackGroup(
        this.id,
        this.name,
        this.createdEpochSeconds,
        this.creatorId,
        this.archived,
        mpim,
        this.memberIds,
        this.topic,
        this.purpose,
        this.latest);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SlackGroupIF#getMemberIds() memberIds}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final SlackGroup withMemberIds(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new SlackGroup(
        this.id,
        this.name,
        this.createdEpochSeconds,
        this.creatorId,
        this.archived,
        this.mpim,
        newValue,
        this.topic,
        this.purpose,
        this.latest);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link SlackGroupIF#getMemberIds() memberIds}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of memberIds elements to set
   * @return A modified copy of {@code this} object
   */
  public final SlackGroup withMemberIds(Iterable<String> elements) {
    if (this.memberIds == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new SlackGroup(
        this.id,
        this.name,
        this.createdEpochSeconds,
        this.creatorId,
        this.archived,
        this.mpim,
        newValue,
        this.topic,
        this.purpose,
        this.latest);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackGroupIF#getTopic() topic} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param topic A new value for topic
   * @return A modified copy of the {@code this} object
   */
  public final SlackGroup withTopic(ChannelMetadata topic) {
    if (this.topic == topic) return this;
    ChannelMetadata newValue = Objects.requireNonNull(topic, "topic");
    return new SlackGroup(
        this.id,
        this.name,
        this.createdEpochSeconds,
        this.creatorId,
        this.archived,
        this.mpim,
        this.memberIds,
        newValue,
        this.purpose,
        this.latest);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackGroupIF#getPurpose() purpose} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param purpose A new value for purpose
   * @return A modified copy of the {@code this} object
   */
  public final SlackGroup withPurpose(ChannelMetadata purpose) {
    if (this.purpose == purpose) return this;
    ChannelMetadata newValue = Objects.requireNonNull(purpose, "purpose");
    return new SlackGroup(
        this.id,
        this.name,
        this.createdEpochSeconds,
        this.creatorId,
        this.archived,
        this.mpim,
        this.memberIds,
        this.topic,
        newValue,
        this.latest);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackGroupIF#getLatest() latest} attribute.
   * @param value The value for latest, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackGroup withLatest(@Nullable Message value) {
    @Nullable Message newValue = value;
    if (this.latest == newValue) return this;
    return new SlackGroup(
        this.id,
        this.name,
        this.createdEpochSeconds,
        this.creatorId,
        this.archived,
        this.mpim,
        this.memberIds,
        this.topic,
        this.purpose,
        newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackGroupIF#getLatest() latest} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for latest
   * @return A modified copy of {@code this} object
   */
  public final SlackGroup withLatest(Optional<Message> optional) {
    @Nullable Message value = optional.orElse(null);
    if (this.latest == value) return this;
    return new SlackGroup(
        this.id,
        this.name,
        this.createdEpochSeconds,
        this.creatorId,
        this.archived,
        this.mpim,
        this.memberIds,
        this.topic,
        this.purpose,
        value);
  }

  /**
   * This instance is equal to all instances of {@code SlackGroup} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof SlackGroup
        && equalTo((SlackGroup) another);
  }

  private boolean equalTo(SlackGroup another) {
    return id.equals(another.id)
        && name.equals(another.name)
        && createdEpochSeconds == another.createdEpochSeconds
        && creatorId.equals(another.creatorId)
        && archived == another.archived
        && mpim == another.mpim
        && memberIds.equals(another.memberIds)
        && topic.equals(another.topic)
        && purpose.equals(another.purpose)
        && Objects.equals(latest, another.latest);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code name}, {@code createdEpochSeconds}, {@code creatorId}, {@code archived}, {@code mpim}, {@code memberIds}, {@code topic}, {@code purpose}, {@code latest}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + id.hashCode();
    h = h * 17 + name.hashCode();
    h = h * 17 + Long.hashCode(createdEpochSeconds);
    h = h * 17 + creatorId.hashCode();
    h = h * 17 + Boolean.hashCode(archived);
    h = h * 17 + Boolean.hashCode(mpim);
    h = h * 17 + memberIds.hashCode();
    h = h * 17 + topic.hashCode();
    h = h * 17 + purpose.hashCode();
    h = h * 17 + Objects.hashCode(latest);
    return h;
  }

  /**
   * Prints the immutable value {@code SlackGroup} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("SlackGroup{");
    builder.append("id=").append(id);
    builder.append(", ");
    builder.append("name=").append(name);
    builder.append(", ");
    builder.append("createdEpochSeconds=").append(createdEpochSeconds);
    builder.append(", ");
    builder.append("creatorId=").append(creatorId);
    builder.append(", ");
    builder.append("archived=").append(archived);
    builder.append(", ");
    builder.append("mpim=").append(mpim);
    builder.append(", ");
    builder.append("memberIds=").append(memberIds);
    builder.append(", ");
    builder.append("topic=").append(topic);
    builder.append(", ");
    builder.append("purpose=").append(purpose);
    if (latest != null) {
      builder.append(", ");
      builder.append("latest=").append(latest);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements SlackGroupIF {
    @Nullable String id;
    @Nullable String name;
    long createdEpochSeconds;
    boolean createdEpochSecondsIsSet;
    @Nullable String creatorId;
    boolean archived;
    boolean archivedIsSet;
    boolean mpim;
    boolean mpimIsSet;
    List<String> memberIds = Collections.emptyList();
    @Nullable ChannelMetadata topic;
    @Nullable ChannelMetadata purpose;
    Optional<Message> latest = Optional.empty();
    @JsonProperty
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty
    public void setName(String name) {
      this.name = name;
    }
    @JsonProperty("created")
    public void setCreatedEpochSeconds(long createdEpochSeconds) {
      this.createdEpochSeconds = createdEpochSeconds;
      this.createdEpochSecondsIsSet = true;
    }
    @JsonProperty("creator")
    public void setCreatorId(String creatorId) {
      this.creatorId = creatorId;
    }
    @JsonProperty("is_archived")
    public void setArchived(boolean archived) {
      this.archived = archived;
      this.archivedIsSet = true;
    }
    @JsonProperty("is_mpim")
    public void setMpim(boolean mpim) {
      this.mpim = mpim;
      this.mpimIsSet = true;
    }
    @JsonProperty("members")
    public void setMemberIds(List<String> memberIds) {
      this.memberIds = memberIds;
    }
    @JsonProperty
    public void setTopic(ChannelMetadata topic) {
      this.topic = topic;
    }
    @JsonProperty
    public void setPurpose(ChannelMetadata purpose) {
      this.purpose = purpose;
    }
    @JsonProperty
    public void setLatest(Optional<Message> latest) {
      this.latest = latest;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getName() { throw new UnsupportedOperationException(); }
    @Override
    public long getCreatedEpochSeconds() { throw new UnsupportedOperationException(); }
    @Override
    public String getCreatorId() { throw new UnsupportedOperationException(); }
    @Override
    public boolean isArchived() { throw new UnsupportedOperationException(); }
    @Override
    public boolean isMpim() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getMemberIds() { throw new UnsupportedOperationException(); }
    @Override
    public ChannelMetadata getTopic() { throw new UnsupportedOperationException(); }
    @Override
    public ChannelMetadata getPurpose() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Message> getLatest() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static SlackGroup fromJson(Json json) {
    SlackGroup.Builder builder = SlackGroup.builder();
    if (json.id != null) {
      builder.setId(json.id);
    }
    if (json.name != null) {
      builder.setName(json.name);
    }
    if (json.createdEpochSecondsIsSet) {
      builder.setCreatedEpochSeconds(json.createdEpochSeconds);
    }
    if (json.creatorId != null) {
      builder.setCreatorId(json.creatorId);
    }
    if (json.archivedIsSet) {
      builder.setArchived(json.archived);
    }
    if (json.mpimIsSet) {
      builder.setMpim(json.mpim);
    }
    if (json.memberIds != null) {
      builder.addAllMemberIds(json.memberIds);
    }
    if (json.topic != null) {
      builder.setTopic(json.topic);
    }
    if (json.purpose != null) {
      builder.setPurpose(json.purpose);
    }
    if (json.latest != null) {
      builder.setLatest(json.latest);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link SlackGroupIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SlackGroup instance
   */
  public static SlackGroup copyOf(SlackGroupIF instance) {
    if (instance instanceof SlackGroup) {
      return (SlackGroup) instance;
    }
    return SlackGroup.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link SlackGroup SlackGroup}.
   * @return A new SlackGroup builder
   */
  public static SlackGroup.Builder builder() {
    return new SlackGroup.Builder();
  }

  /**
   * Builds instances of type {@link SlackGroup SlackGroup}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_NAME = 0x2L;
    private static final long INIT_BIT_CREATED_EPOCH_SECONDS = 0x4L;
    private static final long INIT_BIT_CREATOR_ID = 0x8L;
    private static final long INIT_BIT_ARCHIVED = 0x10L;
    private static final long INIT_BIT_MPIM = 0x20L;
    private static final long INIT_BIT_TOPIC = 0x40L;
    private static final long INIT_BIT_PURPOSE = 0x80L;
    private long initBits = 0xffL;

    private @Nullable String id;
    private @Nullable String name;
    private long createdEpochSeconds;
    private @Nullable String creatorId;
    private boolean archived;
    private boolean mpim;
    private List<String> memberIds = new ArrayList<String>();
    private @Nullable ChannelMetadata topic;
    private @Nullable ChannelMetadata purpose;
    private @Nullable Message latest;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SlackGroupIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackGroupIF instance) {
      Objects.requireNonNull(instance, "instance");
      setId(instance.getId());
      setName(instance.getName());
      setCreatedEpochSeconds(instance.getCreatedEpochSeconds());
      setCreatorId(instance.getCreatorId());
      setArchived(instance.isArchived());
      setMpim(instance.isMpim());
      addAllMemberIds(instance.getMemberIds());
      setTopic(instance.getTopic());
      setPurpose(instance.getPurpose());
      Optional<Message> latestOptional = instance.getLatest();
      if (latestOptional.isPresent()) {
        setLatest(latestOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link SlackGroupIF#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setId(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackGroupIF#getName() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setName(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackGroupIF#getCreatedEpochSeconds() createdEpochSeconds} attribute.
     * @param createdEpochSeconds The value for createdEpochSeconds 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setCreatedEpochSeconds(long createdEpochSeconds) {
      this.createdEpochSeconds = createdEpochSeconds;
      initBits &= ~INIT_BIT_CREATED_EPOCH_SECONDS;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackGroupIF#getCreatorId() creatorId} attribute.
     * @param creatorId The value for creatorId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setCreatorId(String creatorId) {
      this.creatorId = Objects.requireNonNull(creatorId, "creatorId");
      initBits &= ~INIT_BIT_CREATOR_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackGroupIF#isArchived() archived} attribute.
     * @param archived The value for archived 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setArchived(boolean archived) {
      this.archived = archived;
      initBits &= ~INIT_BIT_ARCHIVED;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackGroupIF#isMpim() mpim} attribute.
     * @param mpim The value for mpim 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setMpim(boolean mpim) {
      this.mpim = mpim;
      initBits &= ~INIT_BIT_MPIM;
      return this;
    }

    /**
     * Adds one element to {@link SlackGroupIF#getMemberIds() memberIds} list.
     * @param element A memberIds element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addMemberIds(String element) {
      this.memberIds.add(Objects.requireNonNull(element, "memberIds element"));
      return this;
    }

    /**
     * Adds elements to {@link SlackGroupIF#getMemberIds() memberIds} list.
     * @param elements An array of memberIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addMemberIds(String... elements) {
      for (String element : elements) {
        this.memberIds.add(Objects.requireNonNull(element, "memberIds element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link SlackGroupIF#getMemberIds() memberIds} list.
     * @param elements An iterable of memberIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setMemberIds(Iterable<String> elements) {
      this.memberIds.clear();
      return addAllMemberIds(elements);
    }

    /**
     * Adds elements to {@link SlackGroupIF#getMemberIds() memberIds} list.
     * @param elements An iterable of memberIds elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllMemberIds(Iterable<String> elements) {
      for (String element : elements) {
        this.memberIds.add(Objects.requireNonNull(element, "memberIds element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link SlackGroupIF#getTopic() topic} attribute.
     * @param topic The value for topic 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTopic(ChannelMetadata topic) {
      this.topic = Objects.requireNonNull(topic, "topic");
      initBits &= ~INIT_BIT_TOPIC;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackGroupIF#getPurpose() purpose} attribute.
     * @param purpose The value for purpose 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setPurpose(ChannelMetadata purpose) {
      this.purpose = Objects.requireNonNull(purpose, "purpose");
      initBits &= ~INIT_BIT_PURPOSE;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackGroupIF#getLatest() latest} to latest.
     * @param latest The value for latest, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setLatest(@Nullable Message latest) {
      this.latest = latest;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackGroupIF#getLatest() latest} to latest.
     * @param latest The value for latest
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setLatest(Optional<Message> latest) {
      this.latest = latest.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link SlackGroup SlackGroup}.
     * @return An immutable instance of SlackGroup
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public SlackGroup build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new SlackGroup(
          id,
          name,
          createdEpochSeconds,
          creatorId,
          archived,
          mpim,
          createUnmodifiableList(true, memberIds),
          topic,
          purpose,
          latest);
    }

    private boolean idIsSet() {
      return (initBits & INIT_BIT_ID) == 0;
    }

    private boolean nameIsSet() {
      return (initBits & INIT_BIT_NAME) == 0;
    }

    private boolean createdEpochSecondsIsSet() {
      return (initBits & INIT_BIT_CREATED_EPOCH_SECONDS) == 0;
    }

    private boolean creatorIdIsSet() {
      return (initBits & INIT_BIT_CREATOR_ID) == 0;
    }

    private boolean archivedIsSet() {
      return (initBits & INIT_BIT_ARCHIVED) == 0;
    }

    private boolean mpimIsSet() {
      return (initBits & INIT_BIT_MPIM) == 0;
    }

    private boolean topicIsSet() {
      return (initBits & INIT_BIT_TOPIC) == 0;
    }

    private boolean purposeIsSet() {
      return (initBits & INIT_BIT_PURPOSE) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!idIsSet()) attributes.add("id");
      if (!nameIsSet()) attributes.add("name");
      if (!createdEpochSecondsIsSet()) attributes.add("createdEpochSeconds");
      if (!creatorIdIsSet()) attributes.add("creatorId");
      if (!archivedIsSet()) attributes.add("archived");
      if (!mpimIsSet()) attributes.add("mpim");
      if (!topicIsSet()) attributes.add("topic");
      if (!purposeIsSet()) attributes.add("purpose");
      return "Cannot build SlackGroup, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
