package com.hubspot.slack.client.models.interaction;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.LiteMessage;
import com.hubspot.slack.client.models.SlackChannel;
import com.hubspot.slack.client.models.teams.SlackTeam;
import com.hubspot.slack.client.models.users.SlackUserLite;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link MessageActionIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code MessageAction.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "MessageActionIF"})
@Immutable
public final class MessageAction implements MessageActionIF {
  private final String triggerId;
  private final String responseUrl;
  private final LiteMessage message;
  private final InteractiveCallbackType type;
  private final String callbackId;
  private final String actionTs;
  private final String token;
  private final SlackTeam team;
  private final SlackChannel channel;
  private final SlackUserLite user;

  private MessageAction(
      String triggerId,
      String responseUrl,
      LiteMessage message,
      InteractiveCallbackType type,
      String callbackId,
      String actionTs,
      String token,
      SlackTeam team,
      SlackChannel channel,
      SlackUserLite user) {
    this.triggerId = triggerId;
    this.responseUrl = responseUrl;
    this.message = message;
    this.type = type;
    this.callbackId = callbackId;
    this.actionTs = actionTs;
    this.token = token;
    this.team = team;
    this.channel = channel;
    this.user = user;
  }

  /**
   * @return The value of the {@code triggerId} attribute
   */
  @JsonProperty
  @Override
  public String getTriggerId() {
    return triggerId;
  }

  /**
   * @return The value of the {@code responseUrl} attribute
   */
  @JsonProperty
  @Override
  public String getResponseUrl() {
    return responseUrl;
  }

  /**
   * @return The value of the {@code message} attribute
   */
  @JsonProperty
  @Override
  public LiteMessage getMessage() {
    return message;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @JsonProperty
  @Override
  public InteractiveCallbackType getType() {
    return type;
  }

  /**
   * @return The value of the {@code callbackId} attribute
   */
  @JsonProperty
  @Override
  public String getCallbackId() {
    return callbackId;
  }

  /**
   * @return The value of the {@code actionTs} attribute
   */
  @JsonProperty
  @Override
  public String getActionTs() {
    return actionTs;
  }

  /**
   * @return The value of the {@code token} attribute
   */
  @JsonProperty
  @Override
  public String getToken() {
    return token;
  }

  /**
   * @return The value of the {@code team} attribute
   */
  @JsonProperty
  @Override
  public SlackTeam getTeam() {
    return team;
  }

  /**
   * @return The value of the {@code channel} attribute
   */
  @JsonProperty
  @Override
  public SlackChannel getChannel() {
    return channel;
  }

  /**
   * @return The value of the {@code user} attribute
   */
  @JsonProperty
  @Override
  public SlackUserLite getUser() {
    return user;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessageActionIF#getTriggerId() triggerId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param triggerId A new value for triggerId
   * @return A modified copy of the {@code this} object
   */
  public final MessageAction withTriggerId(String triggerId) {
    if (this.triggerId.equals(triggerId)) return this;
    String newValue = Objects.requireNonNull(triggerId, "triggerId");
    return new MessageAction(
        newValue,
        this.responseUrl,
        this.message,
        this.type,
        this.callbackId,
        this.actionTs,
        this.token,
        this.team,
        this.channel,
        this.user);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessageActionIF#getResponseUrl() responseUrl} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param responseUrl A new value for responseUrl
   * @return A modified copy of the {@code this} object
   */
  public final MessageAction withResponseUrl(String responseUrl) {
    if (this.responseUrl.equals(responseUrl)) return this;
    String newValue = Objects.requireNonNull(responseUrl, "responseUrl");
    return new MessageAction(
        this.triggerId,
        newValue,
        this.message,
        this.type,
        this.callbackId,
        this.actionTs,
        this.token,
        this.team,
        this.channel,
        this.user);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessageActionIF#getMessage() message} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param message A new value for message
   * @return A modified copy of the {@code this} object
   */
  public final MessageAction withMessage(LiteMessage message) {
    if (this.message == message) return this;
    LiteMessage newValue = Objects.requireNonNull(message, "message");
    return new MessageAction(
        this.triggerId,
        this.responseUrl,
        newValue,
        this.type,
        this.callbackId,
        this.actionTs,
        this.token,
        this.team,
        this.channel,
        this.user);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessageActionIF#getType() type} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param type A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final MessageAction withType(InteractiveCallbackType type) {
    if (this.type == type) return this;
    InteractiveCallbackType newValue = Objects.requireNonNull(type, "type");
    return new MessageAction(
        this.triggerId,
        this.responseUrl,
        this.message,
        newValue,
        this.callbackId,
        this.actionTs,
        this.token,
        this.team,
        this.channel,
        this.user);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessageActionIF#getCallbackId() callbackId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param callbackId A new value for callbackId
   * @return A modified copy of the {@code this} object
   */
  public final MessageAction withCallbackId(String callbackId) {
    if (this.callbackId.equals(callbackId)) return this;
    String newValue = Objects.requireNonNull(callbackId, "callbackId");
    return new MessageAction(
        this.triggerId,
        this.responseUrl,
        this.message,
        this.type,
        newValue,
        this.actionTs,
        this.token,
        this.team,
        this.channel,
        this.user);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessageActionIF#getActionTs() actionTs} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param actionTs A new value for actionTs
   * @return A modified copy of the {@code this} object
   */
  public final MessageAction withActionTs(String actionTs) {
    if (this.actionTs.equals(actionTs)) return this;
    String newValue = Objects.requireNonNull(actionTs, "actionTs");
    return new MessageAction(
        this.triggerId,
        this.responseUrl,
        this.message,
        this.type,
        this.callbackId,
        newValue,
        this.token,
        this.team,
        this.channel,
        this.user);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessageActionIF#getToken() token} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param token A new value for token
   * @return A modified copy of the {@code this} object
   */
  public final MessageAction withToken(String token) {
    if (this.token.equals(token)) return this;
    String newValue = Objects.requireNonNull(token, "token");
    return new MessageAction(
        this.triggerId,
        this.responseUrl,
        this.message,
        this.type,
        this.callbackId,
        this.actionTs,
        newValue,
        this.team,
        this.channel,
        this.user);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessageActionIF#getTeam() team} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param team A new value for team
   * @return A modified copy of the {@code this} object
   */
  public final MessageAction withTeam(SlackTeam team) {
    if (this.team == team) return this;
    SlackTeam newValue = Objects.requireNonNull(team, "team");
    return new MessageAction(
        this.triggerId,
        this.responseUrl,
        this.message,
        this.type,
        this.callbackId,
        this.actionTs,
        this.token,
        newValue,
        this.channel,
        this.user);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessageActionIF#getChannel() channel} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param channel A new value for channel
   * @return A modified copy of the {@code this} object
   */
  public final MessageAction withChannel(SlackChannel channel) {
    if (this.channel == channel) return this;
    SlackChannel newValue = Objects.requireNonNull(channel, "channel");
    return new MessageAction(
        this.triggerId,
        this.responseUrl,
        this.message,
        this.type,
        this.callbackId,
        this.actionTs,
        this.token,
        this.team,
        newValue,
        this.user);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MessageActionIF#getUser() user} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param user A new value for user
   * @return A modified copy of the {@code this} object
   */
  public final MessageAction withUser(SlackUserLite user) {
    if (this.user == user) return this;
    SlackUserLite newValue = Objects.requireNonNull(user, "user");
    return new MessageAction(
        this.triggerId,
        this.responseUrl,
        this.message,
        this.type,
        this.callbackId,
        this.actionTs,
        this.token,
        this.team,
        this.channel,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code MessageAction} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof MessageAction
        && equalTo((MessageAction) another);
  }

  private boolean equalTo(MessageAction another) {
    return triggerId.equals(another.triggerId)
        && responseUrl.equals(another.responseUrl)
        && message.equals(another.message)
        && type.equals(another.type)
        && callbackId.equals(another.callbackId)
        && actionTs.equals(another.actionTs)
        && token.equals(another.token)
        && team.equals(another.team)
        && channel.equals(another.channel)
        && user.equals(another.user);
  }

  /**
   * Computes a hash code from attributes: {@code triggerId}, {@code responseUrl}, {@code message}, {@code type}, {@code callbackId}, {@code actionTs}, {@code token}, {@code team}, {@code channel}, {@code user}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + triggerId.hashCode();
    h = h * 17 + responseUrl.hashCode();
    h = h * 17 + message.hashCode();
    h = h * 17 + type.hashCode();
    h = h * 17 + callbackId.hashCode();
    h = h * 17 + actionTs.hashCode();
    h = h * 17 + token.hashCode();
    h = h * 17 + team.hashCode();
    h = h * 17 + channel.hashCode();
    h = h * 17 + user.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MessageAction} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "MessageAction{"
        + "triggerId=" + triggerId
        + ", responseUrl=" + responseUrl
        + ", message=" + message
        + ", type=" + type
        + ", callbackId=" + callbackId
        + ", actionTs=" + actionTs
        + ", token=" + token
        + ", team=" + team
        + ", channel=" + channel
        + ", user=" + user
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements MessageActionIF {
    @Nullable String triggerId;
    @Nullable String responseUrl;
    @Nullable LiteMessage message;
    @Nullable InteractiveCallbackType type;
    @Nullable String callbackId;
    @Nullable String actionTs;
    @Nullable String token;
    @Nullable SlackTeam team;
    @Nullable SlackChannel channel;
    @Nullable SlackUserLite user;
    @JsonProperty
    public void setTriggerId(String triggerId) {
      this.triggerId = triggerId;
    }
    @JsonProperty
    public void setResponseUrl(String responseUrl) {
      this.responseUrl = responseUrl;
    }
    @JsonProperty
    public void setMessage(LiteMessage message) {
      this.message = message;
    }
    @JsonProperty
    public void setType(InteractiveCallbackType type) {
      this.type = type;
    }
    @JsonProperty
    public void setCallbackId(String callbackId) {
      this.callbackId = callbackId;
    }
    @JsonProperty
    public void setActionTs(String actionTs) {
      this.actionTs = actionTs;
    }
    @JsonProperty
    public void setToken(String token) {
      this.token = token;
    }
    @JsonProperty
    public void setTeam(SlackTeam team) {
      this.team = team;
    }
    @JsonProperty
    public void setChannel(SlackChannel channel) {
      this.channel = channel;
    }
    @JsonProperty
    public void setUser(SlackUserLite user) {
      this.user = user;
    }
    @Override
    public String getTriggerId() { throw new UnsupportedOperationException(); }
    @Override
    public String getResponseUrl() { throw new UnsupportedOperationException(); }
    @Override
    public LiteMessage getMessage() { throw new UnsupportedOperationException(); }
    @Override
    public InteractiveCallbackType getType() { throw new UnsupportedOperationException(); }
    @Override
    public String getCallbackId() { throw new UnsupportedOperationException(); }
    @Override
    public String getActionTs() { throw new UnsupportedOperationException(); }
    @Override
    public String getToken() { throw new UnsupportedOperationException(); }
    @Override
    public SlackTeam getTeam() { throw new UnsupportedOperationException(); }
    @Override
    public SlackChannel getChannel() { throw new UnsupportedOperationException(); }
    @Override
    public SlackUserLite getUser() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static MessageAction fromJson(Json json) {
    MessageAction.Builder builder = MessageAction.builder();
    if (json.triggerId != null) {
      builder.setTriggerId(json.triggerId);
    }
    if (json.responseUrl != null) {
      builder.setResponseUrl(json.responseUrl);
    }
    if (json.message != null) {
      builder.setMessage(json.message);
    }
    if (json.type != null) {
      builder.setType(json.type);
    }
    if (json.callbackId != null) {
      builder.setCallbackId(json.callbackId);
    }
    if (json.actionTs != null) {
      builder.setActionTs(json.actionTs);
    }
    if (json.token != null) {
      builder.setToken(json.token);
    }
    if (json.team != null) {
      builder.setTeam(json.team);
    }
    if (json.channel != null) {
      builder.setChannel(json.channel);
    }
    if (json.user != null) {
      builder.setUser(json.user);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link MessageActionIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MessageAction instance
   */
  public static MessageAction copyOf(MessageActionIF instance) {
    if (instance instanceof MessageAction) {
      return (MessageAction) instance;
    }
    return MessageAction.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link MessageAction MessageAction}.
   * @return A new MessageAction builder
   */
  public static MessageAction.Builder builder() {
    return new MessageAction.Builder();
  }

  /**
   * Builds instances of type {@link MessageAction MessageAction}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TRIGGER_ID = 0x1L;
    private static final long INIT_BIT_RESPONSE_URL = 0x2L;
    private static final long INIT_BIT_MESSAGE = 0x4L;
    private static final long INIT_BIT_TYPE = 0x8L;
    private static final long INIT_BIT_CALLBACK_ID = 0x10L;
    private static final long INIT_BIT_ACTION_TS = 0x20L;
    private static final long INIT_BIT_TOKEN = 0x40L;
    private static final long INIT_BIT_TEAM = 0x80L;
    private static final long INIT_BIT_CHANNEL = 0x100L;
    private static final long INIT_BIT_USER = 0x200L;
    private long initBits = 0x3ffL;

    private @Nullable String triggerId;
    private @Nullable String responseUrl;
    private @Nullable LiteMessage message;
    private @Nullable InteractiveCallbackType type;
    private @Nullable String callbackId;
    private @Nullable String actionTs;
    private @Nullable String token;
    private @Nullable SlackTeam team;
    private @Nullable SlackChannel channel;
    private @Nullable SlackUserLite user;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.interaction.SlackInteractiveCallback} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackInteractiveCallback instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.interaction.MessageActionIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(MessageActionIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof SlackInteractiveCallback) {
        SlackInteractiveCallback instance = (SlackInteractiveCallback) object;
        setCallbackId(instance.getCallbackId());
        setChannel(instance.getChannel());
        setTeam(instance.getTeam());
        setType(instance.getType());
        setActionTs(instance.getActionTs());
        setUser(instance.getUser());
        setToken(instance.getToken());
      }
      if (object instanceof MessageActionIF) {
        MessageActionIF instance = (MessageActionIF) object;
        setMessage(instance.getMessage());
        setResponseUrl(instance.getResponseUrl());
        setTriggerId(instance.getTriggerId());
      }
    }

    /**
     * Initializes the value for the {@link MessageActionIF#getTriggerId() triggerId} attribute.
     * @param triggerId The value for triggerId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTriggerId(String triggerId) {
      this.triggerId = Objects.requireNonNull(triggerId, "triggerId");
      initBits &= ~INIT_BIT_TRIGGER_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link MessageActionIF#getResponseUrl() responseUrl} attribute.
     * @param responseUrl The value for responseUrl 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setResponseUrl(String responseUrl) {
      this.responseUrl = Objects.requireNonNull(responseUrl, "responseUrl");
      initBits &= ~INIT_BIT_RESPONSE_URL;
      return this;
    }

    /**
     * Initializes the value for the {@link MessageActionIF#getMessage() message} attribute.
     * @param message The value for message 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setMessage(LiteMessage message) {
      this.message = Objects.requireNonNull(message, "message");
      initBits &= ~INIT_BIT_MESSAGE;
      return this;
    }

    /**
     * Initializes the value for the {@link MessageActionIF#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setType(InteractiveCallbackType type) {
      this.type = Objects.requireNonNull(type, "type");
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link MessageActionIF#getCallbackId() callbackId} attribute.
     * @param callbackId The value for callbackId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setCallbackId(String callbackId) {
      this.callbackId = Objects.requireNonNull(callbackId, "callbackId");
      initBits &= ~INIT_BIT_CALLBACK_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link MessageActionIF#getActionTs() actionTs} attribute.
     * @param actionTs The value for actionTs 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setActionTs(String actionTs) {
      this.actionTs = Objects.requireNonNull(actionTs, "actionTs");
      initBits &= ~INIT_BIT_ACTION_TS;
      return this;
    }

    /**
     * Initializes the value for the {@link MessageActionIF#getToken() token} attribute.
     * @param token The value for token 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setToken(String token) {
      this.token = Objects.requireNonNull(token, "token");
      initBits &= ~INIT_BIT_TOKEN;
      return this;
    }

    /**
     * Initializes the value for the {@link MessageActionIF#getTeam() team} attribute.
     * @param team The value for team 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTeam(SlackTeam team) {
      this.team = Objects.requireNonNull(team, "team");
      initBits &= ~INIT_BIT_TEAM;
      return this;
    }

    /**
     * Initializes the value for the {@link MessageActionIF#getChannel() channel} attribute.
     * @param channel The value for channel 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannel(SlackChannel channel) {
      this.channel = Objects.requireNonNull(channel, "channel");
      initBits &= ~INIT_BIT_CHANNEL;
      return this;
    }

    /**
     * Initializes the value for the {@link MessageActionIF#getUser() user} attribute.
     * @param user The value for user 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUser(SlackUserLite user) {
      this.user = Objects.requireNonNull(user, "user");
      initBits &= ~INIT_BIT_USER;
      return this;
    }

    /**
     * Builds a new {@link MessageAction MessageAction}.
     * @return An immutable instance of MessageAction
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public MessageAction build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new MessageAction(triggerId, responseUrl, message, type, callbackId, actionTs, token, team, channel, user);
    }

    private boolean triggerIdIsSet() {
      return (initBits & INIT_BIT_TRIGGER_ID) == 0;
    }

    private boolean responseUrlIsSet() {
      return (initBits & INIT_BIT_RESPONSE_URL) == 0;
    }

    private boolean messageIsSet() {
      return (initBits & INIT_BIT_MESSAGE) == 0;
    }

    private boolean typeIsSet() {
      return (initBits & INIT_BIT_TYPE) == 0;
    }

    private boolean callbackIdIsSet() {
      return (initBits & INIT_BIT_CALLBACK_ID) == 0;
    }

    private boolean actionTsIsSet() {
      return (initBits & INIT_BIT_ACTION_TS) == 0;
    }

    private boolean tokenIsSet() {
      return (initBits & INIT_BIT_TOKEN) == 0;
    }

    private boolean teamIsSet() {
      return (initBits & INIT_BIT_TEAM) == 0;
    }

    private boolean channelIsSet() {
      return (initBits & INIT_BIT_CHANNEL) == 0;
    }

    private boolean userIsSet() {
      return (initBits & INIT_BIT_USER) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!triggerIdIsSet()) attributes.add("triggerId");
      if (!responseUrlIsSet()) attributes.add("responseUrl");
      if (!messageIsSet()) attributes.add("message");
      if (!typeIsSet()) attributes.add("type");
      if (!callbackIdIsSet()) attributes.add("callbackId");
      if (!actionTsIsSet()) attributes.add("actionTs");
      if (!tokenIsSet()) attributes.add("token");
      if (!teamIsSet()) attributes.add("team");
      if (!channelIsSet()) attributes.add("channel");
      if (!userIsSet()) attributes.add("user");
      return "Cannot build MessageAction, some of required attributes are not set " + attributes;
    }
  }
}
