package com.hubspot.slack.client.models.response;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link PagingIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code Paging.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "PagingIF"})
@Immutable
public final class Paging implements PagingIF {
  private final int count;
  private final int total;
  private final int page;
  private final int pages;

  private Paging(int count, int total, int page, int pages) {
    this.count = count;
    this.total = total;
    this.page = page;
    this.pages = pages;
  }

  /**
   * @return The value of the {@code count} attribute
   */
  @JsonProperty
  @Override
  public int getCount() {
    return count;
  }

  /**
   * @return The value of the {@code total} attribute
   */
  @JsonProperty
  @Override
  public int getTotal() {
    return total;
  }

  /**
   * @return The value of the {@code page} attribute
   */
  @JsonProperty
  @Override
  public int getPage() {
    return page;
  }

  /**
   * @return The value of the {@code pages} attribute
   */
  @JsonProperty
  @Override
  public int getPages() {
    return pages;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PagingIF#getCount() count} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param count A new value for count
   * @return A modified copy of the {@code this} object
   */
  public final Paging withCount(int count) {
    if (this.count == count) return this;
    return new Paging(count, this.total, this.page, this.pages);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PagingIF#getTotal() total} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param total A new value for total
   * @return A modified copy of the {@code this} object
   */
  public final Paging withTotal(int total) {
    if (this.total == total) return this;
    return new Paging(this.count, total, this.page, this.pages);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PagingIF#getPage() page} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param page A new value for page
   * @return A modified copy of the {@code this} object
   */
  public final Paging withPage(int page) {
    if (this.page == page) return this;
    return new Paging(this.count, this.total, page, this.pages);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link PagingIF#getPages() pages} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param pages A new value for pages
   * @return A modified copy of the {@code this} object
   */
  public final Paging withPages(int pages) {
    if (this.pages == pages) return this;
    return new Paging(this.count, this.total, this.page, pages);
  }

  /**
   * This instance is equal to all instances of {@code Paging} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof Paging
        && equalTo((Paging) another);
  }

  private boolean equalTo(Paging another) {
    return count == another.count
        && total == another.total
        && page == another.page
        && pages == another.pages;
  }

  /**
   * Computes a hash code from attributes: {@code count}, {@code total}, {@code page}, {@code pages}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + count;
    h = h * 17 + total;
    h = h * 17 + page;
    h = h * 17 + pages;
    return h;
  }

  /**
   * Prints the immutable value {@code Paging} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "Paging{"
        + "count=" + count
        + ", total=" + total
        + ", page=" + page
        + ", pages=" + pages
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements PagingIF {
    int count;
    boolean countIsSet;
    int total;
    boolean totalIsSet;
    int page;
    boolean pageIsSet;
    int pages;
    boolean pagesIsSet;
    @JsonProperty
    public void setCount(int count) {
      this.count = count;
      this.countIsSet = true;
    }
    @JsonProperty
    public void setTotal(int total) {
      this.total = total;
      this.totalIsSet = true;
    }
    @JsonProperty
    public void setPage(int page) {
      this.page = page;
      this.pageIsSet = true;
    }
    @JsonProperty
    public void setPages(int pages) {
      this.pages = pages;
      this.pagesIsSet = true;
    }
    @Override
    public int getCount() { throw new UnsupportedOperationException(); }
    @Override
    public int getTotal() { throw new UnsupportedOperationException(); }
    @Override
    public int getPage() { throw new UnsupportedOperationException(); }
    @Override
    public int getPages() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static Paging fromJson(Json json) {
    Paging.Builder builder = Paging.builder();
    if (json.countIsSet) {
      builder.setCount(json.count);
    }
    if (json.totalIsSet) {
      builder.setTotal(json.total);
    }
    if (json.pageIsSet) {
      builder.setPage(json.page);
    }
    if (json.pagesIsSet) {
      builder.setPages(json.pages);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link PagingIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Paging instance
   */
  public static Paging copyOf(PagingIF instance) {
    if (instance instanceof Paging) {
      return (Paging) instance;
    }
    return Paging.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link Paging Paging}.
   * @return A new Paging builder
   */
  public static Paging.Builder builder() {
    return new Paging.Builder();
  }

  /**
   * Builds instances of type {@link Paging Paging}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_COUNT = 0x1L;
    private static final long INIT_BIT_TOTAL = 0x2L;
    private static final long INIT_BIT_PAGE = 0x4L;
    private static final long INIT_BIT_PAGES = 0x8L;
    private long initBits = 0xfL;

    private int count;
    private int total;
    private int page;
    private int pages;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code PagingIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(PagingIF instance) {
      Objects.requireNonNull(instance, "instance");
      setCount(instance.getCount());
      setTotal(instance.getTotal());
      setPage(instance.getPage());
      setPages(instance.getPages());
      return this;
    }

    /**
     * Initializes the value for the {@link PagingIF#getCount() count} attribute.
     * @param count The value for count 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setCount(int count) {
      this.count = count;
      initBits &= ~INIT_BIT_COUNT;
      return this;
    }

    /**
     * Initializes the value for the {@link PagingIF#getTotal() total} attribute.
     * @param total The value for total 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTotal(int total) {
      this.total = total;
      initBits &= ~INIT_BIT_TOTAL;
      return this;
    }

    /**
     * Initializes the value for the {@link PagingIF#getPage() page} attribute.
     * @param page The value for page 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setPage(int page) {
      this.page = page;
      initBits &= ~INIT_BIT_PAGE;
      return this;
    }

    /**
     * Initializes the value for the {@link PagingIF#getPages() pages} attribute.
     * @param pages The value for pages 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setPages(int pages) {
      this.pages = pages;
      initBits &= ~INIT_BIT_PAGES;
      return this;
    }

    /**
     * Builds a new {@link Paging Paging}.
     * @return An immutable instance of Paging
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public Paging build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new Paging(count, total, page, pages);
    }

    private boolean countIsSet() {
      return (initBits & INIT_BIT_COUNT) == 0;
    }

    private boolean totalIsSet() {
      return (initBits & INIT_BIT_TOTAL) == 0;
    }

    private boolean pageIsSet() {
      return (initBits & INIT_BIT_PAGE) == 0;
    }

    private boolean pagesIsSet() {
      return (initBits & INIT_BIT_PAGES) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!countIsSet()) attributes.add("count");
      if (!totalIsSet()) attributes.add("total");
      if (!pageIsSet()) attributes.add("page");
      if (!pagesIsSet()) attributes.add("pages");
      return "Cannot build Paging, some of required attributes are not set " + attributes;
    }
  }
}
