package com.hubspot.slack.client.models.response.auth;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.response.*;
import com.hubspot.slack.client.models.response.SlackResponse;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link AuthTestResponseIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code AuthTestResponse.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "AuthTestResponseIF"})
@Immutable
public final class AuthTestResponse
    implements AuthTestResponseIF {
  private final String url;
  private final String team;
  private final String teamId;
  private final @Nullable String user;
  private final @Nullable String userId;
  private final boolean ok;
  private final @Nullable ResponseMetadata responseMetadata;

  private AuthTestResponse(
      String url,
      String team,
      String teamId,
      @Nullable String user,
      @Nullable String userId,
      boolean ok,
      @Nullable ResponseMetadata responseMetadata) {
    this.url = url;
    this.team = team;
    this.teamId = teamId;
    this.user = user;
    this.userId = userId;
    this.ok = ok;
    this.responseMetadata = responseMetadata;
  }

  /**
   * @return The value of the {@code url} attribute
   */
  @JsonProperty
  @Override
  public String getUrl() {
    return url;
  }

  /**
   * @return The value of the {@code team} attribute
   */
  @JsonProperty
  @Override
  public String getTeam() {
    return team;
  }

  /**
   * @return The value of the {@code teamId} attribute
   */
  @JsonProperty
  @Override
  public String getTeamId() {
    return teamId;
  }

  /**
   * @return The value of the {@code user} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getUser() {
    return Optional.ofNullable(user);
  }

  /**
   * @return The value of the {@code userId} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getUserId() {
    return Optional.ofNullable(userId);
  }

  /**
   * @return The value of the {@code ok} attribute
   */
  @JsonProperty
  @Override
  public boolean isOk() {
    return ok;
  }

  /**
   * @return The value of the {@code responseMetadata} attribute
   */
  @JsonProperty
  @Override
  public Optional<ResponseMetadata> getResponseMetadata() {
    return Optional.ofNullable(responseMetadata);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AuthTestResponseIF#getUrl() url} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param url A new value for url
   * @return A modified copy of the {@code this} object
   */
  public final AuthTestResponse withUrl(String url) {
    if (this.url.equals(url)) return this;
    String newValue = Objects.requireNonNull(url, "url");
    return new AuthTestResponse(newValue, this.team, this.teamId, this.user, this.userId, this.ok, this.responseMetadata);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AuthTestResponseIF#getTeam() team} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param team A new value for team
   * @return A modified copy of the {@code this} object
   */
  public final AuthTestResponse withTeam(String team) {
    if (this.team.equals(team)) return this;
    String newValue = Objects.requireNonNull(team, "team");
    return new AuthTestResponse(this.url, newValue, this.teamId, this.user, this.userId, this.ok, this.responseMetadata);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AuthTestResponseIF#getTeamId() teamId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param teamId A new value for teamId
   * @return A modified copy of the {@code this} object
   */
  public final AuthTestResponse withTeamId(String teamId) {
    if (this.teamId.equals(teamId)) return this;
    String newValue = Objects.requireNonNull(teamId, "teamId");
    return new AuthTestResponse(this.url, this.team, newValue, this.user, this.userId, this.ok, this.responseMetadata);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AuthTestResponseIF#getUser() user} attribute.
   * @param value The value for user, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final AuthTestResponse withUser(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.user, newValue)) return this;
    return new AuthTestResponse(this.url, this.team, this.teamId, newValue, this.userId, this.ok, this.responseMetadata);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AuthTestResponseIF#getUser() user} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for user
   * @return A modified copy of {@code this} object
   */
  public final AuthTestResponse withUser(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.user, value)) return this;
    return new AuthTestResponse(this.url, this.team, this.teamId, value, this.userId, this.ok, this.responseMetadata);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AuthTestResponseIF#getUserId() userId} attribute.
   * @param value The value for userId, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final AuthTestResponse withUserId(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.userId, newValue)) return this;
    return new AuthTestResponse(this.url, this.team, this.teamId, this.user, newValue, this.ok, this.responseMetadata);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AuthTestResponseIF#getUserId() userId} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for userId
   * @return A modified copy of {@code this} object
   */
  public final AuthTestResponse withUserId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.userId, value)) return this;
    return new AuthTestResponse(this.url, this.team, this.teamId, this.user, value, this.ok, this.responseMetadata);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link AuthTestResponseIF#isOk() ok} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param ok A new value for ok
   * @return A modified copy of the {@code this} object
   */
  public final AuthTestResponse withOk(boolean ok) {
    if (this.ok == ok) return this;
    return new AuthTestResponse(this.url, this.team, this.teamId, this.user, this.userId, ok, this.responseMetadata);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link AuthTestResponseIF#getResponseMetadata() responseMetadata} attribute.
   * @param value The value for responseMetadata, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final AuthTestResponse withResponseMetadata(@Nullable ResponseMetadata value) {
    @Nullable ResponseMetadata newValue = value;
    if (this.responseMetadata == newValue) return this;
    return new AuthTestResponse(this.url, this.team, this.teamId, this.user, this.userId, this.ok, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link AuthTestResponseIF#getResponseMetadata() responseMetadata} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for responseMetadata
   * @return A modified copy of {@code this} object
   */
  public final AuthTestResponse withResponseMetadata(Optional<ResponseMetadata> optional) {
    @Nullable ResponseMetadata value = optional.orElse(null);
    if (this.responseMetadata == value) return this;
    return new AuthTestResponse(this.url, this.team, this.teamId, this.user, this.userId, this.ok, value);
  }

  /**
   * This instance is equal to all instances of {@code AuthTestResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof AuthTestResponse
        && equalTo((AuthTestResponse) another);
  }

  private boolean equalTo(AuthTestResponse another) {
    return url.equals(another.url)
        && team.equals(another.team)
        && teamId.equals(another.teamId)
        && Objects.equals(user, another.user)
        && Objects.equals(userId, another.userId)
        && ok == another.ok
        && Objects.equals(responseMetadata, another.responseMetadata);
  }

  /**
   * Computes a hash code from attributes: {@code url}, {@code team}, {@code teamId}, {@code user}, {@code userId}, {@code ok}, {@code responseMetadata}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + url.hashCode();
    h = h * 17 + team.hashCode();
    h = h * 17 + teamId.hashCode();
    h = h * 17 + Objects.hashCode(user);
    h = h * 17 + Objects.hashCode(userId);
    h = h * 17 + Boolean.hashCode(ok);
    h = h * 17 + Objects.hashCode(responseMetadata);
    return h;
  }

  /**
   * Prints the immutable value {@code AuthTestResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("AuthTestResponse{");
    builder.append("url=").append(url);
    builder.append(", ");
    builder.append("team=").append(team);
    builder.append(", ");
    builder.append("teamId=").append(teamId);
    if (user != null) {
      builder.append(", ");
      builder.append("user=").append(user);
    }
    if (userId != null) {
      builder.append(", ");
      builder.append("userId=").append(userId);
    }
    builder.append(", ");
    builder.append("ok=").append(ok);
    if (responseMetadata != null) {
      builder.append(", ");
      builder.append("responseMetadata=").append(responseMetadata);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements AuthTestResponseIF {
    @Nullable String url;
    @Nullable String team;
    @Nullable String teamId;
    Optional<String> user = Optional.empty();
    Optional<String> userId = Optional.empty();
    boolean ok;
    boolean okIsSet;
    Optional<ResponseMetadata> responseMetadata = Optional.empty();
    @JsonProperty
    public void setUrl(String url) {
      this.url = url;
    }
    @JsonProperty
    public void setTeam(String team) {
      this.team = team;
    }
    @JsonProperty
    public void setTeamId(String teamId) {
      this.teamId = teamId;
    }
    @JsonProperty
    public void setUser(Optional<String> user) {
      this.user = user;
    }
    @JsonProperty
    public void setUserId(Optional<String> userId) {
      this.userId = userId;
    }
    @JsonProperty
    public void setOk(boolean ok) {
      this.ok = ok;
      this.okIsSet = true;
    }
    @JsonProperty
    public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
      this.responseMetadata = responseMetadata;
    }
    @Override
    public String getUrl() { throw new UnsupportedOperationException(); }
    @Override
    public String getTeam() { throw new UnsupportedOperationException(); }
    @Override
    public String getTeamId() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getUser() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getUserId() { throw new UnsupportedOperationException(); }
    @Override
    public boolean isOk() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<ResponseMetadata> getResponseMetadata() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static AuthTestResponse fromJson(Json json) {
    AuthTestResponse.Builder builder = AuthTestResponse.builder();
    if (json.url != null) {
      builder.setUrl(json.url);
    }
    if (json.team != null) {
      builder.setTeam(json.team);
    }
    if (json.teamId != null) {
      builder.setTeamId(json.teamId);
    }
    if (json.user != null) {
      builder.setUser(json.user);
    }
    if (json.userId != null) {
      builder.setUserId(json.userId);
    }
    if (json.okIsSet) {
      builder.setOk(json.ok);
    }
    if (json.responseMetadata != null) {
      builder.setResponseMetadata(json.responseMetadata);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link AuthTestResponseIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable AuthTestResponse instance
   */
  public static AuthTestResponse copyOf(AuthTestResponseIF instance) {
    if (instance instanceof AuthTestResponse) {
      return (AuthTestResponse) instance;
    }
    return AuthTestResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link AuthTestResponse AuthTestResponse}.
   * @return A new AuthTestResponse builder
   */
  public static AuthTestResponse.Builder builder() {
    return new AuthTestResponse.Builder();
  }

  /**
   * Builds instances of type {@link AuthTestResponse AuthTestResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_URL = 0x1L;
    private static final long INIT_BIT_TEAM = 0x2L;
    private static final long INIT_BIT_TEAM_ID = 0x4L;
    private static final long INIT_BIT_OK = 0x8L;
    private long initBits = 0xfL;

    private @Nullable String url;
    private @Nullable String team;
    private @Nullable String teamId;
    private @Nullable String user;
    private @Nullable String userId;
    private boolean ok;
    private @Nullable ResponseMetadata responseMetadata;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.response.SlackResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.response.auth.AuthTestResponseIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(AuthTestResponseIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof SlackResponse) {
        SlackResponse instance = (SlackResponse) object;
        setOk(instance.isOk());
        Optional<ResponseMetadata> responseMetadataOptional = instance.getResponseMetadata();
        if (responseMetadataOptional.isPresent()) {
          setResponseMetadata(responseMetadataOptional);
        }
      }
      if (object instanceof AuthTestResponseIF) {
        AuthTestResponseIF instance = (AuthTestResponseIF) object;
        setTeam(instance.getTeam());
        Optional<String> userOptional = instance.getUser();
        if (userOptional.isPresent()) {
          setUser(userOptional);
        }
        Optional<String> userIdOptional = instance.getUserId();
        if (userIdOptional.isPresent()) {
          setUserId(userIdOptional);
        }
        setUrl(instance.getUrl());
        setTeamId(instance.getTeamId());
      }
    }

    /**
     * Initializes the value for the {@link AuthTestResponseIF#getUrl() url} attribute.
     * @param url The value for url 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUrl(String url) {
      this.url = Objects.requireNonNull(url, "url");
      initBits &= ~INIT_BIT_URL;
      return this;
    }

    /**
     * Initializes the value for the {@link AuthTestResponseIF#getTeam() team} attribute.
     * @param team The value for team 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTeam(String team) {
      this.team = Objects.requireNonNull(team, "team");
      initBits &= ~INIT_BIT_TEAM;
      return this;
    }

    /**
     * Initializes the value for the {@link AuthTestResponseIF#getTeamId() teamId} attribute.
     * @param teamId The value for teamId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTeamId(String teamId) {
      this.teamId = Objects.requireNonNull(teamId, "teamId");
      initBits &= ~INIT_BIT_TEAM_ID;
      return this;
    }

    /**
     * Initializes the optional value {@link AuthTestResponseIF#getUser() user} to user.
     * @param user The value for user, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setUser(@Nullable String user) {
      this.user = user;
      return this;
    }

    /**
     * Initializes the optional value {@link AuthTestResponseIF#getUser() user} to user.
     * @param user The value for user
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUser(Optional<String> user) {
      this.user = user.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link AuthTestResponseIF#getUserId() userId} to userId.
     * @param userId The value for userId, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setUserId(@Nullable String userId) {
      this.userId = userId;
      return this;
    }

    /**
     * Initializes the optional value {@link AuthTestResponseIF#getUserId() userId} to userId.
     * @param userId The value for userId
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUserId(Optional<String> userId) {
      this.userId = userId.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link AuthTestResponseIF#isOk() ok} attribute.
     * @param ok The value for ok 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setOk(boolean ok) {
      this.ok = ok;
      initBits &= ~INIT_BIT_OK;
      return this;
    }

    /**
     * Initializes the optional value {@link AuthTestResponseIF#getResponseMetadata() responseMetadata} to responseMetadata.
     * @param responseMetadata The value for responseMetadata, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
      this.responseMetadata = responseMetadata;
      return this;
    }

    /**
     * Initializes the optional value {@link AuthTestResponseIF#getResponseMetadata() responseMetadata} to responseMetadata.
     * @param responseMetadata The value for responseMetadata
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
      this.responseMetadata = responseMetadata.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link AuthTestResponse AuthTestResponse}.
     * @return An immutable instance of AuthTestResponse
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public AuthTestResponse build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new AuthTestResponse(url, team, teamId, user, userId, ok, responseMetadata);
    }

    private boolean urlIsSet() {
      return (initBits & INIT_BIT_URL) == 0;
    }

    private boolean teamIsSet() {
      return (initBits & INIT_BIT_TEAM) == 0;
    }

    private boolean teamIdIsSet() {
      return (initBits & INIT_BIT_TEAM_ID) == 0;
    }

    private boolean okIsSet() {
      return (initBits & INIT_BIT_OK) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!urlIsSet()) attributes.add("url");
      if (!teamIsSet()) attributes.add("team");
      if (!teamIdIsSet()) attributes.add("teamId");
      if (!okIsSet()) attributes.add("ok");
      return "Cannot build AuthTestResponse, some of required attributes are not set " + attributes;
    }
  }
}
