package com.hubspot.slack.client.models.response.chat;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.response.*;
import com.hubspot.slack.client.models.response.SlackResponse;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ChatDeleteResponseIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ChatDeleteResponse.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ChatDeleteResponseIF"})
@Immutable
public final class ChatDeleteResponse
    implements ChatDeleteResponseIF {
  private final String channelId;
  private final String deletedMessageTs;
  private final boolean ok;
  private final @Nullable ResponseMetadata responseMetadata;

  private ChatDeleteResponse(
      String channelId,
      String deletedMessageTs,
      boolean ok,
      @Nullable ResponseMetadata responseMetadata) {
    this.channelId = channelId;
    this.deletedMessageTs = deletedMessageTs;
    this.ok = ok;
    this.responseMetadata = responseMetadata;
  }

  /**
   * @return The value of the {@code channelId} attribute
   */
  @JsonProperty("channel")
  @Override
  public String getChannelId() {
    return channelId;
  }

  /**
   * @return The value of the {@code deletedMessageTs} attribute
   */
  @JsonProperty("ts")
  @Override
  public String getDeletedMessageTs() {
    return deletedMessageTs;
  }

  /**
   * @return The value of the {@code ok} attribute
   */
  @JsonProperty
  @Override
  public boolean isOk() {
    return ok;
  }

  /**
   * @return The value of the {@code responseMetadata} attribute
   */
  @JsonProperty
  @Override
  public Optional<ResponseMetadata> getResponseMetadata() {
    return Optional.ofNullable(responseMetadata);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ChatDeleteResponseIF#getChannelId() channelId} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param channelId A new value for channelId
   * @return A modified copy of the {@code this} object
   */
  public final ChatDeleteResponse withChannelId(String channelId) {
    if (this.channelId.equals(channelId)) return this;
    String newValue = Objects.requireNonNull(channelId, "channelId");
    return new ChatDeleteResponse(newValue, this.deletedMessageTs, this.ok, this.responseMetadata);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ChatDeleteResponseIF#getDeletedMessageTs() deletedMessageTs} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param deletedMessageTs A new value for deletedMessageTs
   * @return A modified copy of the {@code this} object
   */
  public final ChatDeleteResponse withDeletedMessageTs(String deletedMessageTs) {
    if (this.deletedMessageTs.equals(deletedMessageTs)) return this;
    String newValue = Objects.requireNonNull(deletedMessageTs, "deletedMessageTs");
    return new ChatDeleteResponse(this.channelId, newValue, this.ok, this.responseMetadata);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ChatDeleteResponseIF#isOk() ok} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param ok A new value for ok
   * @return A modified copy of the {@code this} object
   */
  public final ChatDeleteResponse withOk(boolean ok) {
    if (this.ok == ok) return this;
    return new ChatDeleteResponse(this.channelId, this.deletedMessageTs, ok, this.responseMetadata);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ChatDeleteResponseIF#getResponseMetadata() responseMetadata} attribute.
   * @param value The value for responseMetadata, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ChatDeleteResponse withResponseMetadata(@Nullable ResponseMetadata value) {
    @Nullable ResponseMetadata newValue = value;
    if (this.responseMetadata == newValue) return this;
    return new ChatDeleteResponse(this.channelId, this.deletedMessageTs, this.ok, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ChatDeleteResponseIF#getResponseMetadata() responseMetadata} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for responseMetadata
   * @return A modified copy of {@code this} object
   */
  public final ChatDeleteResponse withResponseMetadata(Optional<ResponseMetadata> optional) {
    @Nullable ResponseMetadata value = optional.orElse(null);
    if (this.responseMetadata == value) return this;
    return new ChatDeleteResponse(this.channelId, this.deletedMessageTs, this.ok, value);
  }

  /**
   * This instance is equal to all instances of {@code ChatDeleteResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ChatDeleteResponse
        && equalTo((ChatDeleteResponse) another);
  }

  private boolean equalTo(ChatDeleteResponse another) {
    return channelId.equals(another.channelId)
        && deletedMessageTs.equals(another.deletedMessageTs)
        && ok == another.ok
        && Objects.equals(responseMetadata, another.responseMetadata);
  }

  /**
   * Computes a hash code from attributes: {@code channelId}, {@code deletedMessageTs}, {@code ok}, {@code responseMetadata}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + channelId.hashCode();
    h = h * 17 + deletedMessageTs.hashCode();
    h = h * 17 + Boolean.hashCode(ok);
    h = h * 17 + Objects.hashCode(responseMetadata);
    return h;
  }

  /**
   * Prints the immutable value {@code ChatDeleteResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("ChatDeleteResponse{");
    builder.append("channelId=").append(channelId);
    builder.append(", ");
    builder.append("deletedMessageTs=").append(deletedMessageTs);
    builder.append(", ");
    builder.append("ok=").append(ok);
    if (responseMetadata != null) {
      builder.append(", ");
      builder.append("responseMetadata=").append(responseMetadata);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ChatDeleteResponseIF {
    @Nullable String channelId;
    @Nullable String deletedMessageTs;
    boolean ok;
    boolean okIsSet;
    Optional<ResponseMetadata> responseMetadata = Optional.empty();
    @JsonProperty("channel")
    public void setChannelId(String channelId) {
      this.channelId = channelId;
    }
    @JsonProperty("ts")
    public void setDeletedMessageTs(String deletedMessageTs) {
      this.deletedMessageTs = deletedMessageTs;
    }
    @JsonProperty
    public void setOk(boolean ok) {
      this.ok = ok;
      this.okIsSet = true;
    }
    @JsonProperty
    public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
      this.responseMetadata = responseMetadata;
    }
    @Override
    public String getChannelId() { throw new UnsupportedOperationException(); }
    @Override
    public String getDeletedMessageTs() { throw new UnsupportedOperationException(); }
    @Override
    public boolean isOk() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<ResponseMetadata> getResponseMetadata() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ChatDeleteResponse fromJson(Json json) {
    ChatDeleteResponse.Builder builder = ChatDeleteResponse.builder();
    if (json.channelId != null) {
      builder.setChannelId(json.channelId);
    }
    if (json.deletedMessageTs != null) {
      builder.setDeletedMessageTs(json.deletedMessageTs);
    }
    if (json.okIsSet) {
      builder.setOk(json.ok);
    }
    if (json.responseMetadata != null) {
      builder.setResponseMetadata(json.responseMetadata);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ChatDeleteResponseIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ChatDeleteResponse instance
   */
  public static ChatDeleteResponse copyOf(ChatDeleteResponseIF instance) {
    if (instance instanceof ChatDeleteResponse) {
      return (ChatDeleteResponse) instance;
    }
    return ChatDeleteResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ChatDeleteResponse ChatDeleteResponse}.
   * @return A new ChatDeleteResponse builder
   */
  public static ChatDeleteResponse.Builder builder() {
    return new ChatDeleteResponse.Builder();
  }

  /**
   * Builds instances of type {@link ChatDeleteResponse ChatDeleteResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CHANNEL_ID = 0x1L;
    private static final long INIT_BIT_DELETED_MESSAGE_TS = 0x2L;
    private static final long INIT_BIT_OK = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String channelId;
    private @Nullable String deletedMessageTs;
    private boolean ok;
    private @Nullable ResponseMetadata responseMetadata;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.response.SlackResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.response.chat.ChatDeleteResponseIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ChatDeleteResponseIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof SlackResponse) {
        SlackResponse instance = (SlackResponse) object;
        setOk(instance.isOk());
        Optional<ResponseMetadata> responseMetadataOptional = instance.getResponseMetadata();
        if (responseMetadataOptional.isPresent()) {
          setResponseMetadata(responseMetadataOptional);
        }
      }
      if (object instanceof ChatDeleteResponseIF) {
        ChatDeleteResponseIF instance = (ChatDeleteResponseIF) object;
        setDeletedMessageTs(instance.getDeletedMessageTs());
        setChannelId(instance.getChannelId());
      }
    }

    /**
     * Initializes the value for the {@link ChatDeleteResponseIF#getChannelId() channelId} attribute.
     * @param channelId The value for channelId 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannelId(String channelId) {
      this.channelId = Objects.requireNonNull(channelId, "channelId");
      initBits &= ~INIT_BIT_CHANNEL_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ChatDeleteResponseIF#getDeletedMessageTs() deletedMessageTs} attribute.
     * @param deletedMessageTs The value for deletedMessageTs 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setDeletedMessageTs(String deletedMessageTs) {
      this.deletedMessageTs = Objects.requireNonNull(deletedMessageTs, "deletedMessageTs");
      initBits &= ~INIT_BIT_DELETED_MESSAGE_TS;
      return this;
    }

    /**
     * Initializes the value for the {@link ChatDeleteResponseIF#isOk() ok} attribute.
     * @param ok The value for ok 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setOk(boolean ok) {
      this.ok = ok;
      initBits &= ~INIT_BIT_OK;
      return this;
    }

    /**
     * Initializes the optional value {@link ChatDeleteResponseIF#getResponseMetadata() responseMetadata} to responseMetadata.
     * @param responseMetadata The value for responseMetadata, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
      this.responseMetadata = responseMetadata;
      return this;
    }

    /**
     * Initializes the optional value {@link ChatDeleteResponseIF#getResponseMetadata() responseMetadata} to responseMetadata.
     * @param responseMetadata The value for responseMetadata
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
      this.responseMetadata = responseMetadata.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ChatDeleteResponse ChatDeleteResponse}.
     * @return An immutable instance of ChatDeleteResponse
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ChatDeleteResponse build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new ChatDeleteResponse(channelId, deletedMessageTs, ok, responseMetadata);
    }

    private boolean channelIdIsSet() {
      return (initBits & INIT_BIT_CHANNEL_ID) == 0;
    }

    private boolean deletedMessageTsIsSet() {
      return (initBits & INIT_BIT_DELETED_MESSAGE_TS) == 0;
    }

    private boolean okIsSet() {
      return (initBits & INIT_BIT_OK) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!channelIdIsSet()) attributes.add("channelId");
      if (!deletedMessageTsIsSet()) attributes.add("deletedMessageTs");
      if (!okIsSet()) attributes.add("ok");
      return "Cannot build ChatDeleteResponse, some of required attributes are not set " + attributes;
    }
  }
}
