package com.hubspot.slack.client.models.response.chat;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.response.*;
import com.hubspot.slack.client.models.response.SlackResponse;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ChatPostMessageResponseIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ChatPostMessageResponse.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ChatPostMessageResponseIF"})
@Immutable
public final class ChatPostMessageResponse
    implements ChatPostMessageResponseIF {
  private final String ts;
  private final String channel;
  private final Map<String, Object> message;
  private final boolean ok;
  private final @Nullable ResponseMetadata responseMetadata;

  private ChatPostMessageResponse(
      String ts,
      String channel,
      Map<String, Object> message,
      boolean ok,
      @Nullable ResponseMetadata responseMetadata) {
    this.ts = ts;
    this.channel = channel;
    this.message = message;
    this.ok = ok;
    this.responseMetadata = responseMetadata;
  }

  /**
   * @return The value of the {@code ts} attribute
   */
  @JsonProperty
  @Override
  public String getTs() {
    return ts;
  }

  /**
   * @return The value of the {@code channel} attribute
   */
  @JsonProperty
  @Override
  public String getChannel() {
    return channel;
  }

  /**
   * @return The value of the {@code message} attribute
   */
  @JsonProperty
  @Override
  public Map<String, Object> getMessage() {
    return message;
  }

  /**
   * @return The value of the {@code ok} attribute
   */
  @JsonProperty
  @Override
  public boolean isOk() {
    return ok;
  }

  /**
   * @return The value of the {@code responseMetadata} attribute
   */
  @JsonProperty
  @Override
  public Optional<ResponseMetadata> getResponseMetadata() {
    return Optional.ofNullable(responseMetadata);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ChatPostMessageResponseIF#getTs() ts} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param ts A new value for ts
   * @return A modified copy of the {@code this} object
   */
  public final ChatPostMessageResponse withTs(String ts) {
    if (this.ts.equals(ts)) return this;
    String newValue = Objects.requireNonNull(ts, "ts");
    return new ChatPostMessageResponse(newValue, this.channel, this.message, this.ok, this.responseMetadata);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ChatPostMessageResponseIF#getChannel() channel} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param channel A new value for channel
   * @return A modified copy of the {@code this} object
   */
  public final ChatPostMessageResponse withChannel(String channel) {
    if (this.channel.equals(channel)) return this;
    String newValue = Objects.requireNonNull(channel, "channel");
    return new ChatPostMessageResponse(this.ts, newValue, this.message, this.ok, this.responseMetadata);
  }

  /**
   * Copy the current immutable object by replacing the {@link ChatPostMessageResponseIF#getMessage() message} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param message The entries to be added to the message map
   * @return A modified copy of {@code this} object
   */
  public final ChatPostMessageResponse withMessage(Map<String, ? extends Object> message) {
    if (this.message == message) return this;
    Map<String, Object> newValue = createUnmodifiableMap(true, false, message);
    return new ChatPostMessageResponse(this.ts, this.channel, newValue, this.ok, this.responseMetadata);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ChatPostMessageResponseIF#isOk() ok} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param ok A new value for ok
   * @return A modified copy of the {@code this} object
   */
  public final ChatPostMessageResponse withOk(boolean ok) {
    if (this.ok == ok) return this;
    return new ChatPostMessageResponse(this.ts, this.channel, this.message, ok, this.responseMetadata);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ChatPostMessageResponseIF#getResponseMetadata() responseMetadata} attribute.
   * @param value The value for responseMetadata, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ChatPostMessageResponse withResponseMetadata(@Nullable ResponseMetadata value) {
    @Nullable ResponseMetadata newValue = value;
    if (this.responseMetadata == newValue) return this;
    return new ChatPostMessageResponse(this.ts, this.channel, this.message, this.ok, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ChatPostMessageResponseIF#getResponseMetadata() responseMetadata} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for responseMetadata
   * @return A modified copy of {@code this} object
   */
  public final ChatPostMessageResponse withResponseMetadata(Optional<ResponseMetadata> optional) {
    @Nullable ResponseMetadata value = optional.orElse(null);
    if (this.responseMetadata == value) return this;
    return new ChatPostMessageResponse(this.ts, this.channel, this.message, this.ok, value);
  }

  /**
   * This instance is equal to all instances of {@code ChatPostMessageResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ChatPostMessageResponse
        && equalTo((ChatPostMessageResponse) another);
  }

  private boolean equalTo(ChatPostMessageResponse another) {
    return ts.equals(another.ts)
        && channel.equals(another.channel)
        && message.equals(another.message)
        && ok == another.ok
        && Objects.equals(responseMetadata, another.responseMetadata);
  }

  /**
   * Computes a hash code from attributes: {@code ts}, {@code channel}, {@code message}, {@code ok}, {@code responseMetadata}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + ts.hashCode();
    h = h * 17 + channel.hashCode();
    h = h * 17 + message.hashCode();
    h = h * 17 + Boolean.hashCode(ok);
    h = h * 17 + Objects.hashCode(responseMetadata);
    return h;
  }

  /**
   * Prints the immutable value {@code ChatPostMessageResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("ChatPostMessageResponse{");
    builder.append("ts=").append(ts);
    builder.append(", ");
    builder.append("channel=").append(channel);
    builder.append(", ");
    builder.append("message=").append(message);
    builder.append(", ");
    builder.append("ok=").append(ok);
    if (responseMetadata != null) {
      builder.append(", ");
      builder.append("responseMetadata=").append(responseMetadata);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ChatPostMessageResponseIF {
    @Nullable String ts;
    @Nullable String channel;
    @Nullable Map<String, Object> message;
    boolean ok;
    boolean okIsSet;
    Optional<ResponseMetadata> responseMetadata = Optional.empty();
    @JsonProperty
    public void setTs(String ts) {
      this.ts = ts;
    }
    @JsonProperty
    public void setChannel(String channel) {
      this.channel = channel;
    }
    @JsonProperty
    public void setMessage(Map<String, Object> message) {
      this.message = message;
    }
    @JsonProperty
    public void setOk(boolean ok) {
      this.ok = ok;
      this.okIsSet = true;
    }
    @JsonProperty
    public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
      this.responseMetadata = responseMetadata;
    }
    @Override
    public String getTs() { throw new UnsupportedOperationException(); }
    @Override
    public String getChannel() { throw new UnsupportedOperationException(); }
    @Override
    public Map<String, Object> getMessage() { throw new UnsupportedOperationException(); }
    @Override
    public boolean isOk() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<ResponseMetadata> getResponseMetadata() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ChatPostMessageResponse fromJson(Json json) {
    ChatPostMessageResponse.Builder builder = ChatPostMessageResponse.builder();
    if (json.ts != null) {
      builder.setTs(json.ts);
    }
    if (json.channel != null) {
      builder.setChannel(json.channel);
    }
    if (json.message != null) {
      builder.putAllMessage(json.message);
    }
    if (json.okIsSet) {
      builder.setOk(json.ok);
    }
    if (json.responseMetadata != null) {
      builder.setResponseMetadata(json.responseMetadata);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ChatPostMessageResponseIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ChatPostMessageResponse instance
   */
  public static ChatPostMessageResponse copyOf(ChatPostMessageResponseIF instance) {
    if (instance instanceof ChatPostMessageResponse) {
      return (ChatPostMessageResponse) instance;
    }
    return ChatPostMessageResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ChatPostMessageResponse ChatPostMessageResponse}.
   * @return A new ChatPostMessageResponse builder
   */
  public static ChatPostMessageResponse.Builder builder() {
    return new ChatPostMessageResponse.Builder();
  }

  /**
   * Builds instances of type {@link ChatPostMessageResponse ChatPostMessageResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TS = 0x1L;
    private static final long INIT_BIT_CHANNEL = 0x2L;
    private static final long INIT_BIT_OK = 0x4L;
    private long initBits = 0x7L;

    private @Nullable String ts;
    private @Nullable String channel;
    private Map<String, Object> message = new LinkedHashMap<String, Object>();
    private boolean ok;
    private @Nullable ResponseMetadata responseMetadata;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.response.chat.ChatPostMessageResponseIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ChatPostMessageResponseIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.response.SlackResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof ChatPostMessageResponseIF) {
        ChatPostMessageResponseIF instance = (ChatPostMessageResponseIF) object;
        setChannel(instance.getChannel());
        putAllMessage(instance.getMessage());
        setTs(instance.getTs());
      }
      if (object instanceof SlackResponse) {
        SlackResponse instance = (SlackResponse) object;
        setOk(instance.isOk());
        Optional<ResponseMetadata> responseMetadataOptional = instance.getResponseMetadata();
        if (responseMetadataOptional.isPresent()) {
          setResponseMetadata(responseMetadataOptional);
        }
      }
    }

    /**
     * Initializes the value for the {@link ChatPostMessageResponseIF#getTs() ts} attribute.
     * @param ts The value for ts 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTs(String ts) {
      this.ts = Objects.requireNonNull(ts, "ts");
      initBits &= ~INIT_BIT_TS;
      return this;
    }

    /**
     * Initializes the value for the {@link ChatPostMessageResponseIF#getChannel() channel} attribute.
     * @param channel The value for channel 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannel(String channel) {
      this.channel = Objects.requireNonNull(channel, "channel");
      initBits &= ~INIT_BIT_CHANNEL;
      return this;
    }

    /**
     * Put one entry to the {@link ChatPostMessageResponseIF#getMessage() message} map.
     * @param key The key in the message map
     * @param value The associated value in the message map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putMessage(String key, Object value) {
      this.message.put(
          Objects.requireNonNull(key, "message key"),
          Objects.requireNonNull(value, "message value"));
      return this;
    }

    /**
     * Put one entry to the {@link ChatPostMessageResponseIF#getMessage() message} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putMessage(Map.Entry<String, ? extends Object> entry) {
      String k = entry.getKey();
      Object v = entry.getValue();
      this.message.put(
          Objects.requireNonNull(k, "message key"),
          Objects.requireNonNull(v, "message value"));
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link ChatPostMessageResponseIF#getMessage() message} map. Nulls are not permitted
     * @param message The entries that will be added to the message map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setMessage(Map<String, ? extends Object> message) {
      this.message.clear();
      return putAllMessage(message);
    }

    /**
     * Put all mappings from the specified map as entries to {@link ChatPostMessageResponseIF#getMessage() message} map. Nulls are not permitted
     * @param message The entries that will be added to the message map
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder putAllMessage(Map<String, ? extends Object> message) {
      for (Map.Entry<String, ? extends Object> entry : message.entrySet()) {
        String k = entry.getKey();
        Object v = entry.getValue();
        this.message.put(
            Objects.requireNonNull(k, "message key"),
            Objects.requireNonNull(v, "message value"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ChatPostMessageResponseIF#isOk() ok} attribute.
     * @param ok The value for ok 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setOk(boolean ok) {
      this.ok = ok;
      initBits &= ~INIT_BIT_OK;
      return this;
    }

    /**
     * Initializes the optional value {@link ChatPostMessageResponseIF#getResponseMetadata() responseMetadata} to responseMetadata.
     * @param responseMetadata The value for responseMetadata, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
      this.responseMetadata = responseMetadata;
      return this;
    }

    /**
     * Initializes the optional value {@link ChatPostMessageResponseIF#getResponseMetadata() responseMetadata} to responseMetadata.
     * @param responseMetadata The value for responseMetadata
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
      this.responseMetadata = responseMetadata.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ChatPostMessageResponse ChatPostMessageResponse}.
     * @return An immutable instance of ChatPostMessageResponse
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ChatPostMessageResponse build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new ChatPostMessageResponse(ts, channel, createUnmodifiableMap(false, false, message), ok, responseMetadata);
    }

    private boolean tsIsSet() {
      return (initBits & INIT_BIT_TS) == 0;
    }

    private boolean channelIsSet() {
      return (initBits & INIT_BIT_CHANNEL) == 0;
    }

    private boolean okIsSet() {
      return (initBits & INIT_BIT_OK) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!tsIsSet()) attributes.add("ts");
      if (!channelIsSet()) attributes.add("channel");
      if (!okIsSet()) attributes.add("ok");
      return "Cannot build ChatPostMessageResponse, some of required attributes are not set " + attributes;
    }
  }

  private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
    switch (map.size()) {
    case 0: return Collections.emptyMap();
    case 1: {
      Map.Entry<? extends K, ? extends V> e = map.entrySet().iterator().next();
      K k = e.getKey();
      V v = e.getValue();
      if (checkNulls) {
        Objects.requireNonNull(k, "key");
        Objects.requireNonNull(v, "value");
      }
      if (skipNulls && (k == null || v == null)) {
        return Collections.emptyMap();
      }
      return Collections.singletonMap(k, v);
    }
    default: {
      Map<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
      if (skipNulls || checkNulls) {
        for (Map.Entry<? extends K, ? extends V> e : map.entrySet()) {
          K k = e.getKey();
          V v = e.getValue();
          if (skipNulls) {
            if (k == null || v == null) continue;
          } else if (checkNulls) {
            Objects.requireNonNull(k, "key");
            Objects.requireNonNull(v, "value");
          }
          linkedMap.put(k, v);
        }
      } else {
        linkedMap.putAll(map);
      }
      return Collections.unmodifiableMap(linkedMap);
    }
    }
  }
}
