package com.hubspot.slack.client.models.response.conversations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.LiteMessage;
import com.hubspot.slack.client.models.response.*;
import com.hubspot.slack.client.models.response.SlackResponse;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ConversationsHistoryResponseIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ConversationsHistoryResponse.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ConversationsHistoryResponseIF"})
@Immutable
public final class ConversationsHistoryResponse
    implements ConversationsHistoryResponseIF {
  private final List<LiteMessage> messages;
  private final boolean hasMore;
  private final int pinCount;
  private final boolean ok;
  private final @Nullable ResponseMetadata responseMetadata;

  private ConversationsHistoryResponse(
      List<LiteMessage> messages,
      boolean hasMore,
      int pinCount,
      boolean ok,
      @Nullable ResponseMetadata responseMetadata) {
    this.messages = messages;
    this.hasMore = hasMore;
    this.pinCount = pinCount;
    this.ok = ok;
    this.responseMetadata = responseMetadata;
  }

  /**
   * @return The value of the {@code messages} attribute
   */
  @JsonProperty
  @Override
  public List<LiteMessage> getMessages() {
    return messages;
  }

  /**
   * @return The value of the {@code hasMore} attribute
   */
  @JsonProperty("has_more")
  @Override
  public boolean hasMore() {
    return hasMore;
  }

  /**
   * @return The value of the {@code pinCount} attribute
   */
  @JsonProperty
  @Override
  public int getPinCount() {
    return pinCount;
  }

  /**
   * @return The value of the {@code ok} attribute
   */
  @JsonProperty
  @Override
  public boolean isOk() {
    return ok;
  }

  /**
   * @return The value of the {@code responseMetadata} attribute
   */
  @JsonProperty
  @Override
  public Optional<ResponseMetadata> getResponseMetadata() {
    return Optional.ofNullable(responseMetadata);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ConversationsHistoryResponseIF#getMessages() messages}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ConversationsHistoryResponse withMessages(LiteMessage... elements) {
    List<LiteMessage> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new ConversationsHistoryResponse(newValue, this.hasMore, this.pinCount, this.ok, this.responseMetadata);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link ConversationsHistoryResponseIF#getMessages() messages}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of messages elements to set
   * @return A modified copy of {@code this} object
   */
  public final ConversationsHistoryResponse withMessages(Iterable<? extends LiteMessage> elements) {
    if (this.messages == elements) return this;
    List<LiteMessage> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new ConversationsHistoryResponse(newValue, this.hasMore, this.pinCount, this.ok, this.responseMetadata);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConversationsHistoryResponseIF#hasMore() hasMore} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param hasMore A new value for hasMore
   * @return A modified copy of the {@code this} object
   */
  public final ConversationsHistoryResponse withHasMore(boolean hasMore) {
    if (this.hasMore == hasMore) return this;
    return new ConversationsHistoryResponse(this.messages, hasMore, this.pinCount, this.ok, this.responseMetadata);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConversationsHistoryResponseIF#getPinCount() pinCount} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param pinCount A new value for pinCount
   * @return A modified copy of the {@code this} object
   */
  public final ConversationsHistoryResponse withPinCount(int pinCount) {
    if (this.pinCount == pinCount) return this;
    return new ConversationsHistoryResponse(this.messages, this.hasMore, pinCount, this.ok, this.responseMetadata);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ConversationsHistoryResponseIF#isOk() ok} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param ok A new value for ok
   * @return A modified copy of the {@code this} object
   */
  public final ConversationsHistoryResponse withOk(boolean ok) {
    if (this.ok == ok) return this;
    return new ConversationsHistoryResponse(this.messages, this.hasMore, this.pinCount, ok, this.responseMetadata);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ConversationsHistoryResponseIF#getResponseMetadata() responseMetadata} attribute.
   * @param value The value for responseMetadata, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ConversationsHistoryResponse withResponseMetadata(@Nullable ResponseMetadata value) {
    @Nullable ResponseMetadata newValue = value;
    if (this.responseMetadata == newValue) return this;
    return new ConversationsHistoryResponse(this.messages, this.hasMore, this.pinCount, this.ok, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ConversationsHistoryResponseIF#getResponseMetadata() responseMetadata} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for responseMetadata
   * @return A modified copy of {@code this} object
   */
  public final ConversationsHistoryResponse withResponseMetadata(Optional<ResponseMetadata> optional) {
    @Nullable ResponseMetadata value = optional.orElse(null);
    if (this.responseMetadata == value) return this;
    return new ConversationsHistoryResponse(this.messages, this.hasMore, this.pinCount, this.ok, value);
  }

  /**
   * This instance is equal to all instances of {@code ConversationsHistoryResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ConversationsHistoryResponse
        && equalTo((ConversationsHistoryResponse) another);
  }

  private boolean equalTo(ConversationsHistoryResponse another) {
    return messages.equals(another.messages)
        && hasMore == another.hasMore
        && pinCount == another.pinCount
        && ok == another.ok
        && Objects.equals(responseMetadata, another.responseMetadata);
  }

  /**
   * Computes a hash code from attributes: {@code messages}, {@code hasMore}, {@code pinCount}, {@code ok}, {@code responseMetadata}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + messages.hashCode();
    h = h * 17 + Boolean.hashCode(hasMore);
    h = h * 17 + pinCount;
    h = h * 17 + Boolean.hashCode(ok);
    h = h * 17 + Objects.hashCode(responseMetadata);
    return h;
  }

  /**
   * Prints the immutable value {@code ConversationsHistoryResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("ConversationsHistoryResponse{");
    builder.append("messages=").append(messages);
    builder.append(", ");
    builder.append("hasMore=").append(hasMore);
    builder.append(", ");
    builder.append("pinCount=").append(pinCount);
    builder.append(", ");
    builder.append("ok=").append(ok);
    if (responseMetadata != null) {
      builder.append(", ");
      builder.append("responseMetadata=").append(responseMetadata);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements ConversationsHistoryResponseIF {
    List<LiteMessage> messages = Collections.emptyList();
    boolean hasMore;
    boolean hasMoreIsSet;
    int pinCount;
    boolean pinCountIsSet;
    boolean ok;
    boolean okIsSet;
    Optional<ResponseMetadata> responseMetadata = Optional.empty();
    @JsonProperty
    public void setMessages(List<LiteMessage> messages) {
      this.messages = messages;
    }
    @JsonProperty("has_more")
    public void setHasMore(boolean hasMore) {
      this.hasMore = hasMore;
      this.hasMoreIsSet = true;
    }
    @JsonProperty
    public void setPinCount(int pinCount) {
      this.pinCount = pinCount;
      this.pinCountIsSet = true;
    }
    @JsonProperty
    public void setOk(boolean ok) {
      this.ok = ok;
      this.okIsSet = true;
    }
    @JsonProperty
    public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
      this.responseMetadata = responseMetadata;
    }
    @Override
    public List<LiteMessage> getMessages() { throw new UnsupportedOperationException(); }
    @Override
    public boolean hasMore() { throw new UnsupportedOperationException(); }
    @Override
    public int getPinCount() { throw new UnsupportedOperationException(); }
    @Override
    public boolean isOk() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<ResponseMetadata> getResponseMetadata() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ConversationsHistoryResponse fromJson(Json json) {
    ConversationsHistoryResponse.Builder builder = ConversationsHistoryResponse.builder();
    if (json.messages != null) {
      builder.addAllMessages(json.messages);
    }
    if (json.hasMoreIsSet) {
      builder.setHasMore(json.hasMore);
    }
    if (json.pinCountIsSet) {
      builder.setPinCount(json.pinCount);
    }
    if (json.okIsSet) {
      builder.setOk(json.ok);
    }
    if (json.responseMetadata != null) {
      builder.setResponseMetadata(json.responseMetadata);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ConversationsHistoryResponseIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ConversationsHistoryResponse instance
   */
  public static ConversationsHistoryResponse copyOf(ConversationsHistoryResponseIF instance) {
    if (instance instanceof ConversationsHistoryResponse) {
      return (ConversationsHistoryResponse) instance;
    }
    return ConversationsHistoryResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ConversationsHistoryResponse ConversationsHistoryResponse}.
   * @return A new ConversationsHistoryResponse builder
   */
  public static ConversationsHistoryResponse.Builder builder() {
    return new ConversationsHistoryResponse.Builder();
  }

  /**
   * Builds instances of type {@link ConversationsHistoryResponse ConversationsHistoryResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_HAS_MORE = 0x1L;
    private static final long INIT_BIT_PIN_COUNT = 0x2L;
    private static final long INIT_BIT_OK = 0x4L;
    private long initBits = 0x7L;

    private List<LiteMessage> messages = new ArrayList<LiteMessage>();
    private boolean hasMore;
    private int pinCount;
    private boolean ok;
    private @Nullable ResponseMetadata responseMetadata;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.response.conversations.ConversationsHistoryResponseIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ConversationsHistoryResponseIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.response.SlackResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof ConversationsHistoryResponseIF) {
        ConversationsHistoryResponseIF instance = (ConversationsHistoryResponseIF) object;
        setHasMore(instance.hasMore());
        setPinCount(instance.getPinCount());
        addAllMessages(instance.getMessages());
      }
      if (object instanceof SlackResponse) {
        SlackResponse instance = (SlackResponse) object;
        setOk(instance.isOk());
        Optional<ResponseMetadata> responseMetadataOptional = instance.getResponseMetadata();
        if (responseMetadataOptional.isPresent()) {
          setResponseMetadata(responseMetadataOptional);
        }
      }
    }

    /**
     * Adds one element to {@link ConversationsHistoryResponseIF#getMessages() messages} list.
     * @param element A messages element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addMessages(LiteMessage element) {
      this.messages.add(Objects.requireNonNull(element, "messages element"));
      return this;
    }

    /**
     * Adds elements to {@link ConversationsHistoryResponseIF#getMessages() messages} list.
     * @param elements An array of messages elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addMessages(LiteMessage... elements) {
      for (LiteMessage element : elements) {
        this.messages.add(Objects.requireNonNull(element, "messages element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link ConversationsHistoryResponseIF#getMessages() messages} list.
     * @param elements An iterable of messages elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setMessages(Iterable<? extends LiteMessage> elements) {
      this.messages.clear();
      return addAllMessages(elements);
    }

    /**
     * Adds elements to {@link ConversationsHistoryResponseIF#getMessages() messages} list.
     * @param elements An iterable of messages elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllMessages(Iterable<? extends LiteMessage> elements) {
      for (LiteMessage element : elements) {
        this.messages.add(Objects.requireNonNull(element, "messages element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link ConversationsHistoryResponseIF#hasMore() hasMore} attribute.
     * @param hasMore The value for hasMore 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setHasMore(boolean hasMore) {
      this.hasMore = hasMore;
      initBits &= ~INIT_BIT_HAS_MORE;
      return this;
    }

    /**
     * Initializes the value for the {@link ConversationsHistoryResponseIF#getPinCount() pinCount} attribute.
     * @param pinCount The value for pinCount 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setPinCount(int pinCount) {
      this.pinCount = pinCount;
      initBits &= ~INIT_BIT_PIN_COUNT;
      return this;
    }

    /**
     * Initializes the value for the {@link ConversationsHistoryResponseIF#isOk() ok} attribute.
     * @param ok The value for ok 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setOk(boolean ok) {
      this.ok = ok;
      initBits &= ~INIT_BIT_OK;
      return this;
    }

    /**
     * Initializes the optional value {@link ConversationsHistoryResponseIF#getResponseMetadata() responseMetadata} to responseMetadata.
     * @param responseMetadata The value for responseMetadata, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
      this.responseMetadata = responseMetadata;
      return this;
    }

    /**
     * Initializes the optional value {@link ConversationsHistoryResponseIF#getResponseMetadata() responseMetadata} to responseMetadata.
     * @param responseMetadata The value for responseMetadata
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
      this.responseMetadata = responseMetadata.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ConversationsHistoryResponse ConversationsHistoryResponse}.
     * @return An immutable instance of ConversationsHistoryResponse
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ConversationsHistoryResponse build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new ConversationsHistoryResponse(createUnmodifiableList(true, messages), hasMore, pinCount, ok, responseMetadata);
    }

    private boolean hasMoreIsSet() {
      return (initBits & INIT_BIT_HAS_MORE) == 0;
    }

    private boolean pinCountIsSet() {
      return (initBits & INIT_BIT_PIN_COUNT) == 0;
    }

    private boolean okIsSet() {
      return (initBits & INIT_BIT_OK) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!hasMoreIsSet()) attributes.add("hasMore");
      if (!pinCountIsSet()) attributes.add("pinCount");
      if (!okIsSet()) attributes.add("ok");
      return "Cannot build ConversationsHistoryResponse, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
