package com.hubspot.slack.client.models.response.conversations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ConversationsHistoryResponseMetadataIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ConversationsHistoryResponseMetadata.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ConversationsHistoryResponseMetadataIF"})
@Immutable
public final class ConversationsHistoryResponseMetadata
    implements ConversationsHistoryResponseMetadataIF {
  private final @Nullable String nextCursor;

  private ConversationsHistoryResponseMetadata(@Nullable String nextCursor) {
    this.nextCursor = nextCursor;
  }

  /**
   * @return The value of the {@code nextCursor} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getNextCursor() {
    return Optional.ofNullable(nextCursor);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ConversationsHistoryResponseMetadataIF#getNextCursor() nextCursor} attribute.
   * @param value The value for nextCursor, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ConversationsHistoryResponseMetadata withNextCursor(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.nextCursor, newValue)) return this;
    return new ConversationsHistoryResponseMetadata(newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ConversationsHistoryResponseMetadataIF#getNextCursor() nextCursor} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for nextCursor
   * @return A modified copy of {@code this} object
   */
  public final ConversationsHistoryResponseMetadata withNextCursor(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.nextCursor, value)) return this;
    return new ConversationsHistoryResponseMetadata(value);
  }

  /**
   * This instance is equal to all instances of {@code ConversationsHistoryResponseMetadata} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ConversationsHistoryResponseMetadata
        && equalTo((ConversationsHistoryResponseMetadata) another);
  }

  private boolean equalTo(ConversationsHistoryResponseMetadata another) {
    return Objects.equals(nextCursor, another.nextCursor);
  }

  /**
   * Computes a hash code from attributes: {@code nextCursor}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Objects.hashCode(nextCursor);
    return h;
  }

  /**
   * Prints the immutable value {@code ConversationsHistoryResponseMetadata} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("ConversationsHistoryResponseMetadata{");
    if (nextCursor != null) {
      builder.append("nextCursor=").append(nextCursor);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements ConversationsHistoryResponseMetadataIF {
    Optional<String> nextCursor = Optional.empty();
    @JsonProperty
    public void setNextCursor(Optional<String> nextCursor) {
      this.nextCursor = nextCursor;
    }
    @Override
    public Optional<String> getNextCursor() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ConversationsHistoryResponseMetadata fromJson(Json json) {
    ConversationsHistoryResponseMetadata.Builder builder = ConversationsHistoryResponseMetadata.builder();
    if (json.nextCursor != null) {
      builder.setNextCursor(json.nextCursor);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ConversationsHistoryResponseMetadataIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ConversationsHistoryResponseMetadata instance
   */
  public static ConversationsHistoryResponseMetadata copyOf(ConversationsHistoryResponseMetadataIF instance) {
    if (instance instanceof ConversationsHistoryResponseMetadata) {
      return (ConversationsHistoryResponseMetadata) instance;
    }
    return ConversationsHistoryResponseMetadata.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ConversationsHistoryResponseMetadata ConversationsHistoryResponseMetadata}.
   * @return A new ConversationsHistoryResponseMetadata builder
   */
  public static ConversationsHistoryResponseMetadata.Builder builder() {
    return new ConversationsHistoryResponseMetadata.Builder();
  }

  /**
   * Builds instances of type {@link ConversationsHistoryResponseMetadata ConversationsHistoryResponseMetadata}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private @Nullable String nextCursor;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ConversationsHistoryResponseMetadataIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ConversationsHistoryResponseMetadataIF instance) {
      Objects.requireNonNull(instance, "instance");
      Optional<String> nextCursorOptional = instance.getNextCursor();
      if (nextCursorOptional.isPresent()) {
        setNextCursor(nextCursorOptional);
      }
      return this;
    }

    /**
     * Initializes the optional value {@link ConversationsHistoryResponseMetadataIF#getNextCursor() nextCursor} to nextCursor.
     * @param nextCursor The value for nextCursor, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setNextCursor(@Nullable String nextCursor) {
      this.nextCursor = nextCursor;
      return this;
    }

    /**
     * Initializes the optional value {@link ConversationsHistoryResponseMetadataIF#getNextCursor() nextCursor} to nextCursor.
     * @param nextCursor The value for nextCursor
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setNextCursor(Optional<String> nextCursor) {
      this.nextCursor = nextCursor.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ConversationsHistoryResponseMetadata ConversationsHistoryResponseMetadata}.
     * @return An immutable instance of ConversationsHistoryResponseMetadata
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ConversationsHistoryResponseMetadata build() throws InvalidImmutableStateException {
      return new ConversationsHistoryResponseMetadata(nextCursor);
    }
  }
}
