package com.hubspot.slack.client.models.response.im;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.channel.ImChannel;
import com.hubspot.slack.client.models.response.*;
import com.hubspot.slack.client.models.response.SlackResponse;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link ImOpenResponseIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImOpenResponse.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "ImOpenResponseIF"})
@Immutable
public final class ImOpenResponse implements ImOpenResponseIF {
  private final boolean noOp;
  private final boolean alreadyOpen;
  private final @Nullable ImChannel channel;
  private final boolean ok;
  private final @Nullable ResponseMetadata responseMetadata;

  private ImOpenResponse(ImOpenResponse.Builder builder) {
    this.channel = builder.channel;
    this.ok = builder.ok;
    this.responseMetadata = builder.responseMetadata;
    if (builder.noOpIsSet()) {
      initShim.setNoOp(builder.noOp);
    }
    if (builder.alreadyOpenIsSet()) {
      initShim.setAlreadyOpen(builder.alreadyOpen);
    }
    this.noOp = initShim.isNoOp();
    this.alreadyOpen = initShim.isAlreadyOpen();
    this.initShim = null;
  }

  private ImOpenResponse(
      boolean noOp,
      boolean alreadyOpen,
      @Nullable ImChannel channel,
      boolean ok,
      @Nullable ResponseMetadata responseMetadata) {
    this.noOp = noOp;
    this.alreadyOpen = alreadyOpen;
    this.channel = channel;
    this.ok = ok;
    this.responseMetadata = responseMetadata;
    this.initShim = null;
  }

  private static final int STAGE_INITIALIZING = -1;
  private static final int STAGE_UNINITIALIZED = 0;
  private static final int STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private boolean noOp;
    private int noOpStage;

    boolean isNoOp() {
      if (noOpStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (noOpStage == STAGE_UNINITIALIZED) {
        noOpStage = STAGE_INITIALIZING;
        this.noOp = isNoOpInitialize();
        noOpStage = STAGE_INITIALIZED;
      }
      return this.noOp;
    }

    void setNoOp(boolean noOp) {
      this.noOp = noOp;
      noOpStage = STAGE_INITIALIZED;
    }
    private boolean alreadyOpen;
    private int alreadyOpenStage;

    boolean isAlreadyOpen() {
      if (alreadyOpenStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (alreadyOpenStage == STAGE_UNINITIALIZED) {
        alreadyOpenStage = STAGE_INITIALIZING;
        this.alreadyOpen = isAlreadyOpenInitialize();
        alreadyOpenStage = STAGE_INITIALIZED;
      }
      return this.alreadyOpen;
    }

    void setAlreadyOpen(boolean alreadyOpen) {
      this.alreadyOpen = alreadyOpen;
      alreadyOpenStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      ArrayList<String> attributes = new ArrayList<String>();
      if (noOpStage == STAGE_INITIALIZING) attributes.add("noOp");
      if (alreadyOpenStage == STAGE_INITIALIZING) attributes.add("alreadyOpen");
      return "Cannot build ImOpenResponse, attribute initializers form cycle" + attributes;
    }
  }

  private boolean isNoOpInitialize() {
    return ImOpenResponseIF.super.isNoOp();
  }

  private boolean isAlreadyOpenInitialize() {
    return ImOpenResponseIF.super.isAlreadyOpen();
  }

  /**
   * @return The value of the {@code noOp} attribute
   */
  @JsonProperty
  @Override
  public boolean isNoOp() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isNoOp()
        : this.noOp;
  }

  /**
   * @return The value of the {@code alreadyOpen} attribute
   */
  @JsonProperty
  @Override
  public boolean isAlreadyOpen() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isAlreadyOpen()
        : this.alreadyOpen;
  }

  /**
   * @return The value of the {@code channel} attribute
   */
  @JsonProperty
  @Override
  public Optional<ImChannel> getChannel() {
    return Optional.ofNullable(channel);
  }

  /**
   * @return The value of the {@code ok} attribute
   */
  @JsonProperty
  @Override
  public boolean isOk() {
    return ok;
  }

  /**
   * @return The value of the {@code responseMetadata} attribute
   */
  @JsonProperty
  @Override
  public Optional<ResponseMetadata> getResponseMetadata() {
    return Optional.ofNullable(responseMetadata);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ImOpenResponseIF#isNoOp() noOp} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param noOp A new value for noOp
   * @return A modified copy of the {@code this} object
   */
  public final ImOpenResponse withNoOp(boolean noOp) {
    if (this.noOp == noOp) return this;
    return new ImOpenResponse(noOp, this.alreadyOpen, this.channel, this.ok, this.responseMetadata);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ImOpenResponseIF#isAlreadyOpen() alreadyOpen} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param alreadyOpen A new value for alreadyOpen
   * @return A modified copy of the {@code this} object
   */
  public final ImOpenResponse withAlreadyOpen(boolean alreadyOpen) {
    if (this.alreadyOpen == alreadyOpen) return this;
    return new ImOpenResponse(this.noOp, alreadyOpen, this.channel, this.ok, this.responseMetadata);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ImOpenResponseIF#getChannel() channel} attribute.
   * @param value The value for channel, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ImOpenResponse withChannel(@Nullable ImChannel value) {
    @Nullable ImChannel newValue = value;
    if (this.channel == newValue) return this;
    return new ImOpenResponse(this.noOp, this.alreadyOpen, newValue, this.ok, this.responseMetadata);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ImOpenResponseIF#getChannel() channel} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for channel
   * @return A modified copy of {@code this} object
   */
  public final ImOpenResponse withChannel(Optional<ImChannel> optional) {
    @Nullable ImChannel value = optional.orElse(null);
    if (this.channel == value) return this;
    return new ImOpenResponse(this.noOp, this.alreadyOpen, value, this.ok, this.responseMetadata);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ImOpenResponseIF#isOk() ok} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param ok A new value for ok
   * @return A modified copy of the {@code this} object
   */
  public final ImOpenResponse withOk(boolean ok) {
    if (this.ok == ok) return this;
    return new ImOpenResponse(this.noOp, this.alreadyOpen, this.channel, ok, this.responseMetadata);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link ImOpenResponseIF#getResponseMetadata() responseMetadata} attribute.
   * @param value The value for responseMetadata, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final ImOpenResponse withResponseMetadata(@Nullable ResponseMetadata value) {
    @Nullable ResponseMetadata newValue = value;
    if (this.responseMetadata == newValue) return this;
    return new ImOpenResponse(this.noOp, this.alreadyOpen, this.channel, this.ok, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link ImOpenResponseIF#getResponseMetadata() responseMetadata} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for responseMetadata
   * @return A modified copy of {@code this} object
   */
  public final ImOpenResponse withResponseMetadata(Optional<ResponseMetadata> optional) {
    @Nullable ResponseMetadata value = optional.orElse(null);
    if (this.responseMetadata == value) return this;
    return new ImOpenResponse(this.noOp, this.alreadyOpen, this.channel, this.ok, value);
  }

  /**
   * This instance is equal to all instances of {@code ImOpenResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImOpenResponse
        && equalTo((ImOpenResponse) another);
  }

  private boolean equalTo(ImOpenResponse another) {
    return noOp == another.noOp
        && alreadyOpen == another.alreadyOpen
        && Objects.equals(channel, another.channel)
        && ok == another.ok
        && Objects.equals(responseMetadata, another.responseMetadata);
  }

  /**
   * Computes a hash code from attributes: {@code noOp}, {@code alreadyOpen}, {@code channel}, {@code ok}, {@code responseMetadata}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + Boolean.hashCode(noOp);
    h = h * 17 + Boolean.hashCode(alreadyOpen);
    h = h * 17 + Objects.hashCode(channel);
    h = h * 17 + Boolean.hashCode(ok);
    h = h * 17 + Objects.hashCode(responseMetadata);
    return h;
  }

  /**
   * Prints the immutable value {@code ImOpenResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("ImOpenResponse{");
    builder.append("noOp=").append(noOp);
    builder.append(", ");
    builder.append("alreadyOpen=").append(alreadyOpen);
    if (channel != null) {
      builder.append(", ");
      builder.append("channel=").append(channel);
    }
    builder.append(", ");
    builder.append("ok=").append(ok);
    if (responseMetadata != null) {
      builder.append(", ");
      builder.append("responseMetadata=").append(responseMetadata);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements ImOpenResponseIF {
    boolean noOp;
    boolean noOpIsSet;
    boolean alreadyOpen;
    boolean alreadyOpenIsSet;
    Optional<ImChannel> channel = Optional.empty();
    boolean ok;
    boolean okIsSet;
    Optional<ResponseMetadata> responseMetadata = Optional.empty();
    @JsonProperty
    public void setNoOp(boolean noOp) {
      this.noOp = noOp;
      this.noOpIsSet = true;
    }
    @JsonProperty
    public void setAlreadyOpen(boolean alreadyOpen) {
      this.alreadyOpen = alreadyOpen;
      this.alreadyOpenIsSet = true;
    }
    @JsonProperty
    public void setChannel(Optional<ImChannel> channel) {
      this.channel = channel;
    }
    @JsonProperty
    public void setOk(boolean ok) {
      this.ok = ok;
      this.okIsSet = true;
    }
    @JsonProperty
    public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
      this.responseMetadata = responseMetadata;
    }
    @Override
    public boolean isNoOp() { throw new UnsupportedOperationException(); }
    @Override
    public boolean isAlreadyOpen() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<ImChannel> getChannel() { throw new UnsupportedOperationException(); }
    @Override
    public boolean isOk() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<ResponseMetadata> getResponseMetadata() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static ImOpenResponse fromJson(Json json) {
    ImOpenResponse.Builder builder = ImOpenResponse.builder();
    if (json.noOpIsSet) {
      builder.setNoOp(json.noOp);
    }
    if (json.alreadyOpenIsSet) {
      builder.setAlreadyOpen(json.alreadyOpen);
    }
    if (json.channel != null) {
      builder.setChannel(json.channel);
    }
    if (json.okIsSet) {
      builder.setOk(json.ok);
    }
    if (json.responseMetadata != null) {
      builder.setResponseMetadata(json.responseMetadata);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link ImOpenResponseIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ImOpenResponse instance
   */
  public static ImOpenResponse copyOf(ImOpenResponseIF instance) {
    if (instance instanceof ImOpenResponse) {
      return (ImOpenResponse) instance;
    }
    return ImOpenResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImOpenResponse ImOpenResponse}.
   * @return A new ImOpenResponse builder
   */
  public static ImOpenResponse.Builder builder() {
    return new ImOpenResponse.Builder();
  }

  /**
   * Builds instances of type {@link ImOpenResponse ImOpenResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_OK = 0x1L;
    private static final long OPT_BIT_NO_OP = 0x1L;
    private static final long OPT_BIT_ALREADY_OPEN = 0x2L;
    private long initBits = 0x1L;
    private long optBits;

    private boolean noOp;
    private boolean alreadyOpen;
    private @Nullable ImChannel channel;
    private boolean ok;
    private @Nullable ResponseMetadata responseMetadata;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.response.SlackResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.response.im.ImOpenResponseIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ImOpenResponseIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof SlackResponse) {
        SlackResponse instance = (SlackResponse) object;
        setOk(instance.isOk());
        Optional<ResponseMetadata> responseMetadataOptional = instance.getResponseMetadata();
        if (responseMetadataOptional.isPresent()) {
          setResponseMetadata(responseMetadataOptional);
        }
      }
      if (object instanceof ImOpenResponseIF) {
        ImOpenResponseIF instance = (ImOpenResponseIF) object;
        Optional<ImChannel> channelOptional = instance.getChannel();
        if (channelOptional.isPresent()) {
          setChannel(channelOptional);
        }
        setNoOp(instance.isNoOp());
        setAlreadyOpen(instance.isAlreadyOpen());
      }
    }

    /**
     * Initializes the value for the {@link ImOpenResponseIF#isNoOp() noOp} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ImOpenResponseIF#isNoOp() noOp}.</em>
     * @param noOp The value for noOp 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setNoOp(boolean noOp) {
      this.noOp = noOp;
      optBits |= OPT_BIT_NO_OP;
      return this;
    }

    /**
     * Initializes the value for the {@link ImOpenResponseIF#isAlreadyOpen() alreadyOpen} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link ImOpenResponseIF#isAlreadyOpen() alreadyOpen}.</em>
     * @param alreadyOpen The value for alreadyOpen 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setAlreadyOpen(boolean alreadyOpen) {
      this.alreadyOpen = alreadyOpen;
      optBits |= OPT_BIT_ALREADY_OPEN;
      return this;
    }

    /**
     * Initializes the optional value {@link ImOpenResponseIF#getChannel() channel} to channel.
     * @param channel The value for channel, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setChannel(@Nullable ImChannel channel) {
      this.channel = channel;
      return this;
    }

    /**
     * Initializes the optional value {@link ImOpenResponseIF#getChannel() channel} to channel.
     * @param channel The value for channel
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannel(Optional<ImChannel> channel) {
      this.channel = channel.orElse(null);
      return this;
    }

    /**
     * Initializes the value for the {@link ImOpenResponseIF#isOk() ok} attribute.
     * @param ok The value for ok 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setOk(boolean ok) {
      this.ok = ok;
      initBits &= ~INIT_BIT_OK;
      return this;
    }

    /**
     * Initializes the optional value {@link ImOpenResponseIF#getResponseMetadata() responseMetadata} to responseMetadata.
     * @param responseMetadata The value for responseMetadata, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
      this.responseMetadata = responseMetadata;
      return this;
    }

    /**
     * Initializes the optional value {@link ImOpenResponseIF#getResponseMetadata() responseMetadata} to responseMetadata.
     * @param responseMetadata The value for responseMetadata
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
      this.responseMetadata = responseMetadata.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImOpenResponse ImOpenResponse}.
     * @return An immutable instance of ImOpenResponse
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public ImOpenResponse build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new ImOpenResponse(this);
    }

    private boolean noOpIsSet() {
      return (optBits & OPT_BIT_NO_OP) != 0;
    }

    private boolean alreadyOpenIsSet() {
      return (optBits & OPT_BIT_ALREADY_OPEN) != 0;
    }

    private boolean okIsSet() {
      return (initBits & INIT_BIT_OK) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!okIsSet()) attributes.add("ok");
      return "Cannot build ImOpenResponse, some of required attributes are not set " + attributes;
    }
  }
}
