package com.hubspot.slack.client.models.response.usergroups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.response.*;
import com.hubspot.slack.client.models.response.SlackResponse;
import com.hubspot.slack.client.models.usergroups.SlackUsergroup;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link UsergroupListResponseIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code UsergroupListResponse.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "UsergroupListResponseIF"})
@Immutable
public final class UsergroupListResponse
    implements UsergroupListResponseIF {
  private final List<SlackUsergroup> usergroups;
  private final boolean ok;
  private final @Nullable ResponseMetadata responseMetadata;

  private UsergroupListResponse(
      List<SlackUsergroup> usergroups,
      boolean ok,
      @Nullable ResponseMetadata responseMetadata) {
    this.usergroups = usergroups;
    this.ok = ok;
    this.responseMetadata = responseMetadata;
  }

  /**
   * @return The value of the {@code usergroups} attribute
   */
  @JsonProperty
  @Override
  public List<SlackUsergroup> getUsergroups() {
    return usergroups;
  }

  /**
   * @return The value of the {@code ok} attribute
   */
  @JsonProperty
  @Override
  public boolean isOk() {
    return ok;
  }

  /**
   * @return The value of the {@code responseMetadata} attribute
   */
  @JsonProperty
  @Override
  public Optional<ResponseMetadata> getResponseMetadata() {
    return Optional.ofNullable(responseMetadata);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UsergroupListResponseIF#getUsergroups() usergroups}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final UsergroupListResponse withUsergroups(SlackUsergroup... elements) {
    List<SlackUsergroup> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new UsergroupListResponse(newValue, this.ok, this.responseMetadata);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UsergroupListResponseIF#getUsergroups() usergroups}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of usergroups elements to set
   * @return A modified copy of {@code this} object
   */
  public final UsergroupListResponse withUsergroups(Iterable<? extends SlackUsergroup> elements) {
    if (this.usergroups == elements) return this;
    List<SlackUsergroup> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new UsergroupListResponse(newValue, this.ok, this.responseMetadata);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link UsergroupListResponseIF#isOk() ok} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param ok A new value for ok
   * @return A modified copy of the {@code this} object
   */
  public final UsergroupListResponse withOk(boolean ok) {
    if (this.ok == ok) return this;
    return new UsergroupListResponse(this.usergroups, ok, this.responseMetadata);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link UsergroupListResponseIF#getResponseMetadata() responseMetadata} attribute.
   * @param value The value for responseMetadata, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final UsergroupListResponse withResponseMetadata(@Nullable ResponseMetadata value) {
    @Nullable ResponseMetadata newValue = value;
    if (this.responseMetadata == newValue) return this;
    return new UsergroupListResponse(this.usergroups, this.ok, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link UsergroupListResponseIF#getResponseMetadata() responseMetadata} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for responseMetadata
   * @return A modified copy of {@code this} object
   */
  public final UsergroupListResponse withResponseMetadata(Optional<ResponseMetadata> optional) {
    @Nullable ResponseMetadata value = optional.orElse(null);
    if (this.responseMetadata == value) return this;
    return new UsergroupListResponse(this.usergroups, this.ok, value);
  }

  /**
   * This instance is equal to all instances of {@code UsergroupListResponse} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof UsergroupListResponse
        && equalTo((UsergroupListResponse) another);
  }

  private boolean equalTo(UsergroupListResponse another) {
    return usergroups.equals(another.usergroups)
        && ok == another.ok
        && Objects.equals(responseMetadata, another.responseMetadata);
  }

  /**
   * Computes a hash code from attributes: {@code usergroups}, {@code ok}, {@code responseMetadata}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + usergroups.hashCode();
    h = h * 17 + Boolean.hashCode(ok);
    h = h * 17 + Objects.hashCode(responseMetadata);
    return h;
  }

  /**
   * Prints the immutable value {@code UsergroupListResponse} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("UsergroupListResponse{");
    builder.append("usergroups=").append(usergroups);
    builder.append(", ");
    builder.append("ok=").append(ok);
    if (responseMetadata != null) {
      builder.append(", ");
      builder.append("responseMetadata=").append(responseMetadata);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json
      implements UsergroupListResponseIF {
    List<SlackUsergroup> usergroups = Collections.emptyList();
    boolean ok;
    boolean okIsSet;
    Optional<ResponseMetadata> responseMetadata = Optional.empty();
    @JsonProperty
    public void setUsergroups(List<SlackUsergroup> usergroups) {
      this.usergroups = usergroups;
    }
    @JsonProperty
    public void setOk(boolean ok) {
      this.ok = ok;
      this.okIsSet = true;
    }
    @JsonProperty
    public void setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
      this.responseMetadata = responseMetadata;
    }
    @Override
    public List<SlackUsergroup> getUsergroups() { throw new UnsupportedOperationException(); }
    @Override
    public boolean isOk() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<ResponseMetadata> getResponseMetadata() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static UsergroupListResponse fromJson(Json json) {
    UsergroupListResponse.Builder builder = UsergroupListResponse.builder();
    if (json.usergroups != null) {
      builder.addAllUsergroups(json.usergroups);
    }
    if (json.okIsSet) {
      builder.setOk(json.ok);
    }
    if (json.responseMetadata != null) {
      builder.setResponseMetadata(json.responseMetadata);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link UsergroupListResponseIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable UsergroupListResponse instance
   */
  public static UsergroupListResponse copyOf(UsergroupListResponseIF instance) {
    if (instance instanceof UsergroupListResponse) {
      return (UsergroupListResponse) instance;
    }
    return UsergroupListResponse.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link UsergroupListResponse UsergroupListResponse}.
   * @return A new UsergroupListResponse builder
   */
  public static UsergroupListResponse.Builder builder() {
    return new UsergroupListResponse.Builder();
  }

  /**
   * Builds instances of type {@link UsergroupListResponse UsergroupListResponse}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_OK = 0x1L;
    private long initBits = 0x1L;

    private List<SlackUsergroup> usergroups = new ArrayList<SlackUsergroup>();
    private boolean ok;
    private @Nullable ResponseMetadata responseMetadata;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.response.usergroups.UsergroupListResponseIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UsergroupListResponseIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.response.SlackResponse} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackResponse instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof UsergroupListResponseIF) {
        UsergroupListResponseIF instance = (UsergroupListResponseIF) object;
        addAllUsergroups(instance.getUsergroups());
      }
      if (object instanceof SlackResponse) {
        SlackResponse instance = (SlackResponse) object;
        setOk(instance.isOk());
        Optional<ResponseMetadata> responseMetadataOptional = instance.getResponseMetadata();
        if (responseMetadataOptional.isPresent()) {
          setResponseMetadata(responseMetadataOptional);
        }
      }
    }

    /**
     * Adds one element to {@link UsergroupListResponseIF#getUsergroups() usergroups} list.
     * @param element A usergroups element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addUsergroups(SlackUsergroup element) {
      this.usergroups.add(Objects.requireNonNull(element, "usergroups element"));
      return this;
    }

    /**
     * Adds elements to {@link UsergroupListResponseIF#getUsergroups() usergroups} list.
     * @param elements An array of usergroups elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addUsergroups(SlackUsergroup... elements) {
      for (SlackUsergroup element : elements) {
        this.usergroups.add(Objects.requireNonNull(element, "usergroups element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link UsergroupListResponseIF#getUsergroups() usergroups} list.
     * @param elements An iterable of usergroups elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUsergroups(Iterable<? extends SlackUsergroup> elements) {
      this.usergroups.clear();
      return addAllUsergroups(elements);
    }

    /**
     * Adds elements to {@link UsergroupListResponseIF#getUsergroups() usergroups} list.
     * @param elements An iterable of usergroups elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllUsergroups(Iterable<? extends SlackUsergroup> elements) {
      for (SlackUsergroup element : elements) {
        this.usergroups.add(Objects.requireNonNull(element, "usergroups element"));
      }
      return this;
    }

    /**
     * Initializes the value for the {@link UsergroupListResponseIF#isOk() ok} attribute.
     * @param ok The value for ok 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setOk(boolean ok) {
      this.ok = ok;
      initBits &= ~INIT_BIT_OK;
      return this;
    }

    /**
     * Initializes the optional value {@link UsergroupListResponseIF#getResponseMetadata() responseMetadata} to responseMetadata.
     * @param responseMetadata The value for responseMetadata, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setResponseMetadata(@Nullable ResponseMetadata responseMetadata) {
      this.responseMetadata = responseMetadata;
      return this;
    }

    /**
     * Initializes the optional value {@link UsergroupListResponseIF#getResponseMetadata() responseMetadata} to responseMetadata.
     * @param responseMetadata The value for responseMetadata
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setResponseMetadata(Optional<ResponseMetadata> responseMetadata) {
      this.responseMetadata = responseMetadata.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link UsergroupListResponse UsergroupListResponse}.
     * @return An immutable instance of UsergroupListResponse
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public UsergroupListResponse build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new UsergroupListResponse(createUnmodifiableList(true, usergroups), ok, responseMetadata);
    }

    private boolean okIsSet() {
      return (initBits & INIT_BIT_OK) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!okIsSet()) attributes.add("ok");
      return "Cannot build UsergroupListResponse, some of required attributes are not set " + attributes;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
