package com.hubspot.slack.client.models.teams;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link SlackTeamIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code SlackTeam.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "SlackTeamIF"})
@Immutable
public final class SlackTeam implements SlackTeamIF {
  private final String id;
  private final String domain;
  private final @Nullable String enterpriseId;
  private final @Nullable String enterpriseName;

  private SlackTeam(
      String id,
      String domain,
      @Nullable String enterpriseId,
      @Nullable String enterpriseName) {
    this.id = id;
    this.domain = domain;
    this.enterpriseId = enterpriseId;
    this.enterpriseName = enterpriseName;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code domain} attribute
   */
  @JsonProperty
  @Override
  public String getDomain() {
    return domain;
  }

  /**
   * @return The value of the {@code enterpriseId} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getEnterpriseId() {
    return Optional.ofNullable(enterpriseId);
  }

  /**
   * @return The value of the {@code enterpriseName} attribute
   */
  @JsonProperty
  @Override
  public Optional<String> getEnterpriseName() {
    return Optional.ofNullable(enterpriseName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackTeamIF#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param id A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final SlackTeam withId(String id) {
    if (this.id.equals(id)) return this;
    String newValue = Objects.requireNonNull(id, "id");
    return new SlackTeam(newValue, this.domain, this.enterpriseId, this.enterpriseName);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackTeamIF#getDomain() domain} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param domain A new value for domain
   * @return A modified copy of the {@code this} object
   */
  public final SlackTeam withDomain(String domain) {
    if (this.domain.equals(domain)) return this;
    String newValue = Objects.requireNonNull(domain, "domain");
    return new SlackTeam(this.id, newValue, this.enterpriseId, this.enterpriseName);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackTeamIF#getEnterpriseId() enterpriseId} attribute.
   * @param value The value for enterpriseId, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackTeam withEnterpriseId(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.enterpriseId, newValue)) return this;
    return new SlackTeam(this.id, this.domain, newValue, this.enterpriseName);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackTeamIF#getEnterpriseId() enterpriseId} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for enterpriseId
   * @return A modified copy of {@code this} object
   */
  public final SlackTeam withEnterpriseId(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.enterpriseId, value)) return this;
    return new SlackTeam(this.id, this.domain, value, this.enterpriseName);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackTeamIF#getEnterpriseName() enterpriseName} attribute.
   * @param value The value for enterpriseName, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackTeam withEnterpriseName(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.enterpriseName, newValue)) return this;
    return new SlackTeam(this.id, this.domain, this.enterpriseId, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackTeamIF#getEnterpriseName() enterpriseName} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for enterpriseName
   * @return A modified copy of {@code this} object
   */
  public final SlackTeam withEnterpriseName(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.enterpriseName, value)) return this;
    return new SlackTeam(this.id, this.domain, this.enterpriseId, value);
  }

  /**
   * This instance is equal to all instances of {@code SlackTeam} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof SlackTeam
        && equalTo((SlackTeam) another);
  }

  private boolean equalTo(SlackTeam another) {
    return id.equals(another.id)
        && domain.equals(another.domain)
        && Objects.equals(enterpriseId, another.enterpriseId)
        && Objects.equals(enterpriseName, another.enterpriseName);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code domain}, {@code enterpriseId}, {@code enterpriseName}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + id.hashCode();
    h = h * 17 + domain.hashCode();
    h = h * 17 + Objects.hashCode(enterpriseId);
    h = h * 17 + Objects.hashCode(enterpriseName);
    return h;
  }

  /**
   * Prints the immutable value {@code SlackTeam} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("SlackTeam{");
    builder.append("id=").append(id);
    builder.append(", ");
    builder.append("domain=").append(domain);
    if (enterpriseId != null) {
      builder.append(", ");
      builder.append("enterpriseId=").append(enterpriseId);
    }
    if (enterpriseName != null) {
      builder.append(", ");
      builder.append("enterpriseName=").append(enterpriseName);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements SlackTeamIF {
    @Nullable String id;
    @Nullable String domain;
    Optional<String> enterpriseId = Optional.empty();
    Optional<String> enterpriseName = Optional.empty();
    @JsonProperty
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty
    public void setDomain(String domain) {
      this.domain = domain;
    }
    @JsonProperty
    public void setEnterpriseId(Optional<String> enterpriseId) {
      this.enterpriseId = enterpriseId;
    }
    @JsonProperty
    public void setEnterpriseName(Optional<String> enterpriseName) {
      this.enterpriseName = enterpriseName;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public String getDomain() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getEnterpriseId() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getEnterpriseName() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static SlackTeam fromJson(Json json) {
    SlackTeam.Builder builder = SlackTeam.builder();
    if (json.id != null) {
      builder.setId(json.id);
    }
    if (json.domain != null) {
      builder.setDomain(json.domain);
    }
    if (json.enterpriseId != null) {
      builder.setEnterpriseId(json.enterpriseId);
    }
    if (json.enterpriseName != null) {
      builder.setEnterpriseName(json.enterpriseName);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link SlackTeamIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SlackTeam instance
   */
  public static SlackTeam copyOf(SlackTeamIF instance) {
    if (instance instanceof SlackTeam) {
      return (SlackTeam) instance;
    }
    return SlackTeam.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link SlackTeam SlackTeam}.
   * @return A new SlackTeam builder
   */
  public static SlackTeam.Builder builder() {
    return new SlackTeam.Builder();
  }

  /**
   * Builds instances of type {@link SlackTeam SlackTeam}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_DOMAIN = 0x2L;
    private long initBits = 0x3L;

    private @Nullable String id;
    private @Nullable String domain;
    private @Nullable String enterpriseId;
    private @Nullable String enterpriseName;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SlackTeamIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackTeamIF instance) {
      Objects.requireNonNull(instance, "instance");
      setId(instance.getId());
      setDomain(instance.getDomain());
      Optional<String> enterpriseIdOptional = instance.getEnterpriseId();
      if (enterpriseIdOptional.isPresent()) {
        setEnterpriseId(enterpriseIdOptional);
      }
      Optional<String> enterpriseNameOptional = instance.getEnterpriseName();
      if (enterpriseNameOptional.isPresent()) {
        setEnterpriseName(enterpriseNameOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link SlackTeamIF#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setId(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackTeamIF#getDomain() domain} attribute.
     * @param domain The value for domain 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setDomain(String domain) {
      this.domain = Objects.requireNonNull(domain, "domain");
      initBits &= ~INIT_BIT_DOMAIN;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackTeamIF#getEnterpriseId() enterpriseId} to enterpriseId.
     * @param enterpriseId The value for enterpriseId, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setEnterpriseId(@Nullable String enterpriseId) {
      this.enterpriseId = enterpriseId;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackTeamIF#getEnterpriseId() enterpriseId} to enterpriseId.
     * @param enterpriseId The value for enterpriseId
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setEnterpriseId(Optional<String> enterpriseId) {
      this.enterpriseId = enterpriseId.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link SlackTeamIF#getEnterpriseName() enterpriseName} to enterpriseName.
     * @param enterpriseName The value for enterpriseName, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setEnterpriseName(@Nullable String enterpriseName) {
      this.enterpriseName = enterpriseName;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackTeamIF#getEnterpriseName() enterpriseName} to enterpriseName.
     * @param enterpriseName The value for enterpriseName
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setEnterpriseName(Optional<String> enterpriseName) {
      this.enterpriseName = enterpriseName.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link SlackTeam SlackTeam}.
     * @return An immutable instance of SlackTeam
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public SlackTeam build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new SlackTeam(id, domain, enterpriseId, enterpriseName);
    }

    private boolean idIsSet() {
      return (initBits & INIT_BIT_ID) == 0;
    }

    private boolean domainIsSet() {
      return (initBits & INIT_BIT_DOMAIN) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!idIsSet()) attributes.add("id");
      if (!domainIsSet()) attributes.add("domain");
      return "Cannot build SlackTeam, some of required attributes are not set " + attributes;
    }
  }
}
