package com.hubspot.slack.client.models.usergroups;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link UsergroupPreferencesIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code UsergroupPreferences.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "UsergroupPreferencesIF"})
@Immutable
public final class UsergroupPreferences
    implements UsergroupPreferencesIF {
  private final List<String> channelIdsUsersAutojoin;
  private final List<String> groupsUsersAutojoin;

  private UsergroupPreferences(
      List<String> channelIdsUsersAutojoin,
      List<String> groupsUsersAutojoin) {
    this.channelIdsUsersAutojoin = channelIdsUsersAutojoin;
    this.groupsUsersAutojoin = groupsUsersAutojoin;
  }

  /**
   * @return The value of the {@code channelIdsUsersAutojoin} attribute
   */
  @JsonProperty("channels")
  @Override
  public List<String> getChannelIdsUsersAutojoin() {
    return channelIdsUsersAutojoin;
  }

  /**
   * @return The value of the {@code groupsUsersAutojoin} attribute
   */
  @JsonProperty("groups")
  @Override
  public List<String> getGroupsUsersAutojoin() {
    return groupsUsersAutojoin;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UsergroupPreferencesIF#getChannelIdsUsersAutojoin() channelIdsUsersAutojoin}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final UsergroupPreferences withChannelIdsUsersAutojoin(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new UsergroupPreferences(newValue, this.groupsUsersAutojoin);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UsergroupPreferencesIF#getChannelIdsUsersAutojoin() channelIdsUsersAutojoin}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of channelIdsUsersAutojoin elements to set
   * @return A modified copy of {@code this} object
   */
  public final UsergroupPreferences withChannelIdsUsersAutojoin(Iterable<String> elements) {
    if (this.channelIdsUsersAutojoin == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new UsergroupPreferences(newValue, this.groupsUsersAutojoin);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UsergroupPreferencesIF#getGroupsUsersAutojoin() groupsUsersAutojoin}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final UsergroupPreferences withGroupsUsersAutojoin(String... elements) {
    List<String> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new UsergroupPreferences(this.channelIdsUsersAutojoin, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link UsergroupPreferencesIF#getGroupsUsersAutojoin() groupsUsersAutojoin}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of groupsUsersAutojoin elements to set
   * @return A modified copy of {@code this} object
   */
  public final UsergroupPreferences withGroupsUsersAutojoin(Iterable<String> elements) {
    if (this.groupsUsersAutojoin == elements) return this;
    List<String> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new UsergroupPreferences(this.channelIdsUsersAutojoin, newValue);
  }

  /**
   * This instance is equal to all instances of {@code UsergroupPreferences} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof UsergroupPreferences
        && equalTo((UsergroupPreferences) another);
  }

  private boolean equalTo(UsergroupPreferences another) {
    return channelIdsUsersAutojoin.equals(another.channelIdsUsersAutojoin)
        && groupsUsersAutojoin.equals(another.groupsUsersAutojoin);
  }

  /**
   * Computes a hash code from attributes: {@code channelIdsUsersAutojoin}, {@code groupsUsersAutojoin}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + channelIdsUsersAutojoin.hashCode();
    h = h * 17 + groupsUsersAutojoin.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code UsergroupPreferences} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UsergroupPreferences{"
        + "channelIdsUsersAutojoin=" + channelIdsUsersAutojoin
        + ", groupsUsersAutojoin=" + groupsUsersAutojoin
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements UsergroupPreferencesIF {
    List<String> channelIdsUsersAutojoin = Collections.emptyList();
    List<String> groupsUsersAutojoin = Collections.emptyList();
    @JsonProperty("channels")
    public void setChannelIdsUsersAutojoin(List<String> channelIdsUsersAutojoin) {
      this.channelIdsUsersAutojoin = channelIdsUsersAutojoin;
    }
    @JsonProperty("groups")
    public void setGroupsUsersAutojoin(List<String> groupsUsersAutojoin) {
      this.groupsUsersAutojoin = groupsUsersAutojoin;
    }
    @Override
    public List<String> getChannelIdsUsersAutojoin() { throw new UnsupportedOperationException(); }
    @Override
    public List<String> getGroupsUsersAutojoin() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static UsergroupPreferences fromJson(Json json) {
    UsergroupPreferences.Builder builder = UsergroupPreferences.builder();
    if (json.channelIdsUsersAutojoin != null) {
      builder.addAllChannelIdsUsersAutojoin(json.channelIdsUsersAutojoin);
    }
    if (json.groupsUsersAutojoin != null) {
      builder.addAllGroupsUsersAutojoin(json.groupsUsersAutojoin);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link UsergroupPreferencesIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable UsergroupPreferences instance
   */
  public static UsergroupPreferences copyOf(UsergroupPreferencesIF instance) {
    if (instance instanceof UsergroupPreferences) {
      return (UsergroupPreferences) instance;
    }
    return UsergroupPreferences.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link UsergroupPreferences UsergroupPreferences}.
   * @return A new UsergroupPreferences builder
   */
  public static UsergroupPreferences.Builder builder() {
    return new UsergroupPreferences.Builder();
  }

  /**
   * Builds instances of type {@link UsergroupPreferences UsergroupPreferences}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private List<String> channelIdsUsersAutojoin = new ArrayList<String>();
    private List<String> groupsUsersAutojoin = new ArrayList<String>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UsergroupPreferencesIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UsergroupPreferencesIF instance) {
      Objects.requireNonNull(instance, "instance");
      addAllChannelIdsUsersAutojoin(instance.getChannelIdsUsersAutojoin());
      addAllGroupsUsersAutojoin(instance.getGroupsUsersAutojoin());
      return this;
    }

    /**
     * Adds one element to {@link UsergroupPreferencesIF#getChannelIdsUsersAutojoin() channelIdsUsersAutojoin} list.
     * @param element A channelIdsUsersAutojoin element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addChannelIdsUsersAutojoin(String element) {
      this.channelIdsUsersAutojoin.add(Objects.requireNonNull(element, "channelIdsUsersAutojoin element"));
      return this;
    }

    /**
     * Adds elements to {@link UsergroupPreferencesIF#getChannelIdsUsersAutojoin() channelIdsUsersAutojoin} list.
     * @param elements An array of channelIdsUsersAutojoin elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addChannelIdsUsersAutojoin(String... elements) {
      for (String element : elements) {
        this.channelIdsUsersAutojoin.add(Objects.requireNonNull(element, "channelIdsUsersAutojoin element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link UsergroupPreferencesIF#getChannelIdsUsersAutojoin() channelIdsUsersAutojoin} list.
     * @param elements An iterable of channelIdsUsersAutojoin elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannelIdsUsersAutojoin(Iterable<String> elements) {
      this.channelIdsUsersAutojoin.clear();
      return addAllChannelIdsUsersAutojoin(elements);
    }

    /**
     * Adds elements to {@link UsergroupPreferencesIF#getChannelIdsUsersAutojoin() channelIdsUsersAutojoin} list.
     * @param elements An iterable of channelIdsUsersAutojoin elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllChannelIdsUsersAutojoin(Iterable<String> elements) {
      for (String element : elements) {
        this.channelIdsUsersAutojoin.add(Objects.requireNonNull(element, "channelIdsUsersAutojoin element"));
      }
      return this;
    }

    /**
     * Adds one element to {@link UsergroupPreferencesIF#getGroupsUsersAutojoin() groupsUsersAutojoin} list.
     * @param element A groupsUsersAutojoin element
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addGroupsUsersAutojoin(String element) {
      this.groupsUsersAutojoin.add(Objects.requireNonNull(element, "groupsUsersAutojoin element"));
      return this;
    }

    /**
     * Adds elements to {@link UsergroupPreferencesIF#getGroupsUsersAutojoin() groupsUsersAutojoin} list.
     * @param elements An array of groupsUsersAutojoin elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addGroupsUsersAutojoin(String... elements) {
      for (String element : elements) {
        this.groupsUsersAutojoin.add(Objects.requireNonNull(element, "groupsUsersAutojoin element"));
      }
      return this;
    }

    /**
     * Sets or replaces all elements for {@link UsergroupPreferencesIF#getGroupsUsersAutojoin() groupsUsersAutojoin} list.
     * @param elements An iterable of groupsUsersAutojoin elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setGroupsUsersAutojoin(Iterable<String> elements) {
      this.groupsUsersAutojoin.clear();
      return addAllGroupsUsersAutojoin(elements);
    }

    /**
     * Adds elements to {@link UsergroupPreferencesIF#getGroupsUsersAutojoin() groupsUsersAutojoin} list.
     * @param elements An iterable of groupsUsersAutojoin elements
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addAllGroupsUsersAutojoin(Iterable<String> elements) {
      for (String element : elements) {
        this.groupsUsersAutojoin.add(Objects.requireNonNull(element, "groupsUsersAutojoin element"));
      }
      return this;
    }

    /**
     * Builds a new {@link UsergroupPreferences UsergroupPreferences}.
     * @return An immutable instance of UsergroupPreferences
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public UsergroupPreferences build() throws InvalidImmutableStateException {
      return new UsergroupPreferences(
          createUnmodifiableList(true, channelIdsUsersAutojoin),
          createUnmodifiableList(true, groupsUsersAutojoin));
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<T>();
    } else {
      list = new ArrayList<T>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
