package com.hubspot.slack.client.models.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link SlackUserLiteIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code SlackUserLite.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "SlackUserLiteIF"})
@Immutable
public final class SlackUserLite implements SlackUserLiteIF {
  private final String id;
  private final @Nullable String username;

  private SlackUserLite(String id, @Nullable String username) {
    this.id = id;
    this.username = username;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @JsonProperty
  @Override
  public String getId() {
    return id;
  }

  /**
   * @return The value of the {@code username} attribute
   */
  @JsonProperty("name")
  @Override
  public Optional<String> getUsername() {
    return Optional.ofNullable(username);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackUserLiteIF#getId() id} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param id A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final SlackUserLite withId(String id) {
    if (this.id.equals(id)) return this;
    String newValue = Objects.requireNonNull(id, "id");
    return new SlackUserLite(newValue, this.username);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackUserLiteIF#getUsername() username} attribute.
   * @param value The value for username, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackUserLite withUsername(@Nullable String value) {
    @Nullable String newValue = value;
    if (Objects.equals(this.username, newValue)) return this;
    return new SlackUserLite(this.id, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackUserLiteIF#getUsername() username} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for username
   * @return A modified copy of {@code this} object
   */
  public final SlackUserLite withUsername(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.username, value)) return this;
    return new SlackUserLite(this.id, value);
  }

  /**
   * This instance is equal to all instances of {@code SlackUserLite} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof SlackUserLite
        && equalTo((SlackUserLite) another);
  }

  private boolean equalTo(SlackUserLite another) {
    return id.equals(another.id)
        && Objects.equals(username, another.username);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code username}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + id.hashCode();
    h = h * 17 + Objects.hashCode(username);
    return h;
  }

  /**
   * Prints the immutable value {@code SlackUserLite} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("SlackUserLite{");
    builder.append("id=").append(id);
    if (username != null) {
      builder.append(", ");
      builder.append("username=").append(username);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements SlackUserLiteIF {
    @Nullable String id;
    Optional<String> username = Optional.empty();
    @JsonProperty
    public void setId(String id) {
      this.id = id;
    }
    @JsonProperty("name")
    public void setUsername(Optional<String> username) {
      this.username = username;
    }
    @Override
    public String getId() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> getUsername() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static SlackUserLite fromJson(Json json) {
    SlackUserLite.Builder builder = SlackUserLite.builder();
    if (json.id != null) {
      builder.setId(json.id);
    }
    if (json.username != null) {
      builder.setUsername(json.username);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link SlackUserLiteIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SlackUserLite instance
   */
  public static SlackUserLite copyOf(SlackUserLiteIF instance) {
    if (instance instanceof SlackUserLite) {
      return (SlackUserLite) instance;
    }
    return SlackUserLite.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link SlackUserLite SlackUserLite}.
   * @return A new SlackUserLite builder
   */
  public static SlackUserLite.Builder builder() {
    return new SlackUserLite.Builder();
  }

  /**
   * Builds instances of type {@link SlackUserLite SlackUserLite}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private long initBits = 0x1L;

    private @Nullable String id;
    private @Nullable String username;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.users.SlackUserCore} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackUserCore instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code com.hubspot.slack.client.models.users.SlackUserLiteIF} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackUserLiteIF instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      if (object instanceof SlackUserCore) {
        SlackUserCore instance = (SlackUserCore) object;
        setId(instance.getId());
        Optional<String> usernameOptional = instance.getUsername();
        if (usernameOptional.isPresent()) {
          setUsername(usernameOptional);
        }
      }
    }

    /**
     * Initializes the value for the {@link SlackUserLiteIF#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setId(String id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackUserLiteIF#getUsername() username} to username.
     * @param username The value for username, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setUsername(@Nullable String username) {
      this.username = username;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackUserLiteIF#getUsername() username} to username.
     * @param username The value for username
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUsername(Optional<String> username) {
      this.username = username.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link SlackUserLite SlackUserLite}.
     * @return An immutable instance of SlackUserLite
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public SlackUserLite build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new SlackUserLite(id, username);
    }

    private boolean idIsSet() {
      return (initBits & INIT_BIT_ID) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!idIsSet()) attributes.add("id");
      return "Cannot build SlackUserLite, some of required attributes are not set " + attributes;
    }
  }
}
