/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.channels;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import com.hubspot.slack.client.methods.params.channels.AbstractChannelsInfoParams;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ChannelsInfoParams
extends AbstractChannelsInfoParams {
    private final String channelId;
    @Nullable
    private final Boolean includeLocale;

    private ChannelsInfoParams(String channelId) {
        this.channelId = Objects.requireNonNull(channelId, "channelId");
        this.includeLocale = null;
    }

    private ChannelsInfoParams(String channelId, @Nullable Boolean includeLocale) {
        this.channelId = channelId;
        this.includeLocale = includeLocale;
    }

    @Override
    @JsonProperty(value="channel")
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty
    public Optional<Boolean> getIncludeLocale() {
        return Optional.ofNullable(this.includeLocale);
    }

    public final ChannelsInfoParams withChannelId(String channelId) {
        if (this.channelId.equals(channelId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(channelId, "channelId");
        return new ChannelsInfoParams(newValue, this.includeLocale);
    }

    public final ChannelsInfoParams withIncludeLocale(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.includeLocale, newValue)) {
            return this;
        }
        return new ChannelsInfoParams(this.channelId, newValue);
    }

    public final ChannelsInfoParams withIncludeLocale(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.includeLocale, value)) {
            return this;
        }
        return new ChannelsInfoParams(this.channelId, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ChannelsInfoParams && this.equalTo((ChannelsInfoParams)another);
    }

    private boolean equalTo(ChannelsInfoParams another) {
        return this.channelId.equals(another.channelId) && Objects.equals(this.includeLocale, another.includeLocale);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.channelId.hashCode();
        h = h * 17 + Objects.hashCode(this.includeLocale);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ChannelsInfoParams{");
        builder.append("channelId=").append(this.channelId);
        if (this.includeLocale != null) {
            builder.append(", ");
            builder.append("includeLocale=").append(this.includeLocale);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static ChannelsInfoParams fromJson(Json json) {
        Builder builder = ChannelsInfoParams.builder();
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.includeLocale != null) {
            builder.setIncludeLocale(json.includeLocale);
        }
        return builder.build();
    }

    public static ChannelsInfoParams of(String channelId) {
        return new ChannelsInfoParams(channelId);
    }

    public static ChannelsInfoParams copyOf(AbstractChannelsInfoParams instance) {
        if (instance instanceof ChannelsInfoParams) {
            return (ChannelsInfoParams)instance;
        }
        return ChannelsInfoParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CHANNEL_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String channelId;
        @Nullable
        private Boolean includeLocale;

        private Builder() {
        }

        public final Builder from(AbstractChannelsInfoParams instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(HasChannel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            HasChannel instance;
            long bits = 0L;
            if (object instanceof AbstractChannelsInfoParams) {
                Optional<Boolean> includeLocaleOptional;
                instance = (AbstractChannelsInfoParams)object;
                if ((bits & 1L) == 0L) {
                    this.setChannelId(((AbstractChannelsInfoParams)instance).getChannelId());
                    bits |= 1L;
                }
                if ((includeLocaleOptional = ((AbstractChannelsInfoParams)instance).getIncludeLocale()).isPresent()) {
                    this.setIncludeLocale(includeLocaleOptional);
                }
            }
            if (object instanceof HasChannel) {
                instance = (HasChannel)object;
                if ((bits & 1L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 1L;
                }
            }
        }

        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setIncludeLocale(@Nullable Boolean includeLocale) {
            this.includeLocale = includeLocale;
            return this;
        }

        public final Builder setIncludeLocale(Optional<Boolean> includeLocale) {
            this.includeLocale = includeLocale.orElse(null);
            return this;
        }

        public ChannelsInfoParams build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new ChannelsInfoParams(this.channelId, this.includeLocale);
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            return "Cannot build ChannelsInfoParams, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends AbstractChannelsInfoParams {
        @Nullable
        String channelId;
        Optional<Boolean> includeLocale = Optional.empty();

        Json() {
        }

        @JsonProperty(value="channel")
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty
        public void setIncludeLocale(Optional<Boolean> includeLocale) {
            this.includeLocale = includeLocale;
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getIncludeLocale() {
            throw new UnsupportedOperationException();
        }
    }
}

