/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.chat;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import com.hubspot.slack.client.methods.params.chat.ChatUpdateMessageParamsIF;
import com.hubspot.slack.client.methods.params.chat.MessageParams;
import com.hubspot.slack.client.models.Attachment;
import com.hubspot.slack.client.models.blocks.Block;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ChatUpdateMessageParams
implements ChatUpdateMessageParamsIF {
    private final String channelId;
    @Nullable
    private final String text;
    private final String ts;
    @Nullable
    private final Boolean asUser;
    private final boolean shouldLinkNames;
    private final String parse;
    private final List<Attachment> attachments;
    private final List<Block> blocks;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ChatUpdateMessageParams(Builder builder) {
        this.channelId = builder.channelId;
        this.text = builder.text;
        this.ts = builder.ts;
        this.asUser = builder.asUser;
        this.attachments = ChatUpdateMessageParams.createUnmodifiableList(true, builder.attachments);
        if (builder.shouldLinkNamesIsSet()) {
            this.initShim.setShouldLinkNames(builder.shouldLinkNames);
        }
        if (builder.parse != null) {
            this.initShim.setParse(builder.parse);
        }
        if (builder.blocksIsSet()) {
            this.initShim.setBlocks(ChatUpdateMessageParams.createUnmodifiableList(true, builder.blocks));
        }
        this.shouldLinkNames = this.initShim.shouldLinkNames();
        this.parse = this.initShim.getParse();
        this.blocks = this.initShim.getBlocks();
        this.initShim = null;
    }

    private ChatUpdateMessageParams(String channelId, @Nullable String text, String ts, @Nullable Boolean asUser, boolean shouldLinkNames, String parse, List<Attachment> attachments, List<Block> blocks) {
        this.channelId = channelId;
        this.text = text;
        this.ts = ts;
        this.asUser = asUser;
        this.shouldLinkNames = shouldLinkNames;
        this.parse = parse;
        this.attachments = attachments;
        this.blocks = blocks;
        this.initShim = null;
    }

    private boolean shouldLinkNamesInitialize() {
        return ChatUpdateMessageParamsIF.super.shouldLinkNames();
    }

    private String getParseInitialize() {
        return ChatUpdateMessageParamsIF.super.getParse();
    }

    private List<Block> getBlocksInitialize() {
        return ChatUpdateMessageParamsIF.super.getBlocks();
    }

    @Override
    @JsonProperty(value="channel")
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty
    public Optional<String> getText() {
        return Optional.ofNullable(this.text);
    }

    @Override
    @JsonProperty
    public String getTs() {
        return this.ts;
    }

    @Override
    @JsonProperty(value="as_user")
    public Optional<Boolean> getAsUser() {
        return Optional.ofNullable(this.asUser);
    }

    @Override
    @JsonProperty(value="link_names")
    public boolean shouldLinkNames() {
        InitShim shim = this.initShim;
        return shim != null ? shim.shouldLinkNames() : this.shouldLinkNames;
    }

    @Override
    @JsonProperty
    public String getParse() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getParse() : this.parse;
    }

    @Override
    @JsonProperty
    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    @Override
    @JsonProperty
    public List<Block> getBlocks() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getBlocks() : this.blocks;
    }

    public final ChatUpdateMessageParams withChannelId(String channelId) {
        if (this.channelId.equals(channelId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(channelId, "channelId");
        return ChatUpdateMessageParams.validate(new ChatUpdateMessageParams(newValue, this.text, this.ts, this.asUser, this.shouldLinkNames, this.parse, this.attachments, this.blocks));
    }

    public final ChatUpdateMessageParams withText(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.text, newValue)) {
            return this;
        }
        return ChatUpdateMessageParams.validate(new ChatUpdateMessageParams(this.channelId, newValue, this.ts, this.asUser, this.shouldLinkNames, this.parse, this.attachments, this.blocks));
    }

    public final ChatUpdateMessageParams withText(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.text, value)) {
            return this;
        }
        return ChatUpdateMessageParams.validate(new ChatUpdateMessageParams(this.channelId, value, this.ts, this.asUser, this.shouldLinkNames, this.parse, this.attachments, this.blocks));
    }

    public final ChatUpdateMessageParams withTs(String ts) {
        if (this.ts.equals(ts)) {
            return this;
        }
        String newValue = Objects.requireNonNull(ts, "ts");
        return ChatUpdateMessageParams.validate(new ChatUpdateMessageParams(this.channelId, this.text, newValue, this.asUser, this.shouldLinkNames, this.parse, this.attachments, this.blocks));
    }

    public final ChatUpdateMessageParams withAsUser(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.asUser, newValue)) {
            return this;
        }
        return ChatUpdateMessageParams.validate(new ChatUpdateMessageParams(this.channelId, this.text, this.ts, newValue, this.shouldLinkNames, this.parse, this.attachments, this.blocks));
    }

    public final ChatUpdateMessageParams withAsUser(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.asUser, value)) {
            return this;
        }
        return ChatUpdateMessageParams.validate(new ChatUpdateMessageParams(this.channelId, this.text, this.ts, value, this.shouldLinkNames, this.parse, this.attachments, this.blocks));
    }

    public final ChatUpdateMessageParams withShouldLinkNames(boolean shouldLinkNames) {
        if (this.shouldLinkNames == shouldLinkNames) {
            return this;
        }
        return ChatUpdateMessageParams.validate(new ChatUpdateMessageParams(this.channelId, this.text, this.ts, this.asUser, shouldLinkNames, this.parse, this.attachments, this.blocks));
    }

    public final ChatUpdateMessageParams withParse(String parse) {
        if (this.parse.equals(parse)) {
            return this;
        }
        String newValue = Objects.requireNonNull(parse, "parse");
        return ChatUpdateMessageParams.validate(new ChatUpdateMessageParams(this.channelId, this.text, this.ts, this.asUser, this.shouldLinkNames, newValue, this.attachments, this.blocks));
    }

    public final ChatUpdateMessageParams withAttachments(Attachment ... elements) {
        List<Attachment> newValue = ChatUpdateMessageParams.createUnmodifiableList(false, ChatUpdateMessageParams.createSafeList(Arrays.asList(elements), true, false));
        return ChatUpdateMessageParams.validate(new ChatUpdateMessageParams(this.channelId, this.text, this.ts, this.asUser, this.shouldLinkNames, this.parse, newValue, this.blocks));
    }

    public final ChatUpdateMessageParams withAttachments(Iterable<? extends Attachment> elements) {
        if (this.attachments == elements) {
            return this;
        }
        List<Attachment> newValue = ChatUpdateMessageParams.createUnmodifiableList(false, ChatUpdateMessageParams.createSafeList(elements, true, false));
        return ChatUpdateMessageParams.validate(new ChatUpdateMessageParams(this.channelId, this.text, this.ts, this.asUser, this.shouldLinkNames, this.parse, newValue, this.blocks));
    }

    public final ChatUpdateMessageParams withBlocks(Block ... elements) {
        List<Block> newValue = ChatUpdateMessageParams.createUnmodifiableList(false, ChatUpdateMessageParams.createSafeList(Arrays.asList(elements), true, false));
        return ChatUpdateMessageParams.validate(new ChatUpdateMessageParams(this.channelId, this.text, this.ts, this.asUser, this.shouldLinkNames, this.parse, this.attachments, newValue));
    }

    public final ChatUpdateMessageParams withBlocks(Iterable<? extends Block> elements) {
        if (this.blocks == elements) {
            return this;
        }
        List<Block> newValue = ChatUpdateMessageParams.createUnmodifiableList(false, ChatUpdateMessageParams.createSafeList(elements, true, false));
        return ChatUpdateMessageParams.validate(new ChatUpdateMessageParams(this.channelId, this.text, this.ts, this.asUser, this.shouldLinkNames, this.parse, this.attachments, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ChatUpdateMessageParams && this.equalTo((ChatUpdateMessageParams)another);
    }

    private boolean equalTo(ChatUpdateMessageParams another) {
        return this.channelId.equals(another.channelId) && Objects.equals(this.text, another.text) && this.ts.equals(another.ts) && Objects.equals(this.asUser, another.asUser) && this.shouldLinkNames == another.shouldLinkNames && this.parse.equals(another.parse) && this.attachments.equals(another.attachments) && this.blocks.equals(another.blocks);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.channelId.hashCode();
        h = h * 17 + Objects.hashCode(this.text);
        h = h * 17 + this.ts.hashCode();
        h = h * 17 + Objects.hashCode(this.asUser);
        h = h * 17 + Boolean.hashCode(this.shouldLinkNames);
        h = h * 17 + this.parse.hashCode();
        h = h * 17 + this.attachments.hashCode();
        h = h * 17 + this.blocks.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ChatUpdateMessageParams{");
        builder.append("channelId=").append(this.channelId);
        if (this.text != null) {
            builder.append(", ");
            builder.append("text=").append(this.text);
        }
        builder.append(", ");
        builder.append("ts=").append(this.ts);
        if (this.asUser != null) {
            builder.append(", ");
            builder.append("asUser=").append(this.asUser);
        }
        builder.append(", ");
        builder.append("shouldLinkNames=").append(this.shouldLinkNames);
        builder.append(", ");
        builder.append("parse=").append(this.parse);
        builder.append(", ");
        builder.append("attachments=").append(this.attachments);
        builder.append(", ");
        builder.append("blocks=").append(this.blocks);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static ChatUpdateMessageParams fromJson(Json json) {
        Builder builder = ChatUpdateMessageParams.builder();
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.text != null) {
            builder.setText(json.text);
        }
        if (json.ts != null) {
            builder.setTs(json.ts);
        }
        if (json.asUser != null) {
            builder.setAsUser(json.asUser);
        }
        if (json.shouldLinkNamesIsSet) {
            builder.setShouldLinkNames(json.shouldLinkNames);
        }
        if (json.parse != null) {
            builder.setParse(json.parse);
        }
        if (json.attachments != null) {
            builder.addAllAttachments(json.attachments);
        }
        if (json.blocksIsSet) {
            builder.setBlocks(json.blocks);
        }
        return builder.build();
    }

    private static ChatUpdateMessageParams validate(ChatUpdateMessageParams instance) {
        instance.check();
        return instance;
    }

    public static ChatUpdateMessageParams copyOf(ChatUpdateMessageParamsIF instance) {
        if (instance instanceof ChatUpdateMessageParams) {
            return (ChatUpdateMessageParams)instance;
        }
        return ChatUpdateMessageParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CHANNEL_ID = 1L;
        private static final long INIT_BIT_TS = 2L;
        private static final long OPT_BIT_SHOULD_LINK_NAMES = 1L;
        private static final long OPT_BIT_BLOCKS = 2L;
        private long initBits = 3L;
        private long optBits;
        @Nullable
        private String channelId;
        @Nullable
        private String text;
        @Nullable
        private String ts;
        @Nullable
        private Boolean asUser;
        private boolean shouldLinkNames;
        @Nullable
        private String parse;
        private List<Attachment> attachments = new ArrayList<Attachment>();
        private List<Block> blocks = new ArrayList<Block>();

        private Builder() {
        }

        public final Builder from(MessageParams instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(HasChannel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ChatUpdateMessageParamsIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional<String> textOptional;
            HasChannel instance;
            long bits = 0L;
            if (object instanceof MessageParams) {
                instance = (MessageParams)object;
                this.addAllBlocks(instance.getBlocks());
                this.addAllAttachments(instance.getAttachments());
                if ((bits & 1L) == 0L) {
                    textOptional = instance.getText();
                    if (textOptional.isPresent()) {
                        this.setText(textOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof HasChannel) {
                instance = (HasChannel)object;
                if ((bits & 2L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 2L;
                }
            }
            if (object instanceof ChatUpdateMessageParamsIF) {
                Optional<Boolean> asUserOptional;
                instance = (ChatUpdateMessageParamsIF)object;
                if ((bits & 1L) == 0L) {
                    textOptional = instance.getText();
                    if (textOptional.isPresent()) {
                        this.setText(textOptional);
                    }
                    bits |= 1L;
                }
                this.setParse(instance.getParse());
                this.setShouldLinkNames(instance.shouldLinkNames());
                if ((bits & 2L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 2L;
                }
                if ((asUserOptional = instance.getAsUser()).isPresent()) {
                    this.setAsUser(asUserOptional);
                }
                this.setTs(instance.getTs());
            }
        }

        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setText(@Nullable String text) {
            this.text = text;
            return this;
        }

        public final Builder setText(Optional<String> text) {
            this.text = text.orElse(null);
            return this;
        }

        public final Builder setTs(String ts) {
            this.ts = Objects.requireNonNull(ts, "ts");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setAsUser(@Nullable Boolean asUser) {
            this.asUser = asUser;
            return this;
        }

        public final Builder setAsUser(Optional<Boolean> asUser) {
            this.asUser = asUser.orElse(null);
            return this;
        }

        public final Builder setShouldLinkNames(boolean shouldLinkNames) {
            this.shouldLinkNames = shouldLinkNames;
            this.optBits |= 1L;
            return this;
        }

        public final Builder setParse(String parse) {
            this.parse = Objects.requireNonNull(parse, "parse");
            return this;
        }

        public final Builder addAttachments(Attachment element) {
            this.attachments.add(Objects.requireNonNull(element, "attachments element"));
            return this;
        }

        public final Builder addAttachments(Attachment ... elements) {
            for (Attachment element : elements) {
                this.attachments.add(Objects.requireNonNull(element, "attachments element"));
            }
            return this;
        }

        public final Builder setAttachments(Iterable<? extends Attachment> elements) {
            this.attachments.clear();
            return this.addAllAttachments(elements);
        }

        public final Builder addAllAttachments(Iterable<? extends Attachment> elements) {
            for (Attachment attachment : elements) {
                this.attachments.add(Objects.requireNonNull(attachment, "attachments element"));
            }
            return this;
        }

        public final Builder addBlocks(Block element) {
            this.blocks.add(Objects.requireNonNull(element, "blocks element"));
            this.optBits |= 2L;
            return this;
        }

        public final Builder addBlocks(Block ... elements) {
            for (Block element : elements) {
                this.blocks.add(Objects.requireNonNull(element, "blocks element"));
            }
            this.optBits |= 2L;
            return this;
        }

        public final Builder setBlocks(Iterable<? extends Block> elements) {
            this.blocks.clear();
            return this.addAllBlocks(elements);
        }

        public final Builder addAllBlocks(Iterable<? extends Block> elements) {
            for (Block block : elements) {
                this.blocks.add(Objects.requireNonNull(block, "blocks element"));
            }
            this.optBits |= 2L;
            return this;
        }

        public ChatUpdateMessageParams build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return ChatUpdateMessageParams.validate(new ChatUpdateMessageParams(this));
        }

        private boolean shouldLinkNamesIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean blocksIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean tsIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            if (!this.tsIsSet()) {
                attributes.add("ts");
            }
            return "Cannot build ChatUpdateMessageParams, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ChatUpdateMessageParamsIF {
        @Nullable
        String channelId;
        Optional<String> text = Optional.empty();
        @Nullable
        String ts;
        Optional<Boolean> asUser = Optional.empty();
        boolean shouldLinkNames;
        boolean shouldLinkNamesIsSet;
        @Nullable
        String parse;
        List<Attachment> attachments = Collections.emptyList();
        List<Block> blocks = Collections.emptyList();
        boolean blocksIsSet;

        Json() {
        }

        @JsonProperty(value="channel")
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty
        public void setText(Optional<String> text) {
            this.text = text;
        }

        @JsonProperty
        public void setTs(String ts) {
            this.ts = ts;
        }

        @JsonProperty(value="as_user")
        public void setAsUser(Optional<Boolean> asUser) {
            this.asUser = asUser;
        }

        @JsonProperty(value="link_names")
        public void setShouldLinkNames(boolean shouldLinkNames) {
            this.shouldLinkNames = shouldLinkNames;
            this.shouldLinkNamesIsSet = true;
        }

        @JsonProperty
        public void setParse(String parse) {
            this.parse = parse;
        }

        @JsonProperty
        public void setAttachments(List<Attachment> attachments) {
            this.attachments = attachments;
        }

        @JsonProperty
        public void setBlocks(List<Block> blocks) {
            this.blocks = blocks;
            this.blocksIsSet = true;
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getAsUser() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean shouldLinkNames() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getParse() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Attachment> getAttachments() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Block> getBlocks() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private boolean shouldLinkNames;
        private int shouldLinkNamesStage;
        private String parse;
        private int parseStage;
        private List<Block> blocks;
        private int blocksStage;

        private InitShim() {
        }

        boolean shouldLinkNames() {
            if (this.shouldLinkNamesStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.shouldLinkNamesStage == 0) {
                this.shouldLinkNamesStage = -1;
                this.shouldLinkNames = ChatUpdateMessageParams.this.shouldLinkNamesInitialize();
                this.shouldLinkNamesStage = 1;
            }
            return this.shouldLinkNames;
        }

        void setShouldLinkNames(boolean shouldLinkNames) {
            this.shouldLinkNames = shouldLinkNames;
            this.shouldLinkNamesStage = 1;
        }

        String getParse() {
            if (this.parseStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.parseStage == 0) {
                this.parseStage = -1;
                this.parse = Objects.requireNonNull(ChatUpdateMessageParams.this.getParseInitialize(), "parse");
                this.parseStage = 1;
            }
            return this.parse;
        }

        void setParse(String parse) {
            this.parse = parse;
            this.parseStage = 1;
        }

        List<Block> getBlocks() {
            if (this.blocksStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.blocksStage == 0) {
                this.blocksStage = -1;
                this.blocks = ChatUpdateMessageParams.createUnmodifiableList(false, ChatUpdateMessageParams.createSafeList(ChatUpdateMessageParams.this.getBlocksInitialize(), true, false));
                this.blocksStage = 1;
            }
            return this.blocks;
        }

        void setBlocks(List<Block> blocks) {
            this.blocks = blocks;
            this.blocksStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.shouldLinkNamesStage == -1) {
                attributes.add("shouldLinkNames");
            }
            if (this.parseStage == -1) {
                attributes.add("parse");
            }
            if (this.blocksStage == -1) {
                attributes.add("blocks");
            }
            return "Cannot build ChatUpdateMessageParams, attribute initializers form cycle" + attributes;
        }
    }
}

