/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.conversations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.params.conversations.ConversationsInfoParamsIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ConversationsInfoParams
implements ConversationsInfoParamsIF {
    private final String conversationId;
    @Nullable
    private final Boolean includeLocale;

    private ConversationsInfoParams(String conversationId, @Nullable Boolean includeLocale) {
        this.conversationId = conversationId;
        this.includeLocale = includeLocale;
    }

    @Override
    @JsonProperty(value="channel")
    public String getConversationId() {
        return this.conversationId;
    }

    @Override
    @JsonProperty
    public Optional<Boolean> getIncludeLocale() {
        return Optional.ofNullable(this.includeLocale);
    }

    public final ConversationsInfoParams withConversationId(String conversationId) {
        if (this.conversationId.equals(conversationId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(conversationId, "conversationId");
        return new ConversationsInfoParams(newValue, this.includeLocale);
    }

    public final ConversationsInfoParams withIncludeLocale(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.includeLocale, newValue)) {
            return this;
        }
        return new ConversationsInfoParams(this.conversationId, newValue);
    }

    public final ConversationsInfoParams withIncludeLocale(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.includeLocale, value)) {
            return this;
        }
        return new ConversationsInfoParams(this.conversationId, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ConversationsInfoParams && this.equalTo((ConversationsInfoParams)another);
    }

    private boolean equalTo(ConversationsInfoParams another) {
        return this.conversationId.equals(another.conversationId) && Objects.equals(this.includeLocale, another.includeLocale);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.conversationId.hashCode();
        h = h * 17 + Objects.hashCode(this.includeLocale);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ConversationsInfoParams{");
        builder.append("conversationId=").append(this.conversationId);
        if (this.includeLocale != null) {
            builder.append(", ");
            builder.append("includeLocale=").append(this.includeLocale);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static ConversationsInfoParams fromJson(Json json) {
        Builder builder = ConversationsInfoParams.builder();
        if (json.conversationId != null) {
            builder.setConversationId(json.conversationId);
        }
        if (json.includeLocale != null) {
            builder.setIncludeLocale(json.includeLocale);
        }
        return builder.build();
    }

    public static ConversationsInfoParams copyOf(ConversationsInfoParamsIF instance) {
        if (instance instanceof ConversationsInfoParams) {
            return (ConversationsInfoParams)instance;
        }
        return ConversationsInfoParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CONVERSATION_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String conversationId;
        @Nullable
        private Boolean includeLocale;

        private Builder() {
        }

        public final Builder from(ConversationsInfoParamsIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.setConversationId(instance.getConversationId());
            Optional<Boolean> includeLocaleOptional = instance.getIncludeLocale();
            if (includeLocaleOptional.isPresent()) {
                this.setIncludeLocale(includeLocaleOptional);
            }
            return this;
        }

        public final Builder setConversationId(String conversationId) {
            this.conversationId = Objects.requireNonNull(conversationId, "conversationId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setIncludeLocale(@Nullable Boolean includeLocale) {
            this.includeLocale = includeLocale;
            return this;
        }

        public final Builder setIncludeLocale(Optional<Boolean> includeLocale) {
            this.includeLocale = includeLocale.orElse(null);
            return this;
        }

        public ConversationsInfoParams build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new ConversationsInfoParams(this.conversationId, this.includeLocale);
        }

        private boolean conversationIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.conversationIdIsSet()) {
                attributes.add("conversationId");
            }
            return "Cannot build ConversationsInfoParams, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ConversationsInfoParamsIF {
        @Nullable
        String conversationId;
        Optional<Boolean> includeLocale = Optional.empty();

        Json() {
        }

        @JsonProperty(value="channel")
        public void setConversationId(String conversationId) {
            this.conversationId = conversationId;
        }

        @JsonProperty
        public void setIncludeLocale(Optional<Boolean> includeLocale) {
            this.includeLocale = includeLocale;
        }

        @Override
        public String getConversationId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getIncludeLocale() {
            throw new UnsupportedOperationException();
        }
    }
}

