/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.files;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.params.files.FilesUploadParamsIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class FilesUploadParams
implements FilesUploadParamsIF {
    private final List<String> channels;
    @Nullable
    private final String content;
    @Nullable
    private final String filename;
    @Nullable
    private final String initialComment;
    @Nullable
    private final String threadTs;
    @Nullable
    private final String title;

    private FilesUploadParams(List<String> channels, @Nullable String content, @Nullable String filename, @Nullable String initialComment, @Nullable String threadTs, @Nullable String title) {
        this.channels = channels;
        this.content = content;
        this.filename = filename;
        this.initialComment = initialComment;
        this.threadTs = threadTs;
        this.title = title;
    }

    @Override
    @JsonProperty
    public List<String> getChannels() {
        return this.channels;
    }

    @Override
    @JsonProperty
    public Optional<String> getContent() {
        return Optional.ofNullable(this.content);
    }

    @Override
    @JsonProperty
    public Optional<String> getFilename() {
        return Optional.ofNullable(this.filename);
    }

    @Override
    @JsonProperty
    public Optional<String> getInitialComment() {
        return Optional.ofNullable(this.initialComment);
    }

    @Override
    @JsonProperty
    public Optional<String> getThreadTs() {
        return Optional.ofNullable(this.threadTs);
    }

    @Override
    @JsonProperty
    public Optional<String> getTitle() {
        return Optional.ofNullable(this.title);
    }

    public final FilesUploadParams withChannels(String ... elements) {
        List<String> newValue = FilesUploadParams.createUnmodifiableList(false, FilesUploadParams.createSafeList(Arrays.asList(elements), true, false));
        return FilesUploadParams.validate(new FilesUploadParams(newValue, this.content, this.filename, this.initialComment, this.threadTs, this.title));
    }

    public final FilesUploadParams withChannels(Iterable<String> elements) {
        if (this.channels == elements) {
            return this;
        }
        List<String> newValue = FilesUploadParams.createUnmodifiableList(false, FilesUploadParams.createSafeList(elements, true, false));
        return FilesUploadParams.validate(new FilesUploadParams(newValue, this.content, this.filename, this.initialComment, this.threadTs, this.title));
    }

    public final FilesUploadParams withContent(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.content, newValue)) {
            return this;
        }
        return FilesUploadParams.validate(new FilesUploadParams(this.channels, newValue, this.filename, this.initialComment, this.threadTs, this.title));
    }

    public final FilesUploadParams withContent(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.content, value)) {
            return this;
        }
        return FilesUploadParams.validate(new FilesUploadParams(this.channels, value, this.filename, this.initialComment, this.threadTs, this.title));
    }

    public final FilesUploadParams withFilename(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.filename, newValue)) {
            return this;
        }
        return FilesUploadParams.validate(new FilesUploadParams(this.channels, this.content, newValue, this.initialComment, this.threadTs, this.title));
    }

    public final FilesUploadParams withFilename(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.filename, value)) {
            return this;
        }
        return FilesUploadParams.validate(new FilesUploadParams(this.channels, this.content, value, this.initialComment, this.threadTs, this.title));
    }

    public final FilesUploadParams withInitialComment(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.initialComment, newValue)) {
            return this;
        }
        return FilesUploadParams.validate(new FilesUploadParams(this.channels, this.content, this.filename, newValue, this.threadTs, this.title));
    }

    public final FilesUploadParams withInitialComment(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.initialComment, value)) {
            return this;
        }
        return FilesUploadParams.validate(new FilesUploadParams(this.channels, this.content, this.filename, value, this.threadTs, this.title));
    }

    public final FilesUploadParams withThreadTs(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.threadTs, newValue)) {
            return this;
        }
        return FilesUploadParams.validate(new FilesUploadParams(this.channels, this.content, this.filename, this.initialComment, newValue, this.title));
    }

    public final FilesUploadParams withThreadTs(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.threadTs, value)) {
            return this;
        }
        return FilesUploadParams.validate(new FilesUploadParams(this.channels, this.content, this.filename, this.initialComment, value, this.title));
    }

    public final FilesUploadParams withTitle(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.title, newValue)) {
            return this;
        }
        return FilesUploadParams.validate(new FilesUploadParams(this.channels, this.content, this.filename, this.initialComment, this.threadTs, newValue));
    }

    public final FilesUploadParams withTitle(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.title, value)) {
            return this;
        }
        return FilesUploadParams.validate(new FilesUploadParams(this.channels, this.content, this.filename, this.initialComment, this.threadTs, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof FilesUploadParams && this.equalTo((FilesUploadParams)another);
    }

    private boolean equalTo(FilesUploadParams another) {
        return this.channels.equals(another.channels) && Objects.equals(this.content, another.content) && Objects.equals(this.filename, another.filename) && Objects.equals(this.initialComment, another.initialComment) && Objects.equals(this.threadTs, another.threadTs) && Objects.equals(this.title, another.title);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.channels.hashCode();
        h = h * 17 + Objects.hashCode(this.content);
        h = h * 17 + Objects.hashCode(this.filename);
        h = h * 17 + Objects.hashCode(this.initialComment);
        h = h * 17 + Objects.hashCode(this.threadTs);
        h = h * 17 + Objects.hashCode(this.title);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("FilesUploadParams{");
        builder.append("channels=").append(this.channels);
        if (this.content != null) {
            builder.append(", ");
            builder.append("content=").append(this.content);
        }
        if (this.filename != null) {
            builder.append(", ");
            builder.append("filename=").append(this.filename);
        }
        if (this.initialComment != null) {
            builder.append(", ");
            builder.append("initialComment=").append(this.initialComment);
        }
        if (this.threadTs != null) {
            builder.append(", ");
            builder.append("threadTs=").append(this.threadTs);
        }
        if (this.title != null) {
            builder.append(", ");
            builder.append("title=").append(this.title);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static FilesUploadParams fromJson(Json json) {
        Builder builder = FilesUploadParams.builder();
        if (json.channels != null) {
            builder.addAllChannels(json.channels);
        }
        if (json.content != null) {
            builder.setContent(json.content);
        }
        if (json.filename != null) {
            builder.setFilename(json.filename);
        }
        if (json.initialComment != null) {
            builder.setInitialComment(json.initialComment);
        }
        if (json.threadTs != null) {
            builder.setThreadTs(json.threadTs);
        }
        if (json.title != null) {
            builder.setTitle(json.title);
        }
        return builder.build();
    }

    private static FilesUploadParams validate(FilesUploadParams instance) {
        instance.hasContent();
        return instance;
    }

    public static FilesUploadParams copyOf(FilesUploadParamsIF instance) {
        if (instance instanceof FilesUploadParams) {
            return (FilesUploadParams)instance;
        }
        return FilesUploadParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @NotThreadSafe
    public static final class Builder {
        private List<String> channels = new ArrayList<String>();
        @Nullable
        private String content;
        @Nullable
        private String filename;
        @Nullable
        private String initialComment;
        @Nullable
        private String threadTs;
        @Nullable
        private String title;

        private Builder() {
        }

        public final Builder from(FilesUploadParamsIF instance) {
            Optional<String> titleOptional;
            Optional<String> threadTsOptional;
            Optional<String> initialCommentOptional;
            Optional<String> filenameOptional;
            Objects.requireNonNull(instance, "instance");
            this.addAllChannels(instance.getChannels());
            Optional<String> contentOptional = instance.getContent();
            if (contentOptional.isPresent()) {
                this.setContent(contentOptional);
            }
            if ((filenameOptional = instance.getFilename()).isPresent()) {
                this.setFilename(filenameOptional);
            }
            if ((initialCommentOptional = instance.getInitialComment()).isPresent()) {
                this.setInitialComment(initialCommentOptional);
            }
            if ((threadTsOptional = instance.getThreadTs()).isPresent()) {
                this.setThreadTs(threadTsOptional);
            }
            if ((titleOptional = instance.getTitle()).isPresent()) {
                this.setTitle(titleOptional);
            }
            return this;
        }

        public final Builder addChannels(String element) {
            this.channels.add(Objects.requireNonNull(element, "channels element"));
            return this;
        }

        public final Builder addChannels(String ... elements) {
            for (String element : elements) {
                this.channels.add(Objects.requireNonNull(element, "channels element"));
            }
            return this;
        }

        public final Builder setChannels(Iterable<String> elements) {
            this.channels.clear();
            return this.addAllChannels(elements);
        }

        public final Builder addAllChannels(Iterable<String> elements) {
            for (String element : elements) {
                this.channels.add(Objects.requireNonNull(element, "channels element"));
            }
            return this;
        }

        public final Builder setContent(@Nullable String content) {
            this.content = content;
            return this;
        }

        public final Builder setContent(Optional<String> content) {
            this.content = content.orElse(null);
            return this;
        }

        public final Builder setFilename(@Nullable String filename) {
            this.filename = filename;
            return this;
        }

        public final Builder setFilename(Optional<String> filename) {
            this.filename = filename.orElse(null);
            return this;
        }

        public final Builder setInitialComment(@Nullable String initialComment) {
            this.initialComment = initialComment;
            return this;
        }

        public final Builder setInitialComment(Optional<String> initialComment) {
            this.initialComment = initialComment.orElse(null);
            return this;
        }

        public final Builder setThreadTs(@Nullable String threadTs) {
            this.threadTs = threadTs;
            return this;
        }

        public final Builder setThreadTs(Optional<String> threadTs) {
            this.threadTs = threadTs.orElse(null);
            return this;
        }

        public final Builder setTitle(@Nullable String title) {
            this.title = title;
            return this;
        }

        public final Builder setTitle(Optional<String> title) {
            this.title = title.orElse(null);
            return this;
        }

        public FilesUploadParams build() throws InvalidImmutableStateException {
            return FilesUploadParams.validate(new FilesUploadParams(FilesUploadParams.createUnmodifiableList(true, this.channels), this.content, this.filename, this.initialComment, this.threadTs, this.title));
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements FilesUploadParamsIF {
        List<String> channels = Collections.emptyList();
        Optional<String> content = Optional.empty();
        Optional<String> filename = Optional.empty();
        Optional<String> initialComment = Optional.empty();
        Optional<String> threadTs = Optional.empty();
        Optional<String> title = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setChannels(List<String> channels) {
            this.channels = channels;
        }

        @JsonProperty
        public void setContent(Optional<String> content) {
            this.content = content;
        }

        @JsonProperty
        public void setFilename(Optional<String> filename) {
            this.filename = filename;
        }

        @JsonProperty
        public void setInitialComment(Optional<String> initialComment) {
            this.initialComment = initialComment;
        }

        @JsonProperty
        public void setThreadTs(Optional<String> threadTs) {
            this.threadTs = threadTs;
        }

        @JsonProperty
        public void setTitle(Optional<String> title) {
            this.title = title;
        }

        @Override
        public List<String> getChannels() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getContent() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getFilename() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getInitialComment() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getThreadTs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getTitle() {
            throw new UnsupportedOperationException();
        }
    }
}

