/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.group;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.params.channels.BaseChannelsFilter;
import com.hubspot.slack.client.methods.params.group.GroupsListParamsIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class GroupsListParams
implements GroupsListParamsIF {
    @Nullable
    private final Boolean shouldExcludeArchived;
    private final boolean shouldExcludeMembers;

    private GroupsListParams(Builder builder) {
        this.shouldExcludeArchived = builder.shouldExcludeArchived;
        this.shouldExcludeMembers = builder.shouldExcludeMembersIsSet() ? builder.shouldExcludeMembers : GroupsListParamsIF.super.shouldExcludeMembers();
    }

    private GroupsListParams(@Nullable Boolean shouldExcludeArchived, boolean shouldExcludeMembers) {
        this.shouldExcludeArchived = shouldExcludeArchived;
        this.shouldExcludeMembers = shouldExcludeMembers;
    }

    @Override
    @JsonProperty(value="exclude_archived")
    public Optional<Boolean> shouldExcludeArchived() {
        return Optional.ofNullable(this.shouldExcludeArchived);
    }

    @Override
    @JsonProperty(value="exclude_members")
    public boolean shouldExcludeMembers() {
        return this.shouldExcludeMembers;
    }

    public final GroupsListParams withShouldExcludeArchived(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.shouldExcludeArchived, newValue)) {
            return this;
        }
        return new GroupsListParams(newValue, this.shouldExcludeMembers);
    }

    public final GroupsListParams withShouldExcludeArchived(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.shouldExcludeArchived, value)) {
            return this;
        }
        return new GroupsListParams(value, this.shouldExcludeMembers);
    }

    public final GroupsListParams withShouldExcludeMembers(boolean shouldExcludeMembers) {
        if (this.shouldExcludeMembers == shouldExcludeMembers) {
            return this;
        }
        return new GroupsListParams(this.shouldExcludeArchived, shouldExcludeMembers);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GroupsListParams && this.equalTo((GroupsListParams)another);
    }

    private boolean equalTo(GroupsListParams another) {
        return Objects.equals(this.shouldExcludeArchived, another.shouldExcludeArchived) && this.shouldExcludeMembers == another.shouldExcludeMembers;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.shouldExcludeArchived);
        h = h * 17 + Boolean.hashCode(this.shouldExcludeMembers);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("GroupsListParams{");
        if (this.shouldExcludeArchived != null) {
            builder.append("shouldExcludeArchived=").append(this.shouldExcludeArchived);
        }
        if (builder.length() > 17) {
            builder.append(", ");
        }
        builder.append("shouldExcludeMembers=").append(this.shouldExcludeMembers);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static GroupsListParams fromJson(Json json) {
        Builder builder = GroupsListParams.builder();
        if (json.shouldExcludeArchived != null) {
            builder.setShouldExcludeArchived(json.shouldExcludeArchived);
        }
        if (json.shouldExcludeMembersIsSet) {
            builder.setShouldExcludeMembers(json.shouldExcludeMembers);
        }
        return builder.build();
    }

    public static GroupsListParams copyOf(GroupsListParamsIF instance) {
        if (instance instanceof GroupsListParams) {
            return (GroupsListParams)instance;
        }
        return GroupsListParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_SHOULD_EXCLUDE_MEMBERS = 1L;
        private long optBits;
        @Nullable
        private Boolean shouldExcludeArchived;
        private boolean shouldExcludeMembers;

        private Builder() {
        }

        public final Builder from(BaseChannelsFilter instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GroupsListParamsIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof BaseChannelsFilter) {
                BaseChannelsFilter instance = (BaseChannelsFilter)object;
                Optional<Boolean> shouldExcludeArchivedOptional = instance.shouldExcludeArchived();
                if (shouldExcludeArchivedOptional.isPresent()) {
                    this.setShouldExcludeArchived(shouldExcludeArchivedOptional);
                }
                this.setShouldExcludeMembers(instance.shouldExcludeMembers());
            }
        }

        public final Builder setShouldExcludeArchived(@Nullable Boolean shouldExcludeArchived) {
            this.shouldExcludeArchived = shouldExcludeArchived;
            return this;
        }

        public final Builder setShouldExcludeArchived(Optional<Boolean> shouldExcludeArchived) {
            this.shouldExcludeArchived = shouldExcludeArchived.orElse(null);
            return this;
        }

        public final Builder setShouldExcludeMembers(boolean shouldExcludeMembers) {
            this.shouldExcludeMembers = shouldExcludeMembers;
            this.optBits |= 1L;
            return this;
        }

        public GroupsListParams build() throws InvalidImmutableStateException {
            return new GroupsListParams(this);
        }

        private boolean shouldExcludeMembersIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements GroupsListParamsIF {
        Optional<Boolean> shouldExcludeArchived = Optional.empty();
        boolean shouldExcludeMembers;
        boolean shouldExcludeMembersIsSet;

        Json() {
        }

        @JsonProperty(value="exclude_archived")
        public void setShouldExcludeArchived(Optional<Boolean> shouldExcludeArchived) {
            this.shouldExcludeArchived = shouldExcludeArchived;
        }

        @JsonProperty(value="exclude_members")
        public void setShouldExcludeMembers(boolean shouldExcludeMembers) {
            this.shouldExcludeMembers = shouldExcludeMembers;
            this.shouldExcludeMembersIsSet = true;
        }

        @Override
        public Optional<Boolean> shouldExcludeArchived() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean shouldExcludeMembers() {
            throw new UnsupportedOperationException();
        }
    }
}

