/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.im;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasUser;
import com.hubspot.slack.client.methods.params.im.ImOpenParamsIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ImOpenParams
implements ImOpenParamsIF {
    private final String userId;
    private final boolean includeLocale;
    private final boolean returnIm;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImOpenParams(String userId) {
        this.userId = Objects.requireNonNull(userId, "userId");
        this.includeLocale = this.initShim.getIncludeLocale();
        this.returnIm = this.initShim.getReturnIm();
        this.initShim = null;
    }

    private ImOpenParams(Builder builder) {
        this.userId = builder.userId;
        if (builder.includeLocaleIsSet()) {
            this.initShim.setIncludeLocale(builder.includeLocale);
        }
        if (builder.returnImIsSet()) {
            this.initShim.setReturnIm(builder.returnIm);
        }
        this.includeLocale = this.initShim.getIncludeLocale();
        this.returnIm = this.initShim.getReturnIm();
        this.initShim = null;
    }

    private ImOpenParams(String userId, boolean includeLocale, boolean returnIm) {
        this.userId = userId;
        this.includeLocale = includeLocale;
        this.returnIm = returnIm;
        this.initShim = null;
    }

    private boolean getIncludeLocaleInitialize() {
        return ImOpenParamsIF.super.getIncludeLocale();
    }

    private boolean getReturnImInitialize() {
        return ImOpenParamsIF.super.getReturnIm();
    }

    @Override
    @JsonProperty(value="user")
    public String getUserId() {
        return this.userId;
    }

    @Override
    @JsonProperty
    public boolean getIncludeLocale() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getIncludeLocale() : this.includeLocale;
    }

    @Override
    @JsonProperty
    public boolean getReturnIm() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getReturnIm() : this.returnIm;
    }

    public final ImOpenParams withUserId(String userId) {
        if (this.userId.equals(userId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(userId, "userId");
        return new ImOpenParams(newValue, this.includeLocale, this.returnIm);
    }

    public final ImOpenParams withIncludeLocale(boolean includeLocale) {
        if (this.includeLocale == includeLocale) {
            return this;
        }
        return new ImOpenParams(this.userId, includeLocale, this.returnIm);
    }

    public final ImOpenParams withReturnIm(boolean returnIm) {
        if (this.returnIm == returnIm) {
            return this;
        }
        return new ImOpenParams(this.userId, this.includeLocale, returnIm);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImOpenParams && this.equalTo((ImOpenParams)another);
    }

    private boolean equalTo(ImOpenParams another) {
        return this.userId.equals(another.userId) && this.includeLocale == another.includeLocale && this.returnIm == another.returnIm;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.userId.hashCode();
        h = h * 17 + Boolean.hashCode(this.includeLocale);
        h = h * 17 + Boolean.hashCode(this.returnIm);
        return h;
    }

    public String toString() {
        return "ImOpenParams{userId=" + this.userId + ", includeLocale=" + this.includeLocale + ", returnIm=" + this.returnIm + "}";
    }

    @Deprecated
    @JsonCreator
    static ImOpenParams fromJson(Json json) {
        Builder builder = ImOpenParams.builder();
        if (json.userId != null) {
            builder.setUserId(json.userId);
        }
        if (json.includeLocaleIsSet) {
            builder.setIncludeLocale(json.includeLocale);
        }
        if (json.returnImIsSet) {
            builder.setReturnIm(json.returnIm);
        }
        return builder.build();
    }

    public static ImOpenParams of(String userId) {
        return new ImOpenParams(userId);
    }

    public static ImOpenParams copyOf(ImOpenParamsIF instance) {
        if (instance instanceof ImOpenParams) {
            return (ImOpenParams)instance;
        }
        return ImOpenParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_USER_ID = 1L;
        private static final long OPT_BIT_INCLUDE_LOCALE = 1L;
        private static final long OPT_BIT_RETURN_IM = 2L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private String userId;
        private boolean includeLocale;
        private boolean returnIm;

        private Builder() {
        }

        public final Builder from(ImOpenParamsIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(HasUser instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            HasUser instance;
            long bits = 0L;
            if (object instanceof ImOpenParamsIF) {
                instance = (ImOpenParamsIF)object;
                if ((bits & 1L) == 0L) {
                    this.setUserId(instance.getUserId());
                    bits |= 1L;
                }
                this.setIncludeLocale(instance.getIncludeLocale());
                this.setReturnIm(instance.getReturnIm());
            }
            if (object instanceof HasUser) {
                instance = (HasUser)object;
                if ((bits & 1L) == 0L) {
                    this.setUserId(instance.getUserId());
                    bits |= 1L;
                }
            }
        }

        public final Builder setUserId(String userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setIncludeLocale(boolean includeLocale) {
            this.includeLocale = includeLocale;
            this.optBits |= 1L;
            return this;
        }

        public final Builder setReturnIm(boolean returnIm) {
            this.returnIm = returnIm;
            this.optBits |= 2L;
            return this;
        }

        public ImOpenParams build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new ImOpenParams(this);
        }

        private boolean includeLocaleIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean returnImIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean userIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.userIdIsSet()) {
                attributes.add("userId");
            }
            return "Cannot build ImOpenParams, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ImOpenParamsIF {
        @Nullable
        String userId;
        boolean includeLocale;
        boolean includeLocaleIsSet;
        boolean returnIm;
        boolean returnImIsSet;

        Json() {
        }

        @JsonProperty(value="user")
        public void setUserId(String userId) {
            this.userId = userId;
        }

        @JsonProperty
        public void setIncludeLocale(boolean includeLocale) {
            this.includeLocale = includeLocale;
            this.includeLocaleIsSet = true;
        }

        @JsonProperty
        public void setReturnIm(boolean returnIm) {
            this.returnIm = returnIm;
            this.returnImIsSet = true;
        }

        @Override
        public String getUserId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getIncludeLocale() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getReturnIm() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private boolean includeLocale;
        private int includeLocaleStage;
        private boolean returnIm;
        private int returnImStage;

        private InitShim() {
        }

        boolean getIncludeLocale() {
            if (this.includeLocaleStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.includeLocaleStage == 0) {
                this.includeLocaleStage = -1;
                this.includeLocale = ImOpenParams.this.getIncludeLocaleInitialize();
                this.includeLocaleStage = 1;
            }
            return this.includeLocale;
        }

        void setIncludeLocale(boolean includeLocale) {
            this.includeLocale = includeLocale;
            this.includeLocaleStage = 1;
        }

        boolean getReturnIm() {
            if (this.returnImStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.returnImStage == 0) {
                this.returnImStage = -1;
                this.returnIm = ImOpenParams.this.getReturnImInitialize();
                this.returnImStage = 1;
            }
            return this.returnIm;
        }

        void setReturnIm(boolean returnIm) {
            this.returnIm = returnIm;
            this.returnImStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.includeLocaleStage == -1) {
                attributes.add("includeLocale");
            }
            if (this.returnImStage == -1) {
                attributes.add("returnIm");
            }
            return "Cannot build ImOpenParams, attribute initializers form cycle" + attributes;
        }
    }
}

