/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.params.users.UsersListParamsIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class UsersListParams
implements UsersListParamsIF {
    @Nullable
    private final String cursor;
    @Nullable
    private final Integer limit;

    private UsersListParams(@Nullable String cursor, @Nullable Integer limit) {
        this.cursor = cursor;
        this.limit = limit;
    }

    @Override
    @JsonProperty
    public Optional<String> getCursor() {
        return Optional.ofNullable(this.cursor);
    }

    @Override
    @JsonProperty
    public Optional<Integer> getLimit() {
        return Optional.ofNullable(this.limit);
    }

    public final UsersListParams withCursor(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.cursor, newValue)) {
            return this;
        }
        return new UsersListParams(newValue, this.limit);
    }

    public final UsersListParams withCursor(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.cursor, value)) {
            return this;
        }
        return new UsersListParams(value, this.limit);
    }

    public final UsersListParams withLimit(@Nullable Integer value) {
        Integer newValue = value;
        if (Objects.equals(this.limit, newValue)) {
            return this;
        }
        return new UsersListParams(this.cursor, newValue);
    }

    public final UsersListParams withLimit(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.limit, value)) {
            return this;
        }
        return new UsersListParams(this.cursor, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UsersListParams && this.equalTo((UsersListParams)another);
    }

    private boolean equalTo(UsersListParams another) {
        return Objects.equals(this.cursor, another.cursor) && Objects.equals(this.limit, another.limit);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.cursor);
        h = h * 17 + Objects.hashCode(this.limit);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("UsersListParams{");
        if (this.cursor != null) {
            builder.append("cursor=").append(this.cursor);
        }
        if (this.limit != null) {
            if (builder.length() > 16) {
                builder.append(", ");
            }
            builder.append("limit=").append(this.limit);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static UsersListParams fromJson(Json json) {
        Builder builder = UsersListParams.builder();
        if (json.cursor != null) {
            builder.setCursor(json.cursor);
        }
        if (json.limit != null) {
            builder.setLimit(json.limit);
        }
        return builder.build();
    }

    public static UsersListParams copyOf(UsersListParamsIF instance) {
        if (instance instanceof UsersListParams) {
            return (UsersListParams)instance;
        }
        return UsersListParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String cursor;
        @Nullable
        private Integer limit;

        private Builder() {
        }

        public final Builder from(UsersListParamsIF instance) {
            Optional<Integer> limitOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<String> cursorOptional = instance.getCursor();
            if (cursorOptional.isPresent()) {
                this.setCursor(cursorOptional);
            }
            if ((limitOptional = instance.getLimit()).isPresent()) {
                this.setLimit(limitOptional);
            }
            return this;
        }

        public final Builder setCursor(@Nullable String cursor) {
            this.cursor = cursor;
            return this;
        }

        public final Builder setCursor(Optional<String> cursor) {
            this.cursor = cursor.orElse(null);
            return this;
        }

        public final Builder setLimit(@Nullable Integer limit) {
            this.limit = limit;
            return this;
        }

        public final Builder setLimit(Optional<Integer> limit) {
            this.limit = limit.orElse(null);
            return this;
        }

        public UsersListParams build() throws InvalidImmutableStateException {
            return new UsersListParams(this.cursor, this.limit);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements UsersListParamsIF {
        Optional<String> cursor = Optional.empty();
        Optional<Integer> limit = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setCursor(Optional<String> cursor) {
            this.cursor = cursor;
        }

        @JsonProperty
        public void setLimit(Optional<Integer> limit) {
            this.limit = limit;
        }

        @Override
        public Optional<String> getCursor() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getLimit() {
            throw new UnsupportedOperationException();
        }
    }
}

