/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.ReplySkeletonIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ReplySkeleton
implements ReplySkeletonIF {
    private final String userId;
    private final String replyTs;

    private ReplySkeleton(String userId, String replyTs) {
        this.userId = userId;
        this.replyTs = replyTs;
    }

    @Override
    @JsonProperty(value="user")
    public String getUserId() {
        return this.userId;
    }

    @Override
    @JsonProperty(value="ts")
    public String getReplyTs() {
        return this.replyTs;
    }

    public final ReplySkeleton withUserId(String userId) {
        if (this.userId.equals(userId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(userId, "userId");
        return new ReplySkeleton(newValue, this.replyTs);
    }

    public final ReplySkeleton withReplyTs(String replyTs) {
        if (this.replyTs.equals(replyTs)) {
            return this;
        }
        String newValue = Objects.requireNonNull(replyTs, "replyTs");
        return new ReplySkeleton(this.userId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ReplySkeleton && this.equalTo((ReplySkeleton)another);
    }

    private boolean equalTo(ReplySkeleton another) {
        return this.userId.equals(another.userId) && this.replyTs.equals(another.replyTs);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.userId.hashCode();
        h = h * 17 + this.replyTs.hashCode();
        return h;
    }

    public String toString() {
        return "ReplySkeleton{userId=" + this.userId + ", replyTs=" + this.replyTs + "}";
    }

    @Deprecated
    @JsonCreator
    static ReplySkeleton fromJson(Json json) {
        Builder builder = ReplySkeleton.builder();
        if (json.userId != null) {
            builder.setUserId(json.userId);
        }
        if (json.replyTs != null) {
            builder.setReplyTs(json.replyTs);
        }
        return builder.build();
    }

    public static ReplySkeleton copyOf(ReplySkeletonIF instance) {
        if (instance instanceof ReplySkeleton) {
            return (ReplySkeleton)instance;
        }
        return ReplySkeleton.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_USER_ID = 1L;
        private static final long INIT_BIT_REPLY_TS = 2L;
        private long initBits = 3L;
        @Nullable
        private String userId;
        @Nullable
        private String replyTs;

        private Builder() {
        }

        public final Builder from(ReplySkeletonIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.setUserId(instance.getUserId());
            this.setReplyTs(instance.getReplyTs());
            return this;
        }

        public final Builder setUserId(String userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setReplyTs(String replyTs) {
            this.replyTs = Objects.requireNonNull(replyTs, "replyTs");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ReplySkeleton build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new ReplySkeleton(this.userId, this.replyTs);
        }

        private boolean userIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean replyTsIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.userIdIsSet()) {
                attributes.add("userId");
            }
            if (!this.replyTsIsSet()) {
                attributes.add("replyTs");
            }
            return "Cannot build ReplySkeleton, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ReplySkeletonIF {
        @Nullable
        String userId;
        @Nullable
        String replyTs;

        Json() {
        }

        @JsonProperty(value="user")
        public void setUserId(String userId) {
            this.userId = userId;
        }

        @JsonProperty(value="ts")
        public void setReplyTs(String replyTs) {
            this.replyTs = replyTs;
        }

        @Override
        public String getUserId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getReplyTs() {
            throw new UnsupportedOperationException();
        }
    }
}

