/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.actions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.hubspot.slack.client.enums.EnumIndex;
import com.hubspot.slack.client.enums.UnmappedKeyException;

public enum SlackDataSource {
    STATIC,
    USERS,
    CHANNELS,
    CONVERSATIONS,
    EXTERNAL;

    private static final EnumIndex<String, SlackDataSource> INDEX;

    @JsonCreator
    public static SlackDataSource get(String key) throws UnmappedKeyException {
        return INDEX.get(key);
    }

    @JsonValue
    public String toString() {
        return this.name().toLowerCase();
    }

    static {
        INDEX = new EnumIndex<String, SlackDataSource>(SlackDataSource.class, SlackDataSource::toString);
    }
}

