/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.blocks.elements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.elements.ExternalSelectMenuIF;
import com.hubspot.slack.client.models.blocks.objects.ConfirmationDialog;
import com.hubspot.slack.client.models.blocks.objects.Option;
import com.hubspot.slack.client.models.blocks.objects.Text;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ExternalSelectMenu
implements ExternalSelectMenuIF {
    private final String type;
    private final Text placeholder;
    private final String actionId;
    @Nullable
    private final Option initialOption;
    @Nullable
    private final Integer minQueryLength;
    @Nullable
    private final ConfirmationDialog confirmationDialog;

    private ExternalSelectMenu(Text placeholder, String actionId) {
        this.placeholder = Objects.requireNonNull(placeholder, "placeholder");
        this.actionId = Objects.requireNonNull(actionId, "actionId");
        this.initialOption = null;
        this.minQueryLength = null;
        this.confirmationDialog = null;
        this.type = Objects.requireNonNull(ExternalSelectMenuIF.super.getType(), "type");
    }

    private ExternalSelectMenu(Text placeholder, String actionId, @Nullable Option initialOption, @Nullable Integer minQueryLength, @Nullable ConfirmationDialog confirmationDialog) {
        this.placeholder = placeholder;
        this.actionId = actionId;
        this.initialOption = initialOption;
        this.minQueryLength = minQueryLength;
        this.confirmationDialog = confirmationDialog;
        this.type = Objects.requireNonNull(ExternalSelectMenuIF.super.getType(), "type");
    }

    @Override
    @JsonProperty
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public Text getPlaceholder() {
        return this.placeholder;
    }

    @Override
    @JsonProperty
    public String getActionId() {
        return this.actionId;
    }

    @Override
    @JsonProperty
    public Optional<Option> getInitialOption() {
        return Optional.ofNullable(this.initialOption);
    }

    @Override
    @JsonProperty
    public Optional<Integer> getMinQueryLength() {
        return Optional.ofNullable(this.minQueryLength);
    }

    @Override
    @JsonProperty(value="confirm")
    public Optional<ConfirmationDialog> getConfirmationDialog() {
        return Optional.ofNullable(this.confirmationDialog);
    }

    public final ExternalSelectMenu withPlaceholder(Text placeholder) {
        if (this.placeholder == placeholder) {
            return this;
        }
        Text newValue = Objects.requireNonNull(placeholder, "placeholder");
        return new ExternalSelectMenu(newValue, this.actionId, this.initialOption, this.minQueryLength, this.confirmationDialog);
    }

    public final ExternalSelectMenu withActionId(String actionId) {
        if (this.actionId.equals(actionId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(actionId, "actionId");
        return new ExternalSelectMenu(this.placeholder, newValue, this.initialOption, this.minQueryLength, this.confirmationDialog);
    }

    public final ExternalSelectMenu withInitialOption(@Nullable Option value) {
        Option newValue = value;
        if (this.initialOption == newValue) {
            return this;
        }
        return new ExternalSelectMenu(this.placeholder, this.actionId, newValue, this.minQueryLength, this.confirmationDialog);
    }

    public final ExternalSelectMenu withInitialOption(Optional<Option> optional) {
        Option value = optional.orElse(null);
        if (this.initialOption == value) {
            return this;
        }
        return new ExternalSelectMenu(this.placeholder, this.actionId, value, this.minQueryLength, this.confirmationDialog);
    }

    public final ExternalSelectMenu withMinQueryLength(@Nullable Integer value) {
        Integer newValue = value;
        if (Objects.equals(this.minQueryLength, newValue)) {
            return this;
        }
        return new ExternalSelectMenu(this.placeholder, this.actionId, this.initialOption, newValue, this.confirmationDialog);
    }

    public final ExternalSelectMenu withMinQueryLength(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.minQueryLength, value)) {
            return this;
        }
        return new ExternalSelectMenu(this.placeholder, this.actionId, this.initialOption, value, this.confirmationDialog);
    }

    public final ExternalSelectMenu withConfirmationDialog(@Nullable ConfirmationDialog value) {
        ConfirmationDialog newValue = value;
        if (this.confirmationDialog == newValue) {
            return this;
        }
        return new ExternalSelectMenu(this.placeholder, this.actionId, this.initialOption, this.minQueryLength, newValue);
    }

    public final ExternalSelectMenu withConfirmationDialog(Optional<ConfirmationDialog> optional) {
        ConfirmationDialog value = optional.orElse(null);
        if (this.confirmationDialog == value) {
            return this;
        }
        return new ExternalSelectMenu(this.placeholder, this.actionId, this.initialOption, this.minQueryLength, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ExternalSelectMenu && this.equalTo((ExternalSelectMenu)another);
    }

    private boolean equalTo(ExternalSelectMenu another) {
        return this.type.equals(another.type) && this.placeholder.equals(another.placeholder) && this.actionId.equals(another.actionId) && Objects.equals(this.initialOption, another.initialOption) && Objects.equals(this.minQueryLength, another.minQueryLength) && Objects.equals(this.confirmationDialog, another.confirmationDialog);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.type.hashCode();
        h = h * 17 + this.placeholder.hashCode();
        h = h * 17 + this.actionId.hashCode();
        h = h * 17 + Objects.hashCode(this.initialOption);
        h = h * 17 + Objects.hashCode(this.minQueryLength);
        h = h * 17 + Objects.hashCode(this.confirmationDialog);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ExternalSelectMenu{");
        builder.append("type=").append(this.type);
        builder.append(", ");
        builder.append("placeholder=").append(this.placeholder);
        builder.append(", ");
        builder.append("actionId=").append(this.actionId);
        if (this.initialOption != null) {
            builder.append(", ");
            builder.append("initialOption=").append(this.initialOption);
        }
        if (this.minQueryLength != null) {
            builder.append(", ");
            builder.append("minQueryLength=").append(this.minQueryLength);
        }
        if (this.confirmationDialog != null) {
            builder.append(", ");
            builder.append("confirmationDialog=").append(this.confirmationDialog);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static ExternalSelectMenu fromJson(Json json) {
        Builder builder = ExternalSelectMenu.builder();
        if (json.placeholder != null) {
            builder.setPlaceholder(json.placeholder);
        }
        if (json.actionId != null) {
            builder.setActionId(json.actionId);
        }
        if (json.initialOption != null) {
            builder.setInitialOption(json.initialOption);
        }
        if (json.minQueryLength != null) {
            builder.setMinQueryLength(json.minQueryLength);
        }
        if (json.confirmationDialog != null) {
            builder.setConfirmationDialog(json.confirmationDialog);
        }
        return builder.build();
    }

    public static ExternalSelectMenu of(Text placeholder, String actionId) {
        return new ExternalSelectMenu(placeholder, actionId);
    }

    public static ExternalSelectMenu copyOf(ExternalSelectMenuIF instance) {
        if (instance instanceof ExternalSelectMenu) {
            return (ExternalSelectMenu)instance;
        }
        return ExternalSelectMenu.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PLACEHOLDER = 1L;
        private static final long INIT_BIT_ACTION_ID = 2L;
        private long initBits = 3L;
        @Nullable
        private Text placeholder;
        @Nullable
        private String actionId;
        @Nullable
        private Option initialOption;
        @Nullable
        private Integer minQueryLength;
        @Nullable
        private ConfirmationDialog confirmationDialog;

        private Builder() {
        }

        public final Builder from(ExternalSelectMenuIF instance) {
            Optional<ConfirmationDialog> confirmationDialogOptional;
            Optional<Integer> minQueryLengthOptional;
            Objects.requireNonNull(instance, "instance");
            this.setPlaceholder(instance.getPlaceholder());
            this.setActionId(instance.getActionId());
            Optional<Option> initialOptionOptional = instance.getInitialOption();
            if (initialOptionOptional.isPresent()) {
                this.setInitialOption(initialOptionOptional);
            }
            if ((minQueryLengthOptional = instance.getMinQueryLength()).isPresent()) {
                this.setMinQueryLength(minQueryLengthOptional);
            }
            if ((confirmationDialogOptional = instance.getConfirmationDialog()).isPresent()) {
                this.setConfirmationDialog(confirmationDialogOptional);
            }
            return this;
        }

        public final Builder setPlaceholder(Text placeholder) {
            this.placeholder = Objects.requireNonNull(placeholder, "placeholder");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setActionId(String actionId) {
            this.actionId = Objects.requireNonNull(actionId, "actionId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setInitialOption(@Nullable Option initialOption) {
            this.initialOption = initialOption;
            return this;
        }

        public final Builder setInitialOption(Optional<Option> initialOption) {
            this.initialOption = initialOption.orElse(null);
            return this;
        }

        public final Builder setMinQueryLength(@Nullable Integer minQueryLength) {
            this.minQueryLength = minQueryLength;
            return this;
        }

        public final Builder setMinQueryLength(Optional<Integer> minQueryLength) {
            this.minQueryLength = minQueryLength.orElse(null);
            return this;
        }

        public final Builder setConfirmationDialog(@Nullable ConfirmationDialog confirmationDialog) {
            this.confirmationDialog = confirmationDialog;
            return this;
        }

        public final Builder setConfirmationDialog(Optional<ConfirmationDialog> confirmationDialog) {
            this.confirmationDialog = confirmationDialog.orElse(null);
            return this;
        }

        public ExternalSelectMenu build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new ExternalSelectMenu(this.placeholder, this.actionId, this.initialOption, this.minQueryLength, this.confirmationDialog);
        }

        private boolean placeholderIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean actionIdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.placeholderIsSet()) {
                attributes.add("placeholder");
            }
            if (!this.actionIdIsSet()) {
                attributes.add("actionId");
            }
            return "Cannot build ExternalSelectMenu, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ExternalSelectMenuIF {
        @Nullable
        Text placeholder;
        @Nullable
        String actionId;
        Optional<Option> initialOption = Optional.empty();
        Optional<Integer> minQueryLength = Optional.empty();
        Optional<ConfirmationDialog> confirmationDialog = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setPlaceholder(Text placeholder) {
            this.placeholder = placeholder;
        }

        @JsonProperty
        public void setActionId(String actionId) {
            this.actionId = actionId;
        }

        @JsonProperty
        public void setInitialOption(Optional<Option> initialOption) {
            this.initialOption = initialOption;
        }

        @JsonProperty
        public void setMinQueryLength(Optional<Integer> minQueryLength) {
            this.minQueryLength = minQueryLength;
        }

        @JsonProperty(value="confirm")
        public void setConfirmationDialog(Optional<ConfirmationDialog> confirmationDialog) {
            this.confirmationDialog = confirmationDialog;
        }

        @Override
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Text getPlaceholder() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getActionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Option> getInitialOption() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getMinQueryLength() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ConfirmationDialog> getConfirmationDialog() {
            throw new UnsupportedOperationException();
        }
    }
}

