/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.dialog.form.elements;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.hubspot.immutables.style.HubSpotStyle;
import com.hubspot.slack.client.models.dialog.form.SlackFormElementTypes;
import com.hubspot.slack.client.models.dialog.form.elements.AbstractSlackDialogFormTextElement;
import org.immutables.value.Value;

@JsonNaming(value=PropertyNamingStrategy.SnakeCaseStrategy.class)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@Value.Immutable
@HubSpotStyle
public abstract class AbstractSlackFormTextElement
extends AbstractSlackDialogFormTextElement {
    @Override
    @Value.Default
    public SlackFormElementTypes getType() {
        return SlackFormElementTypes.TEXT;
    }

    @Value.Check
    public void validate() {
        super.validateBaseTextElementProps();
        if (this.getMaxLength() > 150) {
            throw new IllegalStateException("Form text element cannot have max length > 150 chars, got " + this.getMaxLength());
        }
        if (this.getMinLength() > 150) {
            throw new IllegalStateException("Form text element cannot have min length > 150 chars, got " + this.getMinLength());
        }
        if (this.getValue().isPresent() && this.getValue().get().length() > 150) {
            throw new IllegalStateException("Value cannot exceed 150 chars, got '" + this.getValue().get() + "'");
        }
    }
}

