/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.dialog.form.elements;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.slack.client.models.dialog.form.SlackFormElementTypes;
import java.util.Optional;

public abstract class SlackDialogFormElement {
    public abstract SlackFormElementTypes getType();

    public abstract String getName();

    public abstract String getLabel();

    public abstract Optional<String> getPlaceholder();

    @JsonProperty(value="optional")
    public abstract Optional<Boolean> isOptional();

    protected void validateBaseElementProperties() {
        if (this.getLabel().length() > 24) {
            throw new IllegalStateException("Label cannot exceed 24 chars, got " + this.getLabel());
        }
        if (this.getName().length() > 300) {
            throw new IllegalStateException("Name cannot exceed 300 chars, got " + this.getName());
        }
        if (this.getPlaceholder().isPresent() && this.getPlaceholder().get().length() > 150) {
            throw new IllegalStateException("Placeholder length cannot exceed 150 chars, got " + this.getPlaceholder().get());
        }
    }
}

