/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.dialog.form.elements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.dialog.form.elements.SlackFormOptionIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class SlackFormOption
implements SlackFormOptionIF {
    private final String label;
    private final String value;

    private SlackFormOption(String label, String value) {
        this.label = label;
        this.value = value;
    }

    @Override
    @JsonProperty
    public String getLabel() {
        return this.label;
    }

    @Override
    @JsonProperty
    public String getValue() {
        return this.value;
    }

    public final SlackFormOption withLabel(String label) {
        if (this.label.equals(label)) {
            return this;
        }
        String newValue = Objects.requireNonNull(label, "label");
        return SlackFormOption.validate(new SlackFormOption(newValue, this.value));
    }

    public final SlackFormOption withValue(String value) {
        if (this.value.equals(value)) {
            return this;
        }
        String newValue = Objects.requireNonNull(value, "value");
        return SlackFormOption.validate(new SlackFormOption(this.label, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackFormOption && this.equalTo((SlackFormOption)another);
    }

    private boolean equalTo(SlackFormOption another) {
        return this.label.equals(another.label) && this.value.equals(another.value);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.label.hashCode();
        h = h * 17 + this.value.hashCode();
        return h;
    }

    public String toString() {
        return "SlackFormOption{label=" + this.label + ", value=" + this.value + "}";
    }

    @Deprecated
    @JsonCreator
    static SlackFormOption fromJson(Json json) {
        Builder builder = SlackFormOption.builder();
        if (json.label != null) {
            builder.setLabel(json.label);
        }
        if (json.value != null) {
            builder.setValue(json.value);
        }
        return builder.build();
    }

    private static SlackFormOption validate(SlackFormOption instance) {
        instance.validate();
        return instance;
    }

    public static SlackFormOption copyOf(SlackFormOptionIF instance) {
        if (instance instanceof SlackFormOption) {
            return (SlackFormOption)instance;
        }
        return SlackFormOption.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_LABEL = 1L;
        private static final long INIT_BIT_VALUE = 2L;
        private long initBits = 3L;
        @Nullable
        private String label;
        @Nullable
        private String value;

        private Builder() {
        }

        public final Builder from(SlackFormOptionIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.setLabel(instance.getLabel());
            this.setValue(instance.getValue());
            return this;
        }

        public final Builder setLabel(String label) {
            this.label = Objects.requireNonNull(label, "label");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setValue(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public SlackFormOption build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return SlackFormOption.validate(new SlackFormOption(this.label, this.value));
        }

        private boolean labelIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean valueIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.labelIsSet()) {
                attributes.add("label");
            }
            if (!this.valueIsSet()) {
                attributes.add("value");
            }
            return "Cannot build SlackFormOption, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements SlackFormOptionIF {
        @Nullable
        String label;
        @Nullable
        String value;

        Json() {
        }

        @JsonProperty
        public void setLabel(String label) {
            this.label = label;
        }

        @JsonProperty
        public void setValue(String value) {
            this.value = value;
        }

        @Override
        public String getLabel() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getValue() {
            throw new UnsupportedOperationException();
        }
    }
}

