/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import com.hubspot.slack.client.methods.interceptor.HasUser;
import com.hubspot.slack.client.models.events.AbstractSlackEventMessageIm;
import com.hubspot.slack.client.models.events.SlackEvent;
import com.hubspot.slack.client.models.events.SlackEventMessageBase;
import com.hubspot.slack.client.models.events.SlackEventType;
import com.hubspot.slack.client.models.events.SlackMessageSubtype;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class SlackEventMessageIm
extends AbstractSlackEventMessageIm {
    private final String channelId;
    @Nullable
    private final String threadTs;
    private final String text;
    private final String userId;
    @Nullable
    private final SlackMessageSubtype subtype;
    private final SlackEventType type;
    private final String ts;

    private SlackEventMessageIm(String channelId, @Nullable String threadTs, String text, String userId, @Nullable SlackMessageSubtype subtype, SlackEventType type, String ts) {
        this.channelId = channelId;
        this.threadTs = threadTs;
        this.text = text;
        this.userId = userId;
        this.subtype = subtype;
        this.type = type;
        this.ts = ts;
    }

    @Override
    @JsonProperty(value="channel")
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty
    public Optional<String> getThreadTs() {
        return Optional.ofNullable(this.threadTs);
    }

    @Override
    @JsonProperty
    public String getText() {
        return this.text;
    }

    @Override
    @JsonProperty(value="user")
    public String getUserId() {
        return this.userId;
    }

    @Override
    @JsonProperty
    public Optional<SlackMessageSubtype> getSubtype() {
        return Optional.ofNullable(this.subtype);
    }

    @Override
    @JsonProperty
    public SlackEventType getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public String getTs() {
        return this.ts;
    }

    public final SlackEventMessageIm withChannelId(String channelId) {
        if (this.channelId.equals(channelId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(channelId, "channelId");
        return new SlackEventMessageIm(newValue, this.threadTs, this.text, this.userId, this.subtype, this.type, this.ts);
    }

    public final SlackEventMessageIm withThreadTs(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.threadTs, newValue)) {
            return this;
        }
        return new SlackEventMessageIm(this.channelId, newValue, this.text, this.userId, this.subtype, this.type, this.ts);
    }

    public final SlackEventMessageIm withThreadTs(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.threadTs, value)) {
            return this;
        }
        return new SlackEventMessageIm(this.channelId, value, this.text, this.userId, this.subtype, this.type, this.ts);
    }

    public final SlackEventMessageIm withText(String text) {
        if (this.text.equals(text)) {
            return this;
        }
        String newValue = Objects.requireNonNull(text, "text");
        return new SlackEventMessageIm(this.channelId, this.threadTs, newValue, this.userId, this.subtype, this.type, this.ts);
    }

    public final SlackEventMessageIm withUserId(String userId) {
        if (this.userId.equals(userId)) {
            return this;
        }
        String newValue = Objects.requireNonNull(userId, "userId");
        return new SlackEventMessageIm(this.channelId, this.threadTs, this.text, newValue, this.subtype, this.type, this.ts);
    }

    public final SlackEventMessageIm withSubtype(@Nullable SlackMessageSubtype value) {
        SlackMessageSubtype newValue = value;
        if (Objects.equals((Object)this.subtype, (Object)newValue)) {
            return this;
        }
        return new SlackEventMessageIm(this.channelId, this.threadTs, this.text, this.userId, newValue, this.type, this.ts);
    }

    public final SlackEventMessageIm withSubtype(Optional<SlackMessageSubtype> optional) {
        SlackMessageSubtype value = optional.orElse(null);
        if (Objects.equals((Object)this.subtype, (Object)value)) {
            return this;
        }
        return new SlackEventMessageIm(this.channelId, this.threadTs, this.text, this.userId, value, this.type, this.ts);
    }

    public final SlackEventMessageIm withType(SlackEventType type) {
        if (this.type == type) {
            return this;
        }
        SlackEventType newValue = Objects.requireNonNull(type, "type");
        return new SlackEventMessageIm(this.channelId, this.threadTs, this.text, this.userId, this.subtype, newValue, this.ts);
    }

    public final SlackEventMessageIm withTs(String ts) {
        if (this.ts.equals(ts)) {
            return this;
        }
        String newValue = Objects.requireNonNull(ts, "ts");
        return new SlackEventMessageIm(this.channelId, this.threadTs, this.text, this.userId, this.subtype, this.type, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackEventMessageIm && this.equalTo((SlackEventMessageIm)another);
    }

    private boolean equalTo(SlackEventMessageIm another) {
        return this.channelId.equals(another.channelId) && Objects.equals(this.threadTs, another.threadTs) && this.text.equals(another.text) && this.userId.equals(another.userId) && Objects.equals((Object)this.subtype, (Object)another.subtype) && this.type.equals((Object)another.type) && this.ts.equals(another.ts);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.channelId.hashCode();
        h = h * 17 + Objects.hashCode(this.threadTs);
        h = h * 17 + this.text.hashCode();
        h = h * 17 + this.userId.hashCode();
        h = h * 17 + Objects.hashCode((Object)this.subtype);
        h = h * 17 + this.type.hashCode();
        h = h * 17 + this.ts.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SlackEventMessageIm{");
        builder.append("channelId=").append(this.channelId);
        if (this.threadTs != null) {
            builder.append(", ");
            builder.append("threadTs=").append(this.threadTs);
        }
        builder.append(", ");
        builder.append("text=").append(this.text);
        builder.append(", ");
        builder.append("userId=").append(this.userId);
        if (this.subtype != null) {
            builder.append(", ");
            builder.append("subtype=").append((Object)this.subtype);
        }
        builder.append(", ");
        builder.append("type=").append((Object)this.type);
        builder.append(", ");
        builder.append("ts=").append(this.ts);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static SlackEventMessageIm fromJson(Json json) {
        Builder builder = SlackEventMessageIm.builder();
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.threadTs != null) {
            builder.setThreadTs(json.threadTs);
        }
        if (json.text != null) {
            builder.setText(json.text);
        }
        if (json.userId != null) {
            builder.setUserId(json.userId);
        }
        if (json.subtype != null) {
            builder.setSubtype(json.subtype);
        }
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.ts != null) {
            builder.setTs(json.ts);
        }
        return builder.build();
    }

    public static SlackEventMessageIm copyOf(AbstractSlackEventMessageIm instance) {
        if (instance instanceof SlackEventMessageIm) {
            return (SlackEventMessageIm)instance;
        }
        return SlackEventMessageIm.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CHANNEL_ID = 1L;
        private static final long INIT_BIT_TEXT = 2L;
        private static final long INIT_BIT_USER_ID = 4L;
        private static final long INIT_BIT_TYPE = 8L;
        private static final long INIT_BIT_TS = 16L;
        private long initBits = 31L;
        @Nullable
        private String channelId;
        @Nullable
        private String threadTs;
        @Nullable
        private String text;
        @Nullable
        private String userId;
        @Nullable
        private SlackMessageSubtype subtype;
        @Nullable
        private SlackEventType type;
        @Nullable
        private String ts;

        private Builder() {
        }

        public final Builder from(HasChannel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SlackEventMessageBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SlackEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(HasUser instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AbstractSlackEventMessageIm instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional<SlackMessageSubtype> subtypeOptional;
            Object instance;
            long bits = 0L;
            if (object instanceof HasChannel) {
                instance = (HasChannel)object;
                if ((bits & 2L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 2L;
                }
            }
            if (object instanceof SlackEventMessageBase && (subtypeOptional = ((SlackEventMessageBase)(instance = (SlackEventMessageBase)object)).getSubtype()).isPresent()) {
                this.setSubtype(subtypeOptional);
            }
            if (object instanceof SlackEvent) {
                instance = (SlackEvent)object;
                this.setType(instance.getType());
                this.setTs(instance.getTs());
            }
            if (object instanceof HasUser) {
                instance = (HasUser)object;
                if ((bits & 1L) == 0L) {
                    this.setUserId(instance.getUserId());
                    bits |= 1L;
                }
            }
            if (object instanceof AbstractSlackEventMessageIm) {
                instance = (AbstractSlackEventMessageIm)object;
                this.setText(((AbstractSlackEventMessageIm)instance).getText());
                Optional<String> threadTsOptional = ((AbstractSlackEventMessageIm)instance).getThreadTs();
                if (threadTsOptional.isPresent()) {
                    this.setThreadTs(threadTsOptional);
                }
                if ((bits & 1L) == 0L) {
                    this.setUserId(((AbstractSlackEventMessageIm)instance).getUserId());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.setChannelId(((AbstractSlackEventMessageIm)instance).getChannelId());
                    bits |= 2L;
                }
            }
        }

        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setThreadTs(@Nullable String threadTs) {
            this.threadTs = threadTs;
            return this;
        }

        public final Builder setThreadTs(Optional<String> threadTs) {
            this.threadTs = threadTs.orElse(null);
            return this;
        }

        public final Builder setText(String text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setUserId(String userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setSubtype(@Nullable SlackMessageSubtype subtype) {
            this.subtype = subtype;
            return this;
        }

        public final Builder setSubtype(Optional<SlackMessageSubtype> subtype) {
            this.subtype = subtype.orElse(null);
            return this;
        }

        public final Builder setType(SlackEventType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder setTs(String ts) {
            this.ts = Objects.requireNonNull(ts, "ts");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public SlackEventMessageIm build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new SlackEventMessageIm(this.channelId, this.threadTs, this.text, this.userId, this.subtype, this.type, this.ts);
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean textIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean userIdIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean typeIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private boolean tsIsSet() {
            return (this.initBits & 0x10L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            if (!this.textIsSet()) {
                attributes.add("text");
            }
            if (!this.userIdIsSet()) {
                attributes.add("userId");
            }
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.tsIsSet()) {
                attributes.add("ts");
            }
            return "Cannot build SlackEventMessageIm, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends AbstractSlackEventMessageIm {
        @Nullable
        String channelId;
        Optional<String> threadTs = Optional.empty();
        @Nullable
        String text;
        @Nullable
        String userId;
        Optional<SlackMessageSubtype> subtype = Optional.empty();
        @Nullable
        SlackEventType type;
        @Nullable
        String ts;

        Json() {
        }

        @JsonProperty(value="channel")
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty
        public void setThreadTs(Optional<String> threadTs) {
            this.threadTs = threadTs;
        }

        @JsonProperty
        public void setText(String text) {
            this.text = text;
        }

        @JsonProperty(value="user")
        public void setUserId(String userId) {
            this.userId = userId;
        }

        @JsonProperty
        public void setSubtype(Optional<SlackMessageSubtype> subtype) {
            this.subtype = subtype;
        }

        @JsonProperty
        public void setType(SlackEventType type) {
            this.type = type;
        }

        @JsonProperty
        public void setTs(String ts) {
            this.ts = ts;
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getThreadTs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUserId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<SlackMessageSubtype> getSubtype() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackEventType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTs() {
            throw new UnsupportedOperationException();
        }
    }
}

