/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.response;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.response.ResponseMetadataIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class ResponseMetadata
implements ResponseMetadataIF {
    @Nullable
    private final String nextCursor;

    private ResponseMetadata(@Nullable String nextCursor) {
        this.nextCursor = nextCursor;
    }

    @Override
    @JsonProperty
    public Optional<String> getNextCursor() {
        return Optional.ofNullable(this.nextCursor);
    }

    public final ResponseMetadata withNextCursor(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.nextCursor, newValue)) {
            return this;
        }
        return new ResponseMetadata(newValue);
    }

    public final ResponseMetadata withNextCursor(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.nextCursor, value)) {
            return this;
        }
        return new ResponseMetadata(value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ResponseMetadata && this.equalTo((ResponseMetadata)another);
    }

    private boolean equalTo(ResponseMetadata another) {
        return Objects.equals(this.nextCursor, another.nextCursor);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.nextCursor);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ResponseMetadata{");
        if (this.nextCursor != null) {
            builder.append("nextCursor=").append(this.nextCursor);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static ResponseMetadata fromJson(Json json) {
        Builder builder = ResponseMetadata.builder();
        if (json.nextCursor != null) {
            builder.setNextCursor(json.nextCursor);
        }
        return builder.build();
    }

    public static ResponseMetadata copyOf(ResponseMetadataIF instance) {
        if (instance instanceof ResponseMetadata) {
            return (ResponseMetadata)instance;
        }
        return ResponseMetadata.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String nextCursor;

        private Builder() {
        }

        public final Builder from(ResponseMetadataIF instance) {
            Objects.requireNonNull(instance, "instance");
            Optional<String> nextCursorOptional = instance.getNextCursor();
            if (nextCursorOptional.isPresent()) {
                this.setNextCursor(nextCursorOptional);
            }
            return this;
        }

        public final Builder setNextCursor(@Nullable String nextCursor) {
            this.nextCursor = nextCursor;
            return this;
        }

        public final Builder setNextCursor(Optional<String> nextCursor) {
            this.nextCursor = nextCursor.orElse(null);
            return this;
        }

        public ResponseMetadata build() throws InvalidImmutableStateException {
            return new ResponseMetadata(this.nextCursor);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements ResponseMetadataIF {
        Optional<String> nextCursor = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setNextCursor(Optional<String> nextCursor) {
            this.nextCursor = nextCursor;
        }

        @Override
        public Optional<String> getNextCursor() {
            throw new UnsupportedOperationException();
        }
    }
}

