/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.users;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.users.SlackUserCore;
import com.hubspot.slack.client.models.users.SlackUserLiteIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@SuppressFBWarnings
@Immutable
public final class SlackUserLite
implements SlackUserLiteIF {
    private final String id;
    @Nullable
    private final String username;

    private SlackUserLite(String id, @Nullable String username) {
        this.id = id;
        this.username = username;
    }

    @Override
    @JsonProperty
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="name")
    public Optional<String> getUsername() {
        return Optional.ofNullable(this.username);
    }

    public final SlackUserLite withId(String id) {
        if (this.id.equals(id)) {
            return this;
        }
        String newValue = Objects.requireNonNull(id, "id");
        return new SlackUserLite(newValue, this.username);
    }

    public final SlackUserLite withUsername(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.username, newValue)) {
            return this;
        }
        return new SlackUserLite(this.id, newValue);
    }

    public final SlackUserLite withUsername(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.username, value)) {
            return this;
        }
        return new SlackUserLite(this.id, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackUserLite && this.equalTo((SlackUserLite)another);
    }

    private boolean equalTo(SlackUserLite another) {
        return this.id.equals(another.id) && Objects.equals(this.username, another.username);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.id.hashCode();
        h = h * 17 + Objects.hashCode(this.username);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SlackUserLite{");
        builder.append("id=").append(this.id);
        if (this.username != null) {
            builder.append(", ");
            builder.append("username=").append(this.username);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator
    static SlackUserLite fromJson(Json json) {
        Builder builder = SlackUserLite.builder();
        if (json.id != null) {
            builder.setId(json.id);
        }
        if (json.username != null) {
            builder.setUsername(json.username);
        }
        return builder.build();
    }

    public static SlackUserLite copyOf(SlackUserLiteIF instance) {
        if (instance instanceof SlackUserLite) {
            return (SlackUserLite)instance;
        }
        return SlackUserLite.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String id;
        @Nullable
        private String username;

        private Builder() {
        }

        public final Builder from(SlackUserCore instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SlackUserLiteIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            if (object instanceof SlackUserCore) {
                SlackUserCore instance = (SlackUserCore)object;
                this.setId(instance.getId());
                Optional<String> usernameOptional = instance.getUsername();
                if (usernameOptional.isPresent()) {
                    this.setUsername(usernameOptional);
                }
            }
        }

        public final Builder setId(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setUsername(@Nullable String username) {
            this.username = username;
            return this;
        }

        public final Builder setUsername(Optional<String> username) {
            this.username = username.orElse(null);
            return this;
        }

        public SlackUserLite build() throws InvalidImmutableStateException {
            this.checkRequiredAttributes();
            return new SlackUserLite(this.id, this.username);
        }

        private boolean idIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() throws InvalidImmutableStateException {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.idIsSet()) {
                attributes.add("id");
            }
            return "Cannot build SlackUserLite, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    implements SlackUserLiteIF {
        @Nullable
        String id;
        Optional<String> username = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="name")
        public void setUsername(Optional<String> username) {
            this.username = username;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getUsername() {
            throw new UnsupportedOperationException();
        }
    }
}

