package com.hubspot.slack.client;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.horizon.HttpConfig;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.http.NioHttpClient;
import com.hubspot.slack.client.interceptors.calls.SlackMethodAcceptor;
import com.hubspot.slack.client.interceptors.http.RequestDebugger;
import com.hubspot.slack.client.interceptors.http.ResponseDebugger;
import com.hubspot.slack.client.ratelimiting.SlackRateLimiter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link SlackClientRuntimeConfigIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code SlackClientRuntimeConfig.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "SlackClientRuntimeConfigIF"})
@Immutable
public final class SlackClientRuntimeConfig implements SlackClientRuntimeConfigIF {
  private final Supplier<String> tokenSupplier;
  private final Supplier<String> slackApiBasePath;
  private final Supplier<Integer> usersListBatchSize;
  private final Supplier<Integer> channelsListBatchSize;
  private final Supplier<Integer> channelsHistoryMessageBatchSize;
  private final Supplier<Integer> conversationsHistoryMessageBatchSize;
  private final Supplier<Integer> conversationMembersBatchSize;
  private final @Nullable SlackRateLimiter slackRateLimiter;
  private final @Nullable HttpConfig httpConfig;
  private final @Nullable NioHttpClient httpClient;
  private final @Nullable SlackMethodAcceptor methodFilter;
  private final @Nullable RequestDebugger requestDebugger;
  private final @Nullable ResponseDebugger responseDebugger;

  private SlackClientRuntimeConfig(SlackClientRuntimeConfig.Builder builder) {
    this.tokenSupplier = builder.tokenSupplier;
    this.slackRateLimiter = builder.slackRateLimiter;
    this.httpConfig = builder.httpConfig;
    this.httpClient = builder.httpClient;
    this.methodFilter = builder.methodFilter;
    this.requestDebugger = builder.requestDebugger;
    this.responseDebugger = builder.responseDebugger;
    if (builder.slackApiBasePath != null) {
      initShim.setSlackApiBasePath(builder.slackApiBasePath);
    }
    if (builder.usersListBatchSize != null) {
      initShim.setUsersListBatchSize(builder.usersListBatchSize);
    }
    if (builder.channelsListBatchSize != null) {
      initShim.setChannelsListBatchSize(builder.channelsListBatchSize);
    }
    if (builder.channelsHistoryMessageBatchSize != null) {
      initShim.setChannelsHistoryMessageBatchSize(builder.channelsHistoryMessageBatchSize);
    }
    if (builder.conversationsHistoryMessageBatchSize != null) {
      initShim.setConversationsHistoryMessageBatchSize(builder.conversationsHistoryMessageBatchSize);
    }
    if (builder.conversationMembersBatchSize != null) {
      initShim.setConversationMembersBatchSize(builder.conversationMembersBatchSize);
    }
    this.slackApiBasePath = initShim.getSlackApiBasePath();
    this.usersListBatchSize = initShim.getUsersListBatchSize();
    this.channelsListBatchSize = initShim.getChannelsListBatchSize();
    this.channelsHistoryMessageBatchSize = initShim.getChannelsHistoryMessageBatchSize();
    this.conversationsHistoryMessageBatchSize = initShim.getConversationsHistoryMessageBatchSize();
    this.conversationMembersBatchSize = initShim.getConversationMembersBatchSize();
    this.initShim = null;
  }

  private SlackClientRuntimeConfig(
      Supplier<String> tokenSupplier,
      Supplier<String> slackApiBasePath,
      Supplier<Integer> usersListBatchSize,
      Supplier<Integer> channelsListBatchSize,
      Supplier<Integer> channelsHistoryMessageBatchSize,
      Supplier<Integer> conversationsHistoryMessageBatchSize,
      Supplier<Integer> conversationMembersBatchSize,
      @Nullable SlackRateLimiter slackRateLimiter,
      @Nullable HttpConfig httpConfig,
      @Nullable NioHttpClient httpClient,
      @Nullable SlackMethodAcceptor methodFilter,
      @Nullable RequestDebugger requestDebugger,
      @Nullable ResponseDebugger responseDebugger) {
    this.tokenSupplier = tokenSupplier;
    this.slackApiBasePath = slackApiBasePath;
    this.usersListBatchSize = usersListBatchSize;
    this.channelsListBatchSize = channelsListBatchSize;
    this.channelsHistoryMessageBatchSize = channelsHistoryMessageBatchSize;
    this.conversationsHistoryMessageBatchSize = conversationsHistoryMessageBatchSize;
    this.conversationMembersBatchSize = conversationMembersBatchSize;
    this.slackRateLimiter = slackRateLimiter;
    this.httpConfig = httpConfig;
    this.httpClient = httpClient;
    this.methodFilter = methodFilter;
    this.requestDebugger = requestDebugger;
    this.responseDebugger = responseDebugger;
    this.initShim = null;
  }

  private static final int STAGE_INITIALIZING = -1;
  private static final int STAGE_UNINITIALIZED = 0;
  private static final int STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  private final class InitShim {
    private Supplier<String> slackApiBasePath;
    private int slackApiBasePathStage;

    Supplier<String> getSlackApiBasePath() {
      if (slackApiBasePathStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (slackApiBasePathStage == STAGE_UNINITIALIZED) {
        slackApiBasePathStage = STAGE_INITIALIZING;
        this.slackApiBasePath = Objects.requireNonNull(getSlackApiBasePathInitialize(), "slackApiBasePath");
        slackApiBasePathStage = STAGE_INITIALIZED;
      }
      return this.slackApiBasePath;
    }

    void setSlackApiBasePath(Supplier<String> slackApiBasePath) {
      this.slackApiBasePath = slackApiBasePath;
      slackApiBasePathStage = STAGE_INITIALIZED;
    }
    private Supplier<Integer> usersListBatchSize;
    private int usersListBatchSizeStage;

    Supplier<Integer> getUsersListBatchSize() {
      if (usersListBatchSizeStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (usersListBatchSizeStage == STAGE_UNINITIALIZED) {
        usersListBatchSizeStage = STAGE_INITIALIZING;
        this.usersListBatchSize = Objects.requireNonNull(getUsersListBatchSizeInitialize(), "usersListBatchSize");
        usersListBatchSizeStage = STAGE_INITIALIZED;
      }
      return this.usersListBatchSize;
    }

    void setUsersListBatchSize(Supplier<Integer> usersListBatchSize) {
      this.usersListBatchSize = usersListBatchSize;
      usersListBatchSizeStage = STAGE_INITIALIZED;
    }
    private Supplier<Integer> channelsListBatchSize;
    private int channelsListBatchSizeStage;

    Supplier<Integer> getChannelsListBatchSize() {
      if (channelsListBatchSizeStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (channelsListBatchSizeStage == STAGE_UNINITIALIZED) {
        channelsListBatchSizeStage = STAGE_INITIALIZING;
        this.channelsListBatchSize = Objects.requireNonNull(getChannelsListBatchSizeInitialize(), "channelsListBatchSize");
        channelsListBatchSizeStage = STAGE_INITIALIZED;
      }
      return this.channelsListBatchSize;
    }

    void setChannelsListBatchSize(Supplier<Integer> channelsListBatchSize) {
      this.channelsListBatchSize = channelsListBatchSize;
      channelsListBatchSizeStage = STAGE_INITIALIZED;
    }
    private Supplier<Integer> channelsHistoryMessageBatchSize;
    private int channelsHistoryMessageBatchSizeStage;

    Supplier<Integer> getChannelsHistoryMessageBatchSize() {
      if (channelsHistoryMessageBatchSizeStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (channelsHistoryMessageBatchSizeStage == STAGE_UNINITIALIZED) {
        channelsHistoryMessageBatchSizeStage = STAGE_INITIALIZING;
        this.channelsHistoryMessageBatchSize = Objects.requireNonNull(getChannelsHistoryMessageBatchSizeInitialize(), "channelsHistoryMessageBatchSize");
        channelsHistoryMessageBatchSizeStage = STAGE_INITIALIZED;
      }
      return this.channelsHistoryMessageBatchSize;
    }

    void setChannelsHistoryMessageBatchSize(Supplier<Integer> channelsHistoryMessageBatchSize) {
      this.channelsHistoryMessageBatchSize = channelsHistoryMessageBatchSize;
      channelsHistoryMessageBatchSizeStage = STAGE_INITIALIZED;
    }
    private Supplier<Integer> conversationsHistoryMessageBatchSize;
    private int conversationsHistoryMessageBatchSizeStage;

    Supplier<Integer> getConversationsHistoryMessageBatchSize() {
      if (conversationsHistoryMessageBatchSizeStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (conversationsHistoryMessageBatchSizeStage == STAGE_UNINITIALIZED) {
        conversationsHistoryMessageBatchSizeStage = STAGE_INITIALIZING;
        this.conversationsHistoryMessageBatchSize = Objects.requireNonNull(getConversationsHistoryMessageBatchSizeInitialize(), "conversationsHistoryMessageBatchSize");
        conversationsHistoryMessageBatchSizeStage = STAGE_INITIALIZED;
      }
      return this.conversationsHistoryMessageBatchSize;
    }

    void setConversationsHistoryMessageBatchSize(Supplier<Integer> conversationsHistoryMessageBatchSize) {
      this.conversationsHistoryMessageBatchSize = conversationsHistoryMessageBatchSize;
      conversationsHistoryMessageBatchSizeStage = STAGE_INITIALIZED;
    }
    private Supplier<Integer> conversationMembersBatchSize;
    private int conversationMembersBatchSizeStage;

    Supplier<Integer> getConversationMembersBatchSize() {
      if (conversationMembersBatchSizeStage == STAGE_INITIALIZING) throw new InvalidImmutableStateException(formatInitCycleMessage());
      if (conversationMembersBatchSizeStage == STAGE_UNINITIALIZED) {
        conversationMembersBatchSizeStage = STAGE_INITIALIZING;
        this.conversationMembersBatchSize = Objects.requireNonNull(getConversationMembersBatchSizeInitialize(), "conversationMembersBatchSize");
        conversationMembersBatchSizeStage = STAGE_INITIALIZED;
      }
      return this.conversationMembersBatchSize;
    }

    void setConversationMembersBatchSize(Supplier<Integer> conversationMembersBatchSize) {
      this.conversationMembersBatchSize = conversationMembersBatchSize;
      conversationMembersBatchSizeStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      ArrayList<String> attributes = new ArrayList<String>();
      if (slackApiBasePathStage == STAGE_INITIALIZING) attributes.add("slackApiBasePath");
      if (usersListBatchSizeStage == STAGE_INITIALIZING) attributes.add("usersListBatchSize");
      if (channelsListBatchSizeStage == STAGE_INITIALIZING) attributes.add("channelsListBatchSize");
      if (channelsHistoryMessageBatchSizeStage == STAGE_INITIALIZING) attributes.add("channelsHistoryMessageBatchSize");
      if (conversationsHistoryMessageBatchSizeStage == STAGE_INITIALIZING) attributes.add("conversationsHistoryMessageBatchSize");
      if (conversationMembersBatchSizeStage == STAGE_INITIALIZING) attributes.add("conversationMembersBatchSize");
      return "Cannot build SlackClientRuntimeConfig, attribute initializers form cycle" + attributes;
    }
  }

  private Supplier<String> getSlackApiBasePathInitialize() {
    return SlackClientRuntimeConfigIF.super.getSlackApiBasePath();
  }

  private Supplier<Integer> getUsersListBatchSizeInitialize() {
    return SlackClientRuntimeConfigIF.super.getUsersListBatchSize();
  }

  private Supplier<Integer> getChannelsListBatchSizeInitialize() {
    return SlackClientRuntimeConfigIF.super.getChannelsListBatchSize();
  }

  private Supplier<Integer> getChannelsHistoryMessageBatchSizeInitialize() {
    return SlackClientRuntimeConfigIF.super.getChannelsHistoryMessageBatchSize();
  }

  private Supplier<Integer> getConversationsHistoryMessageBatchSizeInitialize() {
    return SlackClientRuntimeConfigIF.super.getConversationsHistoryMessageBatchSize();
  }

  private Supplier<Integer> getConversationMembersBatchSizeInitialize() {
    return SlackClientRuntimeConfigIF.super.getConversationMembersBatchSize();
  }

  /**
   * @return The value of the {@code tokenSupplier} attribute
   */
  @JsonProperty
  @Override
  public Supplier<String> getTokenSupplier() {
    return tokenSupplier;
  }

  /**
   * @return The value of the {@code slackApiBasePath} attribute
   */
  @JsonProperty
  @Override
  public Supplier<String> getSlackApiBasePath() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getSlackApiBasePath()
        : this.slackApiBasePath;
  }

  /**
   * @return The value of the {@code usersListBatchSize} attribute
   */
  @JsonProperty
  @Override
  public Supplier<Integer> getUsersListBatchSize() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getUsersListBatchSize()
        : this.usersListBatchSize;
  }

  /**
   * @return The value of the {@code channelsListBatchSize} attribute
   */
  @JsonProperty
  @Override
  public Supplier<Integer> getChannelsListBatchSize() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getChannelsListBatchSize()
        : this.channelsListBatchSize;
  }

  /**
   * @return The value of the {@code channelsHistoryMessageBatchSize} attribute
   */
  @JsonProperty
  @Override
  public Supplier<Integer> getChannelsHistoryMessageBatchSize() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getChannelsHistoryMessageBatchSize()
        : this.channelsHistoryMessageBatchSize;
  }

  /**
   * @return The value of the {@code conversationsHistoryMessageBatchSize} attribute
   */
  @JsonProperty
  @Override
  public Supplier<Integer> getConversationsHistoryMessageBatchSize() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getConversationsHistoryMessageBatchSize()
        : this.conversationsHistoryMessageBatchSize;
  }

  /**
   * @return The value of the {@code conversationMembersBatchSize} attribute
   */
  @JsonProperty
  @Override
  public Supplier<Integer> getConversationMembersBatchSize() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getConversationMembersBatchSize()
        : this.conversationMembersBatchSize;
  }

  /**
   * @return The value of the {@code slackRateLimiter} attribute
   */
  @JsonProperty
  @Override
  public Optional<SlackRateLimiter> getSlackRateLimiter() {
    return Optional.ofNullable(slackRateLimiter);
  }

  /**
   * @return The value of the {@code httpConfig} attribute
   */
  @JsonProperty
  @Override
  public Optional<HttpConfig> getHttpConfig() {
    return Optional.ofNullable(httpConfig);
  }

  /**
   * @return The value of the {@code httpClient} attribute
   */
  @JsonProperty
  @Override
  public Optional<NioHttpClient> getHttpClient() {
    return Optional.ofNullable(httpClient);
  }

  /**
   * @return The value of the {@code methodFilter} attribute
   */
  @JsonProperty
  @Override
  public Optional<SlackMethodAcceptor> getMethodFilter() {
    return Optional.ofNullable(methodFilter);
  }

  /**
   * @return The value of the {@code requestDebugger} attribute
   */
  @JsonProperty
  @Override
  public Optional<RequestDebugger> getRequestDebugger() {
    return Optional.ofNullable(requestDebugger);
  }

  /**
   * @return The value of the {@code responseDebugger} attribute
   */
  @JsonProperty
  @Override
  public Optional<ResponseDebugger> getResponseDebugger() {
    return Optional.ofNullable(responseDebugger);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackClientRuntimeConfigIF#getTokenSupplier() tokenSupplier} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param tokenSupplier A new value for tokenSupplier
   * @return A modified copy of the {@code this} object
   */
  public final SlackClientRuntimeConfig withTokenSupplier(Supplier<String> tokenSupplier) {
    if (this.tokenSupplier == tokenSupplier) return this;
    Supplier<String> newValue = Objects.requireNonNull(tokenSupplier, "tokenSupplier");
    return new SlackClientRuntimeConfig(
        newValue,
        this.slackApiBasePath,
        this.usersListBatchSize,
        this.channelsListBatchSize,
        this.channelsHistoryMessageBatchSize,
        this.conversationsHistoryMessageBatchSize,
        this.conversationMembersBatchSize,
        this.slackRateLimiter,
        this.httpConfig,
        this.httpClient,
        this.methodFilter,
        this.requestDebugger,
        this.responseDebugger);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackClientRuntimeConfigIF#getSlackApiBasePath() slackApiBasePath} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param slackApiBasePath A new value for slackApiBasePath
   * @return A modified copy of the {@code this} object
   */
  public final SlackClientRuntimeConfig withSlackApiBasePath(Supplier<String> slackApiBasePath) {
    if (this.slackApiBasePath == slackApiBasePath) return this;
    Supplier<String> newValue = Objects.requireNonNull(slackApiBasePath, "slackApiBasePath");
    return new SlackClientRuntimeConfig(
        this.tokenSupplier,
        newValue,
        this.usersListBatchSize,
        this.channelsListBatchSize,
        this.channelsHistoryMessageBatchSize,
        this.conversationsHistoryMessageBatchSize,
        this.conversationMembersBatchSize,
        this.slackRateLimiter,
        this.httpConfig,
        this.httpClient,
        this.methodFilter,
        this.requestDebugger,
        this.responseDebugger);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackClientRuntimeConfigIF#getUsersListBatchSize() usersListBatchSize} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param usersListBatchSize A new value for usersListBatchSize
   * @return A modified copy of the {@code this} object
   */
  public final SlackClientRuntimeConfig withUsersListBatchSize(Supplier<Integer> usersListBatchSize) {
    if (this.usersListBatchSize == usersListBatchSize) return this;
    Supplier<Integer> newValue = Objects.requireNonNull(usersListBatchSize, "usersListBatchSize");
    return new SlackClientRuntimeConfig(
        this.tokenSupplier,
        this.slackApiBasePath,
        newValue,
        this.channelsListBatchSize,
        this.channelsHistoryMessageBatchSize,
        this.conversationsHistoryMessageBatchSize,
        this.conversationMembersBatchSize,
        this.slackRateLimiter,
        this.httpConfig,
        this.httpClient,
        this.methodFilter,
        this.requestDebugger,
        this.responseDebugger);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackClientRuntimeConfigIF#getChannelsListBatchSize() channelsListBatchSize} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param channelsListBatchSize A new value for channelsListBatchSize
   * @return A modified copy of the {@code this} object
   */
  public final SlackClientRuntimeConfig withChannelsListBatchSize(Supplier<Integer> channelsListBatchSize) {
    if (this.channelsListBatchSize == channelsListBatchSize) return this;
    Supplier<Integer> newValue = Objects.requireNonNull(channelsListBatchSize, "channelsListBatchSize");
    return new SlackClientRuntimeConfig(
        this.tokenSupplier,
        this.slackApiBasePath,
        this.usersListBatchSize,
        newValue,
        this.channelsHistoryMessageBatchSize,
        this.conversationsHistoryMessageBatchSize,
        this.conversationMembersBatchSize,
        this.slackRateLimiter,
        this.httpConfig,
        this.httpClient,
        this.methodFilter,
        this.requestDebugger,
        this.responseDebugger);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackClientRuntimeConfigIF#getChannelsHistoryMessageBatchSize() channelsHistoryMessageBatchSize} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param channelsHistoryMessageBatchSize A new value for channelsHistoryMessageBatchSize
   * @return A modified copy of the {@code this} object
   */
  public final SlackClientRuntimeConfig withChannelsHistoryMessageBatchSize(Supplier<Integer> channelsHistoryMessageBatchSize) {
    if (this.channelsHistoryMessageBatchSize == channelsHistoryMessageBatchSize) return this;
    Supplier<Integer> newValue = Objects.requireNonNull(channelsHistoryMessageBatchSize, "channelsHistoryMessageBatchSize");
    return new SlackClientRuntimeConfig(
        this.tokenSupplier,
        this.slackApiBasePath,
        this.usersListBatchSize,
        this.channelsListBatchSize,
        newValue,
        this.conversationsHistoryMessageBatchSize,
        this.conversationMembersBatchSize,
        this.slackRateLimiter,
        this.httpConfig,
        this.httpClient,
        this.methodFilter,
        this.requestDebugger,
        this.responseDebugger);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackClientRuntimeConfigIF#getConversationsHistoryMessageBatchSize() conversationsHistoryMessageBatchSize} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param conversationsHistoryMessageBatchSize A new value for conversationsHistoryMessageBatchSize
   * @return A modified copy of the {@code this} object
   */
  public final SlackClientRuntimeConfig withConversationsHistoryMessageBatchSize(Supplier<Integer> conversationsHistoryMessageBatchSize) {
    if (this.conversationsHistoryMessageBatchSize == conversationsHistoryMessageBatchSize) return this;
    Supplier<Integer> newValue = Objects.requireNonNull(conversationsHistoryMessageBatchSize, "conversationsHistoryMessageBatchSize");
    return new SlackClientRuntimeConfig(
        this.tokenSupplier,
        this.slackApiBasePath,
        this.usersListBatchSize,
        this.channelsListBatchSize,
        this.channelsHistoryMessageBatchSize,
        newValue,
        this.conversationMembersBatchSize,
        this.slackRateLimiter,
        this.httpConfig,
        this.httpClient,
        this.methodFilter,
        this.requestDebugger,
        this.responseDebugger);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link SlackClientRuntimeConfigIF#getConversationMembersBatchSize() conversationMembersBatchSize} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param conversationMembersBatchSize A new value for conversationMembersBatchSize
   * @return A modified copy of the {@code this} object
   */
  public final SlackClientRuntimeConfig withConversationMembersBatchSize(Supplier<Integer> conversationMembersBatchSize) {
    if (this.conversationMembersBatchSize == conversationMembersBatchSize) return this;
    Supplier<Integer> newValue = Objects.requireNonNull(conversationMembersBatchSize, "conversationMembersBatchSize");
    return new SlackClientRuntimeConfig(
        this.tokenSupplier,
        this.slackApiBasePath,
        this.usersListBatchSize,
        this.channelsListBatchSize,
        this.channelsHistoryMessageBatchSize,
        this.conversationsHistoryMessageBatchSize,
        newValue,
        this.slackRateLimiter,
        this.httpConfig,
        this.httpClient,
        this.methodFilter,
        this.requestDebugger,
        this.responseDebugger);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackClientRuntimeConfigIF#getSlackRateLimiter() slackRateLimiter} attribute.
   * @param value The value for slackRateLimiter, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackClientRuntimeConfig withSlackRateLimiter(@Nullable SlackRateLimiter value) {
    @Nullable SlackRateLimiter newValue = value;
    if (this.slackRateLimiter == newValue) return this;
    return new SlackClientRuntimeConfig(
        this.tokenSupplier,
        this.slackApiBasePath,
        this.usersListBatchSize,
        this.channelsListBatchSize,
        this.channelsHistoryMessageBatchSize,
        this.conversationsHistoryMessageBatchSize,
        this.conversationMembersBatchSize,
        newValue,
        this.httpConfig,
        this.httpClient,
        this.methodFilter,
        this.requestDebugger,
        this.responseDebugger);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackClientRuntimeConfigIF#getSlackRateLimiter() slackRateLimiter} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for slackRateLimiter
   * @return A modified copy of {@code this} object
   */
  public final SlackClientRuntimeConfig withSlackRateLimiter(Optional<SlackRateLimiter> optional) {
    @Nullable SlackRateLimiter value = optional.orElse(null);
    if (this.slackRateLimiter == value) return this;
    return new SlackClientRuntimeConfig(
        this.tokenSupplier,
        this.slackApiBasePath,
        this.usersListBatchSize,
        this.channelsListBatchSize,
        this.channelsHistoryMessageBatchSize,
        this.conversationsHistoryMessageBatchSize,
        this.conversationMembersBatchSize,
        value,
        this.httpConfig,
        this.httpClient,
        this.methodFilter,
        this.requestDebugger,
        this.responseDebugger);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackClientRuntimeConfigIF#getHttpConfig() httpConfig} attribute.
   * @param value The value for httpConfig, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackClientRuntimeConfig withHttpConfig(@Nullable HttpConfig value) {
    @Nullable HttpConfig newValue = value;
    if (this.httpConfig == newValue) return this;
    return new SlackClientRuntimeConfig(
        this.tokenSupplier,
        this.slackApiBasePath,
        this.usersListBatchSize,
        this.channelsListBatchSize,
        this.channelsHistoryMessageBatchSize,
        this.conversationsHistoryMessageBatchSize,
        this.conversationMembersBatchSize,
        this.slackRateLimiter,
        newValue,
        this.httpClient,
        this.methodFilter,
        this.requestDebugger,
        this.responseDebugger);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackClientRuntimeConfigIF#getHttpConfig() httpConfig} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for httpConfig
   * @return A modified copy of {@code this} object
   */
  public final SlackClientRuntimeConfig withHttpConfig(Optional<HttpConfig> optional) {
    @Nullable HttpConfig value = optional.orElse(null);
    if (this.httpConfig == value) return this;
    return new SlackClientRuntimeConfig(
        this.tokenSupplier,
        this.slackApiBasePath,
        this.usersListBatchSize,
        this.channelsListBatchSize,
        this.channelsHistoryMessageBatchSize,
        this.conversationsHistoryMessageBatchSize,
        this.conversationMembersBatchSize,
        this.slackRateLimiter,
        value,
        this.httpClient,
        this.methodFilter,
        this.requestDebugger,
        this.responseDebugger);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackClientRuntimeConfigIF#getHttpClient() httpClient} attribute.
   * @param value The value for httpClient, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackClientRuntimeConfig withHttpClient(@Nullable NioHttpClient value) {
    @Nullable NioHttpClient newValue = value;
    if (this.httpClient == newValue) return this;
    return new SlackClientRuntimeConfig(
        this.tokenSupplier,
        this.slackApiBasePath,
        this.usersListBatchSize,
        this.channelsListBatchSize,
        this.channelsHistoryMessageBatchSize,
        this.conversationsHistoryMessageBatchSize,
        this.conversationMembersBatchSize,
        this.slackRateLimiter,
        this.httpConfig,
        newValue,
        this.methodFilter,
        this.requestDebugger,
        this.responseDebugger);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackClientRuntimeConfigIF#getHttpClient() httpClient} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for httpClient
   * @return A modified copy of {@code this} object
   */
  public final SlackClientRuntimeConfig withHttpClient(Optional<NioHttpClient> optional) {
    @Nullable NioHttpClient value = optional.orElse(null);
    if (this.httpClient == value) return this;
    return new SlackClientRuntimeConfig(
        this.tokenSupplier,
        this.slackApiBasePath,
        this.usersListBatchSize,
        this.channelsListBatchSize,
        this.channelsHistoryMessageBatchSize,
        this.conversationsHistoryMessageBatchSize,
        this.conversationMembersBatchSize,
        this.slackRateLimiter,
        this.httpConfig,
        value,
        this.methodFilter,
        this.requestDebugger,
        this.responseDebugger);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackClientRuntimeConfigIF#getMethodFilter() methodFilter} attribute.
   * @param value The value for methodFilter, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackClientRuntimeConfig withMethodFilter(@Nullable SlackMethodAcceptor value) {
    @Nullable SlackMethodAcceptor newValue = value;
    if (this.methodFilter == newValue) return this;
    return new SlackClientRuntimeConfig(
        this.tokenSupplier,
        this.slackApiBasePath,
        this.usersListBatchSize,
        this.channelsListBatchSize,
        this.channelsHistoryMessageBatchSize,
        this.conversationsHistoryMessageBatchSize,
        this.conversationMembersBatchSize,
        this.slackRateLimiter,
        this.httpConfig,
        this.httpClient,
        newValue,
        this.requestDebugger,
        this.responseDebugger);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackClientRuntimeConfigIF#getMethodFilter() methodFilter} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for methodFilter
   * @return A modified copy of {@code this} object
   */
  public final SlackClientRuntimeConfig withMethodFilter(Optional<SlackMethodAcceptor> optional) {
    @Nullable SlackMethodAcceptor value = optional.orElse(null);
    if (this.methodFilter == value) return this;
    return new SlackClientRuntimeConfig(
        this.tokenSupplier,
        this.slackApiBasePath,
        this.usersListBatchSize,
        this.channelsListBatchSize,
        this.channelsHistoryMessageBatchSize,
        this.conversationsHistoryMessageBatchSize,
        this.conversationMembersBatchSize,
        this.slackRateLimiter,
        this.httpConfig,
        this.httpClient,
        value,
        this.requestDebugger,
        this.responseDebugger);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackClientRuntimeConfigIF#getRequestDebugger() requestDebugger} attribute.
   * @param value The value for requestDebugger, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackClientRuntimeConfig withRequestDebugger(@Nullable RequestDebugger value) {
    @Nullable RequestDebugger newValue = value;
    if (this.requestDebugger == newValue) return this;
    return new SlackClientRuntimeConfig(
        this.tokenSupplier,
        this.slackApiBasePath,
        this.usersListBatchSize,
        this.channelsListBatchSize,
        this.channelsHistoryMessageBatchSize,
        this.conversationsHistoryMessageBatchSize,
        this.conversationMembersBatchSize,
        this.slackRateLimiter,
        this.httpConfig,
        this.httpClient,
        this.methodFilter,
        newValue,
        this.responseDebugger);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackClientRuntimeConfigIF#getRequestDebugger() requestDebugger} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for requestDebugger
   * @return A modified copy of {@code this} object
   */
  public final SlackClientRuntimeConfig withRequestDebugger(Optional<RequestDebugger> optional) {
    @Nullable RequestDebugger value = optional.orElse(null);
    if (this.requestDebugger == value) return this;
    return new SlackClientRuntimeConfig(
        this.tokenSupplier,
        this.slackApiBasePath,
        this.usersListBatchSize,
        this.channelsListBatchSize,
        this.channelsHistoryMessageBatchSize,
        this.conversationsHistoryMessageBatchSize,
        this.conversationMembersBatchSize,
        this.slackRateLimiter,
        this.httpConfig,
        this.httpClient,
        this.methodFilter,
        value,
        this.responseDebugger);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link SlackClientRuntimeConfigIF#getResponseDebugger() responseDebugger} attribute.
   * @param value The value for responseDebugger, {@code null} is accepted as {@code java.util.Optional.empty()}
   * @return A modified copy of {@code this} object
   */
  public final SlackClientRuntimeConfig withResponseDebugger(@Nullable ResponseDebugger value) {
    @Nullable ResponseDebugger newValue = value;
    if (this.responseDebugger == newValue) return this;
    return new SlackClientRuntimeConfig(
        this.tokenSupplier,
        this.slackApiBasePath,
        this.usersListBatchSize,
        this.channelsListBatchSize,
        this.channelsHistoryMessageBatchSize,
        this.conversationsHistoryMessageBatchSize,
        this.conversationMembersBatchSize,
        this.slackRateLimiter,
        this.httpConfig,
        this.httpClient,
        this.methodFilter,
        this.requestDebugger,
        newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link SlackClientRuntimeConfigIF#getResponseDebugger() responseDebugger} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for responseDebugger
   * @return A modified copy of {@code this} object
   */
  public final SlackClientRuntimeConfig withResponseDebugger(Optional<ResponseDebugger> optional) {
    @Nullable ResponseDebugger value = optional.orElse(null);
    if (this.responseDebugger == value) return this;
    return new SlackClientRuntimeConfig(
        this.tokenSupplier,
        this.slackApiBasePath,
        this.usersListBatchSize,
        this.channelsListBatchSize,
        this.channelsHistoryMessageBatchSize,
        this.conversationsHistoryMessageBatchSize,
        this.conversationMembersBatchSize,
        this.slackRateLimiter,
        this.httpConfig,
        this.httpClient,
        this.methodFilter,
        this.requestDebugger,
        value);
  }

  /**
   * This instance is equal to all instances of {@code SlackClientRuntimeConfig} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof SlackClientRuntimeConfig
        && equalTo((SlackClientRuntimeConfig) another);
  }

  private boolean equalTo(SlackClientRuntimeConfig another) {
    return tokenSupplier.equals(another.tokenSupplier)
        && slackApiBasePath.equals(another.slackApiBasePath)
        && usersListBatchSize.equals(another.usersListBatchSize)
        && channelsListBatchSize.equals(another.channelsListBatchSize)
        && channelsHistoryMessageBatchSize.equals(another.channelsHistoryMessageBatchSize)
        && conversationsHistoryMessageBatchSize.equals(another.conversationsHistoryMessageBatchSize)
        && conversationMembersBatchSize.equals(another.conversationMembersBatchSize)
        && Objects.equals(slackRateLimiter, another.slackRateLimiter)
        && Objects.equals(httpConfig, another.httpConfig)
        && Objects.equals(httpClient, another.httpClient)
        && Objects.equals(methodFilter, another.methodFilter)
        && Objects.equals(requestDebugger, another.requestDebugger)
        && Objects.equals(responseDebugger, another.responseDebugger);
  }

  /**
   * Computes a hash code from attributes: {@code tokenSupplier}, {@code slackApiBasePath}, {@code usersListBatchSize}, {@code channelsListBatchSize}, {@code channelsHistoryMessageBatchSize}, {@code conversationsHistoryMessageBatchSize}, {@code conversationMembersBatchSize}, {@code slackRateLimiter}, {@code httpConfig}, {@code httpClient}, {@code methodFilter}, {@code requestDebugger}, {@code responseDebugger}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + tokenSupplier.hashCode();
    h = h * 17 + slackApiBasePath.hashCode();
    h = h * 17 + usersListBatchSize.hashCode();
    h = h * 17 + channelsListBatchSize.hashCode();
    h = h * 17 + channelsHistoryMessageBatchSize.hashCode();
    h = h * 17 + conversationsHistoryMessageBatchSize.hashCode();
    h = h * 17 + conversationMembersBatchSize.hashCode();
    h = h * 17 + Objects.hashCode(slackRateLimiter);
    h = h * 17 + Objects.hashCode(httpConfig);
    h = h * 17 + Objects.hashCode(httpClient);
    h = h * 17 + Objects.hashCode(methodFilter);
    h = h * 17 + Objects.hashCode(requestDebugger);
    h = h * 17 + Objects.hashCode(responseDebugger);
    return h;
  }

  /**
   * Prints the immutable value {@code SlackClientRuntimeConfig} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder("SlackClientRuntimeConfig{");
    builder.append("tokenSupplier=").append(tokenSupplier);
    builder.append(", ");
    builder.append("slackApiBasePath=").append(slackApiBasePath);
    builder.append(", ");
    builder.append("usersListBatchSize=").append(usersListBatchSize);
    builder.append(", ");
    builder.append("channelsListBatchSize=").append(channelsListBatchSize);
    builder.append(", ");
    builder.append("channelsHistoryMessageBatchSize=").append(channelsHistoryMessageBatchSize);
    builder.append(", ");
    builder.append("conversationsHistoryMessageBatchSize=").append(conversationsHistoryMessageBatchSize);
    builder.append(", ");
    builder.append("conversationMembersBatchSize=").append(conversationMembersBatchSize);
    if (slackRateLimiter != null) {
      builder.append(", ");
      builder.append("slackRateLimiter=").append(slackRateLimiter);
    }
    if (httpConfig != null) {
      builder.append(", ");
      builder.append("httpConfig=").append(httpConfig);
    }
    if (httpClient != null) {
      builder.append(", ");
      builder.append("httpClient=").append(httpClient);
    }
    if (methodFilter != null) {
      builder.append(", ");
      builder.append("methodFilter=").append(methodFilter);
    }
    if (requestDebugger != null) {
      builder.append(", ");
      builder.append("requestDebugger=").append(requestDebugger);
    }
    if (responseDebugger != null) {
      builder.append(", ");
      builder.append("responseDebugger=").append(responseDebugger);
    }
    return builder.append("}").toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements SlackClientRuntimeConfigIF {
    @Nullable Supplier<String> tokenSupplier;
    @Nullable Supplier<String> slackApiBasePath;
    @Nullable Supplier<Integer> usersListBatchSize;
    @Nullable Supplier<Integer> channelsListBatchSize;
    @Nullable Supplier<Integer> channelsHistoryMessageBatchSize;
    @Nullable Supplier<Integer> conversationsHistoryMessageBatchSize;
    @Nullable Supplier<Integer> conversationMembersBatchSize;
    Optional<SlackRateLimiter> slackRateLimiter = Optional.empty();
    Optional<HttpConfig> httpConfig = Optional.empty();
    Optional<NioHttpClient> httpClient = Optional.empty();
    Optional<SlackMethodAcceptor> methodFilter = Optional.empty();
    Optional<RequestDebugger> requestDebugger = Optional.empty();
    Optional<ResponseDebugger> responseDebugger = Optional.empty();
    @JsonProperty
    public void setTokenSupplier(Supplier<String> tokenSupplier) {
      this.tokenSupplier = tokenSupplier;
    }
    @JsonProperty
    public void setSlackApiBasePath(Supplier<String> slackApiBasePath) {
      this.slackApiBasePath = slackApiBasePath;
    }
    @JsonProperty
    public void setUsersListBatchSize(Supplier<Integer> usersListBatchSize) {
      this.usersListBatchSize = usersListBatchSize;
    }
    @JsonProperty
    public void setChannelsListBatchSize(Supplier<Integer> channelsListBatchSize) {
      this.channelsListBatchSize = channelsListBatchSize;
    }
    @JsonProperty
    public void setChannelsHistoryMessageBatchSize(Supplier<Integer> channelsHistoryMessageBatchSize) {
      this.channelsHistoryMessageBatchSize = channelsHistoryMessageBatchSize;
    }
    @JsonProperty
    public void setConversationsHistoryMessageBatchSize(Supplier<Integer> conversationsHistoryMessageBatchSize) {
      this.conversationsHistoryMessageBatchSize = conversationsHistoryMessageBatchSize;
    }
    @JsonProperty
    public void setConversationMembersBatchSize(Supplier<Integer> conversationMembersBatchSize) {
      this.conversationMembersBatchSize = conversationMembersBatchSize;
    }
    @JsonProperty
    public void setSlackRateLimiter(Optional<SlackRateLimiter> slackRateLimiter) {
      this.slackRateLimiter = slackRateLimiter;
    }
    @JsonProperty
    public void setHttpConfig(Optional<HttpConfig> httpConfig) {
      this.httpConfig = httpConfig;
    }
    @JsonProperty
    public void setHttpClient(Optional<NioHttpClient> httpClient) {
      this.httpClient = httpClient;
    }
    @JsonProperty
    public void setMethodFilter(Optional<SlackMethodAcceptor> methodFilter) {
      this.methodFilter = methodFilter;
    }
    @JsonProperty
    public void setRequestDebugger(Optional<RequestDebugger> requestDebugger) {
      this.requestDebugger = requestDebugger;
    }
    @JsonProperty
    public void setResponseDebugger(Optional<ResponseDebugger> responseDebugger) {
      this.responseDebugger = responseDebugger;
    }
    @Override
    public Supplier<String> getTokenSupplier() { throw new UnsupportedOperationException(); }
    @Override
    public Supplier<String> getSlackApiBasePath() { throw new UnsupportedOperationException(); }
    @Override
    public Supplier<Integer> getUsersListBatchSize() { throw new UnsupportedOperationException(); }
    @Override
    public Supplier<Integer> getChannelsListBatchSize() { throw new UnsupportedOperationException(); }
    @Override
    public Supplier<Integer> getChannelsHistoryMessageBatchSize() { throw new UnsupportedOperationException(); }
    @Override
    public Supplier<Integer> getConversationsHistoryMessageBatchSize() { throw new UnsupportedOperationException(); }
    @Override
    public Supplier<Integer> getConversationMembersBatchSize() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<SlackRateLimiter> getSlackRateLimiter() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<HttpConfig> getHttpConfig() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<NioHttpClient> getHttpClient() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<SlackMethodAcceptor> getMethodFilter() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<RequestDebugger> getRequestDebugger() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<ResponseDebugger> getResponseDebugger() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static SlackClientRuntimeConfig fromJson(Json json) {
    SlackClientRuntimeConfig.Builder builder = SlackClientRuntimeConfig.builder();
    if (json.tokenSupplier != null) {
      builder.setTokenSupplier(json.tokenSupplier);
    }
    if (json.slackApiBasePath != null) {
      builder.setSlackApiBasePath(json.slackApiBasePath);
    }
    if (json.usersListBatchSize != null) {
      builder.setUsersListBatchSize(json.usersListBatchSize);
    }
    if (json.channelsListBatchSize != null) {
      builder.setChannelsListBatchSize(json.channelsListBatchSize);
    }
    if (json.channelsHistoryMessageBatchSize != null) {
      builder.setChannelsHistoryMessageBatchSize(json.channelsHistoryMessageBatchSize);
    }
    if (json.conversationsHistoryMessageBatchSize != null) {
      builder.setConversationsHistoryMessageBatchSize(json.conversationsHistoryMessageBatchSize);
    }
    if (json.conversationMembersBatchSize != null) {
      builder.setConversationMembersBatchSize(json.conversationMembersBatchSize);
    }
    if (json.slackRateLimiter != null) {
      builder.setSlackRateLimiter(json.slackRateLimiter);
    }
    if (json.httpConfig != null) {
      builder.setHttpConfig(json.httpConfig);
    }
    if (json.httpClient != null) {
      builder.setHttpClient(json.httpClient);
    }
    if (json.methodFilter != null) {
      builder.setMethodFilter(json.methodFilter);
    }
    if (json.requestDebugger != null) {
      builder.setRequestDebugger(json.requestDebugger);
    }
    if (json.responseDebugger != null) {
      builder.setResponseDebugger(json.responseDebugger);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link SlackClientRuntimeConfigIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable SlackClientRuntimeConfig instance
   */
  public static SlackClientRuntimeConfig copyOf(SlackClientRuntimeConfigIF instance) {
    if (instance instanceof SlackClientRuntimeConfig) {
      return (SlackClientRuntimeConfig) instance;
    }
    return SlackClientRuntimeConfig.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link SlackClientRuntimeConfig SlackClientRuntimeConfig}.
   * @return A new SlackClientRuntimeConfig builder
   */
  public static SlackClientRuntimeConfig.Builder builder() {
    return new SlackClientRuntimeConfig.Builder();
  }

  /**
   * Builds instances of type {@link SlackClientRuntimeConfig SlackClientRuntimeConfig}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TOKEN_SUPPLIER = 0x1L;
    private long initBits = 0x1L;

    private @Nullable Supplier<String> tokenSupplier;
    private @Nullable Supplier<String> slackApiBasePath;
    private @Nullable Supplier<Integer> usersListBatchSize;
    private @Nullable Supplier<Integer> channelsListBatchSize;
    private @Nullable Supplier<Integer> channelsHistoryMessageBatchSize;
    private @Nullable Supplier<Integer> conversationsHistoryMessageBatchSize;
    private @Nullable Supplier<Integer> conversationMembersBatchSize;
    private @Nullable SlackRateLimiter slackRateLimiter;
    private @Nullable HttpConfig httpConfig;
    private @Nullable NioHttpClient httpClient;
    private @Nullable SlackMethodAcceptor methodFilter;
    private @Nullable RequestDebugger requestDebugger;
    private @Nullable ResponseDebugger responseDebugger;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code SlackClientRuntimeConfigIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(SlackClientRuntimeConfigIF instance) {
      Objects.requireNonNull(instance, "instance");
      setTokenSupplier(instance.getTokenSupplier());
      setSlackApiBasePath(instance.getSlackApiBasePath());
      setUsersListBatchSize(instance.getUsersListBatchSize());
      setChannelsListBatchSize(instance.getChannelsListBatchSize());
      setChannelsHistoryMessageBatchSize(instance.getChannelsHistoryMessageBatchSize());
      setConversationsHistoryMessageBatchSize(instance.getConversationsHistoryMessageBatchSize());
      setConversationMembersBatchSize(instance.getConversationMembersBatchSize());
      Optional<SlackRateLimiter> slackRateLimiterOptional = instance.getSlackRateLimiter();
      if (slackRateLimiterOptional.isPresent()) {
        setSlackRateLimiter(slackRateLimiterOptional);
      }
      Optional<HttpConfig> httpConfigOptional = instance.getHttpConfig();
      if (httpConfigOptional.isPresent()) {
        setHttpConfig(httpConfigOptional);
      }
      Optional<NioHttpClient> httpClientOptional = instance.getHttpClient();
      if (httpClientOptional.isPresent()) {
        setHttpClient(httpClientOptional);
      }
      Optional<SlackMethodAcceptor> methodFilterOptional = instance.getMethodFilter();
      if (methodFilterOptional.isPresent()) {
        setMethodFilter(methodFilterOptional);
      }
      Optional<RequestDebugger> requestDebuggerOptional = instance.getRequestDebugger();
      if (requestDebuggerOptional.isPresent()) {
        setRequestDebugger(requestDebuggerOptional);
      }
      Optional<ResponseDebugger> responseDebuggerOptional = instance.getResponseDebugger();
      if (responseDebuggerOptional.isPresent()) {
        setResponseDebugger(responseDebuggerOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link SlackClientRuntimeConfigIF#getTokenSupplier() tokenSupplier} attribute.
     * @param tokenSupplier The value for tokenSupplier 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setTokenSupplier(Supplier<String> tokenSupplier) {
      this.tokenSupplier = Objects.requireNonNull(tokenSupplier, "tokenSupplier");
      initBits &= ~INIT_BIT_TOKEN_SUPPLIER;
      return this;
    }

    /**
     * Initializes the value for the {@link SlackClientRuntimeConfigIF#getSlackApiBasePath() slackApiBasePath} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SlackClientRuntimeConfigIF#getSlackApiBasePath() slackApiBasePath}.</em>
     * @param slackApiBasePath The value for slackApiBasePath 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setSlackApiBasePath(Supplier<String> slackApiBasePath) {
      this.slackApiBasePath = Objects.requireNonNull(slackApiBasePath, "slackApiBasePath");
      return this;
    }

    /**
     * Initializes the value for the {@link SlackClientRuntimeConfigIF#getUsersListBatchSize() usersListBatchSize} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SlackClientRuntimeConfigIF#getUsersListBatchSize() usersListBatchSize}.</em>
     * @param usersListBatchSize The value for usersListBatchSize 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setUsersListBatchSize(Supplier<Integer> usersListBatchSize) {
      this.usersListBatchSize = Objects.requireNonNull(usersListBatchSize, "usersListBatchSize");
      return this;
    }

    /**
     * Initializes the value for the {@link SlackClientRuntimeConfigIF#getChannelsListBatchSize() channelsListBatchSize} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SlackClientRuntimeConfigIF#getChannelsListBatchSize() channelsListBatchSize}.</em>
     * @param channelsListBatchSize The value for channelsListBatchSize 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannelsListBatchSize(Supplier<Integer> channelsListBatchSize) {
      this.channelsListBatchSize = Objects.requireNonNull(channelsListBatchSize, "channelsListBatchSize");
      return this;
    }

    /**
     * Initializes the value for the {@link SlackClientRuntimeConfigIF#getChannelsHistoryMessageBatchSize() channelsHistoryMessageBatchSize} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SlackClientRuntimeConfigIF#getChannelsHistoryMessageBatchSize() channelsHistoryMessageBatchSize}.</em>
     * @param channelsHistoryMessageBatchSize The value for channelsHistoryMessageBatchSize 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setChannelsHistoryMessageBatchSize(Supplier<Integer> channelsHistoryMessageBatchSize) {
      this.channelsHistoryMessageBatchSize = Objects.requireNonNull(channelsHistoryMessageBatchSize, "channelsHistoryMessageBatchSize");
      return this;
    }

    /**
     * Initializes the value for the {@link SlackClientRuntimeConfigIF#getConversationsHistoryMessageBatchSize() conversationsHistoryMessageBatchSize} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SlackClientRuntimeConfigIF#getConversationsHistoryMessageBatchSize() conversationsHistoryMessageBatchSize}.</em>
     * @param conversationsHistoryMessageBatchSize The value for conversationsHistoryMessageBatchSize 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setConversationsHistoryMessageBatchSize(Supplier<Integer> conversationsHistoryMessageBatchSize) {
      this.conversationsHistoryMessageBatchSize = Objects.requireNonNull(conversationsHistoryMessageBatchSize, "conversationsHistoryMessageBatchSize");
      return this;
    }

    /**
     * Initializes the value for the {@link SlackClientRuntimeConfigIF#getConversationMembersBatchSize() conversationMembersBatchSize} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link SlackClientRuntimeConfigIF#getConversationMembersBatchSize() conversationMembersBatchSize}.</em>
     * @param conversationMembersBatchSize The value for conversationMembersBatchSize 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setConversationMembersBatchSize(Supplier<Integer> conversationMembersBatchSize) {
      this.conversationMembersBatchSize = Objects.requireNonNull(conversationMembersBatchSize, "conversationMembersBatchSize");
      return this;
    }

    /**
     * Initializes the optional value {@link SlackClientRuntimeConfigIF#getSlackRateLimiter() slackRateLimiter} to slackRateLimiter.
     * @param slackRateLimiter The value for slackRateLimiter, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setSlackRateLimiter(@Nullable SlackRateLimiter slackRateLimiter) {
      this.slackRateLimiter = slackRateLimiter;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackClientRuntimeConfigIF#getSlackRateLimiter() slackRateLimiter} to slackRateLimiter.
     * @param slackRateLimiter The value for slackRateLimiter
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setSlackRateLimiter(Optional<SlackRateLimiter> slackRateLimiter) {
      this.slackRateLimiter = slackRateLimiter.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link SlackClientRuntimeConfigIF#getHttpConfig() httpConfig} to httpConfig.
     * @param httpConfig The value for httpConfig, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setHttpConfig(@Nullable HttpConfig httpConfig) {
      this.httpConfig = httpConfig;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackClientRuntimeConfigIF#getHttpConfig() httpConfig} to httpConfig.
     * @param httpConfig The value for httpConfig
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setHttpConfig(Optional<HttpConfig> httpConfig) {
      this.httpConfig = httpConfig.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link SlackClientRuntimeConfigIF#getHttpClient() httpClient} to httpClient.
     * @param httpClient The value for httpClient, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setHttpClient(@Nullable NioHttpClient httpClient) {
      this.httpClient = httpClient;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackClientRuntimeConfigIF#getHttpClient() httpClient} to httpClient.
     * @param httpClient The value for httpClient
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setHttpClient(Optional<NioHttpClient> httpClient) {
      this.httpClient = httpClient.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link SlackClientRuntimeConfigIF#getMethodFilter() methodFilter} to methodFilter.
     * @param methodFilter The value for methodFilter, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setMethodFilter(@Nullable SlackMethodAcceptor methodFilter) {
      this.methodFilter = methodFilter;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackClientRuntimeConfigIF#getMethodFilter() methodFilter} to methodFilter.
     * @param methodFilter The value for methodFilter
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setMethodFilter(Optional<SlackMethodAcceptor> methodFilter) {
      this.methodFilter = methodFilter.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link SlackClientRuntimeConfigIF#getRequestDebugger() requestDebugger} to requestDebugger.
     * @param requestDebugger The value for requestDebugger, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setRequestDebugger(@Nullable RequestDebugger requestDebugger) {
      this.requestDebugger = requestDebugger;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackClientRuntimeConfigIF#getRequestDebugger() requestDebugger} to requestDebugger.
     * @param requestDebugger The value for requestDebugger
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setRequestDebugger(Optional<RequestDebugger> requestDebugger) {
      this.requestDebugger = requestDebugger.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link SlackClientRuntimeConfigIF#getResponseDebugger() responseDebugger} to responseDebugger.
     * @param responseDebugger The value for responseDebugger, {@code null} is accepted as {@code java.util.Optional.empty()}
     * @return {@code this} builder for chained invocation
     */
    public final Builder setResponseDebugger(@Nullable ResponseDebugger responseDebugger) {
      this.responseDebugger = responseDebugger;
      return this;
    }

    /**
     * Initializes the optional value {@link SlackClientRuntimeConfigIF#getResponseDebugger() responseDebugger} to responseDebugger.
     * @param responseDebugger The value for responseDebugger
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setResponseDebugger(Optional<ResponseDebugger> responseDebugger) {
      this.responseDebugger = responseDebugger.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link SlackClientRuntimeConfig SlackClientRuntimeConfig}.
     * @return An immutable instance of SlackClientRuntimeConfig
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public SlackClientRuntimeConfig build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new SlackClientRuntimeConfig(this);
    }

    private boolean tokenSupplierIsSet() {
      return (initBits & INIT_BIT_TOKEN_SUPPLIER) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!tokenSupplierIsSet()) attributes.add("tokenSupplier");
      return "Cannot build SlackClientRuntimeConfig, some of required attributes are not set " + attributes;
    }
  }
}
