package com.hubspot.slack.client.http;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.horizon.HttpRequest;
import com.hubspot.horizon.HttpResponse;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

/**
 * Immutable implementation of {@link HttpExchangeIF}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code HttpExchange.builder()}.
 */
@SuppressWarnings("all")
@SuppressFBWarnings
@ParametersAreNonnullByDefault
@Generated({"Immutables.generator", "HttpExchangeIF"})
@Immutable
public final class HttpExchange implements HttpExchangeIF {
  private final HttpRequest request;
  private final HttpResponse response;
  private final Duration exchangeDuration;

  private HttpExchange(
      HttpRequest request,
      HttpResponse response,
      Duration exchangeDuration) {
    this.request = request;
    this.response = response;
    this.exchangeDuration = exchangeDuration;
  }

  /**
   * @return The value of the {@code request} attribute
   */
  @JsonProperty
  @Override
  public HttpRequest getRequest() {
    return request;
  }

  /**
   * @return The value of the {@code response} attribute
   */
  @JsonProperty
  @Override
  public HttpResponse getResponse() {
    return response;
  }

  /**
   * @return The value of the {@code exchangeDuration} attribute
   */
  @JsonProperty
  @Override
  public Duration getExchangeDuration() {
    return exchangeDuration;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HttpExchangeIF#getRequest() request} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param request A new value for request
   * @return A modified copy of the {@code this} object
   */
  public final HttpExchange withRequest(HttpRequest request) {
    if (this.request == request) return this;
    HttpRequest newValue = Objects.requireNonNull(request, "request");
    return new HttpExchange(newValue, this.response, this.exchangeDuration);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HttpExchangeIF#getResponse() response} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param response A new value for response
   * @return A modified copy of the {@code this} object
   */
  public final HttpExchange withResponse(HttpResponse response) {
    if (this.response == response) return this;
    HttpResponse newValue = Objects.requireNonNull(response, "response");
    return new HttpExchange(this.request, newValue, this.exchangeDuration);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link HttpExchangeIF#getExchangeDuration() exchangeDuration} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param exchangeDuration A new value for exchangeDuration
   * @return A modified copy of the {@code this} object
   */
  public final HttpExchange withExchangeDuration(Duration exchangeDuration) {
    if (this.exchangeDuration == exchangeDuration) return this;
    Duration newValue = Objects.requireNonNull(exchangeDuration, "exchangeDuration");
    return new HttpExchange(this.request, this.response, newValue);
  }

  /**
   * This instance is equal to all instances of {@code HttpExchange} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof HttpExchange
        && equalTo((HttpExchange) another);
  }

  private boolean equalTo(HttpExchange another) {
    return request.equals(another.request)
        && response.equals(another.response)
        && exchangeDuration.equals(another.exchangeDuration);
  }

  /**
   * Computes a hash code from attributes: {@code request}, {@code response}, {@code exchangeDuration}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 31;
    h = h * 17 + request.hashCode();
    h = h * 17 + response.hashCode();
    h = h * 17 + exchangeDuration.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code HttpExchange} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "HttpExchange{"
        + "request=" + request
        + ", response=" + response
        + ", exchangeDuration=" + exchangeDuration
        + "}";
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json implements HttpExchangeIF {
    @Nullable HttpRequest request;
    @Nullable HttpResponse response;
    @Nullable Duration exchangeDuration;
    @JsonProperty
    public void setRequest(HttpRequest request) {
      this.request = request;
    }
    @JsonProperty
    public void setResponse(HttpResponse response) {
      this.response = response;
    }
    @JsonProperty
    public void setExchangeDuration(Duration exchangeDuration) {
      this.exchangeDuration = exchangeDuration;
    }
    @Override
    public HttpRequest getRequest() { throw new UnsupportedOperationException(); }
    @Override
    public HttpResponse getResponse() { throw new UnsupportedOperationException(); }
    @Override
    public Duration getExchangeDuration() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator
  static HttpExchange fromJson(Json json) {
    HttpExchange.Builder builder = HttpExchange.builder();
    if (json.request != null) {
      builder.setRequest(json.request);
    }
    if (json.response != null) {
      builder.setResponse(json.response);
    }
    if (json.exchangeDuration != null) {
      builder.setExchangeDuration(json.exchangeDuration);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link HttpExchangeIF} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable HttpExchange instance
   */
  public static HttpExchange copyOf(HttpExchangeIF instance) {
    if (instance instanceof HttpExchange) {
      return (HttpExchange) instance;
    }
    return HttpExchange.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link HttpExchange HttpExchange}.
   * @return A new HttpExchange builder
   */
  public static HttpExchange.Builder builder() {
    return new HttpExchange.Builder();
  }

  /**
   * Builds instances of type {@link HttpExchange HttpExchange}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_REQUEST = 0x1L;
    private static final long INIT_BIT_RESPONSE = 0x2L;
    private static final long INIT_BIT_EXCHANGE_DURATION = 0x4L;
    private long initBits = 0x7L;

    private @Nullable HttpRequest request;
    private @Nullable HttpResponse response;
    private @Nullable Duration exchangeDuration;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code HttpExchangeIF} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(HttpExchangeIF instance) {
      Objects.requireNonNull(instance, "instance");
      setRequest(instance.getRequest());
      setResponse(instance.getResponse());
      setExchangeDuration(instance.getExchangeDuration());
      return this;
    }

    /**
     * Initializes the value for the {@link HttpExchangeIF#getRequest() request} attribute.
     * @param request The value for request 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setRequest(HttpRequest request) {
      this.request = Objects.requireNonNull(request, "request");
      initBits &= ~INIT_BIT_REQUEST;
      return this;
    }

    /**
     * Initializes the value for the {@link HttpExchangeIF#getResponse() response} attribute.
     * @param response The value for response 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setResponse(HttpResponse response) {
      this.response = Objects.requireNonNull(response, "response");
      initBits &= ~INIT_BIT_RESPONSE;
      return this;
    }

    /**
     * Initializes the value for the {@link HttpExchangeIF#getExchangeDuration() exchangeDuration} attribute.
     * @param exchangeDuration The value for exchangeDuration 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder setExchangeDuration(Duration exchangeDuration) {
      this.exchangeDuration = Objects.requireNonNull(exchangeDuration, "exchangeDuration");
      initBits &= ~INIT_BIT_EXCHANGE_DURATION;
      return this;
    }

    /**
     * Builds a new {@link HttpExchange HttpExchange}.
     * @return An immutable instance of HttpExchange
     * @throws com.hubspot.immutables.validation.InvalidImmutableStateException if any required attributes are missing
     */
    public HttpExchange build() throws InvalidImmutableStateException {
      checkRequiredAttributes();
      return new HttpExchange(request, response, exchangeDuration);
    }

    private boolean requestIsSet() {
      return (initBits & INIT_BIT_REQUEST) == 0;
    }

    private boolean responseIsSet() {
      return (initBits & INIT_BIT_RESPONSE) == 0;
    }

    private boolean exchangeDurationIsSet() {
      return (initBits & INIT_BIT_EXCHANGE_DURATION) == 0;
    }

    private void checkRequiredAttributes() throws InvalidImmutableStateException {
      if (initBits != 0) {
        throw new InvalidImmutableStateException(formatRequiredAttributesMessage());
      }
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<String>();
      if (!requestIsSet()) attributes.add("request");
      if (!responseIsSet()) attributes.add("response");
      if (!exchangeDurationIsSet()) attributes.add("exchangeDuration");
      return "Cannot build HttpExchange, some of required attributes are not set " + attributes;
    }
  }
}
