/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.concurrency;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.hubspot.slack.client.concurrency.LoggingUncaughtExceptionHandler;
import java.util.concurrent.ThreadFactory;

public class ThreadFactories {
    public static ThreadFactoryBuilder newBuilder(String name) {
        return new ThreadFactoryBuilder().setNameFormat(name + "-%d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new LoggingUncaughtExceptionHandler());
    }

    public static ThreadFactory newThreadFactory(String name) {
        return ThreadFactories.newBuilder(name).build();
    }

    public static ThreadFactory newDaemonThreadFactory(String name) {
        return ThreadFactories.newBuilder(name).setDaemon(true).build();
    }

    private ThreadFactories() {
        throw new AssertionError();
    }
}

